/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.achartengine.chart.LineChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

public class TimeChart
extends LineChart {
    public static final long DAY = 86400000L;
    public static final String TYPE = "Time";
    private String mDateFormat;
    private Double mStartPoint;
    private boolean mXAxisSmart = 1;

    TimeChart() {
    }

    public TimeChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DateFormat getDateFormat(double d, double d2) {
        if (this.mDateFormat != null) {
            try {
                String string2 = this.mDateFormat;
                return new SimpleDateFormat(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DateFormat dateFormat = SimpleDateFormat.getDateInstance(2);
        double d3 = d2 - d;
        if (d3 > 8.64E7 && d3 < 4.32E8) {
            return SimpleDateFormat.getDateTimeInstance(3, 3);
        }
        if (!(d3 < 8.64E7)) return dateFormat;
        return SimpleDateFormat.getTimeInstance(2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void drawXLabels(List<Double> list, Double[] doubleArray, Canvas canvas, Paint paint, int n, int n2, int n3, double d, double d2, double d3) {
        int n4 = list.size();
        if (n4 > 0) {
            int n5;
            int n6;
            boolean bl = this.mRenderer.isShowLabels();
            boolean bl2 = this.mRenderer.isShowGridY();
            double d4 = list.get(0);
            int n7 = n4 + -1;
            double d5 = list.get(n7);
            DateFormat dateFormat = this.getDateFormat(d4, d5);
            int n8 = 0;
            while ((n6 = ++n8) < (n5 = n4)) {
                List<Double> list2 = list;
                int n9 = n8;
                long l = Math.round(list2.get(n9));
                double d6 = n;
                double d7 = ((double)l - d2) * d;
                float f = (float)(d6 + d7);
                if (bl) {
                    int n10 = this.mRenderer.getXLabelsColor();
                    paint.setColor(n10);
                    float f2 = n3;
                    float f3 = n3;
                    float f4 = this.mRenderer.getLabelsTextSize() / 3.0f;
                    float f5 = f3 + f4;
                    Canvas canvas2 = canvas;
                    float f6 = f;
                    Paint paint2 = paint;
                    canvas2.drawLine(f, f2, f6, f5, paint2);
                    long l2 = l;
                    Date date = new Date(l2);
                    String string2 = dateFormat.format(date);
                    float f7 = n3;
                    float f8 = this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f;
                    float f9 = f7 + f8;
                    float f10 = this.mRenderer.getXLabelsAngle();
                    TimeChart timeChart = this;
                    Canvas canvas3 = canvas;
                    float f11 = f;
                    Paint paint3 = paint;
                    timeChart.drawText(canvas3, string2, f11, f9, paint3, f10);
                }
                if (!bl2) continue;
                int n11 = this.mRenderer.getGridColor();
                paint.setColor(n11);
                float f12 = n3;
                float f13 = n2;
                Canvas canvas4 = canvas;
                float f14 = f;
                Paint paint4 = paint;
                canvas4.drawLine(f, f12, f14, f13, paint4);
            }
        }
        TimeChart timeChart = this;
        Double[] doubleArray2 = doubleArray;
        Canvas canvas5 = canvas;
        Paint paint5 = paint;
        int n12 = n;
        int n13 = n2;
        int n14 = n3;
        double d8 = d;
        double d9 = d2;
        double d10 = d3;
        timeChart.drawXTextLabels(doubleArray2, canvas5, paint5, true, n12, n13, n14, d8, d9, d10);
    }

    @Override
    public String getChartType() {
        return TYPE;
    }

    public String getDateFormat() {
        return this.mDateFormat;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected List<Double> getXLabels(double var1_1, double var3_2, int var5_3) {
        block8: {
            if (!this.mXAxisSmart) {
                var6_5 = super.getXLabels(var1_1, var3_2, var5_3);
lbl3:
                // 3 sources

                return var6_5;
            }
            if (this.mStartPoint == null) {
                var7_6 = var1_1 % 8.64E7;
                var9_7 = var1_1 - var7_6 + 8.64E7;
                var11_8 = Math.round(var1_1);
                var13_9 = new Date(var11_8).getTimezoneOffset() * 60 * 1000;
                this.mStartPoint = var15_10 = Double.valueOf(var9_7 + var13_9);
            }
            if (var5_3 > 1.24E-322) {
                var5_4 = 1.24E-322;
            }
            var16_11 = var3_2 - var1_1;
            var18_12 = var5_3;
            var20_13 = var16_11 / var18_12;
            var22_14 = 8.64E7;
            if (!(var20_13 <= 8.64E7)) ** GOTO lbl38
            while (true) {
                block9: {
                    if (var20_13 < (var24_15 = var22_14 / 2.0)) break block9;
lbl20:
                    // 2 sources

                    while (true) {
                        var6_5 = new ArrayList<Double>();
                        var26_16 = this.mStartPoint;
                        var28_17 = Math.floor((this.mStartPoint - var1_1) / var22_14) * var22_14;
                        var32_19 = 0;
                        for (var30_18 = var26_16 - var28_17; var30_18 < var3_2; var30_18 += var22_14) {
                            var33_20 = var32_19 + 1;
                            var34_21 = var5_3;
                            if (var32_19 > var34_21) ** GOTO lbl3
                            var35_22 = var30_18;
                            var36_23 = var6_5.add(var35_22);
                            var32_19 = var33_20;
                        }
                        break block8;
                        break;
                    }
                }
                var22_14 /= 2.0;
            }
lbl-1000:
            // 1 sources

            {
                var22_14 *= 2.0;
lbl38:
                // 2 sources

                ** while (var20_13 > var22_14)
            }
lbl39:
            // 1 sources

            ** while (true)
        }
        var37_24 = var32_19;
        ** while (true)
    }

    public boolean isXAxisSmart() {
        return this.mXAxisSmart;
    }

    public void setDateFormat(String string2) {
        this.mDateFormat = string2;
    }

    public void setXAxisSmart(boolean bl) {
        this.mXAxisSmart = bl;
    }
}

