/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.ClickableArea;
import org.achartengine.chart.ScatterChart;
import org.achartengine.model.Point;
import org.achartengine.model.SeriesSelection;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.BasicStroke;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.util.MathHelper;

public abstract class XYChart
extends AbstractChart {
    private Map<Integer, List<ClickableArea>> clickableAreas;
    private final Map<Integer, double[]> mCalcRange;
    private Point mCenter;
    protected XYMultipleSeriesDataset mDataset;
    protected XYMultipleSeriesRenderer mRenderer;
    private float mScale;
    private Rect mScreenR;
    private float mTranslate;

    protected XYChart() {
        HashMap<Integer, double[]> hashMap = new HashMap<Integer, double[]>();
        this.mCalcRange = hashMap;
        HashMap<Integer, List<ClickableArea>> hashMap2 = new HashMap<Integer, List<ClickableArea>>();
        this.clickableAreas = hashMap2;
    }

    public XYChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        HashMap<Integer, double[]> hashMap = new HashMap<Integer, double[]>();
        this.mCalcRange = hashMap;
        HashMap<Integer, List<ClickableArea>> hashMap2 = new HashMap<Integer, List<ClickableArea>>();
        this.clickableAreas = hashMap2;
        this.mDataset = xYMultipleSeriesDataset;
        this.mRenderer = xYMultipleSeriesRenderer;
    }

    private int getLabelLinePos(Paint.Align align) {
        int n = 4;
        Paint.Align align2 = Paint.Align.LEFT;
        if (align == align2) {
            n = -4;
        }
        return n;
    }

    private List<Double> getValidLabels(List<Double> list) {
        ArrayList<Double> arrayList = new ArrayList<Double>(list);
        Iterator<Double> iterator = list.iterator();
        while (iterator.hasNext()) {
            Double d = iterator.next();
            if (!d.isNaN()) continue;
            boolean bl = arrayList.remove(d);
        }
        return arrayList;
    }

    private void setStroke(Paint.Cap cap, Paint.Join join, float f, Paint.Style style, PathEffect pathEffect, Paint paint) {
        paint.setStrokeCap(cap);
        paint.setStrokeJoin(join);
        paint.setStrokeMiter(f);
        PathEffect pathEffect2 = paint.setPathEffect(pathEffect);
        paint.setStyle(style);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void transform(Canvas canvas, float f, boolean bl) {
        if (bl) {
            float f2 = this.mScale;
            float f3 = 1.0f / f2;
            float f4 = this.mScale;
            canvas.scale(f3, f4);
            float f5 = this.mTranslate;
            float f6 = -this.mTranslate;
            canvas.translate(f5, f6);
            float f7 = -f;
            float f8 = this.mCenter.getX();
            float f9 = this.mCenter.getY();
            canvas.rotate(f7, f8, f9);
            return;
        }
        float f10 = this.mCenter.getX();
        float f11 = this.mCenter.getY();
        canvas.rotate(f, f10, f11);
        float f12 = -this.mTranslate;
        float f13 = this.mTranslate;
        canvas.translate(f12, f13);
        float f14 = this.mScale;
        float f15 = this.mScale;
        float f16 = 1.0f / f15;
        canvas.scale(f14, f16);
    }

    protected abstract ClickableArea[] clickableAreasForPoints(float[] var1, double[] var2, float var3, int var4, int var5);

    /*
     * Unable to fully structure code
     */
    @Override
    public void draw(Canvas var1_1, int var2_2, int var3_3, int var4_4, int var5_5, Paint var6_6) {
        block58: {
            block57: {
                block59: {
                    block55: {
                        block56: {
                            block61: {
                                block54: {
                                    block60: {
                                        block53: {
                                            block52: {
                                                block51: {
                                                    block50: {
                                                        block49: {
                                                            var7_7 = this.mRenderer.isAntialiasing();
                                                            var6_6.setAntiAlias(var7_7);
                                                            var8_8 = this.mRenderer;
                                                            var9_9 = var5_5 / 5;
                                                            var10_10 = this.mRenderer.getAxisTitleTextSize();
                                                            var11_11 = this.getLegendSize(var8_8, var9_9, var10_10);
                                                            var12_12 = this.mRenderer.getMargins();
                                                            var13_13 = var12_12[0];
                                                            var14_14 = var3_3 + var13_13;
                                                            var15_15 = var12_12[1];
                                                            var16_16 = var2_2 + var15_15;
                                                            var17_17 = var2_2 + var4_4;
                                                            var18_18 = var12_12[3];
                                                            var19_19 = var17_17 - var18_18;
                                                            var20_20 = this.mDataset.getSeriesCount();
                                                            var21_21 = new String[var20_20];
                                                            var22_22 = 0;
                                                            while (true) {
                                                                if ((var23_26 = ++var22_22) >= (var24_27 = var20_20)) {
                                                                    if (this.mRenderer.isFitLegend() && this.mRenderer.isShowLegend()) {
                                                                        var25_28 = this.mRenderer;
                                                                        var26_29 = this;
                                                                        var27_30 = var1_1;
                                                                        var28_31 = var3_3;
                                                                        var29_32 = var4_4;
                                                                        var30_33 = var5_5;
                                                                        var31_34 = var6_6;
                                                                        var11_11 = var26_29.drawLegend(var27_30, var25_28, var21_21, var16_16, var19_19, var28_31, var29_32, var30_33, var11_11, var31_34, true);
                                                                    }
                                                                    var32_35 = var3_3 + var5_5;
                                                                    var33_36 = var12_12[2];
                                                                    var34_37 = var32_35 - var33_36 - var11_11;
                                                                    if (this.mScreenR == null) {
                                                                        this.mScreenR = var35_38 = new Rect();
                                                                    }
                                                                    var36_39 = this.mScreenR;
                                                                    var37_40 = var14_14;
                                                                    var38_41 = var34_37;
                                                                    var36_39.set(var16_16, var37_40, var19_19, var38_41);
                                                                    var39_42 = this.mRenderer;
                                                                    var40_43 = this;
                                                                    var41_44 = var1_1;
                                                                    var42_45 = var2_2;
                                                                    var43_46 = var3_3;
                                                                    var44_47 = var4_4;
                                                                    var45_48 = var5_5;
                                                                    var46_49 = var6_6;
                                                                    var40_43.drawBackground(var39_42, var41_44, var42_45, var43_46, var44_47, var45_48, var46_49, false, 0);
                                                                    if (var6_6.getTypeface() == null || !(var47_50 = var6_6.getTypeface().toString()).equals(var48_51 = this.mRenderer.getTextTypefaceName()) || (var49_52 = var6_6.getTypeface().getStyle()) != (var50_53 = this.mRenderer.getTextTypefaceStyle())) {
                                                                        var51_54 = this.mRenderer.getTextTypefaceName();
                                                                        var52_55 = this.mRenderer.getTextTypefaceStyle();
                                                                        var53_56 = Typeface.create((String)var51_54, (int)var52_55);
                                                                        var54_57 = var6_6.setTypeface(var53_56);
                                                                    }
                                                                    if ((var55_58 = this.mRenderer.getOrientation()) == (var56_59 = XYMultipleSeriesRenderer.Orientation.VERTICAL)) {
                                                                        var19_19 -= var11_11;
                                                                        var57_60 = var11_11 + -20;
                                                                        var34_37 += var57_60;
                                                                    }
                                                                    if ((var58_61 = var55_58.getAngle()) != 90) break;
                                                                    var59_62 = true;
lbl58:
                                                                    // 2 sources

                                                                    while (true) {
                                                                        var60_63 = var5_5;
                                                                        var61_64 = var4_4;
                                                                        this.mScale = var62_65 = var60_63 / var61_64;
                                                                        this.mTranslate = var63_66 = (float)(Math.abs(var4_4 - var5_5) / 2);
                                                                        if (this.mScale < 1.0f) {
                                                                            this.mTranslate = var64_67 = this.mTranslate * -1.0f;
                                                                        }
                                                                        var65_68 = (var2_2 + var4_4) / 2;
                                                                        var66_69 = (var3_3 + var5_5) / 2;
                                                                        this.mCenter = var67_70 = new Point(var65_68, var66_69);
                                                                        if (var59_62) {
                                                                            var68_71 = var58_61;
                                                                            var69_72 = this;
                                                                            var70_73 = var1_1;
                                                                            var69_72.transform(var70_73, var68_71, false);
                                                                        }
                                                                        var71_74 = -2147483647;
                                                                        var22_22 = 0;
lbl75:
                                                                        // 2 sources

                                                                        while (true) {
                                                                            var72_75 = var22_22;
                                                                            var73_76 = var20_20;
                                                                            if (var72_75 < var73_76) break block49;
                                                                            if (++var71_74 < 0) lbl-1000:
                                                                            // 3 sources

                                                                            {
                                                                                return;
                                                                            }
                                                                            break block50;
                                                                            break;
                                                                        }
                                                                        break;
                                                                    }
                                                                }
                                                                var74_23 = this.mDataset;
                                                                var75_24 = var22_22;
                                                                var21_21[var22_22] = var76_25 = var74_23.getSeriesAt(var75_24).getTitle();
                                                            }
                                                            var59_62 = false;
                                                            ** while (true)
                                                        }
                                                        var77_77 = this.mDataset;
                                                        var78_78 = var22_22++;
                                                        var79_79 = var77_77.getSeriesAt(var78_78).getScaleNumber();
                                                        var71_74 = Math.max(var71_74, var79_79);
                                                        ** while (true)
                                                    }
                                                    var80_80 = new double[var71_74];
                                                    var81_81 = new double[var71_74];
                                                    var82_82 = new double[var71_74];
                                                    var83_83 = new double[var71_74];
                                                    var84_84 = new boolean[var71_74];
                                                    var85_85 = new boolean[var71_74];
                                                    var86_86 = new boolean[var71_74];
                                                    var87_87 = new boolean[var71_74];
                                                    var22_22 = 0;
                                                    block4: while (true) {
                                                        block62: {
                                                            if ((var88_111 = ++var22_22) < (var89_112 = var71_74)) break block62;
                                                            var90_120 = new double[var71_74];
                                                            var91_121 = new double[var71_74];
                                                            var22_22 = 0;
lbl110:
                                                            // 2 sources

                                                            while (true) {
                                                                var93_159 = var20_20;
                                                                if ((var92_158 = ++var22_22) < var93_159) break block4;
                                                                var22_22 = 0;
lbl114:
                                                                // 2 sources

                                                                while (true) {
                                                                    var95_169 = var71_74;
                                                                    if ((var94_167 = ++var22_22) < var95_169) break block51;
                                                                    var96_176 = false;
                                                                    var97_177 = new HashMap<Integer, List<ClickableArea>>();
                                                                    this.clickableAreas = var97_177;
                                                                    var22_22 = 0;
lbl121:
                                                                    // 2 sources

                                                                    while (true) {
                                                                        var99_179 = var20_20;
                                                                        if ((var98_178 = ++var22_22) < var99_179) break block52;
                                                                        var100_269 = this.mRenderer;
                                                                        var101_270 = var5_5 - var34_37;
                                                                        var102_271 = this.mRenderer.getMarginsColor();
                                                                        var103_272 = this;
                                                                        var104_273 = var1_1;
                                                                        var105_274 = var2_2;
                                                                        var106_275 = var34_37;
                                                                        var107_276 = var4_4;
                                                                        var108_277 = var6_6;
                                                                        var103_272.drawBackground(var100_269, var104_273, var105_274, var106_275, var107_276, var101_270, var108_277, true, var102_271);
                                                                        var109_278 = this.mRenderer;
                                                                        var110_279 = var12_12[0];
                                                                        var111_280 = this.mRenderer.getMarginsColor();
                                                                        var112_281 = this;
                                                                        var113_282 = var1_1;
                                                                        var114_283 = var2_2;
                                                                        var115_284 = var3_3;
                                                                        var116_285 = var4_4;
                                                                        var117_286 = var6_6;
                                                                        var112_281.drawBackground(var109_278, var113_282, var114_283, var115_284, var116_285, var110_279, var117_286, true, var111_280);
                                                                        var118_287 = XYMultipleSeriesRenderer.Orientation.HORIZONTAL;
                                                                        if (var55_58 != var118_287) break block53;
                                                                        var119_288 = this.mRenderer;
                                                                        var120_289 = var16_16 - var2_2;
                                                                        var121_290 = var5_5 - var3_3;
                                                                        var122_291 = this.mRenderer.getMarginsColor();
                                                                        var123_292 = this;
                                                                        var124_293 = var1_1;
                                                                        var125_294 = var2_2;
                                                                        var126_295 = var3_3;
                                                                        var127_296 = var6_6;
                                                                        var123_292.drawBackground(var119_288, var124_293, var125_294, var126_295, var120_289, var121_290, var127_296, true, var122_291);
                                                                        var128_297 = this.mRenderer;
                                                                        var129_298 = var12_12[3];
                                                                        var130_299 = var5_5 - var3_3;
                                                                        var131_300 = this.mRenderer.getMarginsColor();
                                                                        var132_301 = this;
                                                                        var133_302 = var1_1;
                                                                        var134_303 = var19_19;
                                                                        var135_304 = var3_3;
                                                                        var136_305 = var6_6;
                                                                        var132_301.drawBackground(var128_297, var133_302, var134_303, var135_304, var129_298, var130_299, var136_305, true, var131_300);
lbl166:
                                                                        // 3 sources

                                                                        while (this.mRenderer.isShowLabels() && var96_176) {
                                                                            var137_325 = true;
lbl168:
                                                                            // 2 sources

                                                                            block9: while (true) {
                                                                                var138_326 = this.mRenderer.isShowGridX();
                                                                                var139_327 = this.mRenderer.isShowCustomTextGrid();
                                                                                if (!var137_325 && !var138_326) ** GOTO lbl257
                                                                                var140_328 = var80_80[0];
                                                                                var142_329 = var81_81[0];
                                                                                var144_330 = this.mRenderer.getXLabels();
                                                                                var145_331 = this.getXLabels(var140_328, var142_329, var144_330);
                                                                                var146_332 = this.getValidLabels(var145_331);
                                                                                var147_333 = this;
                                                                                var148_334 = var82_82;
                                                                                var149_335 = var83_83;
                                                                                var150_336 = var71_74;
                                                                                var151_337 = var147_333.getYLabels(var148_334, var149_335, var150_336);
                                                                                var152_338 = var16_16;
                                                                                if (var137_325) {
                                                                                    var153_339 = this.mRenderer.getXLabelsColor();
                                                                                    var6_6.setColor(var153_339);
                                                                                    var154_340 = this.mRenderer.getLabelsTextSize();
                                                                                    var6_6.setTextSize(var154_340);
                                                                                    var155_341 = this.mRenderer.getXLabelsAlign();
                                                                                    var6_6.setTextAlign(var155_341);
                                                                                    var156_342 = this.mRenderer.getXLabelsAlign();
                                                                                    var157_343 = Paint.Align.LEFT;
                                                                                    if (var156_342 == var157_343) {
                                                                                        var158_344 = var152_338;
                                                                                        var159_345 = this.mRenderer.getLabelsTextSize() / 4.0f;
                                                                                        var152_338 = (int)(var158_344 + var159_345);
                                                                                    }
                                                                                }
                                                                                var160_346 = this.mRenderer.getXTextLabelLocations();
                                                                                var161_347 = var90_120[0];
                                                                                var163_348 = var80_80[0];
                                                                                var165_349 = var81_81[0];
                                                                                var167_350 = this;
                                                                                var168_351 = var1_1;
                                                                                var169_352 = var6_6;
                                                                                var170_353 = var14_14;
                                                                                var171_354 = var34_37;
                                                                                var167_350.drawXLabels(var146_332, var160_346, var168_351, var169_352, var152_338, var170_353, var171_354, var161_347, var163_348, var165_349);
                                                                                var172_355 = this;
                                                                                var173_356 = var151_337;
                                                                                var174_357 = var1_1;
                                                                                var175_358 = var6_6;
                                                                                var176_359 = var71_74;
                                                                                var177_360 = var16_16;
                                                                                var178_361 = var19_19;
                                                                                var179_362 = var34_37;
                                                                                var172_355.drawYLabels(var173_356, var174_357, var175_358, var176_359, var177_360, var178_361, var179_362, var91_121, var82_82);
                                                                                if (!var137_325) ** GOTO lbl222
                                                                                var180_363 = this.mRenderer.getLabelsColor();
                                                                                var6_6.setColor(var180_363);
                                                                                var22_22 = 0;
                                                                                while (true) {
                                                                                    var182_365 = var71_74;
                                                                                    if ((var181_364 = ++var22_22) < var182_365) break block54;
lbl222:
                                                                                    // 2 sources

                                                                                    if (!var137_325) ** GOTO lbl257
                                                                                    var183_449 = this.mRenderer.getLabelsColor();
                                                                                    var6_6.setColor(var183_449);
                                                                                    var184_450 = this.mRenderer.getAxisTitleTextSize();
                                                                                    var185_451 = var6_6;
                                                                                    var186_452 = var184_450;
                                                                                    var185_451.setTextSize(var186_452);
                                                                                    var187_453 = Paint.Align.CENTER;
                                                                                    var6_6.setTextAlign(var187_453);
                                                                                    var188_454 = XYMultipleSeriesRenderer.Orientation.HORIZONTAL;
                                                                                    if (var55_58 != var188_454) break block55;
                                                                                    var189_455 = this.mRenderer.getXTitle();
                                                                                    var190_456 = var4_4 / 2 + var2_2;
                                                                                    var191_457 = var34_37;
                                                                                    var192_458 = this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f;
                                                                                    var193_459 = var191_457 + var192_458 + var184_450;
                                                                                    var194_460 = this;
                                                                                    var195_461 = var1_1;
                                                                                    var196_462 = var6_6;
                                                                                    var194_460.drawText(var195_461, var189_455, var190_456, var193_459, var196_462, 0.0f);
                                                                                    var22_22 = 0;
lbl243:
                                                                                    // 2 sources

                                                                                    while (true) {
                                                                                        var198_464 = var71_74;
                                                                                        if ((var197_463 = ++var22_22) < var198_464) break block56;
                                                                                        var199_485 = this.mRenderer.getChartTitleTextSize();
                                                                                        var6_6.setTextSize(var199_485);
                                                                                        var200_486 = this.mRenderer.getChartTitle();
                                                                                        var201_487 = var4_4 / 2 + var2_2;
                                                                                        var202_488 = var3_3;
                                                                                        var203_489 = this.mRenderer.getChartTitleTextSize();
                                                                                        var204_490 = var202_488 + var203_489;
                                                                                        var205_491 = this;
                                                                                        var206_492 = var1_1;
                                                                                        var207_493 = var6_6;
                                                                                        var205_491.drawText(var206_492, var200_486, var201_487, var204_490, var207_493, 0.0f);
lbl257:
                                                                                        // 5 sources

                                                                                        while (var55_58 == (var208_514 = XYMultipleSeriesRenderer.Orientation.HORIZONTAL)) {
                                                                                            var209_515 = this.mRenderer;
                                                                                            var210_516 = this;
                                                                                            var211_517 = var1_1;
                                                                                            var212_518 = var21_21;
                                                                                            var213_519 = var16_16;
                                                                                            var214_520 = var19_19;
                                                                                            var215_521 = var3_3;
                                                                                            var216_522 = var4_4;
                                                                                            var217_523 = var5_5;
                                                                                            var218_524 = var11_11;
                                                                                            var219_525 = var6_6;
                                                                                            var220_526 = var210_516.drawLegend(var211_517, var209_515, var212_518, var213_519, var214_520, var215_521, var216_522, var217_523, var218_524, var219_525, false);
lbl270:
                                                                                            // 3 sources

                                                                                            while (true) {
                                                                                                if (!this.mRenderer.isShowAxes()) ** GOTO lbl303
                                                                                                var221_546 = this.mRenderer.getAxesColor();
                                                                                                var6_6.setColor(var221_546);
                                                                                                var222_547 = var16_16;
                                                                                                var223_548 = var34_37;
                                                                                                var224_549 = var19_19;
                                                                                                var225_550 = var34_37;
                                                                                                var226_551 = var1_1;
                                                                                                var227_552 = var6_6;
                                                                                                var226_551.drawLine(var222_547, var223_548, var224_549, var225_550, var227_552);
                                                                                                var228_553 = false;
                                                                                                var22_22 = 0;
lbl283:
                                                                                                // 2 sources

                                                                                                while (true) {
                                                                                                    var230_555 = var71_74;
                                                                                                    if ((var229_554 = ++var22_22) < var230_555 && !var228_553) break block57;
                                                                                                    var231_560 = XYMultipleSeriesRenderer.Orientation.HORIZONTAL;
                                                                                                    if (var55_58 != var231_560) break block58;
                                                                                                    var232_561 = var16_16;
                                                                                                    var233_562 = var14_14;
                                                                                                    var234_563 = var16_16;
                                                                                                    var235_564 = var34_37;
                                                                                                    var236_565 = var1_1;
                                                                                                    var237_566 = var6_6;
                                                                                                    var236_565.drawLine(var232_561, var233_562, var234_563, var235_564, var237_566);
                                                                                                    if (var228_553) {
                                                                                                        var238_567 = var19_19;
                                                                                                        var239_568 = var14_14;
                                                                                                        var240_569 = var19_19;
                                                                                                        var241_570 = var34_37;
                                                                                                        var242_571 = var1_1;
                                                                                                        var243_572 = var6_6;
                                                                                                        var242_571.drawLine(var238_567, var239_568, var240_569, var241_570, var243_572);
                                                                                                    }
lbl303:
                                                                                                    // 6 sources

                                                                                                    while (true) {
                                                                                                        if (!var59_62) ** GOTO lbl-1000
                                                                                                        var244_573 = var58_61;
                                                                                                        var245_574 = this;
                                                                                                        var246_575 = var1_1;
                                                                                                        var245_574.transform(var246_575, var244_573, true);
                                                                                                        ** continue;
                                                                                                        break;
                                                                                                    }
                                                                                                    break;
                                                                                                }
                                                                                                break;
                                                                                            }
lbl310:
                                                                                            // 1 sources

                                                                                            break block9;
                                                                                        }
                                                                                        break block59;
                                                                                        break;
                                                                                    }
                                                                                    break;
                                                                                }
                                                                                break;
                                                                            }
                                                                            ** GOTO lbl-1000
                                                                        }
                                                                        break block60;
                                                                        break;
                                                                    }
                                                                    break;
                                                                }
                                                                break;
                                                            }
                                                        }
                                                        var247_113 = this.mRenderer;
                                                        var248_114 = var22_22;
                                                        var80_80[var22_22] = var249_115 = var247_113.getXAxisMin(var248_114);
                                                        var251_116 = this.mRenderer;
                                                        var252_117 = var22_22;
                                                        var81_81[var22_22] = var253_118 = var251_116.getXAxisMax(var252_117);
                                                        var255_119 = this.mRenderer;
                                                        var256_88 = var22_22;
                                                        var82_82[var22_22] = var257_89 = var255_119.getYAxisMin(var256_88);
                                                        var259_90 = this.mRenderer;
                                                        var260_91 = var22_22;
                                                        var83_83[var22_22] = var261_92 = var259_90.getYAxisMax(var260_91);
                                                        var263_93 = this.mRenderer;
                                                        var264_94 = var22_22;
                                                        var84_84[var22_22] = var265_95 = var263_93.isMinXSet(var264_94);
                                                        var266_96 = this.mRenderer;
                                                        var267_97 = var22_22;
                                                        var85_85[var22_22] = var268_98 = var266_96.isMaxXSet(var267_97);
                                                        var269_99 = this.mRenderer;
                                                        var270_100 = var22_22;
                                                        var86_86[var22_22] = var271_101 = var269_99.isMinYSet(var270_100);
                                                        var272_102 = this.mRenderer;
                                                        var273_103 = var22_22;
                                                        var87_87[var22_22] = var274_104 = var272_102.isMaxYSet(var273_103);
                                                        var275_105 = this.mCalcRange;
                                                        var276_106 = var22_22;
                                                        if (var275_105.get(var276_106) != null) continue;
                                                        var277_107 = this.mCalcRange;
                                                        var278_108 = var22_22;
                                                        var279_109 = new double[4];
                                                        var280_110 = var277_107.put(var278_108, var279_109);
                                                    }
                                                    var281_122 = this.mDataset;
                                                    var282_123 = var22_22;
                                                    var283_124 = var281_122.getSeriesAt(var282_123);
                                                    var284_125 = var283_124.getScaleNumber();
                                                    if (var283_124.getItemCount() == 0) lbl-1000:
                                                    // 3 sources

                                                    {
                                                        while (true) {
                                                            ** continue;
                                                            break;
                                                        }
                                                    }
                                                    if (!var84_84[var284_125]) {
                                                        var285_126 = var283_124.getMinX();
                                                        var287_127 = var80_80[var284_125];
                                                        var289_128 = var285_126;
                                                        var80_80[var284_125] = var291_129 = Math.min(var287_127, var289_128);
                                                        var293_130 = this.mCalcRange;
                                                        var294_131 = var284_125;
                                                        var295_132 = var293_130.get(var294_131);
                                                        var295_132[0] = var296_133 = var80_80[var284_125];
                                                    }
                                                    if (!var85_85[var284_125]) {
                                                        var298_134 = var283_124.getMaxX();
                                                        var300_135 = var81_81[var284_125];
                                                        var302_136 = var298_134;
                                                        var81_81[var284_125] = var304_137 = Math.max(var300_135, var302_136);
                                                        var306_138 = this.mCalcRange;
                                                        var307_139 = var284_125;
                                                        var308_140 = var306_138.get(var307_139);
                                                        var308_140[1] = var309_141 = var81_81[var284_125];
                                                    }
                                                    if (!var86_86[var284_125]) {
                                                        var311_142 = var283_124.getMinY();
                                                        var313_143 = var82_82[var284_125];
                                                        var315_144 = (float)var311_142;
                                                        var82_82[var284_125] = var317_145 = Math.min(var313_143, var315_144);
                                                        var319_146 = this.mCalcRange;
                                                        var320_147 = var284_125;
                                                        var321_148 = var319_146.get(var320_147);
                                                        var321_148[2] = var322_149 = var82_82[var284_125];
                                                    }
                                                    if (var87_87[var284_125]) ** GOTO lbl-1000
                                                    var324_150 = var283_124.getMaxY();
                                                    var326_151 = var83_83[var284_125];
                                                    var328_152 = (float)var324_150;
                                                    var83_83[var284_125] = var330_153 = Math.max(var326_151, var328_152);
                                                    var332_154 = this.mCalcRange;
                                                    var333_155 = var284_125;
                                                    var334_156 = var332_154.get(var333_155);
                                                    var334_156[3] = var335_157 = var83_83[var284_125];
                                                    ** while (true)
                                                }
                                                var337_160 = var81_81[var22_22];
                                                var339_161 = var80_80[var22_22];
                                                if (var337_160 - var339_161 != 0.0) {
                                                    var341_162 = var19_19 - var16_16;
                                                    var343_163 = var81_81[var22_22];
                                                    var345_164 = var80_80[var22_22];
                                                    var347_165 = var343_163 - var345_164;
                                                    var90_120[var22_22] = var349_166 = var341_162 / var347_165;
                                                }
                                                if ((var351_168 = var83_83[var22_22]) - (var353_170 = var82_82[var22_22]) != 0.0) {
                                                    var355_171 = var34_37 - var14_14;
                                                    var357_172 = var83_83[var22_22];
                                                    var359_173 = var82_82[var22_22];
                                                    var361_174 = var357_172 - var359_173;
                                                    var91_121[var22_22] = var363_175 = (double)((float)(var355_171 / var361_174));
                                                }
                                                ** while (true)
                                            }
                                            var365_180 = this.mDataset;
                                            var366_181 = var22_22;
                                            var283_124 = var365_180.getSeriesAt(var366_181);
                                            var284_125 = var283_124.getScaleNumber();
                                            if (var283_124.getItemCount() == 0) lbl-1000:
                                            // 3 sources

                                            {
                                                while (true) {
                                                    ** continue;
                                                    break;
                                                }
                                            }
                                            var367_182 = this.mRenderer;
                                            var368_183 = var22_22;
                                            var369_184 = var367_182.getSeriesRendererAt(var368_183);
                                            var370_185 = new ArrayList<Float>();
                                            var371_186 = new ArrayList<Double>();
                                            var372_187 = var34_37;
                                            var373_188 = var34_37;
                                            var375_189 = var91_121[var284_125];
                                            var377_190 = var82_82[var284_125];
                                            var379_191 = var375_189 * var377_190;
                                            var381_192 = (float)(var373_188 + var379_191);
                                            var382_193 = Math.min(var372_187, var381_192);
                                            var383_194 = new LinkedList<ClickableArea>();
                                            var384_195 = this.clickableAreas;
                                            var385_196 = var22_22;
                                            var386_197 = var383_194;
                                            var387_198 = var384_195.put(var385_196, var386_197);
                                            var388_199 = var80_80[var284_125];
                                            var390_200 = var81_81[var284_125];
                                            var392_201 = var283_124.getRange(var388_199, var390_200, 1);
                                            var393_202 = 65535;
                                            var394_203 = var392_201.entrySet().iterator();
                                            while (true) {
                                                block63: {
                                                    if (var394_203.hasNext()) break block63;
                                                    if (var370_185.size() <= 0) ** GOTO lbl-1000
                                                    var395_205 = this;
                                                    var396_206 = var283_124;
                                                    var397_207 = var1_1;
                                                    var398_208 = var6_6;
                                                    var399_209 = var370_185;
                                                    var395_205.drawSeries(var396_206, var397_207, var398_208, var399_209, var369_184, var382_193, var22_22, var55_58, var393_202);
                                                    var400_210 = MathHelper.getFloats(var370_185);
                                                    var401_211 = MathHelper.getDoubles(var371_186);
                                                    var402_212 = this;
                                                    var403_213 = var382_193;
                                                    var404_214 = var22_22;
                                                    var405_215 = var393_202;
                                                    var406_216 = Arrays.asList(var402_212.clickableAreasForPoints(var400_210, var401_211, var403_213, var404_214, var405_215));
                                                    var407_217 = var383_194.addAll(var406_216);
                                                    ** continue;
                                                }
                                                var408_218 = var394_203.next();
                                                var409_219 = var408_218.getKey();
                                                var411_220 = var408_218.getValue();
                                                if (var393_202 < 0) {
                                                    var413_221 = var409_219;
                                                    var393_202 = var283_124.getIndexForKey(var413_221);
                                                }
                                                var415_222 = var408_218.getKey();
                                                var416_223 = var371_186.add(var415_222);
                                                var417_224 = var408_218.getValue();
                                                var418_225 = var371_186.add(var417_224);
                                                var419_226 = this;
                                                var420_227 = var411_220;
                                                if (!var419_226.isNullValue(var420_227)) {
                                                    var422_228 = var16_16;
                                                    var424_229 = var90_120[var284_125];
                                                    var426_230 = var80_80[var284_125];
                                                    var428_231 = var409_219 - var426_230;
                                                    var430_232 = var424_229 * var428_231;
                                                    var431_233 = Float.valueOf((float)(var422_228 + var430_232));
                                                    var432_234 = var370_185.add(var431_233);
                                                    var433_235 = var34_37;
                                                    var435_236 = var91_121[var284_125];
                                                    var437_237 = var82_82[var284_125];
                                                    var439_238 = var411_220 - var437_237;
                                                    var441_239 = var435_236 * var439_238;
                                                    var442_240 = Float.valueOf((float)(var433_235 - var441_239));
                                                    var443_241 = var370_185.add(var442_240);
                                                    continue;
                                                }
                                                if (this.isRenderNullValues()) {
                                                    var444_242 = var16_16;
                                                    var446_243 = var90_120[var284_125];
                                                    var448_244 = var80_80[var284_125];
                                                    var450_245 = var409_219 - var448_244;
                                                    var452_246 = var446_243 * var450_245;
                                                    var453_247 = Float.valueOf((float)(var444_242 + var452_246));
                                                    var454_248 = var370_185.add(var453_247);
                                                    var455_249 = var34_37;
                                                    var457_250 = var91_121[var284_125];
                                                    var459_251 = -var82_82[var284_125];
                                                    var461_252 = var457_250 * var459_251;
                                                    var462_253 = Float.valueOf((float)(var455_249 - var461_252));
                                                    var463_254 = var370_185.add(var462_253);
                                                    continue;
                                                }
                                                if (var370_185.size() > 0) {
                                                    var464_255 = this;
                                                    var465_256 = var283_124;
                                                    var466_257 = var1_1;
                                                    var467_258 = var6_6;
                                                    var468_259 = var370_185;
                                                    var464_255.drawSeries(var465_256, var466_257, var467_258, var468_259, var369_184, var382_193, var22_22, var55_58, var393_202);
                                                    var469_260 = MathHelper.getFloats(var370_185);
                                                    var470_261 = MathHelper.getDoubles(var371_186);
                                                    var471_262 = this;
                                                    var472_263 = var382_193;
                                                    var473_264 = var22_22;
                                                    var474_265 = var393_202;
                                                    var475_266 = Arrays.asList(var471_262.clickableAreasForPoints(var469_260, var470_261, var472_263, var473_264, var474_265));
                                                    var476_267 = var383_194.addAll(var475_266);
                                                    var370_185.clear();
                                                    var371_186.clear();
                                                }
                                                var477_268 = var383_194.add(null);
                                            }
                                        }
                                        var478_306 = XYMultipleSeriesRenderer.Orientation.VERTICAL;
                                        if (var55_58 != var478_306) ** GOTO lbl166
                                        var479_307 = this.mRenderer;
                                        var480_308 = var4_4 - var19_19;
                                        var481_309 = var5_5 - var3_3;
                                        var482_310 = this.mRenderer.getMarginsColor();
                                        var483_311 = this;
                                        var484_312 = var1_1;
                                        var485_313 = var19_19;
                                        var486_314 = var3_3;
                                        var487_315 = var6_6;
                                        var483_311.drawBackground(var479_307, var484_312, var485_313, var486_314, var480_308, var481_309, var487_315, true, var482_310);
                                        var488_316 = this.mRenderer;
                                        var489_317 = var16_16 - var2_2;
                                        var490_318 = var5_5 - var3_3;
                                        var491_319 = this.mRenderer.getMarginsColor();
                                        var492_320 = this;
                                        var493_321 = var1_1;
                                        var494_322 = var2_2;
                                        var495_323 = var3_3;
                                        var496_324 = var6_6;
                                        var492_320.drawBackground(var488_316, var493_321, var494_322, var495_323, var489_317, var490_318, var496_324, true, var491_319);
                                        ** GOTO lbl166
                                    }
                                    var137_325 = false;
                                    ** while (true)
                                }
                                var497_366 = this.mRenderer;
                                var498_367 = var22_22;
                                var499_368 = var497_366.getYAxisAlign(var498_367);
                                var500_369 = this.mRenderer;
                                var501_370 = var22_22;
                                var502_371 = var500_369.getYTextLabelLocations(var501_370);
                                var394_204 = var502_371.length;
                                var503_372 = 0;
                                block19: while (true) {
                                    if (var503_372 >= var394_204) ** continue;
                                    var505_374 = var82_82[var22_22];
                                    var504_373 = var502_371[var503_372];
                                    var507_375 = var504_373;
                                    if (!(var505_374 <= var507_375) || !((var509_376 = var504_373.doubleValue()) <= (var511_377 = var83_83[var22_22]))) ** GOTO lbl608
                                    var513_378 = var34_37;
                                    var515_379 = var91_121[var22_22];
                                    var517_380 = var504_373;
                                    var519_381 = var82_82[var22_22];
                                    var521_382 = var517_380 - var519_381;
                                    var523_383 = var515_379 * var521_382;
                                    var524_384 = (float)(var513_378 - var523_383);
                                    var525_385 = this.mRenderer;
                                    var526_386 = var504_373;
                                    var527_387 = var22_22;
                                    var528_388 = var525_385.getYTextLabel(var526_386, var527_387);
                                    var529_389 = this.mRenderer;
                                    var530_390 = var22_22;
                                    var531_391 = var529_389.getYLabelsColor(var530_390);
                                    var6_6.setColor(var531_391);
                                    var532_392 = this.mRenderer;
                                    var533_393 = var22_22;
                                    var534_394 = var532_392.getYLabelsAlign(var533_393);
                                    var6_6.setTextAlign(var534_394);
                                    var535_395 = XYMultipleSeriesRenderer.Orientation.HORIZONTAL;
                                    if (var55_58 != var535_395) break block61;
                                    var536_396 = Paint.Align.LEFT;
                                    if (var499_368 != var536_396) break;
                                    var537_397 = this;
                                    var538_398 = var499_368;
                                    var539_399 = var537_397.getLabelLinePos(var538_398) + var16_16;
                                    var540_400 = var16_16;
                                    var541_401 = var1_1;
                                    var542_402 = var524_384;
                                    var543_403 = var6_6;
                                    var541_401.drawLine(var539_399, var524_384, var540_400, var542_402, var543_403);
                                    var544_404 = var16_16;
                                    var545_405 = var524_384 - 2.0f;
                                    var546_406 = this.mRenderer.getYLabelsAngle();
                                    var547_407 = this;
                                    var548_408 = var1_1;
                                    var549_409 = var6_6;
                                    var547_407.drawText(var548_408, var528_388, var544_404, var545_405, var549_409, var546_406);
lbl598:
                                    // 2 sources

                                    while (true) {
                                        if (var139_327) {
                                            var550_410 = this.mRenderer.getGridColor();
                                            var6_6.setColor(var550_410);
                                            var551_411 = var16_16;
                                            var552_412 = var19_19;
                                            var553_413 = var1_1;
                                            var554_414 = var524_384;
                                            var555_415 = var6_6;
                                            var553_413.drawLine(var551_411, var524_384, var552_412, var554_414, var555_415);
                                        }
lbl608:
                                        // 6 sources

                                        while (true) {
                                            ++var503_372;
                                            continue block19;
                                            break;
                                        }
                                        break;
                                    }
                                    break;
                                }
                                var556_416 = var19_19;
                                var557_417 = this;
                                var558_418 = var499_368;
                                var559_419 = var557_417.getLabelLinePos(var558_418) + var19_19;
                                var560_420 = var1_1;
                                var561_421 = var524_384;
                                var562_422 = var6_6;
                                var560_420.drawLine(var556_416, var524_384, var559_419, var561_421, var562_422);
                                var563_423 = var19_19;
                                var564_424 = var524_384 - 2.0f;
                                var565_425 = this.mRenderer.getYLabelsAngle();
                                var566_426 = this;
                                var567_427 = var1_1;
                                var568_428 = var6_6;
                                var566_426.drawText(var567_427, var528_388, var563_423, var564_424, var568_428, var565_425);
                                ** while (true)
                            }
                            var569_429 = this;
                            var570_430 = var499_368;
                            var571_431 = var569_429.getLabelLinePos(var570_430);
                            var572_432 = var19_19 - var571_431;
                            var573_433 = var19_19;
                            var574_434 = var1_1;
                            var575_435 = var524_384;
                            var576_436 = var6_6;
                            var574_434.drawLine(var572_432, var524_384, var573_433, var575_435, var576_436);
                            var577_437 = var19_19 + 10;
                            var578_438 = var524_384 - 2.0f;
                            var579_439 = this.mRenderer.getYLabelsAngle();
                            var580_440 = this;
                            var581_441 = var1_1;
                            var582_442 = var6_6;
                            var580_440.drawText(var581_441, var528_388, var577_437, var578_438, var582_442, var579_439);
                            if (!var139_327) ** GOTO lbl608
                            var583_443 = this.mRenderer.getGridColor();
                            var6_6.setColor(var583_443);
                            var584_444 = var19_19;
                            var585_445 = var16_16;
                            var586_446 = var1_1;
                            var587_447 = var524_384;
                            var588_448 = var6_6;
                            var586_446.drawLine(var584_444, var524_384, var585_445, var587_447, var588_448);
                            ** while (true)
                        }
                        var589_465 = this.mRenderer;
                        var590_466 = var22_22;
                        var591_467 = var589_465.getYAxisAlign(var590_466);
                        if (var591_467 == (var592_468 = Paint.Align.LEFT)) {
                            var593_469 = this.mRenderer;
                            var594_470 = var22_22;
                            var595_471 = var593_469.getYTitle(var594_470);
                            var596_472 = (float)var2_2 + var184_450;
                            var597_473 = var5_5 / 2 + var3_3;
                            var598_474 = this;
                            var599_475 = var1_1;
                            var600_476 = var6_6;
                            var598_474.drawText(var599_475, var595_471, var596_472, var597_473, var600_476, -90.0f);
lbl668:
                            // 2 sources

                            while (true) {
                                ** continue;
                                break;
                            }
                        }
                        var601_477 = this.mRenderer;
                        var602_478 = var22_22;
                        var603_479 = var601_477.getYTitle(var602_478);
                        var604_480 = var2_2 + var4_4;
                        var605_481 = var5_5 / 2 + var3_3;
                        var606_482 = this;
                        var607_483 = var1_1;
                        var608_484 = var6_6;
                        var606_482.drawText(var607_483, var603_479, var604_480, var605_481, var608_484, -90.0f);
                        ** while (true)
                    }
                    var609_494 = XYMultipleSeriesRenderer.Orientation.VERTICAL;
                    if (var55_58 != var609_494) ** GOTO lbl257
                    var610_495 = this.mRenderer.getXTitle();
                    var611_496 = var4_4 / 2 + var2_2;
                    var612_497 = (float)(var3_3 + var5_5) - var184_450;
                    var613_498 = this;
                    var614_499 = var1_1;
                    var615_500 = var6_6;
                    var613_498.drawText(var614_499, var610_495, var611_496, var612_497, var615_500, -90.0f);
                    var616_501 = this.mRenderer.getYTitle();
                    var617_502 = var19_19 + 20;
                    var618_503 = var5_5 / 2 + var3_3;
                    var619_504 = this;
                    var620_505 = var1_1;
                    var621_506 = var6_6;
                    var619_504.drawText(var620_505, var616_501, var617_502, var618_503, var621_506, 0.0f);
                    var622_507 = this.mRenderer.getChartTitleTextSize();
                    var6_6.setTextSize(var622_507);
                    var623_508 = this.mRenderer.getChartTitle();
                    var624_509 = (float)var2_2 + var184_450;
                    var625_510 = var5_5 / 2 + var14_14;
                    var626_511 = this;
                    var627_512 = var1_1;
                    var628_513 = var6_6;
                    var626_511.drawText(var627_512, var623_508, var624_509, var625_510, var628_513, 0.0f);
                    ** GOTO lbl257
                }
                var629_527 = XYMultipleSeriesRenderer.Orientation.VERTICAL;
                if (var55_58 != var629_527) ** GOTO lbl270
                var630_528 = var58_61;
                var631_529 = this;
                var632_530 = var1_1;
                var631_529.transform(var632_530, var630_528, true);
                var633_531 = this.mRenderer;
                var634_532 = this;
                var635_533 = var1_1;
                var636_534 = var21_21;
                var637_535 = var16_16;
                var638_536 = var19_19;
                var639_537 = var3_3;
                var640_538 = var4_4;
                var641_539 = var5_5;
                var642_540 = var11_11;
                var643_541 = var6_6;
                var644_542 = var634_532.drawLegend(var635_533, var633_531, var636_534, var637_535, var638_536, var639_537, var640_538, var641_539, var642_540, var643_541, false);
                var645_543 = var58_61;
                var646_544 = this;
                var647_545 = var1_1;
                var646_544.transform(var647_545, var645_543, false);
                ** while (true)
            }
            var648_556 = this.mRenderer;
            var649_557 = var22_22;
            var650_558 = var648_556.getYAxisAlign(var649_557);
            if (var650_558 == (var651_559 = Paint.Align.RIGHT)) {
                var228_553 = true;
lbl737:
                // 2 sources

                while (true) {
                    ** continue;
                    break;
                }
            }
            var228_553 = false;
            ** while (true)
        }
        var652_576 = XYMultipleSeriesRenderer.Orientation.VERTICAL;
        if (var55_58 != var652_576) ** GOTO lbl303
        var653_577 = var19_19;
        var654_578 = var14_14;
        var655_579 = var19_19;
        var656_580 = var34_37;
        var657_581 = var1_1;
        var658_582 = var6_6;
        var657_581.drawLine(var653_577, var654_578, var655_579, var656_580, var658_582);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void drawChartValuesText(Canvas canvas, XYSeries xYSeries, SimpleSeriesRenderer simpleSeriesRenderer, Paint paint, float[] fArray, int n, int n2) {
        int n3;
        if (fArray.length > 1) {
            int n4;
            float f = fArray[0];
            float f2 = fArray[1];
            for (int i = 0; i < (n4 = fArray.length); i += 2) {
                int n5;
                if (i == 2) {
                    float f3;
                    float f4;
                    float f5 = fArray[2];
                    float f6 = fArray[0];
                    if (!(Math.abs(f5 - f6) > 100.0f) && !(Math.abs((f4 = fArray[3]) - (f3 = fArray[1])) > 100.0f)) continue;
                    int n6 = n2;
                    double d = xYSeries.getY(n6);
                    String string2 = this.getLabel(d);
                    float f7 = fArray[0];
                    float f8 = fArray[1];
                    float f9 = simpleSeriesRenderer.getChartValuesSpacing();
                    float f10 = f8 - f9;
                    XYChart xYChart = this;
                    Canvas canvas2 = canvas;
                    Paint paint2 = paint;
                    xYChart.drawText(canvas2, string2, f7, f10, paint2, 0.0f);
                    int n7 = n2 + 1;
                    double d2 = xYSeries.getY(n7);
                    String string3 = this.getLabel(d2);
                    float f11 = fArray[2];
                    float f12 = fArray[3];
                    float f13 = simpleSeriesRenderer.getChartValuesSpacing();
                    float f14 = f12 - f13;
                    XYChart xYChart2 = this;
                    Canvas canvas3 = canvas;
                    Paint paint3 = paint;
                    xYChart2.drawText(canvas3, string3, f11, f14, paint3, 0.0f);
                    float f15 = fArray[2];
                    float f16 = fArray[3];
                    continue;
                }
                if (i <= 2 || !(Math.abs(fArray[i] - f) > 100.0f) && !(Math.abs(fArray[n5 = i + 1] - f2) > 100.0f)) continue;
                int n8 = i / 2 + n2;
                double d = xYSeries.getY(n8);
                String string4 = this.getLabel(d);
                float f17 = fArray[i];
                int n9 = i + 1;
                float f18 = fArray[n9];
                float f19 = simpleSeriesRenderer.getChartValuesSpacing();
                float f20 = f18 - f19;
                XYChart xYChart = this;
                Canvas canvas4 = canvas;
                Paint paint4 = paint;
                xYChart.drawText(canvas4, string4, f17, f20, paint4, 0.0f);
                float f21 = fArray[i];
                int n10 = i + 1;
                float f22 = fArray[n10];
            }
            return;
        }
        for (int i = 0; i < (n3 = fArray.length); i += 2) {
            int n11 = i / 2 + n2;
            double d = xYSeries.getY(n11);
            String string5 = this.getLabel(d);
            float f = fArray[i];
            int n12 = i + 1;
            float f23 = fArray[n12];
            float f24 = simpleSeriesRenderer.getChartValuesSpacing();
            float f25 = f23 - f24;
            XYChart xYChart = this;
            Canvas canvas5 = canvas;
            Paint paint5 = paint;
            xYChart.drawText(canvas5, string5, f, f25, paint5, 0.0f);
        }
    }

    public abstract void drawSeries(Canvas var1, Paint var2, float[] var3, SimpleSeriesRenderer var4, float var5, int var6, int var7);

    /*
     * Enabled aggressive block sorting
     */
    protected void drawSeries(XYSeries xYSeries, Canvas canvas, Paint paint, List<Float> list, SimpleSeriesRenderer simpleSeriesRenderer, float f, int n, XYMultipleSeriesRenderer.Orientation orientation, int n2) {
        ScatterChart scatterChart;
        BasicStroke basicStroke = simpleSeriesRenderer.getStroke();
        Paint.Cap cap = paint.getStrokeCap();
        Paint.Join join = paint.getStrokeJoin();
        float f2 = paint.getStrokeMiter();
        PathEffect pathEffect = paint.getPathEffect();
        Paint.Style style = paint.getStyle();
        if (basicStroke != null) {
            DashPathEffect dashPathEffect = null;
            if (basicStroke.getIntervals() != null) {
                float[] fArray = basicStroke.getIntervals();
                float f3 = basicStroke.getPhase();
                dashPathEffect = new DashPathEffect(fArray, f3);
            }
            Paint.Cap cap2 = basicStroke.getCap();
            Paint.Join join2 = basicStroke.getJoin();
            float f4 = basicStroke.getMiter();
            Paint.Style style2 = Paint.Style.FILL_AND_STROKE;
            XYChart xYChart = this;
            Paint paint2 = paint;
            xYChart.setStroke(cap2, join2, f4, style2, (PathEffect)dashPathEffect, paint2);
        }
        float[] fArray = MathHelper.getFloats(list);
        XYChart xYChart = this;
        Canvas canvas2 = canvas;
        Paint paint3 = paint;
        SimpleSeriesRenderer simpleSeriesRenderer2 = simpleSeriesRenderer;
        float f5 = f;
        int n3 = n;
        int n4 = n2;
        xYChart.drawSeries(canvas2, paint3, fArray, simpleSeriesRenderer2, f5, n3, n4);
        XYChart xYChart2 = this;
        SimpleSeriesRenderer simpleSeriesRenderer3 = simpleSeriesRenderer;
        if (xYChart2.isRenderPoints(simpleSeriesRenderer3) && (scatterChart = this.getPointsChart()) != null) {
            Canvas canvas3 = canvas;
            Paint paint4 = paint;
            SimpleSeriesRenderer simpleSeriesRenderer4 = simpleSeriesRenderer;
            float f6 = f;
            int n5 = n;
            int n6 = n2;
            scatterChart.drawSeries(canvas3, paint4, fArray, simpleSeriesRenderer4, f6, n5, n6);
        }
        float f7 = simpleSeriesRenderer.getChartValuesTextSize();
        paint.setTextSize(f7);
        XYMultipleSeriesRenderer.Orientation orientation2 = XYMultipleSeriesRenderer.Orientation.HORIZONTAL;
        if (orientation == orientation2) {
            Paint.Align align = Paint.Align.CENTER;
            paint.setTextAlign(align);
        } else {
            Paint.Align align = Paint.Align.LEFT;
            paint.setTextAlign(align);
        }
        if (simpleSeriesRenderer.isDisplayChartValues()) {
            Paint.Align align = simpleSeriesRenderer.getChartValuesTextAlign();
            paint.setTextAlign(align);
            XYChart xYChart3 = this;
            Canvas canvas4 = canvas;
            XYSeries xYSeries2 = xYSeries;
            SimpleSeriesRenderer simpleSeriesRenderer5 = simpleSeriesRenderer;
            Paint paint5 = paint;
            float[] fArray2 = fArray;
            int n7 = n;
            int n8 = n2;
            xYChart3.drawChartValuesText(canvas4, xYSeries2, simpleSeriesRenderer5, paint5, fArray2, n7, n8);
        }
        if (basicStroke != null) {
            XYChart xYChart4 = this;
            Paint.Cap cap3 = cap;
            Paint.Join join3 = join;
            float f8 = f2;
            Paint.Style style3 = style;
            PathEffect pathEffect2 = pathEffect;
            Paint paint6 = paint;
            xYChart4.setStroke(cap3, join3, f8, style3, pathEffect2, paint6);
        }
    }

    protected void drawText(Canvas canvas, String string2, float f, float f2, Paint paint, float f3) {
        float f4 = (float)(-this.mRenderer.getOrientation().getAngle()) + f3;
        if (f4 != 0.0f) {
            canvas.rotate(f4, f, f2);
        }
        this.drawString(canvas, string2, f, f2, paint);
        if (f4 != 0.0f) {
            float f5 = -f4;
            canvas.rotate(f5, f, f2);
        }
    }

    protected void drawXLabels(List<Double> list, Double[] doubleArray, Canvas canvas, Paint paint, int n, int n2, int n3, double d, double d2, double d3) {
        int n4 = list.size();
        boolean bl = this.mRenderer.isShowLabels();
        boolean bl2 = this.mRenderer.isShowGridY();
        int n5 = 0;
        while (true) {
            int n6;
            int n7;
            if ((n7 = ++n5) >= (n6 = n4)) {
                XYChart xYChart = this;
                Double[] doubleArray2 = doubleArray;
                Canvas canvas2 = canvas;
                Paint paint2 = paint;
                boolean bl3 = bl;
                int n8 = n;
                int n9 = n2;
                int n10 = n3;
                double d4 = d;
                double d5 = d2;
                double d6 = d3;
                xYChart.drawXTextLabels(doubleArray2, canvas2, paint2, bl3, n8, n9, n10, d4, d5, d6);
                return;
            }
            List<Double> list2 = list;
            int n11 = n5;
            double d7 = list2.get(n11);
            double d8 = n;
            double d9 = (d7 - d2) * d;
            float f = (float)(d8 + d9);
            if (bl) {
                int n12 = this.mRenderer.getXLabelsColor();
                paint.setColor(n12);
                float f2 = n3;
                float f3 = n3;
                float f4 = this.mRenderer.getLabelsTextSize() / 3.0f;
                float f5 = f3 + f4;
                Canvas canvas3 = canvas;
                float f6 = f;
                Paint paint3 = paint;
                canvas3.drawLine(f, f2, f6, f5, paint3);
                XYChart xYChart = this;
                double d10 = d7;
                String string2 = xYChart.getLabel(d10);
                float f7 = n3;
                float f8 = this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f;
                float f9 = f7 + f8;
                float f10 = this.mRenderer.getXLabelsAngle();
                XYChart xYChart2 = this;
                Canvas canvas4 = canvas;
                float f11 = f;
                Paint paint4 = paint;
                xYChart2.drawText(canvas4, string2, f11, f9, paint4, f10);
            }
            if (!bl2) continue;
            int n13 = this.mRenderer.getGridColor();
            paint.setColor(n13);
            float f12 = n3;
            float f13 = n2;
            Canvas canvas5 = canvas;
            float f14 = f;
            Paint paint5 = paint;
            canvas5.drawLine(f, f12, f14, f13, paint5);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void drawXTextLabels(Double[] doubleArray, Canvas canvas, Paint paint, boolean bl, int n, int n2, int n3, double d, double d2, double d3) {
        boolean bl2 = this.mRenderer.isShowCustomTextGrid();
        if (!bl) return;
        int n4 = this.mRenderer.getXLabelsColor();
        paint.setColor(n4);
        int n5 = doubleArray.length;
        int n6 = 0;
        while (n6 < n5) {
            Double d4 = doubleArray[n6];
            double d5 = d4;
            if (d2 <= d5 && d4 <= d3) {
                double d6 = n;
                double d7 = (d4 - d2) * d;
                float f = (float)(d6 + d7);
                int n7 = this.mRenderer.getXLabelsColor();
                paint.setColor(n7);
                float f2 = n3;
                float f3 = n3;
                float f4 = this.mRenderer.getLabelsTextSize() / 3.0f;
                float f5 = f3 + f4;
                Canvas canvas2 = canvas;
                float f6 = f;
                Paint paint2 = paint;
                canvas2.drawLine(f, f2, f6, f5, paint2);
                String string2 = this.mRenderer.getXTextLabel(d4);
                float f7 = n3;
                float f8 = this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f;
                float f9 = f7 + f8;
                float f10 = this.mRenderer.getXLabelsAngle();
                XYChart xYChart = this;
                Canvas canvas3 = canvas;
                float f11 = f;
                Paint paint3 = paint;
                xYChart.drawText(canvas3, string2, f11, f9, paint3, f10);
                if (bl2) {
                    int n8 = this.mRenderer.getGridColor();
                    paint.setColor(n8);
                    float f12 = n3;
                    float f13 = n2;
                    Canvas canvas4 = canvas;
                    float f14 = f;
                    Paint paint4 = paint;
                    canvas4.drawLine(f, f12, f14, f13, paint4);
                }
            }
            ++n6;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void drawYLabels(Map<Integer, List<Double>> map, Canvas canvas, Paint paint, int n, int n2, int n3, int n4, double[] dArray, double[] dArray2) {
        XYMultipleSeriesRenderer.Orientation orientation = this.mRenderer.getOrientation();
        boolean bl = this.mRenderer.isShowGridX();
        boolean bl2 = this.mRenderer.isShowLabels();
        int n5 = 0;
        int n6;
        block0: while (n5 < (n6 = n)) {
            Paint.Align align = this.mRenderer.getYLabelsAlign(n5);
            paint.setTextAlign(align);
            Integer n7 = n5;
            List<Double> list = map.get(n7);
            int n8 = list.size();
            int n9 = 0;
            while (true) {
                int n10;
                if (n9 >= (n10 = n8)) {
                    ++n5;
                    continue block0;
                }
                double d = list.get(n9);
                Paint.Align align2 = this.mRenderer.getYAxisAlign(n5);
                XYMultipleSeriesRenderer xYMultipleSeriesRenderer = this.mRenderer;
                Double d2 = d;
                boolean bl3 = xYMultipleSeriesRenderer.getYTextLabel(d2, n5) != null;
                double d3 = n4;
                double d4 = dArray[n5];
                double d5 = dArray2[n5];
                double d6 = d - d5;
                double d7 = d4 * d6;
                float f = (float)(d3 - d7);
                XYMultipleSeriesRenderer.Orientation orientation2 = XYMultipleSeriesRenderer.Orientation.HORIZONTAL;
                if (orientation == orientation2) {
                    if (bl2 && !bl3) {
                        int n11 = this.mRenderer.getYLabelsColor(n5);
                        paint.setColor(n11);
                        Paint.Align align3 = Paint.Align.LEFT;
                        if (align2 == align3) {
                            float f2 = this.getLabelLinePos(align2) + n2;
                            float f3 = n2;
                            Canvas canvas2 = canvas;
                            float f4 = f;
                            Paint paint2 = paint;
                            canvas2.drawLine(f2, f, f3, f4, paint2);
                            String string2 = this.getLabel(d);
                            float f5 = n2;
                            float f6 = f - 2.0f;
                            float f7 = this.mRenderer.getYLabelsAngle();
                            XYChart xYChart = this;
                            Canvas canvas3 = canvas;
                            Paint paint3 = paint;
                            xYChart.drawText(canvas3, string2, f5, f6, paint3, f7);
                        } else {
                            float f8 = n3;
                            float f9 = this.getLabelLinePos(align2) + n3;
                            Canvas canvas4 = canvas;
                            float f10 = f;
                            Paint paint4 = paint;
                            canvas4.drawLine(f8, f, f9, f10, paint4);
                            String string3 = this.getLabel(d);
                            float f11 = n3;
                            float f12 = f - 2.0f;
                            float f13 = this.mRenderer.getYLabelsAngle();
                            XYChart xYChart = this;
                            Canvas canvas5 = canvas;
                            Paint paint5 = paint;
                            xYChart.drawText(canvas5, string3, f11, f12, paint5, f13);
                        }
                    }
                    if (bl) {
                        int n12 = this.mRenderer.getGridColor();
                        paint.setColor(n12);
                        float f14 = n2;
                        float f15 = n3;
                        Canvas canvas6 = canvas;
                        float f16 = f;
                        Paint paint6 = paint;
                        canvas6.drawLine(f14, f, f15, f16, paint6);
                    }
                } else {
                    XYMultipleSeriesRenderer.Orientation orientation3 = XYMultipleSeriesRenderer.Orientation.VERTICAL;
                    if (orientation == orientation3) {
                        if (bl2 && !bl3) {
                            int n13 = this.mRenderer.getYLabelsColor(n5);
                            paint.setColor(n13);
                            int n14 = this.getLabelLinePos(align2);
                            float f17 = n3 - n14;
                            float f18 = n3;
                            Canvas canvas7 = canvas;
                            float f19 = f;
                            Paint paint7 = paint;
                            canvas7.drawLine(f17, f, f18, f19, paint7);
                            String string4 = this.getLabel(d);
                            float f20 = n3 + 10;
                            float f21 = f - 2.0f;
                            float f22 = this.mRenderer.getYLabelsAngle();
                            XYChart xYChart = this;
                            Canvas canvas8 = canvas;
                            Paint paint8 = paint;
                            xYChart.drawText(canvas8, string4, f20, f21, paint8, f22);
                        }
                        if (bl) {
                            int n15 = this.mRenderer.getGridColor();
                            paint.setColor(n15);
                            float f23 = n3;
                            float f24 = n2;
                            Canvas canvas9 = canvas;
                            float f25 = f;
                            Paint paint9 = paint;
                            canvas9.drawLine(f23, f, f24, f25, paint9);
                        }
                    }
                }
                ++n9;
            }
            break;
        }
        return;
    }

    public double[] getCalcRange(int n) {
        Map<Integer, double[]> map = this.mCalcRange;
        Integer n2 = n;
        return map.get(n2);
    }

    public abstract String getChartType();

    public XYMultipleSeriesDataset getDataset() {
        return this.mDataset;
    }

    public double getDefaultMinimum() {
        return 0x7FEFFFFFFFFFFFFFL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getLabel(double d) {
        double d2 = Math.round(d);
        if (d == d2) {
            String string2 = String.valueOf(Math.round(d));
            return string2;
        }
        String string3 = String.valueOf(d);
        return string3;
    }

    public ScatterChart getPointsChart() {
        return null;
    }

    public XYMultipleSeriesRenderer getRenderer() {
        return this.mRenderer;
    }

    protected Rect getScreenR() {
        return this.mScreenR;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    @Override
    public SeriesSelection getSeriesAndPointForScreenCoordinate(Point point) {
        if (this.clickableAreas == null) return super.getSeriesAndPointForScreenCoordinate(point);
        int n = this.clickableAreas.size() + -1;
        block0: while (n >= 0) {
            int n2 = 0;
            boolean bl = true;
            while (true) {
                float f;
                float f2;
                Iterator<ClickableArea> iterator;
                block8: {
                    block7: {
                        block6: {
                            if (!bl || (bl = false)) break block6;
                            Map<Integer, List<ClickableArea>> map = this.clickableAreas;
                            Integer n3 = n;
                            if (map.get(n3) == null) break block7;
                            Map<Integer, List<ClickableArea>> map2 = this.clickableAreas;
                            Integer n4 = n;
                            iterator = map2.get(n4).iterator();
                        }
                        if (iterator.hasNext()) break block8;
                    }
                    n += -1;
                    continue block0;
                }
                ClickableArea clickableArea = (ClickableArea)iterator.next();
                RectF rectF = clickableArea.getRect();
                if (rectF != null && rectF.contains(f2 = point.getX(), f = point.getY())) {
                    double d = clickableArea.getX();
                    double d2 = clickableArea.getY();
                    return new SeriesSelection(n, n2, d, d2);
                }
                ++n2;
            }
            break;
        }
        return super.getSeriesAndPointForScreenCoordinate(point);
    }

    protected List<Double> getXLabels(double d, double d2, int n) {
        return MathHelper.getLabels(d, d2, n);
    }

    protected Map<Integer, List<Double>> getYLabels(double[] dArray, double[] dArray2, int n) {
        HashMap<Integer, List<Double>> hashMap = new HashMap<Integer, List<Double>>();
        int n2 = 0;
        while (n2 < n) {
            Integer n3 = n2;
            double d = dArray[n2];
            double d2 = dArray2[n2];
            int n4 = this.mRenderer.getYLabels();
            List<Double> list = MathHelper.getLabels(d, d2, n4);
            List<Double> list2 = this.getValidLabels(list);
            List<Double> list3 = hashMap.put(n3, list2);
            ++n2;
        }
        return hashMap;
    }

    protected boolean isRenderNullValues() {
        return false;
    }

    public boolean isRenderPoints(SimpleSeriesRenderer simpleSeriesRenderer) {
        return false;
    }

    public void setCalcRange(double[] dArray, int n) {
        Map<Integer, double[]> map = this.mCalcRange;
        Integer n2 = n;
        double[] dArray2 = map.put(n2, dArray);
    }

    protected void setDatasetRenderer(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        this.mDataset = xYMultipleSeriesDataset;
        this.mRenderer = xYMultipleSeriesRenderer;
    }

    protected void setScreenR(Rect rect) {
        this.mScreenR = rect;
    }

    public double[] toRealPoint(float f, float f2) {
        return this.toRealPoint(f, f2, 0);
    }

    public double[] toRealPoint(float f, float f2, int n) {
        double d;
        double d2;
        XYMultipleSeriesRenderer xYMultipleSeriesRenderer = this.mRenderer;
        int n2 = n;
        double d3 = xYMultipleSeriesRenderer.getXAxisMin(n2);
        XYMultipleSeriesRenderer xYMultipleSeriesRenderer2 = this.mRenderer;
        int n3 = n;
        double d4 = xYMultipleSeriesRenderer2.getXAxisMax(n3);
        XYMultipleSeriesRenderer xYMultipleSeriesRenderer3 = this.mRenderer;
        int n4 = n;
        double d5 = xYMultipleSeriesRenderer3.getYAxisMin(n4);
        XYMultipleSeriesRenderer xYMultipleSeriesRenderer4 = this.mRenderer;
        int n5 = n;
        double d6 = xYMultipleSeriesRenderer4.getYAxisMax(n5);
        double[] dArray = new double[2];
        float f3 = this.mScreenR.left;
        double d7 = f - f3;
        double d8 = d4 - d3;
        double d9 = d7 * d8;
        double d10 = this.mScreenR.width();
        dArray[0] = d2 = d9 / d10 + d3;
        int n6 = this.mScreenR.top;
        int n7 = this.mScreenR.height();
        double d11 = (float)(n6 + n7) - f2;
        double d12 = d6 - d5;
        double d13 = d11 * d12;
        double d14 = this.mScreenR.height();
        dArray[1] = d = d13 / d14 + d5;
        return dArray;
    }

    public double[] toScreenPoint(double[] dArray) {
        return this.toScreenPoint(dArray, 0);
    }

    public double[] toScreenPoint(double[] dArray, int n) {
        double d;
        double d2;
        int n2;
        XYMultipleSeriesRenderer xYMultipleSeriesRenderer;
        int n3;
        XYMultipleSeriesRenderer xYMultipleSeriesRenderer2;
        int n4;
        XYMultipleSeriesRenderer xYMultipleSeriesRenderer3;
        XYMultipleSeriesRenderer xYMultipleSeriesRenderer4 = this.mRenderer;
        int n5 = n;
        double d3 = xYMultipleSeriesRenderer4.getXAxisMin(n5);
        XYMultipleSeriesRenderer xYMultipleSeriesRenderer5 = this.mRenderer;
        int n6 = n;
        double d4 = xYMultipleSeriesRenderer5.getXAxisMax(n6);
        XYMultipleSeriesRenderer xYMultipleSeriesRenderer6 = this.mRenderer;
        int n7 = n;
        double d5 = xYMultipleSeriesRenderer6.getYAxisMin(n7);
        XYMultipleSeriesRenderer xYMultipleSeriesRenderer7 = this.mRenderer;
        int n8 = n;
        double d6 = xYMultipleSeriesRenderer7.getYAxisMax(n8);
        XYMultipleSeriesRenderer xYMultipleSeriesRenderer8 = this.mRenderer;
        int n9 = n;
        if (!(xYMultipleSeriesRenderer8.isMinXSet(n9) && (xYMultipleSeriesRenderer3 = this.mRenderer).isMaxXSet(n4 = n) && (xYMultipleSeriesRenderer2 = this.mRenderer).isMinXSet(n3 = n) && (xYMultipleSeriesRenderer = this.mRenderer).isMaxYSet(n2 = n))) {
            XYChart xYChart = this;
            int n10 = n;
            double[] dArray2 = xYChart.getCalcRange(n10);
            double d7 = dArray2[0];
            double d8 = dArray2[1];
            double d9 = dArray2[2];
            double d10 = dArray2[3];
        }
        double[] dArray3 = new double[2];
        double d11 = dArray[0] - d3;
        double d12 = this.mScreenR.width();
        double d13 = d11 * d12;
        double d14 = d4 - d3;
        double d15 = d13 / d14;
        double d16 = this.mScreenR.left;
        dArray3[0] = d2 = d15 + d16;
        double d17 = dArray[1];
        double d18 = d6 - d17;
        double d19 = this.mScreenR.height();
        double d20 = d18 * d19;
        double d21 = d6 - d5;
        double d22 = d20 / d21;
        double d23 = this.mScreenR.top;
        dArray3[1] = d = d22 + d23;
        return dArray3;
    }
}

