/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.renderer;

import android.graphics.Color;
import android.graphics.Paint;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.renderer.SimpleSeriesRenderer;

public class XYMultipleSeriesRenderer
extends DefaultRenderer {
    private Map<Integer, double[]> initialRange;
    private float mAxisTitleTextSize = 12.0f;
    private double mBarSpacing;
    private int mGridColor;
    private int mMarginsColor;
    private double[] mMaxX;
    private double[] mMaxY;
    private double[] mMinX;
    private double[] mMinY;
    private Orientation mOrientation;
    private double[] mPanLimits;
    private boolean mPanXEnabled;
    private boolean mPanYEnabled;
    private float mPointSize;
    private int mXLabels = 5;
    private float mXLabelsAngle;
    private int mXLabelsColor;
    private Map<Double, String> mXTextLabels;
    private String mXTitle = "";
    private int mYLabels = 5;
    private float mYLabelsAngle;
    private int[] mYLabelsColor;
    private Map<Integer, Map<Double, String>> mYTextLabels;
    private String[] mYTitle;
    private double[] mZoomLimits;
    private boolean mZoomXEnabled;
    private boolean mZoomYEnabled;
    private int scalesCount;
    private Paint.Align xLabelsAlign;
    private Paint.Align[] yAxisAlign;
    private Paint.Align[] yLabelsAlign;

    public XYMultipleSeriesRenderer() {
        this(1);
    }

    public XYMultipleSeriesRenderer(int n) {
        Paint.Align align;
        int n2;
        Orientation orientation;
        this.mOrientation = orientation = Orientation.HORIZONTAL;
        HashMap<Double, String> hashMap = new HashMap<Double, String>();
        this.mXTextLabels = hashMap;
        LinkedHashMap<Integer, Map<Double, String>> linkedHashMap = new LinkedHashMap<Integer, Map<Double, String>>();
        this.mYTextLabels = linkedHashMap;
        this.mPanXEnabled = 1;
        this.mPanYEnabled = 1;
        this.mZoomXEnabled = 1;
        this.mZoomYEnabled = 1;
        this.mBarSpacing = 0.0;
        this.mMarginsColor = 0;
        LinkedHashMap<Integer, double[]> linkedHashMap2 = new LinkedHashMap<Integer, double[]>();
        this.initialRange = linkedHashMap2;
        this.mPointSize = 3.0f;
        this.mGridColor = n2 = Color.argb((int)75, (int)200, (int)200, (int)200);
        this.xLabelsAlign = align = Paint.Align.CENTER;
        this.mXLabelsColor = -3355444;
        int[] nArray = new int[]{-3355444};
        this.mYLabelsColor = nArray;
        this.scalesCount = n;
        this.initAxesRange(n);
    }

    public void addTextLabel(double d, String string2) {
        this.addXTextLabel(d, string2);
    }

    public void addXTextLabel(double d, String string2) {
        Map<Double, String> map = this.mXTextLabels;
        Double d2 = d;
        String string3 = map.put(d2, string2);
    }

    public void addYTextLabel(double d, String string2) {
        this.addYTextLabel(d, string2, 0);
    }

    public void addYTextLabel(double d, String string2, int n) {
        Map<Integer, Map<Double, String>> map = this.mYTextLabels;
        Integer n2 = n;
        Map<Double, String> map2 = map.get(n2);
        Double d2 = d;
        String string3 = map2.put(d2, string2);
    }

    public void clearTextLabels() {
        this.clearXTextLabels();
    }

    public void clearXTextLabels() {
        this.mXTextLabels.clear();
    }

    public void clearYTextLabels() {
        this.mYTextLabels.clear();
    }

    public float getAxisTitleTextSize() {
        return this.mAxisTitleTextSize;
    }

    public double getBarSpacing() {
        return this.mBarSpacing;
    }

    public double getBarsSpacing() {
        return this.getBarSpacing();
    }

    public int getGridColor() {
        return this.mGridColor;
    }

    public double[] getInitialRange() {
        return this.getInitialRange(0);
    }

    public double[] getInitialRange(int n) {
        Map<Integer, double[]> map = this.initialRange;
        Integer n2 = n;
        return map.get(n2);
    }

    public int getMarginsColor() {
        return this.mMarginsColor;
    }

    public Orientation getOrientation() {
        return this.mOrientation;
    }

    public double[] getPanLimits() {
        return this.mPanLimits;
    }

    public float getPointSize() {
        return this.mPointSize;
    }

    public int getScalesCount() {
        return this.scalesCount;
    }

    public double getXAxisMax() {
        return this.getXAxisMax(0);
    }

    public double getXAxisMax(int n) {
        return this.mMaxX[n];
    }

    public double getXAxisMin() {
        return this.getXAxisMin(0);
    }

    public double getXAxisMin(int n) {
        return this.mMinX[n];
    }

    public int getXLabels() {
        return this.mXLabels;
    }

    public Paint.Align getXLabelsAlign() {
        return this.xLabelsAlign;
    }

    public float getXLabelsAngle() {
        return this.mXLabelsAngle;
    }

    public int getXLabelsColor() {
        return this.mXLabelsColor;
    }

    public String getXTextLabel(Double d) {
        return this.mXTextLabels.get(d);
    }

    public Double[] getXTextLabelLocations() {
        Set<Double> set = this.mXTextLabels.keySet();
        Double[] doubleArray = new Double[]{};
        return set.toArray(doubleArray);
    }

    public String getXTitle() {
        return this.mXTitle;
    }

    public Paint.Align getYAxisAlign(int n) {
        return this.yAxisAlign[n];
    }

    public double getYAxisMax() {
        return this.getYAxisMax(0);
    }

    public double getYAxisMax(int n) {
        return this.mMaxY[n];
    }

    public double getYAxisMin() {
        return this.getYAxisMin(0);
    }

    public double getYAxisMin(int n) {
        return this.mMinY[n];
    }

    public int getYLabels() {
        return this.mYLabels;
    }

    public Paint.Align getYLabelsAlign(int n) {
        return this.yLabelsAlign[n];
    }

    public float getYLabelsAngle() {
        return this.mYLabelsAngle;
    }

    public int getYLabelsColor(int n) {
        return this.mYLabelsColor[n];
    }

    public String getYTextLabel(Double d) {
        return this.getYTextLabel(d, 0);
    }

    public String getYTextLabel(Double d, int n) {
        Map<Integer, Map<Double, String>> map = this.mYTextLabels;
        Integer n2 = n;
        return map.get(n2).get(d);
    }

    public Double[] getYTextLabelLocations() {
        return this.getYTextLabelLocations(0);
    }

    public Double[] getYTextLabelLocations(int n) {
        Map<Integer, Map<Double, String>> map = this.mYTextLabels;
        Integer n2 = n;
        Set<Double> set = map.get(n2).keySet();
        Double[] doubleArray = new Double[]{};
        return set.toArray(doubleArray);
    }

    public String getYTitle() {
        return this.getYTitle(0);
    }

    public String getYTitle(int n) {
        return this.mYTitle[n];
    }

    public double[] getZoomLimits() {
        return this.mZoomLimits;
    }

    public void initAxesRange(int n) {
        String[] stringArray = new String[n];
        this.mYTitle = stringArray;
        Paint.Align[] alignArray = new Paint.Align[n];
        this.yLabelsAlign = alignArray;
        Paint.Align[] alignArray2 = new Paint.Align[n];
        this.yAxisAlign = alignArray2;
        int[] nArray = new int[n];
        this.mYLabelsColor = nArray;
        double[] dArray = new double[n];
        this.mMinX = dArray;
        double[] dArray2 = new double[n];
        this.mMaxX = dArray2;
        double[] dArray3 = new double[n];
        this.mMinY = dArray3;
        double[] dArray4 = new double[n];
        this.mMaxY = dArray4;
        int n2 = 0;
        while (n2 < n) {
            this.mYLabelsColor[n2] = -3355444;
            this.initAxesRangeForScale(n2);
            ++n2;
        }
        return;
    }

    public void initAxesRangeForScale(int n) {
        Paint.Align align;
        Paint.Align align2;
        this.mMinX[n] = 0x7FEFFFFFFFFFFFFFL;
        this.mMaxX[n] = -4503599627370497L;
        this.mMinY[n] = 0x7FEFFFFFFFFFFFFFL;
        this.mMaxY[n] = -4503599627370497L;
        double d = this.mMinX[n];
        double d2 = this.mMaxX[n];
        double d3 = this.mMinY[n];
        double d4 = this.mMaxY[n];
        double[] dArray = new double[]{d, d2, d3, d4};
        Map<Integer, double[]> map = this.initialRange;
        Integer n2 = n;
        double[] dArray2 = map.put(n2, dArray);
        this.mYTitle[n] = "";
        Map<Integer, Map<Double, String>> map2 = this.mYTextLabels;
        Integer n3 = n;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = map2.put(n3, hashMap);
        Paint.Align[] alignArray = this.yLabelsAlign;
        alignArray[n] = align2 = Paint.Align.CENTER;
        Paint.Align[] alignArray2 = this.yAxisAlign;
        alignArray2[n] = align = Paint.Align.LEFT;
    }

    public boolean isInitialRangeSet() {
        return this.isInitialRangeSet(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInitialRangeSet(int n) {
        Map<Integer, double[]> map = this.initialRange;
        Integer n2 = n;
        if (map.get(n2) == null) return false;
        return true;
    }

    public boolean isMaxXSet() {
        return this.isMaxXSet(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMaxXSet(int n) {
        if (this.mMaxX[n] == -1.7976931348623157E308) return false;
        return true;
    }

    public boolean isMaxYSet() {
        return this.isMaxYSet(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMaxYSet(int n) {
        if (this.mMaxY[n] == -1.7976931348623157E308) return false;
        return true;
    }

    public boolean isMinXSet() {
        return this.isMinXSet(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMinXSet(int n) {
        if (this.mMinX[n] == Double.MAX_VALUE) return false;
        return true;
    }

    public boolean isMinYSet() {
        return this.isMinYSet(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMinYSet(int n) {
        if (this.mMinY[n] == Double.MAX_VALUE) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isPanEnabled() {
        if (this.isPanXEnabled()) return true;
        if (this.isPanYEnabled()) return true;
        return false;
    }

    public boolean isPanXEnabled() {
        return this.mPanXEnabled;
    }

    public boolean isPanYEnabled() {
        return this.mPanYEnabled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isZoomEnabled() {
        if (this.isZoomXEnabled()) return true;
        if (this.isZoomYEnabled()) return true;
        return false;
    }

    public boolean isZoomXEnabled() {
        return this.mZoomXEnabled;
    }

    public boolean isZoomYEnabled() {
        return this.mZoomYEnabled;
    }

    public void setAxisTitleTextSize(float f) {
        this.mAxisTitleTextSize = f;
    }

    public void setBarSpacing(double d) {
        this.mBarSpacing = d;
    }

    public void setChartValuesTextSize(float f) {
        SimpleSeriesRenderer[] simpleSeriesRendererArray = this.getSeriesRenderers();
        int n = simpleSeriesRendererArray.length;
        int n2 = 0;
        while (n2 < n) {
            simpleSeriesRendererArray[n2].setChartValuesTextSize(f);
            ++n2;
        }
        return;
    }

    public void setDisplayChartValues(boolean bl) {
        SimpleSeriesRenderer[] simpleSeriesRendererArray = this.getSeriesRenderers();
        int n = simpleSeriesRendererArray.length;
        int n2 = 0;
        while (n2 < n) {
            simpleSeriesRendererArray[n2].setDisplayChartValues(bl);
            ++n2;
        }
        return;
    }

    public void setGridColor(int n) {
        this.mGridColor = n;
    }

    public void setInitialRange(double[] dArray) {
        this.setInitialRange(dArray, 0);
    }

    public void setInitialRange(double[] dArray, int n) {
        Map<Integer, double[]> map = this.initialRange;
        Integer n2 = n;
        double[] dArray2 = map.put(n2, dArray);
    }

    public void setMarginsColor(int n) {
        this.mMarginsColor = n;
    }

    public void setOrientation(Orientation orientation) {
        this.mOrientation = orientation;
    }

    public void setPanEnabled(boolean bl, boolean bl2) {
        this.mPanXEnabled = bl;
        this.mPanYEnabled = bl2;
    }

    public void setPanLimits(double[] dArray) {
        this.mPanLimits = dArray;
    }

    public void setPointSize(float f) {
        this.mPointSize = f;
    }

    public void setRange(double[] dArray) {
        this.setRange(dArray, 0);
    }

    public void setRange(double[] dArray, int n) {
        double d = dArray[0];
        this.setXAxisMin(d, n);
        double d2 = dArray[1];
        this.setXAxisMax(d2, n);
        double d3 = dArray[2];
        this.setYAxisMin(d3, n);
        double d4 = dArray[3];
        this.setYAxisMax(d4, n);
    }

    public void setXAxisMax(double d) {
        this.setXAxisMax(d, 0);
    }

    public void setXAxisMax(double d, int n) {
        if (!this.isMaxXSet(n)) {
            Map<Integer, double[]> map = this.initialRange;
            Integer n2 = n;
            map.get((Object)n2)[1] = d;
        }
        this.mMaxX[n] = d;
    }

    public void setXAxisMin(double d) {
        this.setXAxisMin(d, 0);
    }

    public void setXAxisMin(double d, int n) {
        if (!this.isMinXSet(n)) {
            Map<Integer, double[]> map = this.initialRange;
            Integer n2 = n;
            map.get((Object)n2)[0] = d;
        }
        this.mMinX[n] = d;
    }

    public void setXLabels(int n) {
        this.mXLabels = n;
    }

    public void setXLabelsAlign(Paint.Align align) {
        this.xLabelsAlign = align;
    }

    public void setXLabelsAngle(float f) {
        this.mXLabelsAngle = f;
    }

    public void setXLabelsColor(int n) {
        this.mXLabelsColor = n;
    }

    public void setXTitle(String string2) {
        this.mXTitle = string2;
    }

    public void setYAxisAlign(Paint.Align align, int n) {
        this.yAxisAlign[n] = align;
    }

    public void setYAxisMax(double d) {
        this.setYAxisMax(d, 0);
    }

    public void setYAxisMax(double d, int n) {
        if (!this.isMaxYSet(n)) {
            Map<Integer, double[]> map = this.initialRange;
            Integer n2 = n;
            map.get((Object)n2)[3] = d;
        }
        this.mMaxY[n] = d;
    }

    public void setYAxisMin(double d) {
        this.setYAxisMin(d, 0);
    }

    public void setYAxisMin(double d, int n) {
        if (!this.isMinYSet(n)) {
            Map<Integer, double[]> map = this.initialRange;
            Integer n2 = n;
            map.get((Object)n2)[2] = d;
        }
        this.mMinY[n] = d;
    }

    public void setYLabels(int n) {
        this.mYLabels = n;
    }

    public void setYLabelsAlign(Paint.Align align) {
        this.setYLabelsAlign(align, 0);
    }

    public void setYLabelsAlign(Paint.Align align, int n) {
        this.yLabelsAlign[n] = align;
    }

    public void setYLabelsAngle(float f) {
        this.mYLabelsAngle = f;
    }

    public void setYLabelsColor(int n, int n2) {
        this.mYLabelsColor[n] = n2;
    }

    public void setYTitle(String string2) {
        this.setYTitle(string2, 0);
    }

    public void setYTitle(String string2, int n) {
        this.mYTitle[n] = string2;
    }

    public void setZoomEnabled(boolean bl, boolean bl2) {
        this.mZoomXEnabled = bl;
        this.mZoomYEnabled = bl2;
    }

    public void setZoomLimits(double[] dArray) {
        this.mZoomLimits = dArray;
    }

    public final class Orientation
    extends Enum<Orientation> {
        private static final /* synthetic */ Orientation[] ENUM$VALUES;
        public static final /* enum */ Orientation HORIZONTAL = new Orientation(0);
        public static final /* enum */ Orientation VERTICAL = new Orientation(90);
        private int mAngle = 0;

        static {
            Orientation orientation = HORIZONTAL;
            Orientation orientation2 = VERTICAL;
            Orientation[] orientationArray = new Orientation[]{orientation, orientation2};
            ENUM$VALUES = orientationArray;
        }

        private Orientation(int n2) {
            this.mAngle = n2;
        }

        public static Orientation valueOf(String string2) {
            return Enum.valueOf(Orientation.class, string2);
        }

        public static Orientation[] values() {
            Orientation[] orientationArray = ENUM$VALUES;
            int n = orientationArray.length;
            Orientation[] orientationArray2 = new Orientation[n];
            System.arraycopy(orientationArray, 0, orientationArray2, 0, n);
            return orientationArray2;
        }

        public int getAngle() {
            return this.mAngle;
        }
    }
}

