/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.tools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.RoundChart;
import org.achartengine.chart.XYChart;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.tools.AbstractTool;
import org.achartengine.tools.ZoomEvent;
import org.achartengine.tools.ZoomListener;

public class Zoom
extends AbstractTool {
    public static final int ZOOM_AXIS_X = 1;
    public static final int ZOOM_AXIS_XY = 0;
    public static final int ZOOM_AXIS_Y = 2;
    private boolean limitsReachedX;
    private boolean limitsReachedY;
    private boolean mZoomIn;
    private List<ZoomListener> mZoomListeners;
    private float mZoomRate;

    public Zoom(AbstractChart abstractChart, boolean bl, float f) {
        super(abstractChart);
        ArrayList<ZoomListener> arrayList = new ArrayList<ZoomListener>();
        this.mZoomListeners = arrayList;
        this.limitsReachedX = 0;
        this.limitsReachedY = 0;
        this.mZoomIn = bl;
        this.setZoomRate(f);
    }

    private void notifyZoomListeners(ZoomEvent zoomEvent) {
        synchronized (this) {
            Iterator<ZoomListener> iterator = this.mZoomListeners.iterator();
            while (true) {
                boolean bl;
                if (bl = iterator.hasNext()) break block5;
                break;
            }
            {
                block5: {
                    return;
                }
                iterator.next().zoomApplied(zoomEvent);
                continue;
            }
        }
    }

    public void addZoomListener(ZoomListener zoomListener) {
        synchronized (this) {
            boolean bl = this.mZoomListeners.add(zoomListener);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void apply(int n) {
        if (!(this.mChart instanceof XYChart)) {
            DefaultRenderer defaultRenderer = ((RoundChart)this.mChart).getRenderer();
            if (this.mZoomIn) {
                float f = defaultRenderer.getScale();
                float f2 = this.mZoomRate;
                float f3 = f * f2;
                defaultRenderer.setScale(f3);
            } else {
                float f = defaultRenderer.getScale();
                float f4 = this.mZoomRate;
                float f5 = f / f4;
                defaultRenderer.setScale(f5);
            }
        } else {
            int n2;
            int n3 = this.mRenderer.getScalesCount();
            for (int i = 0; i < (n2 = n3); ++i) {
                double[] dArray = this.getRange(i);
                Zoom zoom = this;
                double[] dArray2 = dArray;
                zoom.checkRange(dArray2, i);
                double[] dArray3 = this.mRenderer.getZoomLimits();
                double d = dArray[0];
                double d2 = dArray[1];
                double d3 = (d + d2) / 2.0;
                double d4 = dArray[2];
                double d5 = dArray[3];
                double d6 = (d4 + d5) / 2.0;
                double d7 = dArray[1];
                double d8 = dArray[0];
                double d9 = d7 - d8;
                double d10 = dArray[3];
                double d11 = dArray[2];
                double d12 = d10 - d11;
                double d13 = d9 / 2.0;
                double d14 = d3 - d13;
                double d15 = d9 / 2.0;
                double d16 = d3 + d15;
                double d17 = d12 / 2.0;
                double d18 = d6 - d17;
                double d19 = d12 / 2.0;
                double d20 = d6 + d19;
                if (i == 0) {
                    double d21;
                    double d22;
                    double d23;
                    double d24;
                    int n4 = dArray3 != null && (d14 <= (d24 = dArray3[0]) || d16 >= (d23 = dArray3[1])) ? 1 : 0;
                    this.limitsReachedX = n4;
                    n4 = dArray3 != null && (d18 <= (d22 = dArray3[2]) || d20 >= (d21 = dArray3[3])) ? 1 : 0;
                    this.limitsReachedY = n4;
                }
                if (this.mZoomIn) {
                    if (!(!this.mRenderer.isZoomXEnabled() || n != 1 && n != 0 || this.limitsReachedX && this.mZoomRate < 1.0f)) {
                        double d25 = this.mZoomRate;
                        d9 /= d25;
                    }
                    if (!(!this.mRenderer.isZoomYEnabled() || n != 2 && n != 0 || this.limitsReachedY && this.mZoomRate < 1.0f)) {
                        double d26 = this.mZoomRate;
                        d12 /= d26;
                    }
                } else {
                    if (this.mRenderer.isZoomXEnabled() && !this.limitsReachedX && (n == 1 || n == 0)) {
                        double d27 = this.mZoomRate;
                        double d28 = d9 * d27;
                    }
                    if (this.mRenderer.isZoomYEnabled() && !this.limitsReachedY && (n == 2 || n == 0)) {
                        double d29 = this.mZoomRate;
                        double d30 = d12 * d29;
                    }
                }
                if (this.mRenderer.isZoomXEnabled() && (n == 1 || n == 0)) {
                    double d31 = d9 / 2.0;
                    double d32 = d3 - d31;
                    double d33 = d9 / 2.0;
                    double d34 = d3 + d33;
                    this.setXRange(d32, d34, i);
                }
                if (!this.mRenderer.isZoomYEnabled() || n != 2 && n != 0) continue;
                double d35 = d12 / 2.0;
                double d36 = d6 - d35;
                double d37 = d12 / 2.0;
                double d38 = d6 + d37;
                Zoom zoom2 = this;
                int n5 = i;
                zoom2.setYRange(d36, d38, n5);
            }
        }
        boolean bl = this.mZoomIn;
        float f = this.mZoomRate;
        ZoomEvent zoomEvent = new ZoomEvent(bl, f);
        this.notifyZoomListeners(zoomEvent);
    }

    public void notifyZoomResetListeners() {
        synchronized (this) {
            Iterator<ZoomListener> iterator = this.mZoomListeners.iterator();
            while (true) {
                boolean bl;
                if (bl = iterator.hasNext()) break block5;
                break;
            }
            {
                block5: {
                    return;
                }
                iterator.next().zoomReset();
                continue;
            }
        }
    }

    public void removeZoomListener(ZoomListener zoomListener) {
        synchronized (this) {
            boolean bl = this.mZoomListeners.add(zoomListener);
            return;
        }
    }

    public void setZoomRate(float f) {
        this.mZoomRate = f;
    }
}

