/*
 * Decompiled with CFR 0.152.
 */
package com.mikameng.tool;

import com.mikameng.tool.Util;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import test.AXMLPrinter;

public class Main
implements SelectionListener {
    private Display display;
    private Shell shell;
    private Button browserButton;
    private Button unzipButton;
    private Button genJarButton;
    private Button genXmlButton;
    private Text apkFileText;
    private Label statusLabel;
    AXMLPrinter xmlGen = new AXMLPrinter();

    public Main() {
        this.display = new Display();
        this.shell = new Shell(this.display, 35040);
        GridData gridData = new GridData(1808);
        this.shell.setLayoutData((Object)gridData);
        this.shell.setLayout((Layout)new GridLayout(1, false));
        this.shell.setText("Android APK\u53cd\u7f16\u8bd1\u5de5\u5177");
        this.createUI();
        this.shell.setImage(new Image((Device)this.display, Main.class.getResourceAsStream("13.png")));
        this.shell.pack();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
    }

    private void createUI() {
        GridData buttonData = new GridData();
        buttonData.widthHint = 100;
        buttonData.heightHint = 35;
        GridData textData = new GridData();
        textData.heightHint = 20;
        textData.widthHint = 300;
        Group group = new Group((Composite)this.shell, 0);
        GridData groupData = new GridData(64);
        groupData.verticalIndent = 10;
        group.setLayoutData((Object)groupData);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText("\u8bbe\u7f6e");
        Label label = new Label((Composite)group, 0);
        label.setText("Android APK:");
        this.apkFileText = new Text((Composite)group, 18436);
        this.apkFileText.setLayoutData((Object)textData);
        this.browserButton = new Button((Composite)group, 8);
        this.browserButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.browserButton.setText("\u6d4f\u89c8");
        this.browserButton.setLayoutData((Object)buttonData);
        this.browserButton.addSelectionListener((SelectionListener)this);
        Composite composite = new Composite((Composite)this.shell, 0);
        GridData buttonsData = new GridData(64);
        buttonsData.verticalIndent = 10;
        composite.setLayoutData((Object)buttonsData);
        composite.setLayout((Layout)new GridLayout(5, false));
        Button unzipButton = new Button(composite, 8);
        unzipButton.setText("\u89e3\u538bAPK\u6587\u4ef6");
        unzipButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        unzipButton.addSelectionListener((SelectionListener)this);
        unzipButton.setLayoutData((Object)buttonData);
        this.genJarButton = new Button(composite, 8);
        this.genJarButton.setText("\u53cd\u7f16\u8bd1Dex");
        this.genJarButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.genJarButton.addSelectionListener((SelectionListener)this);
        this.genJarButton.setLayoutData((Object)buttonData);
        this.genXmlButton = new Button(composite, 8);
        this.genXmlButton.setText("\u53cd\u7f16\u8bd1Xml");
        this.genXmlButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.genXmlButton.addSelectionListener((SelectionListener)this);
        this.genXmlButton.setLayoutData((Object)buttonData);
        this.statusLabel = new Label((Composite)this.shell, 2048);
        GridData status = new GridData(1800);
        status.horizontalSpan = 0;
        this.statusLabel.setLayoutData((Object)status);
        this.statusLabel.setText("\u5de5\u5177\u5df2\u542f\u52a8");
    }

    public static void main(String[] args) {
        File f1 = new File("E:\\project\\Android\\Android\u53cd\u7f16\u8bd1\u5de5\u5177\\lib");
        File[] fs = f1.listFiles();
        StringBuilder sb = new StringBuilder();
        for (File f : fs) {
            sb.append("./lib/").append(f.getName()).append(";");
        }
        System.out.println(sb.toString());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Button button = (Button)e.widget;
        if (button == this.browserButton) {
            try {
                FileDialog browserDir = new FileDialog(this.shell);
                browserDir.setText("\u8bf7\u9009\u62e9Android APK\u6587\u4ef6");
                browserDir.setFilterExtensions(new String[]{"*.apk", "*.*"});
                browserDir.setFilterNames(new String[]{"Android APK\u6587\u4ef6", "\u6240\u6709\u6587\u4ef6"});
                if (this.apkFileText.getText() != null) {
                    browserDir.setFilterPath(this.apkFileText.getText());
                }
                String dir = browserDir.open();
                this.apkFileText.setText(dir);
            }
            catch (Exception e1) {
                // empty catch block
            }
            return;
        }
        String apkFile = this.apkFileText.getText();
        String dir = apkFile.substring(0, apkFile.indexOf(".apk"));
        if (button == this.unzipButton) {
            if (apkFile == null || apkFile.trim().length() == 0 || !apkFile.endsWith(".apk")) {
                MessageBox msg = new MessageBox(this.shell, 8);
                msg.setMessage("\u8bf7\u8f93\u5165\u9700\u8981\u53cd\u7f16\u8bd1\u7684Android APK\u6587\u4ef6!");
                msg.setText("\u8b66\u544a:");
                msg.open();
                return;
            }
            if (!Util.unzipFile((String)apkFile, (String)dir)) {
                MessageBox msg = new MessageBox(this.shell, 8);
                msg.setMessage("unzip Android APK\u6587\u4ef6!");
                msg.setText("\u8b66\u544a:");
                msg.open();
                return;
            }
        }
        if (button == this.genJarButton) {
            this.genJar(dir);
        } else if (button == this.genXmlButton) {
            this.genXml(dir);
        }
    }

    private void genXml(String dir) {
        File[] xmlFolders;
        int total = 0;
        int converted = 0;
        File metaFile = new File(dir, "AndroidManifest.xml");
        this.decompileXml(metaFile);
        converted = 1;
        total = 1;
        File resDir = new File(dir, "res");
        if (!resDir.exists()) {
            MessageBox msg = new MessageBox(this.shell, 8);
            msg.setMessage("Android\u9879\u76ee\u7684\u6839\u76ee\u5f55\u4e0b\u6ca1\u6709\u627e\u5230res \u6587\u4ef6\u5939");
            msg.setText("\u8b66\u544a:");
            msg.open();
            return;
        }
        for (File folder : xmlFolders = resDir.listFiles()) {
            this.statusLabel.setText("\u6b63\u5728\u5904\u7406\u6587\u4ef6\u5939: " + folder.getName());
            File[] xmls = folder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml");
                }
            });
            total += xmls.length;
            for (File xmlFile : xmls) {
                this.decompileXml(xmlFile);
                this.statusLabel.setText("\u5df2\u7ecf\u5904\u7406 " + ++converted + " \u6587\u4ef6\u5939: " + folder.getName() + "; xml\u6587\u4ef6  : " + xmlFile.getName());
            }
        }
        MessageBox msg = new MessageBox(this.shell, 2);
        msg.setText("\u8f6c\u6362XML\u5b8c\u6bd5.");
        msg.setMessage("\u5171\u6709xml\u6587\u4ef6\u6570: " + total + "; \u6210\u529f\u8f6c\u6362 " + converted + " \u4e2axml\u6587\u4ef6. ");
        msg.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompileXml(File xmlFile) {
        PrintStream ps = null;
        try {
            String args = xmlFile.getAbsolutePath();
            File dest = new File(xmlFile.getParent(), xmlFile.getName() + ".txt");
            ps = new PrintStream(dest);
            System.setOut(ps);
            AXMLPrinter.main((String[])new String[]{args});
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        finally {
            ps.flush();
            ps.close();
            System.setOut(null);
        }
    }

    private void genJar(String apkDir) {
        File file = new File(apkDir, "classes.dex");
        if (!file.exists()) {
            MessageBox msg = new MessageBox(this.shell, 8);
            msg.setMessage("\u53cd\u7f16\u8bd1Android\u9879\u76ee\u7684\u6839\u76ee\u5f55\u4e0b\u6ca1\u6709\u627e\u5230classes.dex \u6587\u4ef6");
            msg.setText("\u8b66\u544a:");
            msg.open();
            return;
        }
        pxb.android.dex2jar.v3.Main dexmain = new pxb.android.dex2jar.v3.Main();
        try {
            pxb.android.dex2jar.v3.Main.main((String[])new String[]{file.getAbsolutePath()});
            this.statusLabel.setText("\u6210\u529f\u751f\u6210JAR.");
            MessageBox msg = new MessageBox(this.shell, 2);
            msg.setMessage("\u6210\u529f\u751f\u6210JAR");
            msg.setText("\u6210\u529f");
            msg.open();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            this.statusLabel.setText("\u751f\u6210JAR\u9519\u8bef: " + e1.getMessage());
        }
    }
}

