/*
 * Decompiled with CFR 0.152.
 */
package com.mikameng.tool;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Label;

public class Util {
    private static final Logger logger = Logger.getLogger(Util.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unzipFile(String src, String dest, Label statusLabel) {
        File file = new File(src);
        File destDir = new File(dest);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        try {
            BufferedOutputStream bout = null;
            BufferedInputStream bis = null;
            ZipFile zipFile = new ZipFile(file);
            logger.debug((Object)("\u89e3\u538bAPK\u6587\u4ef6, \u6587\u4ef6 : " + src));
            statusLabel.setText("\u89e3\u538bAPK\u6587\u4ef6, \u6587\u4ef6 : " + src);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                InputStream is;
                ZipEntry entry;
                block12: {
                    entry = entries.nextElement();
                    is = zipFile.getInputStream(entry);
                    if (is != null) break block12;
                    Util.close(bis);
                    Util.close(bout);
                    continue;
                }
                try {
                    bis = new BufferedInputStream(is);
                    String entryName = entry.getName();
                    File f = new File(destDir, entryName);
                    logger.debug((Object)("\u89e3\u538b : " + f.getAbsolutePath()));
                    statusLabel.setText("\u89e3\u538b : " + f.getAbsolutePath());
                    if (entry.isDirectory()) {
                        f.mkdir();
                    } else {
                        File parent = f.getParentFile();
                        if (!parent.exists()) {
                            parent.mkdirs();
                        }
                        f.createNewFile();
                    }
                    FileOutputStream fout = new FileOutputStream(f);
                    bout = new BufferedOutputStream(fout);
                    Util.copy(bis, bout);
                }
                catch (Exception e) {
                    try {
                        logger.error((Object)("\u89e3\u538b\u6587\u4ef6\u51fa\u9519, entry path " + entry.getName()), (Throwable)e);
                        statusLabel.setText("\u89e3\u538b\u6587\u4ef6\u51fa\u9519, entry path " + entry.getName());
                    }
                    catch (Throwable throwable) {
                        Util.close(bis);
                        Util.close(bout);
                        throw throwable;
                    }
                    Util.close(bis);
                    Util.close(bout);
                    continue;
                }
                Util.close(bis);
                Util.close(bout);
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"\u89e3\u538bAPK\u6587\u4ef6\u51fa\u9519: ", (Throwable)e);
            statusLabel.setText("\u89e3\u538bAPK\u6587\u4ef6\u51fa\u9519: " + e.getMessage());
            return false;
        }
    }

    private static void close(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"\u5173\u95ed\u6587\u4ef6\u6d41\u51fa\u9519: ", (Throwable)e);
        }
    }

    public static void copy(InputStream is, OutputStream out) throws IOException {
        int length;
        byte[] buff = new byte[8096];
        while ((length = is.read(buff)) != -1) {
            out.write(buff, 0, length);
        }
        out.flush();
    }
}

