/*
 * Decompiled with CFR 0.152.
 */
package oms.GameEngine;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import oms.GameEngine.C_Lib;
import oms.GameEngine.SpriteManager;
import oms.GameEngine.TextManager;

public class GameCanvas {
    private static SpriteManager SpriteMgr;
    private static TextManager TextMgr;
    private static float fRotate;
    private static int nBackXOff;
    private static int nBackYOff;
    private static int nMaxLogicLayer;
    private static int nScreenHeight;
    private static int nScreenWidth;
    public static int nScreenXOff;
    public static int nScreenYOff;
    private static int nSpriteXOff;
    private static int nSpriteYOff;
    private static Rect nViewRc;
    private static Paint paint;
    public boolean bUpdate;
    private Context mContext;
    public int nScreenAlpha;

    static {
        paint = new Paint();
        fRotate = 0.0f;
        nMaxLogicLayer = 8;
    }

    public GameCanvas(Context context, int n2, int n3, int n4) {
        this.mContext = context;
        nViewRc = null;
        SpriteMgr = null;
        TextMgr = null;
        this.nScreenAlpha = 0;
        this.bUpdate = 0;
        nBackXOff = 0;
        nBackYOff = 0;
        nSpriteXOff = 0;
        nSpriteYOff = 0;
        nScreenXOff = 0;
        nScreenYOff = 0;
        this.SetScreenSize(320, 480);
        this.SetViewRect(65416, 65446, 120, 90);
        Context context2 = this.mContext;
        SpriteMgr = new SpriteManager(context2, n3, n4);
        Context context3 = this.mContext;
        TextMgr = new TextManager(context3, n2);
    }

    public static int GetScreenHeight() {
        return nScreenHeight;
    }

    public static int GetScreenWidth() {
        return nScreenWidth;
    }

    public static Rect GetViewRect() {
        return nViewRc;
    }

    public static void Rotate(float f2) {
        fRotate = f2;
    }

    public static float getRotate() {
        return fRotate;
    }

    public boolean CHKACTTouch(int n2, int n3, int n4, int n5, int n6, int n7) {
        SpriteManager spriteManager = SpriteMgr;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        int n13 = n7;
        return spriteManager.CHKACTTouch(n8, n9, n10, n11, n12, n13);
    }

    public boolean CHKACTTouch(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        SpriteManager spriteManager = SpriteMgr;
        int n11 = n2;
        int n12 = n3;
        int n13 = n4;
        int n14 = n5;
        int n15 = n6;
        int n16 = n7;
        int n17 = n8;
        int n18 = n9;
        int n19 = n10;
        return spriteManager.CHKACTTouch(n11, n12, n13, n14, n15, n16, n17, n18, n19);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void ClearACT() {
        if (SpriteMgr == null) {
            return;
        }
        SpriteMgr.ClearACT();
    }

    public void CloseAllText() {
        TextMgr.CloseAllText();
    }

    public void CloseText(int n2) {
        TextMgr.CloseText(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void FreeACT(int n2) {
        if (SpriteMgr == null) {
            return;
        }
        SpriteMgr.FreeACT(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void FreeACT(int n2, int n3) {
        if (SpriteMgr == null) {
            return;
        }
        SpriteMgr.FreeACT(n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void FreeAllACT() {
        if (SpriteMgr == null) {
            return;
        }
        SpriteMgr.FreeAllACT();
    }

    public int GetACTCount(int n2, int n3) {
        return SpriteMgr.GetACTCount(n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Bitmap GetSpriteBitmap(int n2) {
        if (SpriteMgr != null) return SpriteMgr.GetSpriteBitmap(n2);
        return null;
    }

    public long GetSpriteRamSize() {
        return SpriteMgr.GetBMPRamSize();
    }

    public long GetSpriteSegSize(int n2) {
        return SpriteMgr.GetSpriteSegSize(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetSpriteXHitL(int n2) {
        if (SpriteMgr != null) return SpriteMgr.GetSpriteXHitL(n2);
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetSpriteXHitR(int n2) {
        if (SpriteMgr != null) return SpriteMgr.GetSpriteXHitR(n2);
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetSpriteYHitD(int n2) {
        if (SpriteMgr != null) return SpriteMgr.GetSpriteYHitD(n2);
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetSpriteYHitU(int n2) {
        if (SpriteMgr != null) return SpriteMgr.GetSpriteYHitU(n2);
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetSpriteZHitB(int n2) {
        if (SpriteMgr != null) return SpriteMgr.GetSpriteZHitB(n2);
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetSpriteZHitF(int n2) {
        if (SpriteMgr != null) return SpriteMgr.GetSpriteZHitF(n2);
        return 0;
    }

    public int GetTextHeight(int n2) {
        return TextMgr.GetTextHeight(n2);
    }

    public long GetTextRamSize() {
        return TextMgr.GetBMPRamSize();
    }

    public int GetTextWidth(int n2) {
        return TextMgr.GetTextWidth(n2);
    }

    public int GetTextXVal(int n2) {
        return TextMgr.GetTextXVal(n2);
    }

    public int GetTextYVal(int n2) {
        return TextMgr.GetTextYVal(n2);
    }

    public void InitACT(int n2, int n3) {
        SpriteMgr.InitACT(n2, n3);
    }

    public void LoadACT(int n2, int n3, int n4) {
        SpriteMgr.LoadACT(n2, n3, n4);
    }

    public void LoadACT(int n2, int n3, int n4, int n5) {
        SpriteMgr.LoadACT(n2, n3, n4, n5);
    }

    public boolean LoadACT(int n2, int n3) {
        return SpriteMgr.LoadACT(n2, n3);
    }

    public void LoadPicture(int n2, int n3, int n4) {
        TextMgr.LoadPicture(n2, n3, n4);
    }

    public void LoadText(int n2, int n3, int n4) {
        TextMgr.LoadText(n2, n3, n4);
    }

    public void LoadText(int n2, int n3, int n4, int n5) {
        TextMgr.LoadText(n2, n3, n4, n5);
    }

    public void ScrollText(int n2) {
        TextMgr.ScrollText(n2);
    }

    public void SetACTLibBeg(int n2) {
        SpriteMgr.SetACTLibBeg(n2);
    }

    public void SetBackgroundDrawOffset(int n2, int n3) {
        nBackXOff = n2;
        nBackYOff = n3;
    }

    public void SetLogOut(boolean bl, boolean bl2) {
        SpriteMgr.SetBMPSizeOut(bl);
        TextMgr.SetBMPSizeOut(bl2);
    }

    public void SetMaxLogicLayer(int n2) {
        nMaxLogicLayer = n2;
    }

    public void SetScreenOffset(int n2, int n3) {
        nScreenXOff = n2;
        nScreenYOff = n3;
    }

    public void SetScreenSize(int n2, int n3) {
        nScreenWidth = n2;
        nScreenHeight = n3;
    }

    public void SetSpriteDrawOffset(int n2, int n3) {
        nSpriteXOff = n2;
        nSpriteYOff = n3;
    }

    public void SetTextInc(int n2, int n3, int n4) {
        TextMgr.SetTextInc(n2, n3, n4);
    }

    public void SetTextRotate(int n2, float f2) {
        TextMgr.SetTextRotate(n2, f2);
    }

    public void SetTextScale(int n2, float f2) {
        TextMgr.SetTextScale(n2, f2);
    }

    public void SetTextXVal(int n2, int n3) {
        TextMgr.SetTextXVal(n2, n3);
    }

    public void SetTextYVal(int n2, int n3) {
        TextMgr.SetTextYVal(n2, n3);
    }

    public void SetViewRect(int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        if (nViewRc == null) {
            nViewRc = new Rect();
        }
        GameCanvas.nViewRc.left = n2;
        GameCanvas.nViewRc.top = n3;
        Rect rect = nViewRc;
        rect.right = n7 = nScreenWidth + n4;
        Rect rect2 = nViewRc;
        rect2.bottom = n6 = nScreenHeight + n5;
    }

    public boolean ViewDark(int n2) {
        int n3;
        boolean bl = false;
        this.nScreenAlpha = n3 = this.nScreenAlpha - n2;
        if (this.nScreenAlpha <= 0) {
            this.nScreenAlpha = 0;
            this.CloseAllText();
            this.ClearACT();
            bl = true;
        }
        return bl;
    }

    public boolean ViewOpen(int n2) {
        int n3;
        boolean bl = false;
        this.nScreenAlpha = n3 = this.nScreenAlpha + n2;
        if (this.nScreenAlpha > 255) {
            this.nScreenAlpha = 255;
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int WriteSprite(int n2, int n3, int n4, int n5) {
        if (SpriteMgr != null) return SpriteMgr.WriteSprite(n2, n3, n4, n5);
        return -1;
    }

    public int WriteSprite(int n2, int n3, int n4, int n5, float f2, float f3) {
        SpriteManager spriteManager = SpriteMgr;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        int n9 = n5;
        float f4 = f2;
        float f5 = f3;
        return spriteManager.WriteSprite(n6, n7, n8, n9, f4, f5);
    }

    public int WriteSprite(int n2, int n3, int n4, int n5, float f2, float f3, short s2, short s3) {
        SpriteManager spriteManager = SpriteMgr;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        int n9 = n5;
        float f4 = f2;
        float f5 = f3;
        short s4 = s2;
        short s5 = s3;
        return spriteManager.WriteSprite(n6, n7, n8, n9, f4, f5, s4, s5);
    }

    public void flush() {
        this.bUpdate = 1;
    }

    public boolean getTextPixels(int n2, int[] nArray) {
        return TextMgr.getTextPixels(n2, nArray);
    }

    public boolean getUpdata() {
        return this.bUpdate;
    }

    public boolean isReflash() {
        return this.bUpdate;
    }

    public void onDraw(Canvas canvas) {
        paint.setColor(-16777216);
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            Paint paint;
            int n4;
            int n5;
            int n6;
            int n7;
            Canvas canvas2;
            SpriteManager spriteManager;
            int n8;
            if (n3 >= (n8 = nMaxLogicLayer)) {
                if (this.nScreenAlpha < 255) {
                    int n9 = this.nScreenAlpha;
                    int n10 = 255 - n9;
                    canvas.drawARGB(n10, 0, 0, 0);
                }
                this.bUpdate = 0;
                return;
            }
            TextManager textManager = TextMgr;
            int n11 = nBackXOff;
            int n12 = nScreenXOff + n11;
            int n13 = nBackYOff;
            int n14 = nScreenYOff + n13;
            Paint paint2 = GameCanvas.paint;
            Canvas canvas3 = canvas;
            textManager.OnDraw(canvas3, n2, n12, n14, paint2);
            if (bl && (spriteManager = SpriteMgr).OnDraw(canvas2 = canvas, n2, n7 = nScreenXOff + (n6 = nSpriteXOff), n5 = nScreenYOff + (n4 = nSpriteYOff), paint = GameCanvas.paint)) {
                bl = false;
            }
            ++n2;
            ++n3;
        }
    }

    public void onDraw(C_Lib c_Lib, Canvas canvas, int n2) {
        paint.setColor(-16777216);
        boolean bl = true;
        int n3 = 0;
        if (!c_Lib.mTop && c_Lib.mBackground != null) {
            Bitmap bitmap = c_Lib.mBackground;
            float f2 = nScreenXOff;
            int n4 = c_Lib.mBackground.getHeight();
            float f3 = n2 - n4;
            Paint paint = GameCanvas.paint;
            canvas.drawBitmap(bitmap, f2, f3, paint);
            Bitmap bitmap2 = c_Lib.mBackground;
            float f4 = nScreenXOff;
            float f5 = n2 + 480;
            Paint paint2 = GameCanvas.paint;
            canvas.drawBitmap(bitmap2, f4, f5, paint2);
        }
        int n5 = 0;
        while (true) {
            Paint paint;
            int n6;
            int n7;
            int n8;
            int n9;
            Canvas canvas2;
            SpriteManager spriteManager;
            int n10;
            if (n5 >= (n10 = nMaxLogicLayer)) {
                if (c_Lib.mTop && c_Lib.mBackground != null) {
                    Bitmap bitmap = c_Lib.mBackground;
                    float f6 = nScreenXOff;
                    int n11 = c_Lib.mBackground.getHeight();
                    float f7 = n2 - n11;
                    Paint paint3 = GameCanvas.paint;
                    canvas.drawBitmap(bitmap, f6, f7, paint3);
                    Bitmap bitmap3 = c_Lib.mBackground;
                    float f8 = nScreenXOff;
                    float f9 = n2 + 480;
                    Paint paint4 = GameCanvas.paint;
                    canvas.drawBitmap(bitmap3, f8, f9, paint4);
                }
                if (this.nScreenAlpha < 255) {
                    int n12 = this.nScreenAlpha;
                    int n13 = 255 - n12;
                    canvas.drawARGB(n13, 0, 0, 0);
                }
                this.bUpdate = 0;
                return;
            }
            TextManager textManager = TextMgr;
            int n14 = nBackXOff;
            int n15 = nScreenXOff + n14;
            int n16 = nBackYOff;
            int n17 = nScreenYOff + n16;
            Paint paint5 = GameCanvas.paint;
            Canvas canvas3 = canvas;
            textManager.OnDraw(canvas3, n3, n15, n17, paint5);
            if (bl && (spriteManager = SpriteMgr).OnDraw(canvas2 = canvas, n3, n9 = nScreenXOff + (n8 = nSpriteXOff), n7 = nScreenYOff + (n6 = nSpriteYOff), paint = GameCanvas.paint)) {
                bl = false;
            }
            ++n3;
            ++n5;
        }
    }

    public void release() {
        this.CloseAllText();
        this.FreeAllACT();
    }

    public void setScreenAlpha(int n2) {
        this.nScreenAlpha = n2;
    }

    public void setTextPixels(int n2, int[] nArray) {
        TextMgr.setTextPixels(n2, nArray);
    }

    public void setTextPixels(int n2, int[] nArray, int n3, int n4, int n5, int n6, int n7) {
        TextManager textManager = TextMgr;
        int n8 = n2;
        int[] nArray2 = nArray;
        int n9 = n3;
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        int n13 = n7;
        textManager.setTextPixels(n8, nArray2, n9, n10, n11, n12, n13);
    }

    public void setTextPixels(int n2, int[] nArray, int n3, int n4, int n5, int n6, int n7, int n8) {
        TextManager textManager = TextMgr;
        int n9 = n2;
        int[] nArray2 = nArray;
        int n10 = n3;
        int n11 = n4;
        int n12 = n5;
        int n13 = n6;
        int n14 = n7;
        int n15 = n8;
        textManager.setTextPixels(n9, nArray2, n10, n11, n12, n13, n14, n15);
    }
}

