/*
 * Decompiled with CFR 0.152.
 */
package oms.GameEngine;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.Log;
import oms.GameEngine.ACTStruct;
import oms.GameEngine.GameCanvas;
import oms.GameEngine.GameMath;
import oms.GameEngine.PackageManager;
import oms.GameEngine.RESApp;
import oms.GameEngine.SpriteDEF;
import oms.GameEngine.SpriteResDEF;
import oms.GameEngine.SpriteResSeg;

public class SpriteManager {
    private ACTStruct ACTStructInfo;
    private SpriteDEF[] Sprite;
    private SpriteResDEF[] SpriteRes;
    private SpriteRESACTINFO[] SpriteResACTInfo;
    private boolean bLoadingSpriteRes;
    private Matrix cMatrix;
    private SpriteACTFILE cSpriteACTFile;
    private int mACTLibBeg = 0;
    private Context mContext;
    private boolean mIsLogOut = 1;
    private long nCurBMPRamSize = 0L;
    private int nCurFlushSpriteNum;
    private int nCurSegLoadedSpriteNum;
    private int nCurSpriteFileNum;
    private int nMaxSpriteNum;
    private int nMaxSpriteResNum;
    private int nShowSpriteNum;
    private Rect nViewRc;
    public SpriteResSeg[] pSpriteResSegInfo;

    public SpriteManager(Context context, int n2, int n3) {
        Matrix matrix;
        Rect rect;
        this.mContext = context;
        this.Init();
        this.InitSpriteRes(n2);
        this.InitSprite(n3);
        this.InitSpriteACTFile();
        this.nViewRc = rect = GameCanvas.GetViewRect();
        this.cMatrix = matrix = new Matrix();
    }

    /*
     * Enabled aggressive block sorting
     */
    private int GetBitmapSize(Bitmap bitmap) {
        Bitmap.Config config;
        int n2 = 1;
        Bitmap.Config config2 = bitmap.getConfig();
        if (config2 == (config = Bitmap.Config.ALPHA_8)) {
            n2 = 1;
        } else {
            Bitmap.Config config3;
            Bitmap.Config config4 = bitmap.getConfig();
            if (config4 == (config3 = Bitmap.Config.RGB_565)) {
                n2 = 2;
            } else {
                Bitmap.Config config5;
                Bitmap.Config config6 = bitmap.getConfig();
                if (config6 == (config5 = Bitmap.Config.ARGB_4444)) {
                    n2 = 2;
                } else {
                    Bitmap.Config config7;
                    Bitmap.Config config8 = bitmap.getConfig();
                    if (config8 == (config7 = Bitmap.Config.ARGB_8888)) {
                        n2 = 4;
                    }
                }
            }
        }
        int n3 = bitmap.getWidth();
        int n4 = bitmap.getHeight();
        return n3 * n4 * n2 + 128;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void GetFileHead(int n2) {
        int n3 = n2 * 4;
        byte[] byArray = this.cSpriteACTFile.pACTBuff;
        this.ACTStructInfo.FileNum = 0;
        int n4 = 0;
        while (true) {
            int n5;
            if (n4 >= 2) break;
            int n6 = n3 + n4;
            int n7 = byArray[n6] & 0xFF;
            int n8 = n4 * 8;
            int n9 = n7 << n8;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.FileNum = n5 = aCTStruct.FileNum + n9;
            ++n4;
        }
        this.ACTStructInfo.FileIndexAddr = 0;
        n4 = 0;
        while (n4 < 2) {
            int n10;
            int n11 = n3 + 2 + n4;
            int n12 = byArray[n11] & 0xFF;
            int n13 = n4 * 8;
            int n14 = n12 << n13;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.FileIndexAddr = n10 = aCTStruct.FileIndexAddr + n14;
            ++n4;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void GetFileHead(RESApp rESApp, int n2) {
        byte[] byArray = new byte[4];
        int n3 = n2 * 4;
        rESApp.ResRead(byArray, n3, 4);
        this.ACTStructInfo.FileNum = 0;
        int n4 = 0;
        while (true) {
            int n5;
            if (n4 >= 2) break;
            int n6 = byArray[n4] & 0xFF;
            int n7 = n4 * 8;
            int n8 = n6 << n7;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.FileNum = n5 = aCTStruct.FileNum + n8;
            ++n4;
        }
        this.ACTStructInfo.FileIndexAddr = 0;
        n4 = 0;
        while (n4 < 2) {
            int n9;
            int n10 = n4 + 2;
            int n11 = byArray[n10] & 0xFF;
            int n12 = n4 * 8;
            int n13 = n11 << n12;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.FileIndexAddr = n9 = aCTStruct.FileIndexAddr + n13;
            ++n4;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void GetSpriteHead(int n2) {
        int n3 = n2 * 8;
        int n4 = this.ACTStructInfo.FileIndexAddr;
        int n5 = n3 + n4;
        byte[] byArray = this.cSpriteACTFile.pACTBuff;
        this.ACTStructInfo.SpriteNum = 0;
        int n6 = 0;
        while (true) {
            int n7;
            if (n6 >= 4) break;
            int n8 = n5 + n6;
            int n9 = byArray[n8] & 0xFF;
            int n10 = n6 * 8;
            int n11 = n9 << n10;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.SpriteNum = n7 = aCTStruct.SpriteNum + n11;
            ++n6;
        }
        this.ACTStructInfo.SpriteIndexAddr = 0;
        n6 = 0;
        while (n6 < 4) {
            int n12;
            int n13 = n5 + n6 + 4;
            int n14 = byArray[n13] & 0xFF;
            int n15 = n6 * 8;
            int n16 = n14 << n15;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.SpriteIndexAddr = n12 = aCTStruct.SpriteIndexAddr + n16;
            ++n6;
        }
        return;
    }

    private int GetSpriteResID(int n2) {
        byte[] byArray = this.cSpriteACTFile.pACTBuff;
        int n3 = n2 * 20;
        int n4 = this.ACTStructInfo.SpriteIndexAddr;
        int n5 = n3 + n4;
        int n6 = 0;
        int n7 = 0;
        while (n7 < 4) {
            int n8 = n5 + n7;
            int n9 = byArray[n8] & 0xFF;
            int n10 = n7 * 8;
            int n11 = n9 << n10;
            n6 += n11;
            ++n7;
        }
        return n6;
    }

    private void Init() {
        this.SpriteRes = null;
        this.nMaxSpriteResNum = 0;
        this.SpriteResACTInfo = null;
        this.nCurSpriteFileNum = 0;
        this.bLoadingSpriteRes = 0;
        this.pSpriteResSegInfo = null;
        this.nCurSegLoadedSpriteNum = 0;
        this.ACTStructInfo = null;
        this.Sprite = null;
        this.nMaxSpriteNum = 0;
        this.nShowSpriteNum = 0;
        this.nCurFlushSpriteNum = 0;
        this.nCurBMPRamSize = 0L;
        this.mACTLibBeg = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void ReadSpriteResInfo(int n2, int n3) {
        int n4;
        short s2;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        long l2;
        int n14;
        Bitmap bitmap;
        byte[] byArray = this.cSpriteACTFile.pACTBuff;
        int n15 = n2 * 20;
        int n16 = this.ACTStructInfo.SpriteIndexAddr;
        int n17 = n15 + n16;
        this.ACTStructInfo.ResID = 0;
        int n18 = 0;
        while (true) {
            int n19;
            if (n18 >= 4) {
                n17 += 4;
                break;
            }
            int n20 = n17 + n18;
            int n21 = byArray[n20] & 0xFF;
            int n22 = n18 * 8;
            int n23 = n21 << n22;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.ResID = n19 = aCTStruct.ResID + n23;
            ++n18;
        }
        this.ACTStructInfo.CenterX = 0;
        n18 = 0;
        while (true) {
            int n24;
            if (n18 >= 2) {
                if ((this.ACTStructInfo.CenterX & 0x8000) == 32768) {
                    int n25;
                    ACTStruct aCTStruct = this.ACTStructInfo;
                    int n26 = this.ACTStructInfo.CenterX;
                    aCTStruct.CenterX = n25 = -(65536 - n26);
                }
                n17 += 2;
                break;
            }
            int n27 = n17 + n18;
            int n28 = byArray[n27] & 0xFF;
            int n29 = n18 * 8;
            int n30 = n28 << n29;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.CenterX = n24 = aCTStruct.CenterX + n30;
            ++n18;
        }
        this.ACTStructInfo.CenterY = 0;
        n18 = 0;
        while (true) {
            int n31;
            if (n18 >= 2) {
                if ((this.ACTStructInfo.CenterY & 0x8000) == 32768) {
                    int n32;
                    ACTStruct aCTStruct = this.ACTStructInfo;
                    int n33 = this.ACTStructInfo.CenterY;
                    aCTStruct.CenterY = n32 = -(65536 - n33);
                }
                n17 += 2;
                break;
            }
            int n34 = n17 + n18;
            int n35 = byArray[n34] & 0xFF;
            int n36 = n18 * 8;
            int n37 = n35 << n36;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.CenterY = n31 = aCTStruct.CenterY + n37;
            ++n18;
        }
        this.ACTStructInfo.XHitL = 0;
        n18 = 0;
        while (true) {
            int n38;
            if (n18 >= 2) {
                if ((this.ACTStructInfo.XHitL & 0x8000) == 32768) {
                    int n39;
                    ACTStruct aCTStruct = this.ACTStructInfo;
                    int n40 = this.ACTStructInfo.XHitL;
                    aCTStruct.XHitL = n39 = -(65536 - n40);
                }
                n17 += 2;
                break;
            }
            int n41 = n17 + n18;
            int n42 = byArray[n41] & 0xFF;
            int n43 = n18 * 8;
            int n44 = n42 << n43;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.XHitL = n38 = aCTStruct.XHitL + n44;
            ++n18;
        }
        this.ACTStructInfo.XHitR = 0;
        n18 = 0;
        while (true) {
            int n45;
            if (n18 >= 2) {
                if ((this.ACTStructInfo.XHitR & 0x8000) == 32768) {
                    int n46;
                    ACTStruct aCTStruct = this.ACTStructInfo;
                    int n47 = this.ACTStructInfo.XHitR;
                    aCTStruct.XHitR = n46 = -(65536 - n47);
                }
                n17 += 2;
                break;
            }
            int n48 = n17 + n18;
            int n49 = byArray[n48] & 0xFF;
            int n50 = n18 * 8;
            int n51 = n49 << n50;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.XHitR = n45 = aCTStruct.XHitR + n51;
            ++n18;
        }
        this.ACTStructInfo.YHitU = 0;
        n18 = 0;
        while (true) {
            int n52;
            if (n18 >= 2) {
                if ((this.ACTStructInfo.YHitU & 0x8000) == 32768) {
                    int n53;
                    ACTStruct aCTStruct = this.ACTStructInfo;
                    int n54 = this.ACTStructInfo.YHitU;
                    aCTStruct.YHitU = n53 = -(65536 - n54);
                }
                n17 += 2;
                break;
            }
            int n55 = n17 + n18;
            int n56 = byArray[n55] & 0xFF;
            int n57 = n18 * 8;
            int n58 = n56 << n57;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.YHitU = n52 = aCTStruct.YHitU + n58;
            ++n18;
        }
        this.ACTStructInfo.YHitD = 0;
        n18 = 0;
        while (true) {
            int n59;
            if (n18 >= 2) {
                if ((this.ACTStructInfo.YHitD & 0x8000) == 32768) {
                    int n60;
                    ACTStruct aCTStruct = this.ACTStructInfo;
                    int n61 = this.ACTStructInfo.YHitD;
                    aCTStruct.YHitD = n60 = -(65536 - n61);
                }
                n17 += 2;
                break;
            }
            int n62 = n17 + n18;
            int n63 = byArray[n62] & 0xFF;
            int n64 = n18 * 8;
            int n65 = n63 << n64;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.YHitD = n59 = aCTStruct.YHitD + n65;
            ++n18;
        }
        this.ACTStructInfo.ZHitF = 0;
        n18 = 0;
        while (true) {
            int n66;
            if (n18 >= 2) {
                if ((this.ACTStructInfo.ZHitF & 0x8000) == 32768) {
                    int n67;
                    ACTStruct aCTStruct = this.ACTStructInfo;
                    int n68 = this.ACTStructInfo.ZHitF;
                    aCTStruct.ZHitF = n67 = -(65536 - n68);
                }
                n17 += 2;
                break;
            }
            int n69 = n17 + n18;
            int n70 = byArray[n69] & 0xFF;
            int n71 = n18 * 8;
            int n72 = n70 << n71;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.ZHitF = n66 = aCTStruct.ZHitF + n72;
            ++n18;
        }
        this.ACTStructInfo.ZHitB = 0;
        n18 = 0;
        while (true) {
            int n73;
            if (n18 >= 2) {
                int n74;
                if ((this.ACTStructInfo.ZHitB & 0x8000) == 32768) {
                    int n75;
                    ACTStruct aCTStruct = this.ACTStructInfo;
                    int n76 = this.ACTStructInfo.ZHitB;
                    aCTStruct.ZHitB = n75 = -(65536 - n76);
                }
                int n77 = n17 + 2;
                Resources resources = this.mContext.getResources();
                bitmap = BitmapFactory.decodeResource((Resources)resources, (int)(n74 = this.ACTStructInfo.ResID));
                if (bitmap == null) {
                    Context context = this.mContext;
                    int n78 = this.ACTStructInfo.ResID;
                    bitmap = PackageManager.createBitmap(context, n78);
                }
                if (bitmap == null) return;
                n14 = this.ACTStructInfo.ResID & 0xFFFF;
                int n79 = this.nMaxSpriteResNum;
                if (n14 < n79) break;
                return;
            }
            int n80 = n17 + n18;
            int n81 = byArray[n80] & 0xFF;
            int n82 = n18 * 8;
            int n83 = n81 << n82;
            ACTStruct aCTStruct = this.ACTStructInfo;
            aCTStruct.ZHitB = n73 = aCTStruct.ZHitB + n83;
            ++n18;
        }
        if (this.mIsLogOut) {
            StringBuilder stringBuilder = new StringBuilder("ResID: ");
            int n84 = this.ACTStructInfo.ResID;
            String string2 = stringBuilder.append(n84).toString();
            int n85 = Log.v((String)"GameEngine", (String)string2);
            StringBuilder stringBuilder2 = new StringBuilder("Width: ");
            int n86 = bitmap.getWidth();
            String string3 = stringBuilder2.append(n86).toString();
            int n87 = Log.v((String)"GameEngine", (String)string3);
            StringBuilder stringBuilder3 = new StringBuilder("Height: ");
            int n88 = bitmap.getHeight();
            String string4 = stringBuilder3.append(n88).toString();
            int n89 = Log.v((String)"GameEngine", (String)string4);
            StringBuilder stringBuilder4 = new StringBuilder("OPtions: ");
            Bitmap.Config config = bitmap.getConfig();
            String string5 = stringBuilder4.append(config).toString();
            int n90 = Log.v((String)"GameEngine", (String)string5);
            StringBuilder stringBuilder5 = new StringBuilder("Picture use RAM: ");
            long l3 = this.nCurBMPRamSize / 1024L;
            String string6 = stringBuilder5.append(l3).append(" KBytes").toString();
            int n91 = Log.v((String)"GameEngine", (String)string6);
        }
        long l4 = this.nCurBMPRamSize;
        long l5 = this.GetBitmapSize(bitmap);
        this.nCurBMPRamSize = l2 = l4 + l5;
        this.SpriteRes[n14].Sprite = bitmap;
        SpriteResDEF spriteResDEF = this.SpriteRes[n14];
        spriteResDEF.SpriteResID = n13 = this.ACTStructInfo.ResID;
        SpriteResDEF spriteResDEF2 = this.SpriteRes[n14];
        spriteResDEF2.SpriteCenterX = n12 = this.ACTStructInfo.CenterX;
        SpriteResDEF spriteResDEF3 = this.SpriteRes[n14];
        spriteResDEF3.SpriteCenterY = n11 = this.ACTStructInfo.CenterY;
        SpriteResDEF spriteResDEF4 = this.SpriteRes[n14];
        spriteResDEF4.SpriteXHitL = n10 = this.ACTStructInfo.XHitL;
        SpriteResDEF spriteResDEF5 = this.SpriteRes[n14];
        spriteResDEF5.SpriteXHitR = n9 = this.ACTStructInfo.XHitR;
        SpriteResDEF spriteResDEF6 = this.SpriteRes[n14];
        spriteResDEF6.SpriteYHitU = n8 = this.ACTStructInfo.YHitU;
        SpriteResDEF spriteResDEF7 = this.SpriteRes[n14];
        spriteResDEF7.SpriteYHitD = n7 = this.ACTStructInfo.YHitD;
        SpriteResDEF spriteResDEF8 = this.SpriteRes[n14];
        spriteResDEF8.SpriteZHitF = n6 = this.ACTStructInfo.ZHitF;
        SpriteResDEF spriteResDEF9 = this.SpriteRes[n14];
        spriteResDEF9.SpriteZHitB = n5 = this.ACTStructInfo.ZHitB;
        SpriteRESACTINFO spriteRESACTINFO = this.SpriteResACTInfo[n14];
        spriteRESACTINFO.RESACTIdx = s2 = (short)n3;
        SpriteResSeg spriteResSeg = this.pSpriteResSegInfo[n3];
        int n92 = spriteResSeg.SegSize;
        int n93 = bitmap.getWidth();
        int n94 = bitmap.getHeight();
        int n95 = n93 * n94 * 4 + 128;
        spriteResSeg.SegSize = n4 = n92 + n95;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean CHKACTTouch(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        SpriteManager spriteManager;
        int n9;
        int n10;
        int n11;
        SpriteManager spriteManager2;
        int n12;
        int n13;
        int n14;
        int n15;
        SpriteManager spriteManager3;
        int n16;
        int n17;
        int n18;
        SpriteManager spriteManager4;
        int n19;
        int n20;
        int n21;
        int n22 = this.GetSpriteXHitL(n2);
        if (!GameMath.CHKTouch(n22, n21 = n3, n20 = this.GetSpriteXHitR(n2), n19 = (spriteManager4 = this).GetSpriteXHitL(n18 = n5), n17 = n6, n16 = (spriteManager3 = this).GetSpriteXHitR(n15 = n5))) return false;
        int n23 = this.GetSpriteYHitU(n2);
        if (!GameMath.CHKTouch(n23, n14 = n4, n13 = this.GetSpriteYHitD(n2), n12 = (spriteManager2 = this).GetSpriteYHitU(n11 = n5), n10 = n7, n9 = (spriteManager = this).GetSpriteYHitD(n8 = n5))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean CHKACTTouch(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11;
        SpriteManager spriteManager;
        int n12;
        int n13;
        int n14;
        SpriteManager spriteManager2;
        int n15;
        int n16;
        int n17 = n4;
        int n18 = n2;
        int n19 = n5;
        SpriteManager spriteManager3 = this;
        int n20 = n8;
        int n21 = spriteManager3.GetSpriteXHitL(n20);
        if (!GameMath.CHKTouch(n17, n18, n19, n21, n16 = n9, n15 = (spriteManager2 = this).GetSpriteXHitR(n14 = n8))) return false;
        int n22 = n6;
        int n23 = n3;
        int n24 = n7;
        SpriteManager spriteManager4 = this;
        int n25 = n8;
        int n26 = spriteManager4.GetSpriteYHitU(n25);
        if (!GameMath.CHKTouch(n22, n23, n24, n26, n13 = n10, n12 = (spriteManager = this).GetSpriteYHitD(n11 = n8))) return false;
        return true;
    }

    public void ClearACT() {
        int n2 = 0;
        while (true) {
            int n3;
            if (n2 >= (n3 = this.nShowSpriteNum)) {
                this.nShowSpriteNum = 0;
                return;
            }
            this.Sprite[n2].SpriteResID = (short)-1;
            this.Sprite[n2].Rotate = 0.0f;
            this.Sprite[n2].ScaleX = 1.0f;
            this.Sprite[n2].ScaleY = 1.0f;
            ++n2;
        }
    }

    public void CloseSpriteACTFile() {
        this.cSpriteACTFile.release();
    }

    public void FreeACT(int n2) {
        int n3 = this.mACTLibBeg;
        n2 += n3;
        int n4 = 0;
        while (true) {
            int n5;
            if (n4 >= (n5 = this.nMaxSpriteResNum)) {
                if (this.mIsLogOut) {
                    StringBuilder stringBuilder = new StringBuilder("Picture use RAM: ");
                    long l2 = this.nCurBMPRamSize / 1024L;
                    String string2 = stringBuilder.append(l2).append(" KBytes").toString();
                    int n6 = Log.v((String)"GameEngine", (String)string2);
                }
                System.gc();
                return;
            }
            if (this.SpriteResACTInfo[n4].RESACTIdx == n2) {
                if (this.SpriteRes[n4].Sprite != null) {
                    int n7;
                    long l3;
                    Bitmap bitmap = this.SpriteRes[n4].Sprite;
                    int n8 = this.GetBitmapSize(bitmap);
                    long l4 = this.nCurBMPRamSize;
                    long l5 = n8;
                    this.nCurBMPRamSize = l3 = l4 - l5;
                    SpriteResSeg spriteResSeg = this.pSpriteResSegInfo[n2];
                    spriteResSeg.SegSize = n7 = spriteResSeg.SegSize - n8;
                    this.pSpriteResSegInfo[n2].SegIdx = (short)-1;
                    this.SpriteRes[n4].Sprite.recycle();
                }
                this.SpriteRes[n4].Sprite = null;
                this.SpriteRes[n4].SpriteResID = -1;
                this.SpriteResACTInfo[n4].RESACTIdx = (short)-1;
            }
            ++n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void FreeACT(int n2, int n3) {
        if (n3 < 2130837504) {
            return;
        }
        int n4 = this.mACTLibBeg;
        n2 += n4;
        int n5 = this.nMaxSpriteResNum;
        if ((n3 &= 0xFFFF) < n5 && this.SpriteResACTInfo[n3].RESACTIdx != -1) {
            if (this.SpriteRes[n3].Sprite != null) {
                int n6;
                long l2;
                Bitmap bitmap = this.SpriteRes[n3].Sprite;
                int n7 = this.GetBitmapSize(bitmap);
                long l3 = this.nCurBMPRamSize;
                long l4 = n7;
                this.nCurBMPRamSize = l2 = l3 - l4;
                SpriteResSeg spriteResSeg = this.pSpriteResSegInfo[n2];
                spriteResSeg.SegSize = n6 = spriteResSeg.SegSize - n7;
                this.SpriteRes[n3].Sprite.recycle();
            }
            this.SpriteRes[n3].Sprite = null;
            this.SpriteRes[n3].SpriteResID = -1;
            this.SpriteResACTInfo[n3].RESACTIdx = (short)-1;
        }
        if (!this.mIsLogOut) return;
        StringBuilder stringBuilder = new StringBuilder("Picture use RAM: ");
        long l5 = this.nCurBMPRamSize / 1024L;
        String string2 = stringBuilder.append(l5).append(" KBytes").toString();
        int n8 = Log.v((String)"GameEngine", (String)string2);
    }

    public void FreeAllACT() {
        int n2 = 0;
        while (true) {
            int n3;
            if (n2 >= (n3 = this.nMaxSpriteResNum)) {
                this.nCurBMPRamSize = 0L;
                System.gc();
                return;
            }
            if (this.SpriteRes[n2].Sprite != null) {
                this.SpriteRes[n2].Sprite.recycle();
            }
            this.SpriteRes[n2].Sprite = null;
            this.SpriteRes[n2].SpriteResID = -1;
            this.SpriteResACTInfo[n2].RESACTIdx = (short)-1;
            this.pSpriteResSegInfo[n2].SegSize = 0;
            this.pSpriteResSegInfo[n2].SegIdx = (short)-1;
            ++n2;
        }
    }

    public int GetACTCount(int n2, int n3) {
        int n4 = this.mACTLibBeg;
        int n5 = n2 + n4;
        Context context = this.mContext;
        RESApp rESApp = new RESApp(context);
        rESApp.OpenRes(n3);
        this.GetFileHead(rESApp, n5);
        rESApp.CloseRes();
        return this.ACTStructInfo.FileNum;
    }

    public long GetBMPRamSize() {
        return this.nCurBMPRamSize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Bitmap GetSpriteBitmap(int n2) {
        if (n2 < 2130837504) {
            return null;
        }
        int n3 = n2 & 0xFFFF;
        return this.SpriteRes[n3].Sprite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long GetSpriteSegSize(int n2) {
        int n3 = this.nMaxSpriteResNum;
        if (n2 < n3) return this.pSpriteResSegInfo[n2].SegSize;
        return 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetSpriteXHitL(int n2) {
        SpriteRESACTINFO[] spriteRESACTINFOArray = this.SpriteResACTInfo;
        int n3 = n2 & 0xFFFF;
        if (spriteRESACTINFOArray[n3].RESACTIdx == -1) return 0;
        int n4 = n2 & 0xFFFF;
        return this.SpriteRes[n4].SpriteXHitL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetSpriteXHitR(int n2) {
        SpriteRESACTINFO[] spriteRESACTINFOArray = this.SpriteResACTInfo;
        int n3 = n2 & 0xFFFF;
        if (spriteRESACTINFOArray[n3].RESACTIdx == -1) return 0;
        int n4 = n2 & 0xFFFF;
        return this.SpriteRes[n4].SpriteXHitR;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetSpriteYHitD(int n2) {
        SpriteRESACTINFO[] spriteRESACTINFOArray = this.SpriteResACTInfo;
        int n3 = n2 & 0xFFFF;
        if (spriteRESACTINFOArray[n3].RESACTIdx == -1) return 0;
        int n4 = n2 & 0xFFFF;
        return this.SpriteRes[n4].SpriteYHitD;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetSpriteYHitU(int n2) {
        SpriteRESACTINFO[] spriteRESACTINFOArray = this.SpriteResACTInfo;
        int n3 = n2 & 0xFFFF;
        if (spriteRESACTINFOArray[n3].RESACTIdx == -1) return 0;
        int n4 = n2 & 0xFFFF;
        return this.SpriteRes[n4].SpriteYHitU;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetSpriteZHitB(int n2) {
        SpriteRESACTINFO[] spriteRESACTINFOArray = this.SpriteResACTInfo;
        int n3 = n2 & 0xFFFF;
        if (spriteRESACTINFOArray[n3].RESACTIdx == -1) return 0;
        int n4 = n2 & 0xFFFF;
        return this.SpriteRes[n4].SpriteZHitB;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetSpriteZHitF(int n2) {
        SpriteRESACTINFO[] spriteRESACTINFOArray = this.SpriteResACTInfo;
        int n3 = n2 & 0xFFFF;
        if (spriteRESACTINFOArray[n3].RESACTIdx == -1) return 0;
        int n4 = n2 & 0xFFFF;
        return this.SpriteRes[n4].SpriteZHitF;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void InitACT(int n2, int n3) {
        short s2;
        int n4 = this.mACTLibBeg;
        int n5 = this.nMaxSpriteResNum;
        if ((n2 += n4) >= n5) {
            return;
        }
        if (this.pSpriteResSegInfo[n2].SegIdx == n2) return;
        this.InitSpriteResInfo(n3, n2);
        this.CloseSpriteACTFile();
        SpriteResSeg spriteResSeg = this.pSpriteResSegInfo[n2];
        spriteResSeg.SegIdx = s2 = (short)n2;
    }

    public void InitSprite(int n2) {
        this.nShowSpriteNum = 0;
        this.nMaxSpriteNum = n2;
        if (this.nMaxSpriteNum == 0) {
            this.nMaxSpriteNum = 1;
        }
        SpriteDEF[] spriteDEFArray = new SpriteDEF[this.nMaxSpriteNum];
        this.Sprite = spriteDEFArray;
        int n3 = 0;
        int n4;
        while (n3 < (n4 = this.nMaxSpriteNum)) {
            SpriteDEF spriteDEF;
            SpriteDEF[] spriteDEFArray2 = this.Sprite;
            spriteDEFArray2[n3] = spriteDEF = new SpriteDEF();
            ++n3;
        }
        return;
    }

    public void InitSpriteACTFile() {
        SpriteACTFILE spriteACTFILE;
        this.cSpriteACTFile = spriteACTFILE = new SpriteACTFILE();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void InitSpriteRes(int n2) {
        this.nMaxSpriteResNum = n2;
        if (n2 <= 0) {
            this.nMaxSpriteResNum = 1;
        }
        SpriteResDEF[] spriteResDEFArray = new SpriteResDEF[this.nMaxSpriteResNum];
        this.SpriteRes = spriteResDEFArray;
        SpriteRESACTINFO[] spriteRESACTINFOArray = new SpriteRESACTINFO[this.nMaxSpriteResNum];
        this.SpriteResACTInfo = spriteRESACTINFOArray;
        int n3 = 0;
        while (true) {
            SpriteRESACTINFO spriteRESACTINFO;
            SpriteResDEF spriteResDEF;
            int n4;
            if (n3 >= (n4 = this.nMaxSpriteResNum)) break;
            SpriteResDEF[] spriteResDEFArray2 = this.SpriteRes;
            spriteResDEFArray2[n3] = spriteResDEF = new SpriteResDEF();
            SpriteRESACTINFO[] spriteRESACTINFOArray2 = this.SpriteResACTInfo;
            spriteRESACTINFOArray2[n3] = spriteRESACTINFO = new SpriteRESACTINFO();
            ++n3;
        }
        SpriteResSeg[] spriteResSegArray = new SpriteResSeg[this.nMaxSpriteResNum];
        this.pSpriteResSegInfo = spriteResSegArray;
        n3 = 0;
        while (true) {
            SpriteResSeg spriteResSeg;
            int n5;
            if (n3 >= (n5 = this.nMaxSpriteResNum)) {
                ACTStruct aCTStruct;
                this.ACTStructInfo = aCTStruct = new ACTStruct();
                this.bLoadingSpriteRes = 0;
                this.nCurSpriteFileNum = 0;
                return;
            }
            SpriteResSeg[] spriteResSegArray2 = this.pSpriteResSegInfo;
            spriteResSegArray2[n3] = spriteResSeg = new SpriteResSeg();
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public void InitSpriteResInfo(int n2, int n3) {
        this.nCurSegLoadedSpriteNum = 0;
        if (!this.LoadSpriteACTFile(n2)) {
            return;
        }
        this.GetFileHead(n3);
        int n4 = 0;
        int n5;
        block0: while (n4 < (n5 = this.ACTStructInfo.FileNum)) {
            this.GetSpriteHead(n4);
            int n6 = 0;
            while (true) {
                int n7;
                if (n6 >= (n7 = this.ACTStructInfo.SpriteNum)) {
                    int n8;
                    int n9 = this.nCurSegLoadedSpriteNum;
                    int n10 = this.ACTStructInfo.SpriteNum;
                    this.nCurSegLoadedSpriteNum = n8 = n9 + n10;
                    ++n4;
                    continue block0;
                }
                int n11 = this.GetSpriteResID(n6) & 0xFFFF;
                if (this.SpriteResACTInfo[n11].RESACTIdx == -1) {
                    this.ReadSpriteResInfo(n6, n3);
                }
                ++n6;
            }
            break;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void InitSpriteResInfo(int n2, int n3, int n4) {
        boolean bl = false;
        if (!this.LoadSpriteACTFile(n2)) {
            return;
        }
        this.GetFileHead(n3);
        int n5 = 0;
        int n6;
        block0: while (n5 < (n6 = this.ACTStructInfo.FileNum)) {
            this.GetSpriteHead(n5);
            int n7 = 0;
            while (true) {
                int n8;
                if (n7 >= (n8 = this.ACTStructInfo.SpriteNum)) {
                    if (bl) return;
                    ++n5;
                    continue block0;
                }
                if (this.GetSpriteResID(n7) == n4) {
                    if (this.SpriteResACTInfo[n4 &= 0xFFFF].RESACTIdx != -1) return;
                    this.ReadSpriteResInfo(n7, n3);
                    return;
                }
                ++n7;
            }
            break;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void InitSpriteResInfo(int n2, int n3, int n4, int n5) {
        if (this.LoadSpriteACTFile(n2)) {
            this.GetFileHead(n3);
            this.GetSpriteHead(0);
            int n6 = this.ACTStructInfo.SpriteNum;
            int n7 = n5 < n6 ? n5 : this.ACTStructInfo.SpriteNum;
            for (int i2 = n4; i2 < n7; ++i2) {
                int n8 = this.GetSpriteResID(i2) & 0xFFFF;
                if (this.SpriteResACTInfo[n8].RESACTIdx != -1) continue;
                this.ReadSpriteResInfo(i2, n3);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void LoadACT(int n2, int n3, int n4) {
        int n5 = this.mACTLibBeg;
        int n6 = this.nMaxSpriteResNum;
        if ((n2 += n5) >= n6) {
            return;
        }
        this.InitSpriteResInfo(n4, n2, n3);
        this.CloseSpriteACTFile();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void LoadACT(int n2, int n3, int n4, int n5) {
        int n6 = this.mACTLibBeg;
        int n7 = this.nMaxSpriteResNum;
        if ((n2 += n6) >= n7) {
            return;
        }
        this.InitSpriteResInfo(n5, n2, n3, n4);
        this.CloseSpriteACTFile();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean LoadACT(int n2, int n3) {
        short s2;
        int n4 = this.mACTLibBeg;
        if (this.pSpriteResSegInfo[n2].SegIdx == (n2 += n4)) {
            return true;
        }
        boolean bl = this.LoadSpriteResInfo(n3, n2);
        if (!bl) return bl;
        this.CloseSpriteACTFile();
        SpriteResSeg spriteResSeg = this.pSpriteResSegInfo[n2];
        spriteResSeg.SegIdx = s2 = (short)n2;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean LoadSpriteACTFile(int n2) {
        Context context = this.mContext;
        RESApp rESApp = new RESApp(context);
        rESApp.OpenRes(n2);
        if (rESApp.getLength() > 0) {
            int n3;
            SpriteACTFILE spriteACTFILE = this.cSpriteACTFile;
            spriteACTFILE.nACTBuffLen = n3 = rESApp.getLength();
            SpriteACTFILE spriteACTFILE2 = this.cSpriteACTFile;
            byte[] byArray = new byte[this.cSpriteACTFile.nACTBuffLen];
            spriteACTFILE2.pACTBuff = byArray;
            byte[] byArray2 = this.cSpriteACTFile.pACTBuff;
            int n4 = this.cSpriteACTFile.nACTBuffLen;
            rESApp.ResRead(byArray2, 0, n4);
            rESApp.CloseRes();
            return true;
        }
        rESApp.CloseRes();
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean LoadSpriteResInfo(int n2, int n3) {
        int n4;
        int n5;
        boolean bl = false;
        if (!this.bLoadingSpriteRes) {
            int n6 = this.nMaxSpriteResNum;
            if (n3 >= n6) {
                return true;
            }
            if (!this.LoadSpriteACTFile(n2)) {
                return true;
            }
            this.GetFileHead(n3);
            this.nCurSegLoadedSpriteNum = 0;
            this.nCurSpriteFileNum = 0;
            this.bLoadingSpriteRes = 1;
        }
        if ((n5 = this.nCurSpriteFileNum) < (n4 = this.ACTStructInfo.FileNum)) {
            int n7 = this.nCurSpriteFileNum;
            this.GetSpriteHead(n7);
            int n8 = 0;
            while (true) {
                int n9;
                if (n8 >= (n9 = this.ACTStructInfo.SpriteNum)) {
                    int n10;
                    int n11;
                    int n12 = this.nCurSegLoadedSpriteNum;
                    int n13 = this.ACTStructInfo.SpriteNum;
                    this.nCurSegLoadedSpriteNum = n11 = n12 + n13;
                    this.nCurSpriteFileNum = n10 = this.nCurSpriteFileNum + 1;
                    return bl;
                }
                int n14 = this.GetSpriteResID(n8) & 0xFFFF;
                if (this.SpriteResACTInfo[n14].RESACTIdx == -1) {
                    this.ReadSpriteResInfo(n8, n3);
                }
                ++n8;
            }
        }
        this.bLoadingSpriteRes = 0;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean OnDraw(Canvas canvas, int n2, int n3, int n4, Paint paint) {
        int n5;
        int n6;
        if (n2 == 0) {
            int n7;
            this.nCurFlushSpriteNum = n7 = 0;
        }
        if ((n6 = this.nCurFlushSpriteNum) >= (n5 = this.nShowSpriteNum)) return false;
        int n8 = 0;
        int n9;
        while (n8 < (n9 = this.nShowSpriteNum)) {
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            short s2 = this.Sprite[n8].SpriteResID;
            if (!(s2 == -1 || (n19 = this.Sprite[n8].SpriteAttrib) != (n18 = n2) || (n17 = this.Sprite[n8].SpriteYVal) < (n16 = this.nViewRc.top) && n17 > (n15 = this.nViewRc.bottom) || (n14 = this.Sprite[n8].SpriteXVal) < (n13 = this.nViewRc.left) && n14 > (n12 = this.nViewRc.right))) {
                int n20;
                if (this.Sprite[n8].Rotate == 0.0f && this.Sprite[n8].ScaleX == 1.0f && this.Sprite[n8].ScaleY == 1.0f) {
                    Bitmap bitmap = this.SpriteRes[s2].Sprite;
                    int n21 = n14 + n3;
                    short s3 = this.Sprite[n8].SpriteCenterX;
                    float f2 = n21 - s3;
                    int n22 = n17 + n4;
                    short s4 = this.Sprite[n8].SpriteCenterY;
                    float f3 = n22 - s4;
                    Canvas canvas2 = canvas;
                    Bitmap bitmap2 = bitmap;
                    float f4 = f2;
                    float f5 = f3;
                    Paint paint2 = paint;
                    canvas2.drawBitmap(bitmap2, f4, f5, paint2);
                } else {
                    int n23 = n14 + n3;
                    short s5 = this.Sprite[n8].SpriteCenterX;
                    int n24 = n23 - s5;
                    int n25 = n17 + n4;
                    short s6 = this.Sprite[n8].SpriteCenterY;
                    int n26 = n25 - s6;
                    Matrix matrix = this.cMatrix;
                    float f6 = n24;
                    float f7 = n26;
                    matrix.setTranslate(f6, f7);
                    Matrix matrix2 = this.cMatrix;
                    float f8 = this.Sprite[n8].ScaleX;
                    float f9 = this.Sprite[n8].ScaleY;
                    float f10 = n14 + n3;
                    float f11 = n17 + n4;
                    boolean bl = matrix2.postScale(f8, f9, f10, f11);
                    if (this.Sprite[n8].RotateX != -1 && this.Sprite[n8].RotateY != -1) {
                        Matrix matrix3 = this.cMatrix;
                        float f12 = this.Sprite[n8].Rotate;
                        float f13 = this.Sprite[n8].RotateX + n3;
                        float f14 = this.Sprite[n8].RotateY + n4;
                        boolean bl2 = matrix3.postRotate(f12, f13, f14);
                    } else {
                        Matrix matrix4 = this.cMatrix;
                        float f15 = this.Sprite[n8].Rotate;
                        float f16 = n14 + n3;
                        float f17 = n17 + n4;
                        boolean bl3 = matrix4.postRotate(f15, f16, f17);
                    }
                    Bitmap bitmap = this.SpriteRes[s2].Sprite;
                    Matrix matrix5 = this.cMatrix;
                    Canvas canvas3 = canvas;
                    Bitmap bitmap3 = bitmap;
                    Matrix matrix6 = matrix5;
                    Paint paint3 = paint;
                    canvas3.drawBitmap(bitmap3, matrix6, paint3);
                }
                this.nCurFlushSpriteNum = n20 = this.nCurFlushSpriteNum + 1;
            }
            if ((n11 = this.nCurFlushSpriteNum) == (n10 = this.nShowSpriteNum)) {
                return true;
            }
            ++n8;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean OnDraw(Canvas canvas, int n2, Paint paint) {
        int n3;
        int n4;
        if (n2 == 0) {
            this.nCurFlushSpriteNum = 0;
        }
        if ((n4 = this.nCurFlushSpriteNum) >= (n3 = this.nShowSpriteNum)) return false;
        int n5 = 0;
        int n6;
        while (n5 < (n6 = this.nShowSpriteNum)) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            short s2 = this.Sprite[n5].SpriteResID;
            if (!(s2 == -1 || this.Sprite[n5].SpriteAttrib != n2 || (n14 = this.Sprite[n5].SpriteYVal) < (n13 = this.nViewRc.top) && n14 > (n12 = this.nViewRc.bottom) || (n11 = this.Sprite[n5].SpriteXVal) < (n10 = this.nViewRc.left) && n11 > (n9 = this.nViewRc.right))) {
                int n15;
                Bitmap bitmap = this.SpriteRes[s2].Sprite;
                short s3 = this.Sprite[n5].SpriteCenterX;
                float f2 = n11 - s3;
                short s4 = this.Sprite[n5].SpriteCenterY;
                float f3 = n14 - s4;
                canvas.drawBitmap(bitmap, f2, f3, paint);
                this.nCurFlushSpriteNum = n15 = this.nCurFlushSpriteNum + 1;
            }
            if ((n8 = this.nCurFlushSpriteNum) == (n7 = this.nShowSpriteNum)) {
                return true;
            }
            ++n5;
        }
        return false;
    }

    public void SetACTLibBeg(int n2) {
        this.mACTLibBeg = n2;
    }

    public void SetBMPSizeOut(boolean bl) {
        this.mIsLogOut = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int WriteSprite(int n2, int n3, int n4, int n5) {
        int n6;
        short s2;
        short s3;
        short s4;
        int n7 = -1;
        int n8 = this.nShowSpriteNum;
        int n9 = this.nMaxSpriteNum;
        if (n8 >= n9) {
            return -1;
        }
        if (n2 < 2130837504) {
            return -1;
        }
        SpriteRESACTINFO[] spriteRESACTINFOArray = this.SpriteResACTInfo;
        int n10 = n2 & 0xFFFF;
        if (spriteRESACTINFOArray[n10].RESACTIdx != -1) {
            n7 = n2 & 0xFFFF;
        }
        if (n7 == -1) return n7;
        SpriteDEF[] spriteDEFArray = this.Sprite;
        int n11 = this.nShowSpriteNum;
        SpriteDEF spriteDEF = spriteDEFArray[n11];
        spriteDEF.SpriteResID = s4 = (short)n7;
        SpriteDEF[] spriteDEFArray2 = this.Sprite;
        int n12 = this.nShowSpriteNum;
        spriteDEFArray2[n12].SpriteXVal = n3;
        SpriteDEF[] spriteDEFArray3 = this.Sprite;
        int n13 = this.nShowSpriteNum;
        spriteDEFArray3[n13].SpriteYVal = n4;
        SpriteDEF[] spriteDEFArray4 = this.Sprite;
        int n14 = this.nShowSpriteNum;
        spriteDEFArray4[n14].Rotate = 0.0f;
        SpriteDEF[] spriteDEFArray5 = this.Sprite;
        int n15 = this.nShowSpriteNum;
        spriteDEFArray5[n15].ScaleX = 1.0f;
        SpriteDEF[] spriteDEFArray6 = this.Sprite;
        int n16 = this.nShowSpriteNum;
        spriteDEFArray6[n16].ScaleY = 1.0f;
        SpriteDEF[] spriteDEFArray7 = this.Sprite;
        int n17 = this.nShowSpriteNum;
        SpriteDEF spriteDEF2 = spriteDEFArray7[n17];
        spriteDEF2.SpriteCenterX = s3 = (short)this.SpriteRes[n7].SpriteCenterX;
        SpriteDEF[] spriteDEFArray8 = this.Sprite;
        int n18 = this.nShowSpriteNum;
        SpriteDEF spriteDEF3 = spriteDEFArray8[n18];
        spriteDEF3.SpriteCenterY = s2 = (short)this.SpriteRes[n7].SpriteCenterY;
        SpriteDEF[] spriteDEFArray9 = this.Sprite;
        int n19 = this.nShowSpriteNum;
        spriteDEFArray9[n19].RotateX = (short)-1;
        SpriteDEF[] spriteDEFArray10 = this.Sprite;
        int n20 = this.nShowSpriteNum;
        spriteDEFArray10[n20].RotateY = (short)-1;
        n7 = this.nShowSpriteNum;
        SpriteDEF[] spriteDEFArray11 = this.Sprite;
        int n21 = this.nShowSpriteNum;
        this.nShowSpriteNum = n6 = n21 + 1;
        spriteDEFArray11[n21].SpriteAttrib = n5;
        return n7;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int WriteSprite(int n2, int n3, int n4, int n5, float f2, float f3) {
        int n6;
        short s2;
        short s3;
        short s4;
        int n7 = -1;
        int n8 = this.nShowSpriteNum;
        int n9 = this.nMaxSpriteNum;
        if (n8 >= n9) {
            return -1;
        }
        if (n2 < 2130837504) {
            return -1;
        }
        SpriteRESACTINFO[] spriteRESACTINFOArray = this.SpriteResACTInfo;
        int n10 = n2 & 0xFFFF;
        if (spriteRESACTINFOArray[n10].RESACTIdx != -1) {
            n7 = n2 & 0xFFFF;
        }
        if (n7 == -1) return n7;
        SpriteDEF[] spriteDEFArray = this.Sprite;
        int n11 = this.nShowSpriteNum;
        SpriteDEF spriteDEF = spriteDEFArray[n11];
        spriteDEF.SpriteResID = s4 = (short)n7;
        SpriteDEF[] spriteDEFArray2 = this.Sprite;
        int n12 = this.nShowSpriteNum;
        spriteDEFArray2[n12].SpriteXVal = n3;
        SpriteDEF[] spriteDEFArray3 = this.Sprite;
        int n13 = this.nShowSpriteNum;
        spriteDEFArray3[n13].SpriteYVal = n4;
        SpriteDEF[] spriteDEFArray4 = this.Sprite;
        int n14 = this.nShowSpriteNum;
        spriteDEFArray4[n14].Rotate = f2;
        SpriteDEF[] spriteDEFArray5 = this.Sprite;
        int n15 = this.nShowSpriteNum;
        spriteDEFArray5[n15].ScaleX = f3;
        SpriteDEF[] spriteDEFArray6 = this.Sprite;
        int n16 = this.nShowSpriteNum;
        spriteDEFArray6[n16].ScaleY = f3;
        SpriteDEF[] spriteDEFArray7 = this.Sprite;
        int n17 = this.nShowSpriteNum;
        SpriteDEF spriteDEF2 = spriteDEFArray7[n17];
        spriteDEF2.SpriteCenterX = s3 = (short)this.SpriteRes[n7].SpriteCenterX;
        SpriteDEF[] spriteDEFArray8 = this.Sprite;
        int n18 = this.nShowSpriteNum;
        SpriteDEF spriteDEF3 = spriteDEFArray8[n18];
        spriteDEF3.SpriteCenterY = s2 = (short)this.SpriteRes[n7].SpriteCenterY;
        SpriteDEF[] spriteDEFArray9 = this.Sprite;
        int n19 = this.nShowSpriteNum;
        spriteDEFArray9[n19].RotateX = (short)-1;
        SpriteDEF[] spriteDEFArray10 = this.Sprite;
        int n20 = this.nShowSpriteNum;
        spriteDEFArray10[n20].RotateY = (short)-1;
        n7 = this.nShowSpriteNum;
        SpriteDEF[] spriteDEFArray11 = this.Sprite;
        int n21 = this.nShowSpriteNum;
        this.nShowSpriteNum = n6 = n21 + 1;
        spriteDEFArray11[n21].SpriteAttrib = n5;
        return n7;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int WriteSprite(int n2, int n3, int n4, int n5, float f2, float f3, float f4, short s2, short s3) {
        int n6;
        short s4;
        short s5;
        short s6;
        int n7 = -1;
        int n8 = this.nShowSpriteNum;
        int n9 = this.nMaxSpriteNum;
        if (n8 >= n9) {
            return -1;
        }
        if (n2 < 2130837504) {
            return -1;
        }
        SpriteRESACTINFO[] spriteRESACTINFOArray = this.SpriteResACTInfo;
        int n10 = n2 & 0xFFFF;
        if (spriteRESACTINFOArray[n10].RESACTIdx != -1) {
            n7 = n2 & 0xFFFF;
        }
        if (n7 == -1) return n7;
        SpriteDEF[] spriteDEFArray = this.Sprite;
        int n11 = this.nShowSpriteNum;
        SpriteDEF spriteDEF = spriteDEFArray[n11];
        spriteDEF.SpriteResID = s6 = (short)n7;
        SpriteDEF[] spriteDEFArray2 = this.Sprite;
        int n12 = this.nShowSpriteNum;
        spriteDEFArray2[n12].SpriteXVal = n3;
        SpriteDEF[] spriteDEFArray3 = this.Sprite;
        int n13 = this.nShowSpriteNum;
        spriteDEFArray3[n13].SpriteYVal = n4;
        SpriteDEF[] spriteDEFArray4 = this.Sprite;
        int n14 = this.nShowSpriteNum;
        spriteDEFArray4[n14].Rotate = f2;
        SpriteDEF[] spriteDEFArray5 = this.Sprite;
        int n15 = this.nShowSpriteNum;
        spriteDEFArray5[n15].ScaleX = f3;
        SpriteDEF[] spriteDEFArray6 = this.Sprite;
        int n16 = this.nShowSpriteNum;
        spriteDEFArray6[n16].ScaleY = f4;
        SpriteDEF[] spriteDEFArray7 = this.Sprite;
        int n17 = this.nShowSpriteNum;
        SpriteDEF spriteDEF2 = spriteDEFArray7[n17];
        spriteDEF2.SpriteCenterX = s5 = (short)this.SpriteRes[n7].SpriteCenterX;
        SpriteDEF[] spriteDEFArray8 = this.Sprite;
        int n18 = this.nShowSpriteNum;
        SpriteDEF spriteDEF3 = spriteDEFArray8[n18];
        spriteDEF3.SpriteCenterY = s4 = (short)this.SpriteRes[n7].SpriteCenterY;
        if (s2 != 65535) {
            SpriteDEF[] spriteDEFArray9 = this.Sprite;
            int n19 = this.nShowSpriteNum;
            spriteDEFArray9[n19].RotateX = s2;
        } else {
            short s7;
            SpriteDEF[] spriteDEFArray10 = this.Sprite;
            int n20 = this.nShowSpriteNum;
            SpriteDEF spriteDEF4 = spriteDEFArray10[n20];
            SpriteDEF[] spriteDEFArray11 = this.Sprite;
            int n21 = this.nShowSpriteNum;
            spriteDEF4.RotateX = s7 = spriteDEFArray11[n21].SpriteCenterX;
        }
        if (s2 != 65535) {
            SpriteDEF[] spriteDEFArray12 = this.Sprite;
            int n22 = this.nShowSpriteNum;
            spriteDEFArray12[n22].RotateY = s3;
        } else {
            short s8;
            SpriteDEF[] spriteDEFArray13 = this.Sprite;
            int n23 = this.nShowSpriteNum;
            SpriteDEF spriteDEF5 = spriteDEFArray13[n23];
            SpriteDEF[] spriteDEFArray14 = this.Sprite;
            int n24 = this.nShowSpriteNum;
            spriteDEF5.RotateY = s8 = spriteDEFArray14[n24].SpriteCenterY;
        }
        n7 = this.nShowSpriteNum;
        SpriteDEF[] spriteDEFArray15 = this.Sprite;
        int n25 = this.nShowSpriteNum;
        this.nShowSpriteNum = n6 = n25 + 1;
        spriteDEFArray15[n25].SpriteAttrib = n5;
        return n7;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int WriteSprite(int n2, int n3, int n4, int n5, float f2, float f3, short s2, short s3) {
        int n6;
        short s4;
        short s5;
        short s6;
        int n7 = -1;
        int n8 = this.nShowSpriteNum;
        int n9 = this.nMaxSpriteNum;
        if (n8 >= n9) {
            return -1;
        }
        if (n2 < 2130837504) {
            return -1;
        }
        SpriteRESACTINFO[] spriteRESACTINFOArray = this.SpriteResACTInfo;
        int n10 = n2 & 0xFFFF;
        if (spriteRESACTINFOArray[n10].RESACTIdx != -1) {
            n7 = n2 & 0xFFFF;
        }
        if (n7 == -1) return n7;
        SpriteDEF[] spriteDEFArray = this.Sprite;
        int n11 = this.nShowSpriteNum;
        SpriteDEF spriteDEF = spriteDEFArray[n11];
        spriteDEF.SpriteResID = s6 = (short)n7;
        SpriteDEF[] spriteDEFArray2 = this.Sprite;
        int n12 = this.nShowSpriteNum;
        spriteDEFArray2[n12].SpriteXVal = n3;
        SpriteDEF[] spriteDEFArray3 = this.Sprite;
        int n13 = this.nShowSpriteNum;
        spriteDEFArray3[n13].SpriteYVal = n4;
        SpriteDEF[] spriteDEFArray4 = this.Sprite;
        int n14 = this.nShowSpriteNum;
        spriteDEFArray4[n14].Rotate = f2;
        SpriteDEF[] spriteDEFArray5 = this.Sprite;
        int n15 = this.nShowSpriteNum;
        spriteDEFArray5[n15].ScaleX = f3;
        SpriteDEF[] spriteDEFArray6 = this.Sprite;
        int n16 = this.nShowSpriteNum;
        spriteDEFArray6[n16].ScaleY = f3;
        SpriteDEF[] spriteDEFArray7 = this.Sprite;
        int n17 = this.nShowSpriteNum;
        SpriteDEF spriteDEF2 = spriteDEFArray7[n17];
        spriteDEF2.SpriteCenterX = s5 = (short)this.SpriteRes[n7].SpriteCenterX;
        SpriteDEF[] spriteDEFArray8 = this.Sprite;
        int n18 = this.nShowSpriteNum;
        SpriteDEF spriteDEF3 = spriteDEFArray8[n18];
        spriteDEF3.SpriteCenterY = s4 = (short)this.SpriteRes[n7].SpriteCenterY;
        if (s2 != 65535) {
            SpriteDEF[] spriteDEFArray9 = this.Sprite;
            int n19 = this.nShowSpriteNum;
            spriteDEFArray9[n19].RotateX = s2;
        } else {
            short s7;
            SpriteDEF[] spriteDEFArray10 = this.Sprite;
            int n20 = this.nShowSpriteNum;
            SpriteDEF spriteDEF4 = spriteDEFArray10[n20];
            SpriteDEF[] spriteDEFArray11 = this.Sprite;
            int n21 = this.nShowSpriteNum;
            spriteDEF4.RotateX = s7 = spriteDEFArray11[n21].SpriteCenterX;
        }
        if (s2 != 65535) {
            SpriteDEF[] spriteDEFArray12 = this.Sprite;
            int n22 = this.nShowSpriteNum;
            spriteDEFArray12[n22].RotateY = s3;
        } else {
            short s8;
            SpriteDEF[] spriteDEFArray13 = this.Sprite;
            int n23 = this.nShowSpriteNum;
            SpriteDEF spriteDEF5 = spriteDEFArray13[n23];
            SpriteDEF[] spriteDEFArray14 = this.Sprite;
            int n24 = this.nShowSpriteNum;
            spriteDEF5.RotateY = s8 = spriteDEFArray14[n24].SpriteCenterY;
        }
        n7 = this.nShowSpriteNum;
        SpriteDEF[] spriteDEFArray15 = this.Sprite;
        int n25 = this.nShowSpriteNum;
        this.nShowSpriteNum = n6 = n25 + 1;
        spriteDEFArray15[n25].SpriteAttrib = n5;
        return n7;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public void release() {
        block5: {
            int n2;
            int n3;
            boolean bl = true;
            while (true) {
                block8: {
                    block7: {
                        int n4;
                        block6: {
                            if (!bl || (bl = false)) break block6;
                            if (this.SpriteRes == null) break block7;
                            n3 = 0;
                        }
                        if (n3 < (n4 = this.nMaxSpriteResNum)) break block8;
                    }
                    this.SpriteRes = null;
                    this.nMaxSpriteResNum = 0;
                    this.SpriteResACTInfo = null;
                    this.nCurSpriteFileNum = 0;
                    this.bLoadingSpriteRes = 0;
                    this.pSpriteResSegInfo = null;
                    this.nCurSegLoadedSpriteNum = 0;
                    this.ACTStructInfo = null;
                    if (this.Sprite != null) {
                        break;
                    }
                    break block5;
                }
                if (this.SpriteRes[n3] != false) {
                    this.SpriteRes[n3].release();
                }
                ++n3;
            }
            for (n3 = 0; n3 < (n2 = this.nMaxSpriteNum); ++n3) {
                this.Sprite[n3].release();
            }
        }
        this.Sprite = null;
        this.nMaxSpriteNum = 0;
        this.nShowSpriteNum = 0;
        this.CloseSpriteACTFile();
    }

    class SpriteACTFILE {
        int nACTBuffLen = 0;
        byte[] pACTBuff = null;

        public void release() {
            if (this.pACTBuff != null) {
                this.pACTBuff = null;
            }
            this.nACTBuffLen = 0;
        }
    }

    class SpriteRESACTINFO {
        short RESACTIdx = (short)-1;
    }
}

