/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.AndrolibException;
import brut.directory.DirectoryException;
import brut.directory.FileDirectory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.jf.baksmali.baksmali;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.ByteArrayAnnotatedOutput;
import org.jf.smali.smaliLexer;
import org.jf.smali.smaliParser;
import org.jf.smali.smaliTreeWalker;

public class AndrolibSmali {
    public void baksmali(File file, File file2) throws AndrolibException {
        this.baksmali(file.getAbsolutePath(), file2.getAbsolutePath());
    }

    public void baksmali(String string, String string2) throws AndrolibException {
        try {
            DexFile dexFile = new DexFile(string);
            baksmali.disassembleDexFile(dexFile, false, string2, new String[0], "", false, true, true, true, false, 0, false);
        }
        catch (IOException iOException) {
            throw new AndrolibException(iOException);
        }
    }

    public void smali(File file, File file2) throws AndrolibException {
        this.smali(file.getAbsolutePath(), file2.getAbsolutePath());
    }

    public void smali(String string, String string2) throws AndrolibException {
        try {
            DexFile dexFile = new DexFile();
            for (String object2 : new FileDirectory(string).getFiles(true)) {
                if (AndrolibSmali.assembleSmaliFile(new File(string + "/" + object2), dexFile)) continue;
                throw new AndrolibException("Could not smali file: " + object2);
            }
            dexFile.place();
            for (CodeItem codeItem : dexFile.CodeItemsSection.getItems()) {
                codeItem.fixInstructions(true, true);
            }
            dexFile.place();
            ByteArrayAnnotatedOutput byteArrayAnnotatedOutput = new ByteArrayAnnotatedOutput();
            dexFile.writeTo(byteArrayAnnotatedOutput);
            byte[] byArray = byteArrayAnnotatedOutput.toByteArray();
            DexFile.calcSignature(byArray);
            DexFile.calcChecksum(byArray);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new AndrolibException("Could not smali files", iOException);
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException("Could not smali files", directoryException);
        }
        catch (RecognitionException recognitionException) {
            throw new AndrolibException("Could not smali files", recognitionException);
        }
    }

    private static boolean assembleSmaliFile(File file, DexFile dexFile) throws IOException, RecognitionException {
        ANTLRInputStream aNTLRInputStream = new ANTLRInputStream(new FileInputStream(file));
        aNTLRInputStream.name = file.getAbsolutePath();
        smaliLexer smaliLexer2 = new smaliLexer(aNTLRInputStream);
        CommonTokenStream commonTokenStream = new CommonTokenStream(smaliLexer2);
        smaliParser smaliParser2 = new smaliParser(commonTokenStream);
        smaliParser.smali_file_return smali_file_return2 = smaliParser2.smali_file();
        if (smaliParser2.getNumberOfSyntaxErrors() > 0 || smaliLexer2.getNumberOfLexerErrors() > 0) {
            return false;
        }
        CommonTree commonTree = (CommonTree)smali_file_return2.getTree();
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        commonTreeNodeStream.setTokenStream(commonTokenStream);
        smaliTreeWalker smaliTreeWalker2 = new smaliTreeWalker(commonTreeNodeStream);
        smaliTreeWalker2.dexFile = dexFile;
        smaliTreeWalker2.smali_file();
        return smaliTreeWalker2.getNumberOfSyntaxErrors() <= 0;
    }
}

