/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.Androlib;
import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.util.ExtFile;
import brut.common.BrutException;
import brut.util.OS;
import java.io.File;

public class ApkDecoder {
    public static final short DECODE_SOURCES_NONE = 0;
    public static final short DECODE_SOURCES_SMALI = 1;
    public static final short DECODE_RESOURCES_NONE = 256;
    public static final short DECODE_RESOURCES_FULL = 257;
    private final Androlib mAndrolib;
    private ExtFile mApkFile;
    private File mOutDir;
    private ResTable mResTable;
    private short mDecodeSources = 1;
    private short mDecodeResources = (short)257;

    public ApkDecoder() {
        this(new Androlib());
    }

    public ApkDecoder(Androlib androlib) {
        this.mAndrolib = androlib;
    }

    public ApkDecoder(File file) {
        this(file, new Androlib());
    }

    public ApkDecoder(File file, Androlib androlib) {
        this.mAndrolib = androlib;
        this.setApkFile(file);
    }

    public void setApkFile(File file) {
        this.mApkFile = new ExtFile(file);
        this.mResTable = null;
    }

    public void setOutDir(File file) throws AndrolibException {
        this.mOutDir = file;
    }

    public void decode() throws AndrolibException {
        File file = this.getOutDir();
        try {
            OS.rmdir(file);
        }
        catch (BrutException brutException) {
            throw new AndrolibException(brutException);
        }
        file.mkdirs();
        switch (this.mDecodeSources) {
            case 0: {
                this.mAndrolib.decodeSourcesRaw(this.mApkFile, file);
                break;
            }
            case 1: {
                this.mAndrolib.decodeSourcesSmali(this.mApkFile, file);
            }
        }
        switch (this.mDecodeResources) {
            case 256: {
                this.mAndrolib.decodeResourcesRaw(this.mApkFile, file);
                break;
            }
            case 257: {
                this.mAndrolib.decodeResourcesFull(this.mApkFile, file, this.getResTable());
            }
        }
        this.mAndrolib.decodeRawFiles(this.mApkFile, file);
    }

    public void setDecodeSources(short s) throws AndrolibException {
        if (s != 0 && s != 1) {
            throw new AndrolibException("Invalid decode sources mode: " + s);
        }
        this.mDecodeSources = s;
    }

    public void setDecodeResources(short s) throws AndrolibException {
        if (s != 256 && s != 257) {
            throw new AndrolibException("Invalid decode resources mode");
        }
        this.mDecodeResources = s;
    }

    public ResTable getResTable() throws AndrolibException {
        if (this.mResTable == null) {
            this.mResTable = this.mAndrolib.getResTable(this.mApkFile);
        }
        return this.mResTable;
    }

    private File getOutDir() throws AndrolibException {
        if (this.mOutDir == null) {
            throw new AndrolibException("Out dir not set");
        }
        return this.mOutDir;
    }
}

