/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res;

import brut.androlib.AndrolibException;
import brut.androlib.res.ResSmaliUpdater;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResValuesFile;
import brut.androlib.res.data.value.ResFileValue;
import brut.androlib.res.data.value.ResXmlSerializable;
import brut.androlib.res.decoder.ARSCDecoder;
import brut.androlib.res.decoder.AXmlResourceParser;
import brut.androlib.res.decoder.ResAttrDecoder;
import brut.androlib.res.decoder.ResFileDecoder;
import brut.androlib.res.decoder.ResRawStreamDecoder;
import brut.androlib.res.decoder.ResStreamDecoderContainer;
import brut.androlib.res.decoder.XmlPullStreamDecoder;
import brut.androlib.res.util.ExtFile;
import brut.androlib.res.util.ExtMXSerializer;
import brut.common.BrutException;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.FileDirectory;
import brut.util.BrutIO;
import brut.util.Duo;
import brut.util.Jar;
import brut.util.OS;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.xmlpull.v1.XmlSerializer;

public final class AndrolibResources {
    private static final Logger LOGGER = Logger.getLogger(AndrolibResources.class.getName());

    public ResTable getResTable(ExtFile extFile) throws AndrolibException {
        ResTable resTable = new ResTable();
        this.decodeArsc(resTable, extFile, true);
        if (!resTable.hasPackage(1)) {
            this.decodeArsc(resTable, new ExtFile(this.getAndroidResourcesFile()), false);
        }
        return resTable;
    }

    public void decode(ResTable resTable, ExtFile extFile, File file) throws AndrolibException {
        Directory directory;
        Directory directory2;
        Duo<ResFileDecoder, ResAttrDecoder> duo = this.getResFileDecoder();
        ResFileDecoder resFileDecoder = (ResFileDecoder)duo.m1;
        ResAttrDecoder resAttrDecoder = (ResAttrDecoder)duo.m2;
        resAttrDecoder.setCurrentPackage(resTable.listMainPackages().iterator().next());
        try {
            directory2 = extFile.getDirectory();
            directory = new FileDirectory(file);
            resFileDecoder.decode(directory2, "AndroidManifest.xml", directory, "AndroidManifest.xml", "xml");
            directory2 = directory2.getDir("res");
            directory = directory.createDir("res");
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException(directoryException);
        }
        File file2 = new File(file, "9patch/res");
        ExtMXSerializer extMXSerializer = this.getResXmlSerializer();
        for (ResPackage resPackage : resTable.listMainPackages()) {
            resAttrDecoder.setCurrentPackage(resPackage);
            for (ResResource resResource : resPackage.listFiles()) {
                this.decodeFile(resResource, directory2, directory, resFileDecoder, file2);
            }
            for (ResValuesFile resValuesFile : resPackage.listValuesFiles()) {
                this.generateValuesFile(resValuesFile, directory, extMXSerializer);
            }
            this.generatePublicXml(resPackage, directory, extMXSerializer);
        }
    }

    public void aaptPackage(File file, File file2, File file3, File file4, File file5, boolean bl, boolean bl2) throws AndrolibException {
        String[] stringArray = new String[14];
        int n = 0;
        stringArray[n++] = "aapt";
        stringArray[n++] = "p";
        if (bl) {
            stringArray[n++] = "-u";
        }
        stringArray[n++] = "-F";
        stringArray[n++] = file.getAbsolutePath();
        if (file3 != null) {
            if (bl2) {
                stringArray[n++] = "-x";
            } else {
                stringArray[n++] = "-I";
                stringArray[n++] = this.getAndroidResourcesFile().getAbsolutePath();
            }
            stringArray[n++] = "-S";
            stringArray[n++] = file3.getAbsolutePath();
        } else if (bl2) {
            stringArray[n++] = "-0";
            stringArray[n++] = "arsc";
        }
        if (file2 != null) {
            stringArray[n++] = "-M";
            stringArray[n++] = file2.getAbsolutePath();
        }
        if (file5 != null) {
            stringArray[n++] = "-A";
            stringArray[n++] = file5.getAbsolutePath();
        }
        if (file4 != null) {
            stringArray[n++] = file4.getAbsolutePath();
        }
        try {
            OS.exec(Arrays.copyOf(stringArray, n));
        }
        catch (BrutException brutException) {
            throw new AndrolibException(brutException);
        }
    }

    public boolean detectWhetherAppIsFramework(File file) throws AndrolibException {
        LineIterator lineIterator;
        File file2 = new File(file, "res/values/public.xml");
        if (!file2.exists()) {
            return false;
        }
        try {
            lineIterator = IOUtils.lineIterator(new FileReader(new File(file, "res/values/public.xml")));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new AndrolibException("Could not detect whether app is framework one", fileNotFoundException);
        }
        lineIterator.next();
        lineIterator.next();
        return ((String)lineIterator.next()).contains("0x01");
    }

    public void tagSmaliResIDs(ResTable resTable, File file) throws AndrolibException {
        new ResSmaliUpdater().tagResIDs(resTable, file);
    }

    public void updateSmaliResIDs(ResTable resTable, File file) throws AndrolibException {
        new ResSmaliUpdater().updateResIDs(resTable, file);
    }

    public Duo<ResFileDecoder, ResAttrDecoder> getResFileDecoder() {
        ResStreamDecoderContainer resStreamDecoderContainer = new ResStreamDecoderContainer();
        resStreamDecoderContainer.setDecoder("raw", new ResRawStreamDecoder());
        ResAttrDecoder resAttrDecoder = new ResAttrDecoder();
        AXmlResourceParser aXmlResourceParser = new AXmlResourceParser();
        aXmlResourceParser.setAttrDecoder(resAttrDecoder);
        resStreamDecoderContainer.setDecoder("xml", new XmlPullStreamDecoder(aXmlResourceParser, this.getResXmlSerializer()));
        return new Duo<ResFileDecoder, ResAttrDecoder>(new ResFileDecoder(resStreamDecoderContainer), resAttrDecoder);
    }

    public ExtMXSerializer getResXmlSerializer() {
        ExtMXSerializer extMXSerializer = new ExtMXSerializer();
        extMXSerializer.getClass();
        extMXSerializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "    ");
        extMXSerializer.getClass();
        extMXSerializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", System.getProperty("line.separator"));
        extMXSerializer.setProperty("DEFAULT_ENCODING", "UTF-8");
        return extMXSerializer;
    }

    private void decodeFile(ResResource resResource, Directory directory, Directory directory2, ResFileDecoder resFileDecoder, File file) throws AndrolibException {
        ResFileValue resFileValue = (ResFileValue)resResource.getValue();
        String string = resFileValue.getStrippedPath();
        String string2 = resResource.getFilePath();
        resFileDecoder.decode(directory, string, directory2, string2);
        if (string.endsWith(".9.png")) {
            File file2 = new File(file, string2 + ".png");
            file2.getParentFile().mkdirs();
            try {
                BrutIO.copyAndClose(directory.getFileInput(string), new FileOutputStream(file2));
            }
            catch (IOException iOException) {
                throw new AndrolibException(iOException);
            }
            catch (DirectoryException directoryException) {
                throw new AndrolibException(directoryException);
            }
        }
    }

    private void generateValuesFile(ResValuesFile resValuesFile, Directory directory, XmlSerializer xmlSerializer) throws AndrolibException {
        try {
            OutputStream outputStream = directory.getFileOutput(resValuesFile.getPath());
            xmlSerializer.setOutput(outputStream, null);
            xmlSerializer.startDocument(null, null);
            xmlSerializer.startTag(null, "resources");
            for (ResResource resResource : resValuesFile.listResources()) {
                if (resValuesFile.isSynthesized(resResource)) continue;
                ((ResXmlSerializable)((Object)resResource.getValue())).serializeToXml(xmlSerializer, resResource);
            }
            xmlSerializer.endTag(null, "resources");
            xmlSerializer.endDocument();
            xmlSerializer.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new AndrolibException("Could not generate: " + resValuesFile.getPath(), iOException);
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException("Could not generate: " + resValuesFile.getPath(), directoryException);
        }
    }

    private void generatePublicXml(ResPackage resPackage, Directory directory, XmlSerializer xmlSerializer) throws AndrolibException {
        try {
            OutputStream outputStream = directory.getFileOutput("values/public.xml");
            xmlSerializer.setOutput(outputStream, null);
            xmlSerializer.startDocument(null, null);
            xmlSerializer.startTag(null, "resources");
            for (ResResSpec resResSpec : resPackage.listResSpecs()) {
                xmlSerializer.startTag(null, "public");
                xmlSerializer.attribute(null, "type", resResSpec.getType().getName());
                xmlSerializer.attribute(null, "name", resResSpec.getName());
                xmlSerializer.attribute(null, "id", String.format("0x%08x", resResSpec.getId().id));
                xmlSerializer.endTag(null, "public");
            }
            xmlSerializer.endTag(null, "resources");
            xmlSerializer.endDocument();
            xmlSerializer.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new AndrolibException("Could not generate public.xml file", iOException);
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException("Could not generate public.xml file", directoryException);
        }
    }

    private void decodeArsc(ResTable resTable, ExtFile extFile, boolean bl) throws AndrolibException {
        try {
            this.loadArsc(resTable, extFile.getDirectory().getFileInput("resources.arsc"), bl);
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException("Could not load resources.arsc from file: " + extFile, directoryException);
        }
    }

    private void loadArsc(ResTable resTable, InputStream inputStream, boolean bl) throws AndrolibException {
        ResPackage[] resPackageArray = ARSCDecoder.decode(inputStream, resTable);
        if (resPackageArray.length == 0) {
            throw new AndrolibException("Arsc file with zero package groups");
        }
        if (resPackageArray.length > 1) {
            LOGGER.warning("Arsc file with multiple package groups");
        }
        for (int i = 0; i < resPackageArray.length; ++i) {
            if (resPackageArray.length != 1 && i == 0 && "android".equals(resPackageArray[i].getName())) {
                LOGGER.warning("Skipping \"android\" package group");
                continue;
            }
            resTable.addPackage(resPackageArray[i], bl);
        }
    }

    private File getAndroidResourcesFile() throws AndrolibException {
        try {
            return Jar.getResourceAsFile("/brut/androlib/android-framework.jar");
        }
        catch (BrutException brutException) {
            throw new AndrolibException(brutException);
        }
    }

    public static String escapeForResXml(String string) {
        if (string.isEmpty()) {
            return string;
        }
        string = string.replace("'", "\\'");
        string = string.replace("\"", "\\\"");
        char c = (string = string.replace("\n", "\\n")).charAt(0);
        if (c == '@' || c == '#' || c == '?') {
            return '\\' + string;
        }
        return string;
    }
}

