/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.AndrolibException;
import brut.androlib.err.UndefinedResObject;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.value.ResValue;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ResTable {
    private final Map<Integer, ResPackage> mPackagesById = new HashMap<Integer, ResPackage>();
    private final Map<String, ResPackage> mPackagesByName = new HashMap<String, ResPackage>();
    private final Set<ResPackage> mMainPackages = new LinkedHashSet<ResPackage>();

    public ResResSpec getResSpec(int n) throws AndrolibException {
        return this.getResSpec(new ResID(n));
    }

    public ResResSpec getResSpec(ResID resID) throws AndrolibException {
        return this.getPackage(resID.package_).getResSpec(resID);
    }

    public Set<ResPackage> listMainPackages() {
        return this.mMainPackages;
    }

    public ResPackage getPackage(int n) throws AndrolibException {
        ResPackage resPackage = this.mPackagesById.get(n);
        if (resPackage == null) {
            throw new UndefinedResObject(String.format("package: id=%d", n));
        }
        return resPackage;
    }

    public ResPackage getPackage(String string) throws AndrolibException {
        ResPackage resPackage = this.mPackagesByName.get(string);
        if (resPackage == null) {
            throw new UndefinedResObject("package: name=" + string);
        }
        return resPackage;
    }

    public boolean hasPackage(int n) {
        return this.mPackagesById.containsKey(n);
    }

    public boolean hasPackage(String string) {
        return this.mPackagesByName.containsKey(string);
    }

    public ResValue getValue(String string, String string2, String string3) throws AndrolibException {
        return this.getPackage(string).getType(string2).getResSpec(string3).getDefaultResource().getValue();
    }

    public void addPackage(ResPackage resPackage, boolean bl) throws AndrolibException {
        Integer n = resPackage.getId();
        if (this.mPackagesById.containsKey(n)) {
            throw new AndrolibException("Multiple packages: id=" + n.toString());
        }
        String string = resPackage.getName();
        if (this.mPackagesByName.containsKey(string)) {
            throw new AndrolibException("Multiple packages: name=" + string);
        }
        this.mPackagesById.put(n, resPackage);
        this.mPackagesByName.put(string, resPackage);
        if (bl) {
            this.mMainPackages.add(resPackage);
        }
    }
}

