/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.AndrolibException;
import brut.androlib.err.UndefinedResObject;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResTable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class ResType {
    private final String mName;
    private final Map<String, ResResSpec> mResSpecs = new LinkedHashMap<String, ResResSpec>();
    private final ResTable mResTable;
    private final ResPackage mPackage;

    public ResType(String string, ResTable resTable, ResPackage resPackage) {
        this.mName = string;
        this.mResTable = resTable;
        this.mPackage = resPackage;
    }

    public String getName() {
        return this.mName;
    }

    public Set<ResResSpec> listResSpecs() {
        return new LinkedHashSet<ResResSpec>(this.mResSpecs.values());
    }

    public ResResSpec getResSpec(String string) throws AndrolibException {
        ResResSpec resResSpec = this.mResSpecs.get(string);
        if (resResSpec == null) {
            throw new UndefinedResObject(String.format("resource spec: %s/%s", this.getName(), string));
        }
        return resResSpec;
    }

    public void addResSpec(ResResSpec resResSpec) throws AndrolibException {
        if (this.mResSpecs.put(resResSpec.getName(), resResSpec) != null) {
            throw new AndrolibException(String.format("Multiple res specs: %s/%s", this.getName(), resResSpec.getName()));
        }
    }

    public String toString() {
        return this.mName;
    }
}

