/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.value.ResArrayValue;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResBoolValue;
import brut.androlib.res.data.value.ResColorValue;
import brut.androlib.res.data.value.ResDimenValue;
import brut.androlib.res.data.value.ResFileValue;
import brut.androlib.res.data.value.ResFloatValue;
import brut.androlib.res.data.value.ResFractionValue;
import brut.androlib.res.data.value.ResIntValue;
import brut.androlib.res.data.value.ResPluralsValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.data.value.ResStringValue;
import brut.androlib.res.data.value.ResStyleValue;
import brut.androlib.res.data.value.ResValue;
import brut.util.Duo;

public class ResValueFactory {
    private final ResPackage mPackage;

    public ResValueFactory(ResPackage resPackage) {
        this.mPackage = resPackage;
    }

    public ResScalarValue factory(int n, int n2) throws AndrolibException {
        switch (n) {
            case 1: {
                return this.newReference(n2);
            }
            case 2: {
                return this.newReference(n2, true);
            }
            case 4: {
                return new ResFloatValue(Float.intBitsToFloat(n2));
            }
            case 5: {
                return new ResDimenValue(n2);
            }
            case 6: {
                return new ResFractionValue(n2);
            }
            case 18: {
                return new ResBoolValue(n2 != 0);
            }
        }
        if (n >= 28 && n <= 31) {
            return new ResColorValue(n2);
        }
        if (n >= 16 && n <= 31) {
            return new ResIntValue(n2);
        }
        throw new AndrolibException("Invalid value type: " + n);
    }

    public ResValue factory(String string) {
        if (string.startsWith("res/")) {
            return new ResFileValue(string);
        }
        return new ResStringValue(string);
    }

    public ResBagValue bagFactory(int n, Duo<Integer, ResScalarValue>[] duoArray) throws AndrolibException {
        ResReferenceValue resReferenceValue = this.newReference(n);
        if (duoArray.length == 0) {
            return new ResBagValue(resReferenceValue);
        }
        int n2 = (Integer)duoArray[0].m1;
        if (n2 == 0x1000000) {
            return ResAttr.factory(resReferenceValue, duoArray, this, this.mPackage);
        }
        if (n2 == 0x2000000) {
            return new ResArrayValue(resReferenceValue, duoArray);
        }
        if (n2 >= 0x1000004 && n2 <= 0x1000009) {
            return new ResPluralsValue(resReferenceValue, duoArray);
        }
        return new ResStyleValue(resReferenceValue, duoArray, this);
    }

    public ResReferenceValue newReference(int n) {
        return this.newReference(n, false);
    }

    public ResReferenceValue newReference(int n, boolean bl) {
        return new ResReferenceValue(this.mPackage, n, bl);
    }
}

