/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResConfig;
import brut.androlib.res.data.ResConfigFlags;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResType;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.data.value.ResValue;
import brut.androlib.res.data.value.ResValueFactory;
import brut.androlib.res.decoder.StringBlock;
import brut.util.Duo;
import brut.util.ExtDataInput;
import com.mindprod.ledatastream.LEDataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class ARSCDecoder {
    private final ExtDataInput mIn;
    private final ResTable mResTable;
    private Header mHeader;
    private StringBlock mTableStrings;
    private StringBlock mTypeNames;
    private StringBlock mSpecNames;
    private ResPackage mPkg;
    private ResType mType;
    private ResConfig mConfig;
    private int mResId;
    private static final short ENTRY_FLAG_COMPLEX = 1;
    private static final Logger LOGGER = Logger.getLogger(ARSCDecoder.class.getName());

    public static ResPackage[] decode(InputStream inputStream, ResTable resTable) throws AndrolibException {
        try {
            return new ARSCDecoder(inputStream, resTable).readTable();
        }
        catch (IOException iOException) {
            throw new AndrolibException("Could not decode arsc file", iOException);
        }
    }

    private ARSCDecoder(InputStream inputStream, ResTable resTable) {
        this.mIn = new ExtDataInput(new LEDataInputStream(inputStream));
        this.mResTable = resTable;
    }

    private ResPackage[] readTable() throws IOException, AndrolibException {
        this.nextChunkCheckType(2);
        int n = this.mIn.readInt();
        this.mTableStrings = StringBlock.read(this.mIn);
        ResPackage[] resPackageArray = new ResPackage[n];
        this.nextChunk();
        for (int i = 0; i < n; ++i) {
            resPackageArray[i] = this.readPackage();
        }
        return resPackageArray;
    }

    private ResPackage readPackage() throws IOException, AndrolibException {
        this.checkChunkType(512);
        byte by = (byte)this.mIn.readInt();
        String string = this.mIn.readNulEndedString(128, true);
        this.mIn.skipInt();
        this.mIn.skipInt();
        this.mIn.skipInt();
        this.mIn.skipInt();
        this.mTypeNames = StringBlock.read(this.mIn);
        this.mSpecNames = StringBlock.read(this.mIn);
        this.mResId = by << 24;
        this.mPkg = new ResPackage(this.mResTable, by, string);
        this.nextChunk();
        while (this.mHeader.type == 514) {
            this.readType();
        }
        return this.mPkg;
    }

    private ResType readType() throws AndrolibException, IOException {
        this.checkChunkType(514);
        byte by = this.mIn.readByte();
        this.mIn.skipBytes(3);
        int n = this.mIn.readInt();
        this.mIn.skipBytes(n * 4);
        this.mResId = 0xFF000000 & this.mResId | by << 16;
        this.mType = new ResType(this.mTypeNames.getString(by - 1), this.mResTable, this.mPkg);
        this.mPkg.addType(this.mType);
        while (this.nextChunk().type == 513) {
            this.readConfig();
        }
        return this.mType;
    }

    private ResConfig readConfig() throws IOException, AndrolibException {
        ResConfig resConfig;
        this.checkChunkType(513);
        this.mIn.skipInt();
        int n = this.mIn.readInt();
        this.mIn.skipInt();
        ResConfigFlags resConfigFlags = this.readConfigFlags();
        int[] nArray = this.mIn.readIntArray(n);
        if (this.mPkg.hasConfig(resConfigFlags)) {
            resConfig = this.mPkg.getConfig(resConfigFlags);
        } else {
            resConfig = new ResConfig(resConfigFlags);
            this.mPkg.addConfig(resConfig);
        }
        this.mConfig = resConfig;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == -1) continue;
            this.mResId = this.mResId & 0xFFFF0000 | i;
            this.readEntry();
        }
        return resConfig;
    }

    private void readEntry() throws IOException, AndrolibException {
        ResResSpec resResSpec;
        this.mIn.skipBytes(2);
        short s = this.mIn.readShort();
        int n = this.mIn.readInt();
        ResID resID = new ResID(this.mResId);
        if (this.mPkg.hasResSpec(resID)) {
            resResSpec = this.mPkg.getResSpec(resID);
        } else {
            resResSpec = new ResResSpec(resID, this.mSpecNames.getString(n), this.mPkg, this.mType);
            this.mPkg.addResSpec(resResSpec);
            this.mType.addResSpec(resResSpec);
        }
        ResValue resValue = (s & 1) == 0 ? this.readValue() : this.readComplexEntry();
        ResResource resResource = new ResResource(this.mConfig, resResSpec, resValue);
        this.mConfig.addResource(resResource);
        resResSpec.addResource(resResource);
        this.mPkg.addResource(resResource);
    }

    private ResBagValue readComplexEntry() throws IOException, AndrolibException {
        int n = this.mIn.readInt();
        int n2 = this.mIn.readInt();
        ResValueFactory resValueFactory = this.mPkg.getValueFactory();
        Duo[] duoArray = new Duo[n2];
        for (int i = 0; i < n2; ++i) {
            duoArray[i] = new Duo<Integer, ResScalarValue>(this.mIn.readInt(), (ResScalarValue)this.readValue());
        }
        return resValueFactory.bagFactory(n, duoArray);
    }

    private ResValue readValue() throws IOException, AndrolibException {
        this.mIn.skipCheckShort((short)8);
        this.mIn.skipCheckByte((byte)0);
        byte by = this.mIn.readByte();
        int n = this.mIn.readInt();
        return by == 3 ? this.mPkg.getValueFactory().factory(this.mTableStrings.getString(n)) : this.mPkg.getValueFactory().factory(by, n);
    }

    private ResConfigFlags readConfigFlags() throws IOException, AndrolibException {
        int n = this.mIn.readInt();
        if (n < 28) {
            throw new AndrolibException("Config size < 28");
        }
        if (n > 32) {
            LOGGER.warning("Config size > 32");
        }
        short s = this.mIn.readShort();
        short s2 = this.mIn.readShort();
        char[] cArray = new char[]{(char)this.mIn.readByte(), (char)this.mIn.readByte()};
        char[] cArray2 = new char[]{(char)this.mIn.readByte(), (char)this.mIn.readByte()};
        byte by = this.mIn.readByte();
        byte by2 = this.mIn.readByte();
        short s3 = this.mIn.readShort();
        byte by3 = this.mIn.readByte();
        byte by4 = this.mIn.readByte();
        byte by5 = this.mIn.readByte();
        this.mIn.skipBytes(1);
        short s4 = this.mIn.readShort();
        short s5 = this.mIn.readShort();
        short s6 = this.mIn.readShort();
        this.mIn.skipBytes(2);
        byte by6 = 0;
        if (n >= 32) {
            by6 = this.mIn.readByte();
            this.mIn.skipBytes(3);
        }
        if (n > 32) {
            this.mIn.skipBytes(n - 32);
        }
        return new ResConfigFlags(s, s2, cArray, cArray2, by, by2, s3, by3, by4, by5, s4, s5, by6, s6);
    }

    private Header nextChunk() throws IOException {
        this.mHeader = Header.read(this.mIn);
        return this.mHeader;
    }

    private void checkChunkType(int n) throws AndrolibException {
        if (this.mHeader.type != n) {
            throw new AndrolibException(String.format("Invalid chunk type: expected=0x%08x, got=0x%08x", n, this.mHeader.type));
        }
    }

    private void nextChunkCheckType(int n) throws IOException, AndrolibException {
        this.nextChunk();
        this.checkChunkType(n);
    }

    public static class Header {
        public final short type;
        public final int chunkSize;
        public static final short TYPE_NONE = -1;
        public static final short TYPE_TABLE = 2;
        public static final short TYPE_PACKAGE = 512;
        public static final short TYPE_TYPE = 514;
        public static final short TYPE_CONFIG = 513;

        public Header(short s, int n) {
            this.type = s;
            this.chunkSize = n;
        }

        public static Header read(ExtDataInput extDataInput) throws IOException {
            short s;
            try {
                s = extDataInput.readShort();
            }
            catch (EOFException eOFException) {
                return new Header(-1, 0);
            }
            extDataInput.skipBytes(2);
            return new Header(s, extDataInput.readInt());
        }
    }
}

