/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.AndrolibException;
import brut.androlib.res.decoder.ResStreamDecoderContainer;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ResFileDecoder {
    private final ResStreamDecoderContainer mDecoders;

    public ResFileDecoder(ResStreamDecoderContainer resStreamDecoderContainer) {
        this.mDecoders = resStreamDecoderContainer;
    }

    public void decode(Directory directory, String string, Directory directory2, String string2) throws AndrolibException {
        String string3 = "";
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string3 = string.substring(n);
        }
        if (string.startsWith("raw/")) {
            this.decode(directory, string, directory2, string2 + string3, "raw");
            return;
        }
        if (string.endsWith(".9.png")) {
            this.decode(directory, string, directory2, string2 + ".png", "raw");
            return;
        }
        if (string.endsWith(".xml")) {
            this.decode(directory, string, directory2, string2 + ".xml", "xml");
            return;
        }
        this.decode(directory, string, directory2, string2 + string3, "raw");
    }

    public void decode(Directory directory, String string, Directory directory2, String string2, String string3) throws AndrolibException {
        try {
            InputStream inputStream = directory.getFileInput(string);
            OutputStream outputStream = directory2.getFileOutput(string2);
            this.mDecoders.decode(inputStream, outputStream, string3);
            inputStream.close();
            outputStream.close();
        }
        catch (AndrolibException androlibException) {
            throw new AndrolibException(String.format("Could not decode file \"%s\" to \"%s\"", string, string2), androlibException);
        }
        catch (IOException iOException) {
            throw new AndrolibException(String.format("Could not decode file \"%s\" to \"%s\"", string, string2), iOException);
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException(String.format("Could not decode file \"%s\" to \"%s\"", string, string2), directoryException);
        }
    }
}

