/*
 * Decompiled with CFR 0.152.
 */
package brut.apktool;

import brut.androlib.Androlib;
import brut.androlib.AndrolibException;
import brut.androlib.ApkDecoder;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Main {
    public static void main(String[] stringArray) throws IOException, AndrolibException, InterruptedException {
        block7: {
            try {
                String string;
                int n;
                boolean bl = false;
                for (n = 0; n < stringArray.length && (string = stringArray[n]).startsWith("-"); ++n) {
                    if (!"-v".equals(string) && !"--verbose".equals(string)) {
                        throw new InvalidArgsError();
                    }
                    bl = true;
                }
                Main.setupLogging(bl);
                if (stringArray.length <= n) {
                    throw new InvalidArgsError();
                }
                string = stringArray[n];
                stringArray = Arrays.copyOfRange(stringArray, n + 1, stringArray.length);
                if ("d".equals(string) || "decode".equals(string)) {
                    Main.cmdDecode(stringArray);
                    break block7;
                }
                if ("b".equals(string) || "build".equals(string)) {
                    Main.cmdBuild(stringArray);
                    break block7;
                }
                throw new InvalidArgsError();
            }
            catch (InvalidArgsError invalidArgsError) {
                Main.usage();
            }
        }
    }

    private static void cmdDecode(String[] stringArray) throws InvalidArgsError, AndrolibException {
        String string;
        int n;
        ApkDecoder apkDecoder = new ApkDecoder();
        for (n = 0; n < stringArray.length && (string = stringArray[n]).startsWith("-"); ++n) {
            if ("-s".equals(string) || "--no-src".equals(string)) {
                apkDecoder.setDecodeSources((short)0);
                continue;
            }
            if ("-r".equals(string) || "--no-res".equals(string)) {
                apkDecoder.setDecodeResources((short)256);
                continue;
            }
            throw new InvalidArgsError();
        }
        if (stringArray.length != n + 2) {
            throw new InvalidArgsError();
        }
        apkDecoder.setApkFile(new File(stringArray[n]));
        apkDecoder.setOutDir(new File(stringArray[n + 1]));
        apkDecoder.decode();
    }

    private static void cmdBuild(String[] stringArray) throws InvalidArgsError, AndrolibException {
        Object object;
        int n;
        boolean bl = false;
        for (n = 0; n < stringArray.length && ((String)(object = stringArray[n])).startsWith("-"); ++n) {
            if (!"-f".equals(object) && !"--force-all".equals(object)) {
                throw new InvalidArgsError();
            }
            bl = true;
        }
        if (stringArray.length > n + 1) {
            throw new InvalidArgsError();
        }
        object = new File(stringArray.length == n ? "." : stringArray[n]);
        new Androlib().build((File)object, bl);
    }

    private static void usage() {
        System.out.println("Apktool v1.0 - a tool for reengineering Android apk files\nCopyright 2010 Ryszard Wi\u015bniewski <brut.alll@gmail.com>\n\nUsage: apktool [-v|--verbose] COMMAND [...]\n\nCOMMANDs are:\n\n    d[ecode] [-s|--no-src] [-r|--no-res] <file.apk> <dir>\n        Decode <file.apk> to <dir>.\n\n        -s, --no-src\n            Do not decode sources.\n        -r, --no-res\n            Do not decode resources.\n\n    b[uild] [-f|--force-all] [<app_path>]\n        Build an apk from already decoded application located in <app_path>.\n        Apk file will be placed in <app_path>/dist/out.apk .\n\n        It will automatically detect, whether files was changed and perform\n        needed steps only.\n\n        If you omit <app_path> then current directory will be used.\n\n        -f, --force-all\n            Skip changes detection and build all files.\n\nFor additional info, see: http://code.google.com/p/android-apktool/");
    }

    private static void setupLogging(boolean bl) {
        Logger logger = Logger.getLogger("");
        ConsoleHandler consoleHandler = new ConsoleHandler();
        logger.removeHandler(logger.getHandlers()[0]);
        logger.addHandler(consoleHandler);
        if (bl) {
            consoleHandler.setLevel(Level.ALL);
            logger.setLevel(Level.ALL);
        } else {
            consoleHandler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord logRecord) {
                    return logRecord.getLevel().toString().charAt(0) + ": " + logRecord.getMessage() + System.getProperty("line.separator");
                }
            });
        }
    }

    static class InvalidArgsError
    extends AndrolibException {
        InvalidArgsError() {
        }
    }
}

