/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.antlr.stringtemplate.StringTemplateWriter;

public class AutoIndentWriter
implements StringTemplateWriter {
    protected List indents = new ArrayList();
    protected int[] anchors = new int[10];
    protected int anchors_sp = -1;
    protected String newline;
    protected Writer out = null;
    protected boolean atStartOfLine = true;
    protected int charPosition = 0;
    protected int lineWidth = -1;
    protected int charPositionOfStartOfExpr = 0;

    public AutoIndentWriter(Writer writer, String string) {
        this.out = writer;
        this.indents.add(null);
        this.newline = string;
    }

    public AutoIndentWriter(Writer writer) {
        this(writer, System.getProperty("line.separator"));
    }

    @Override
    public void setLineWidth(int n) {
        this.lineWidth = n;
    }

    @Override
    public void pushIndentation(String string) {
        int n = 0;
        int n2 = this.getIndentationWidth();
        if (this.anchors_sp >= 0 && this.anchors[this.anchors_sp] > n2) {
            n = this.anchors[this.anchors_sp];
            StringBuffer stringBuffer = this.getIndentString(n - n2);
            if (string != null) {
                stringBuffer.append(string);
            }
            this.indents.add(stringBuffer.toString());
            return;
        }
        this.indents.add(string);
    }

    @Override
    public String popIndentation() {
        return (String)this.indents.remove(this.indents.size() - 1);
    }

    @Override
    public void pushAnchorPoint() {
        if (this.anchors_sp + 1 >= this.anchors.length) {
            int[] nArray = new int[this.anchors.length * 2];
            System.arraycopy(this.anchors, 0, nArray, 0, this.anchors.length - 1);
            this.anchors = nArray;
        }
        ++this.anchors_sp;
        this.anchors[this.anchors_sp] = this.charPosition;
    }

    @Override
    public void popAnchorPoint() {
        --this.anchors_sp;
    }

    public int getIndentationWidth() {
        int n = 0;
        for (int i = 0; i < this.indents.size(); ++i) {
            String string = (String)this.indents.get(i);
            if (string == null) continue;
            n += string.length();
        }
        return n;
    }

    @Override
    public int write(String string) throws IOException {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\r' || c == '\n') {
                this.atStartOfLine = true;
                this.charPosition = -1;
                this.out.write(this.newline);
                this.charPosition += (n += this.newline.length());
                if (c != '\r' || i + 1 >= string.length() || string.charAt(i + 1) != '\n') continue;
                ++i;
                continue;
            }
            if (this.atStartOfLine) {
                n += this.indent();
                this.atStartOfLine = false;
            }
            ++n;
            this.out.write(c);
            ++this.charPosition;
        }
        return n;
    }

    @Override
    public int writeSeparator(String string) throws IOException {
        return this.write(string);
    }

    @Override
    public int write(String string, String string2) throws IOException {
        int n = this.writeWrapSeparator(string2);
        return n + this.write(string);
    }

    @Override
    public int writeWrapSeparator(String string) throws IOException {
        int n = 0;
        if (this.lineWidth != -1 && string != null && !this.atStartOfLine && this.charPosition >= this.lineWidth) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\n') {
                    ++n;
                    this.out.write(c);
                    this.charPosition = 0;
                    n += this.indent();
                    continue;
                }
                ++n;
                this.out.write(c);
                ++this.charPosition;
            }
        }
        return n;
    }

    public int indent() throws IOException {
        int n = 0;
        for (int i = 0; i < this.indents.size(); ++i) {
            String string = (String)this.indents.get(i);
            if (string == null) continue;
            n += string.length();
            this.out.write(string);
        }
        this.charPosition += n;
        return n;
    }

    public int indent(int n) throws IOException {
        for (int i = 1; i <= n; ++i) {
            this.out.write(32);
        }
        this.charPosition += n;
        return n;
    }

    protected StringBuffer getIndentString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i <= n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer;
    }
}

