/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

class OptionValidator {
    OptionValidator() {
    }

    static void validateOption(String string) throws IllegalArgumentException {
        if (string == null) {
            return;
        }
        if (string.length() == 1) {
            char c = string.charAt(0);
            if (!OptionValidator.isValidOpt(c)) {
                throw new IllegalArgumentException("illegal option value '" + c + "'");
            }
        } else {
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (OptionValidator.isValidChar(cArray[i])) continue;
                throw new IllegalArgumentException("opt contains illegal character value '" + cArray[i] + "'");
            }
        }
    }

    private static boolean isValidOpt(char c) {
        return OptionValidator.isValidChar(c) || c == ' ' || c == '?' || c == '@';
    }

    private static boolean isValidChar(char c) {
        return Character.isJavaIdentifierPart(c);
    }
}

