/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PatternOptionBuilder;

public class TypeHandler {
    public static Object createValue(String string, Object object) throws ParseException {
        return TypeHandler.createValue(string, (Class)object);
    }

    public static Object createValue(String string, Class clazz) throws ParseException {
        if (PatternOptionBuilder.STRING_VALUE == clazz) {
            return string;
        }
        if (PatternOptionBuilder.OBJECT_VALUE == clazz) {
            return TypeHandler.createObject(string);
        }
        if (PatternOptionBuilder.NUMBER_VALUE == clazz) {
            return TypeHandler.createNumber(string);
        }
        if (PatternOptionBuilder.DATE_VALUE == clazz) {
            return TypeHandler.createDate(string);
        }
        if (PatternOptionBuilder.CLASS_VALUE == clazz) {
            return TypeHandler.createClass(string);
        }
        if (PatternOptionBuilder.FILE_VALUE == clazz) {
            return TypeHandler.createFile(string);
        }
        if (PatternOptionBuilder.EXISTING_FILE_VALUE == clazz) {
            return TypeHandler.createFile(string);
        }
        if (PatternOptionBuilder.FILES_VALUE == clazz) {
            return TypeHandler.createFiles(string);
        }
        if (PatternOptionBuilder.URL_VALUE == clazz) {
            return TypeHandler.createURL(string);
        }
        return null;
    }

    public static Object createObject(String string) throws ParseException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ParseException("Unable to find the class: " + string);
        }
        Object var2_3 = null;
        try {
            var2_3 = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ParseException(exception.getClass().getName() + "; Unable to create an instance of: " + string);
        }
        return var2_3;
    }

    public static Number createNumber(String string) throws ParseException {
        try {
            if (string.indexOf(46) != -1) {
                return Double.valueOf(string);
            }
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException.getMessage());
        }
    }

    public static Class createClass(String string) throws ParseException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ParseException("Unable to find the class: " + string);
        }
    }

    public static Date createDate(String string) throws ParseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static URL createURL(String string) throws ParseException {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ParseException("Unable to parse the URL: " + string);
        }
    }

    public static File createFile(String string) throws ParseException {
        return new File(string);
    }

    public static File[] createFiles(String string) throws ParseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

