/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.jf.baksmali.Adaptors.EndTryLabelMethodItem;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.Reference.TypeReference;
import org.jf.dexlib.TypeIdItem;

public class CatchMethodItem
extends MethodItem {
    private final StringTemplateGroup stg;
    private final TypeIdItem exceptionType;
    private final LabelMethodItem tryStartLabel;
    private final LabelMethodItem tryEndLabel;
    private final LabelMethodItem handlerLabel;

    public CatchMethodItem(MethodDefinition.LabelCache labelCache, int n, StringTemplateGroup stringTemplateGroup, TypeIdItem typeIdItem, int n2, int n3, int n4) {
        super(n);
        this.stg = stringTemplateGroup;
        this.exceptionType = typeIdItem;
        this.tryStartLabel = labelCache.internLabel(new LabelMethodItem(n2, stringTemplateGroup, "try_start_"));
        this.tryStartLabel.setUncommented();
        this.tryEndLabel = labelCache.internLabel(new EndTryLabelMethodItem(n, stringTemplateGroup, n3));
        this.tryEndLabel.setUncommented();
        this.handlerLabel = typeIdItem == null ? labelCache.internLabel(new LabelMethodItem(n4, stringTemplateGroup, "catchall_")) : labelCache.internLabel(new LabelMethodItem(n4, stringTemplateGroup, "catch_"));
        this.handlerLabel.setUncommented();
    }

    public LabelMethodItem getTryStartLabel() {
        return this.tryStartLabel;
    }

    public LabelMethodItem getTryEndLabel() {
        return this.tryEndLabel;
    }

    public LabelMethodItem getHandlerLabel() {
        return this.handlerLabel;
    }

    @Override
    public double getSortOrder() {
        return 102.0;
    }

    protected String getTemplateName() {
        return "Catch";
    }

    public String toString() {
        StringTemplate stringTemplate = this.stg.getInstanceOf(this.getTemplateName());
        if (this.exceptionType != null) {
            stringTemplate.setAttribute("ExceptionType", TypeReference.createTemplate(this.stg, this.exceptionType));
        }
        stringTemplate.setAttribute("StartLabel", this.tryStartLabel);
        stringTemplate.setAttribute("EndLabel", this.tryEndLabel);
        stringTemplate.setAttribute("HandlerLabel", this.handlerLabel);
        return stringTemplate.toString();
    }
}

