/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.util.ArrayList;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.jf.baksmali.Adaptors.AnnotationAdaptor;
import org.jf.baksmali.Adaptors.FieldDefinition;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.dexlib.AnnotationDirectoryItem;
import org.jf.dexlib.AnnotationItem;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.AnnotationSetRefList;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.Code.Analysis.ValidationException;
import org.jf.dexlib.Code.Format.Instruction21c;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.EncodedArrayItem;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.dexlib.Util.SparseArray;

public class ClassDefinition {
    private StringTemplateGroup stg;
    private ClassDefItem classDefItem;
    private ClassDataItem classDataItem;
    private SparseArray<AnnotationSetItem> methodAnnotationsMap;
    private SparseArray<AnnotationSetItem> fieldAnnotationsMap;
    private SparseArray<AnnotationSetRefList> parameterAnnotationsMap;
    private SparseArray<FieldIdItem> fieldsSetInStaticConstructor;
    protected boolean validationErrors;

    public ClassDefinition(StringTemplateGroup stringTemplateGroup, ClassDefItem classDefItem) {
        this.stg = stringTemplateGroup;
        this.classDefItem = classDefItem;
        this.classDataItem = classDefItem.getClassData();
        this.buildAnnotationMaps();
        this.findFieldsSetInStaticConstructor();
    }

    public StringTemplate createTemplate() {
        StringTemplate stringTemplate = this.stg.getInstanceOf("smaliFile");
        stringTemplate.setAttribute("AccessFlags", this.getAccessFlags());
        stringTemplate.setAttribute("ClassType", this.classDefItem.getClassType().getTypeDescriptor());
        stringTemplate.setAttribute("SuperType", this.getSuperType());
        stringTemplate.setAttribute("SourceFile", this.getSourceFile());
        stringTemplate.setAttribute("Interfaces", this.getInterfaces());
        stringTemplate.setAttribute("Annotations", this.getAnnotations());
        stringTemplate.setAttribute("StaticFields", this.getStaticFields());
        stringTemplate.setAttribute("InstanceFields", this.getInstanceFields());
        stringTemplate.setAttribute("DirectMethods", this.getDirectMethods());
        stringTemplate.setAttribute("VirtualMethods", this.getVirtualMethods());
        return stringTemplate;
    }

    public boolean hadValidationErrors() {
        return this.validationErrors;
    }

    private void buildAnnotationMaps() {
        AnnotationDirectoryItem annotationDirectoryItem = this.classDefItem.getAnnotations();
        if (annotationDirectoryItem == null) {
            this.methodAnnotationsMap = new SparseArray(0);
            this.fieldAnnotationsMap = new SparseArray(0);
            this.parameterAnnotationsMap = new SparseArray(0);
            return;
        }
        this.methodAnnotationsMap = new SparseArray(annotationDirectoryItem.getMethodAnnotationCount());
        annotationDirectoryItem.iterateMethodAnnotations(new AnnotationDirectoryItem.MethodAnnotationIteratorDelegate(){

            @Override
            public void processMethodAnnotations(MethodIdItem methodIdItem, AnnotationSetItem annotationSetItem) {
                ClassDefinition.this.methodAnnotationsMap.put(methodIdItem.getIndex(), annotationSetItem);
            }
        });
        this.fieldAnnotationsMap = new SparseArray(annotationDirectoryItem.getFieldAnnotationCount());
        annotationDirectoryItem.iterateFieldAnnotations(new AnnotationDirectoryItem.FieldAnnotationIteratorDelegate(){

            @Override
            public void processFieldAnnotations(FieldIdItem fieldIdItem, AnnotationSetItem annotationSetItem) {
                ClassDefinition.this.fieldAnnotationsMap.put(fieldIdItem.getIndex(), annotationSetItem);
            }
        });
        this.parameterAnnotationsMap = new SparseArray(annotationDirectoryItem.getParameterAnnotationCount());
        annotationDirectoryItem.iterateParameterAnnotations(new AnnotationDirectoryItem.ParameterAnnotationIteratorDelegate(){

            @Override
            public void processParameterAnnotations(MethodIdItem methodIdItem, AnnotationSetRefList annotationSetRefList) {
                ClassDefinition.this.parameterAnnotationsMap.put(methodIdItem.getIndex(), annotationSetRefList);
            }
        });
    }

    private void findFieldsSetInStaticConstructor() {
        this.fieldsSetInStaticConstructor = new SparseArray();
        if (this.classDataItem == null) {
            return;
        }
        for (ClassDataItem.EncodedMethod encodedMethod : this.classDataItem.getDirectMethods()) {
            if (!encodedMethod.method.getMethodName().getStringValue().equals("<clinit>")) continue;
            for (Instruction instruction : encodedMethod.codeItem.getInstructions()) {
                switch (instruction.opcode) {
                    case SPUT: 
                    case SPUT_BOOLEAN: 
                    case SPUT_BYTE: 
                    case SPUT_CHAR: 
                    case SPUT_OBJECT: 
                    case SPUT_SHORT: 
                    case SPUT_WIDE: {
                        Instruction21c instruction21c = (Instruction21c)instruction;
                        FieldIdItem fieldIdItem = (FieldIdItem)instruction21c.getReferencedItem();
                        this.fieldsSetInStaticConstructor.put(fieldIdItem.getIndex(), fieldIdItem);
                    }
                }
            }
        }
    }

    private List<String> getAccessFlags() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AccessFlags accessFlags : AccessFlags.getAccessFlagsForClass(this.classDefItem.getAccessFlags())) {
            arrayList.add(accessFlags.toString());
        }
        return arrayList;
    }

    private String getSuperType() {
        TypeIdItem typeIdItem = this.classDefItem.getSuperclass();
        if (typeIdItem != null) {
            return typeIdItem.getTypeDescriptor();
        }
        return null;
    }

    private String getSourceFile() {
        StringIdItem stringIdItem = this.classDefItem.getSourceFile();
        if (stringIdItem == null) {
            return null;
        }
        return this.classDefItem.getSourceFile().getStringValue();
    }

    private List<String> getInterfaces() {
        ArrayList<String> arrayList = new ArrayList<String>();
        TypeListItem typeListItem = this.classDefItem.getInterfaces();
        if (typeListItem != null) {
            for (TypeIdItem typeIdItem : typeListItem.getTypes()) {
                arrayList.add(typeIdItem.getTypeDescriptor());
            }
        }
        return arrayList;
    }

    private List<StringTemplate> getAnnotations() {
        AnnotationDirectoryItem annotationDirectoryItem = this.classDefItem.getAnnotations();
        if (annotationDirectoryItem == null) {
            return null;
        }
        AnnotationSetItem annotationSetItem = annotationDirectoryItem.getClassAnnotations();
        if (annotationSetItem == null) {
            return null;
        }
        ArrayList<StringTemplate> arrayList = new ArrayList<StringTemplate>();
        for (AnnotationItem annotationItem : annotationSetItem.getAnnotations()) {
            arrayList.add(AnnotationAdaptor.createTemplate(this.stg, annotationItem));
        }
        return arrayList;
    }

    private List<StringTemplate> getStaticFields() {
        ArrayList<StringTemplate> arrayList = new ArrayList<StringTemplate>();
        if (this.classDataItem != null) {
            assert (this.classDefItem != null);
            EncodedArrayItem encodedArrayItem = this.classDefItem.getStaticFieldInitializers();
            EncodedValue[] encodedValueArray = encodedArrayItem != null ? encodedArrayItem.getEncodedArray().values : new EncodedValue[]{};
            int n = 0;
            for (ClassDataItem.EncodedField encodedField : this.classDataItem.getStaticFields()) {
                EncodedValue encodedValue = null;
                if (n < encodedValueArray.length) {
                    encodedValue = encodedValueArray[n];
                }
                AnnotationSetItem annotationSetItem = this.fieldAnnotationsMap.get(encodedField.field.getIndex());
                boolean bl = this.fieldsSetInStaticConstructor.get(encodedField.field.getIndex()) != null;
                arrayList.add(FieldDefinition.createTemplate(this.stg, encodedField, encodedValue, annotationSetItem, bl));
                ++n;
            }
        }
        return arrayList;
    }

    private List<StringTemplate> getInstanceFields() {
        ArrayList<StringTemplate> arrayList = new ArrayList<StringTemplate>();
        if (this.classDataItem != null) {
            for (ClassDataItem.EncodedField encodedField : this.classDataItem.getInstanceFields()) {
                AnnotationSetItem annotationSetItem = this.fieldAnnotationsMap.get(encodedField.field.getIndex());
                arrayList.add(FieldDefinition.createTemplate(this.stg, encodedField, annotationSetItem));
            }
        }
        return arrayList;
    }

    private List<StringTemplate> getDirectMethods() {
        if (this.classDataItem == null) {
            return null;
        }
        return this.getTemplatesForMethods(this.classDataItem.getDirectMethods());
    }

    private List<StringTemplate> getVirtualMethods() {
        if (this.classDataItem == null) {
            return null;
        }
        return this.getTemplatesForMethods(this.classDataItem.getVirtualMethods());
    }

    private List<StringTemplate> getTemplatesForMethods(ClassDataItem.EncodedMethod[] encodedMethodArray) {
        ArrayList<StringTemplate> arrayList = new ArrayList<StringTemplate>();
        for (ClassDataItem.EncodedMethod encodedMethod : encodedMethodArray) {
            AnnotationSetItem annotationSetItem = this.methodAnnotationsMap.get(encodedMethod.method.getIndex());
            AnnotationSetRefList annotationSetRefList = this.parameterAnnotationsMap.get(encodedMethod.method.getIndex());
            MethodDefinition methodDefinition = new MethodDefinition(this.stg, encodedMethod);
            arrayList.add(methodDefinition.createTemplate(annotationSetItem, annotationSetRefList));
            ValidationException validationException = methodDefinition.getValidationException();
            if (validationException == null) continue;
            validationException.printStackTrace(System.err);
            this.validationErrors = true;
        }
        return arrayList;
    }
}

