/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.util.ArrayList;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.jf.baksmali.Adaptors.AnnotationAdaptor;
import org.jf.baksmali.Adaptors.EncodedValue.EncodedValueAdaptor;
import org.jf.dexlib.AnnotationItem;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.NullEncodedValue;
import org.jf.dexlib.Util.AccessFlags;

public class FieldDefinition {
    public static StringTemplate createTemplate(StringTemplateGroup stringTemplateGroup, ClassDataItem.EncodedField encodedField, EncodedValue encodedValue, AnnotationSetItem annotationSetItem, boolean bl) {
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("field");
        String string = encodedField.field.getFieldType().getTypeDescriptor();
        stringTemplate.setAttribute("AccessFlags", FieldDefinition.getAccessFlags(encodedField));
        stringTemplate.setAttribute("FieldName", encodedField.field.getFieldName().getStringValue());
        stringTemplate.setAttribute("FieldType", encodedField.field.getFieldType().getTypeDescriptor());
        stringTemplate.setAttribute("Annotations", FieldDefinition.getAnnotations(stringTemplateGroup, annotationSetItem));
        if (bl && encodedField.isStatic() && (encodedField.accessFlags & AccessFlags.FINAL.getValue()) != 0 && encodedValue != null && (string.length() == 1 || encodedValue != NullEncodedValue.NullValue)) {
            stringTemplate.setAttribute("Comments", (Object)new String[]{"the value of this static final field might be set in the static constructor"});
        } else {
            stringTemplate.setAttribute("Comments", (Object)null);
        }
        if (encodedValue != null) {
            stringTemplate.setAttribute("InitialValue", EncodedValueAdaptor.create(stringTemplateGroup, encodedValue));
        }
        return stringTemplate;
    }

    public static StringTemplate createTemplate(StringTemplateGroup stringTemplateGroup, ClassDataItem.EncodedField encodedField, AnnotationSetItem annotationSetItem) {
        return FieldDefinition.createTemplate(stringTemplateGroup, encodedField, null, annotationSetItem, false);
    }

    private static List<String> getAccessFlags(ClassDataItem.EncodedField encodedField) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AccessFlags accessFlags : AccessFlags.getAccessFlagsForField(encodedField.accessFlags)) {
            arrayList.add(accessFlags.toString());
        }
        return arrayList;
    }

    private static List<StringTemplate> getAnnotations(StringTemplateGroup stringTemplateGroup, AnnotationSetItem annotationSetItem) {
        if (annotationSetItem == null) {
            return null;
        }
        ArrayList<StringTemplate> arrayList = new ArrayList<StringTemplate>();
        for (AnnotationItem annotationItem : annotationSetItem.getAnnotations()) {
            arrayList.add(AnnotationAdaptor.createTemplate(stringTemplateGroup, annotationItem));
        }
        return arrayList;
    }
}

