/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.baksmali;

public class LabelMethodItem
extends MethodItem {
    private final StringTemplateGroup stg;
    private final String labelPrefix;
    private int labelSequence;
    private boolean isCommentedOut = true;

    public LabelMethodItem(int n, StringTemplateGroup stringTemplateGroup, String string) {
        super(n);
        this.stg = stringTemplateGroup;
        this.labelPrefix = string;
    }

    @Override
    public double getSortOrder() {
        return 0.0;
    }

    public boolean isCommentedOut() {
        return this.isCommentedOut;
    }

    public void setUncommented() {
        this.isCommentedOut = false;
    }

    @Override
    public int compareTo(MethodItem methodItem) {
        int n = super.compareTo(methodItem);
        if (n == 0 && methodItem instanceof LabelMethodItem) {
            n = this.labelPrefix.compareTo(((LabelMethodItem)methodItem).labelPrefix);
        }
        return n;
    }

    public int hashCode() {
        return this.getCodeAddress();
    }

    public boolean equals(Object object) {
        if (!(object instanceof LabelMethodItem)) {
            return false;
        }
        return this.compareTo((MethodItem)object) == 0;
    }

    public String toString() {
        StringTemplate stringTemplate = this.stg.getInstanceOf("Label");
        stringTemplate.setAttribute("Prefix", this.labelPrefix);
        if (baksmali.useSequentialLabels) {
            stringTemplate.setAttribute("Suffix", Integer.toHexString(this.labelSequence));
        } else {
            stringTemplate.setAttribute("Suffix", this.getLabelAddress());
        }
        return stringTemplate.toString();
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    public String getLabelAddress() {
        return Integer.toHexString(this.getCodeAddress());
    }

    public int getLabelSequence() {
        return this.labelSequence;
    }

    public void setLabelSequence(int n) {
        this.labelSequence = n;
    }
}

