/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.jf.baksmali.Adaptors.ClassDefinition;
import org.jf.baksmali.Renderers.ByteRenderer;
import org.jf.baksmali.Renderers.CharRenderer;
import org.jf.baksmali.Renderers.FloatRenderer;
import org.jf.baksmali.Renderers.IntegerRenderer;
import org.jf.baksmali.Renderers.LongRenderer;
import org.jf.baksmali.Renderers.ShortRenderer;
import org.jf.baksmali.Renderers.StringIdItemRenderer;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.Code.Analysis.ClassPath;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.StringIdItem;

public class baksmali {
    public static boolean noParameterRegisters = false;
    public static boolean useLocalsDirective = false;
    public static boolean useSequentialLabels = false;
    public static boolean outputDebugInfo = true;
    public static boolean addCodeOffsets = false;
    public static boolean deodex = false;
    public static boolean verify = false;
    public static int registerInfo = 0;
    public static String bootClassPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disassembleDexFile(DexFile dexFile, boolean bl, String string, String[] stringArray, String string2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, boolean bl7) {
        File file;
        noParameterRegisters = bl2;
        useLocalsDirective = bl3;
        useSequentialLabels = bl4;
        outputDebugInfo = bl5;
        addCodeOffsets = bl6;
        deodex = bl;
        registerInfo = n;
        bootClassPath = string2;
        verify = bl7;
        if (n != 0 || bl || bl7) {
            try {
                ClassPath.InitializeClassPath(stringArray, string2 == null ? null : string2.split(":"), dexFile);
            }
            catch (Exception exception) {
                System.err.println("\n\nError occured while loading boot class path files. Aborting.");
                exception.printStackTrace(System.err);
                System.exit(1);
            }
        }
        if (!(file = new File(string)).exists() && !file.mkdirs()) {
            System.err.println("Can't create the output directory " + string);
            System.exit(1);
        }
        InputStream inputStream = baksmali.class.getClassLoader().getResourceAsStream("templates/baksmali.stg");
        StringTemplateGroup stringTemplateGroup = new StringTemplateGroup(new InputStreamReader(inputStream));
        stringTemplateGroup.registerRenderer(Long.class, new LongRenderer());
        stringTemplateGroup.registerRenderer(Integer.class, new IntegerRenderer());
        stringTemplateGroup.registerRenderer(Short.class, new ShortRenderer());
        stringTemplateGroup.registerRenderer(Byte.class, new ByteRenderer());
        stringTemplateGroup.registerRenderer(Float.class, new FloatRenderer());
        stringTemplateGroup.registerRenderer(Character.class, new CharRenderer());
        stringTemplateGroup.registerRenderer(StringIdItem.class, new StringIdItemRenderer());
        for (ClassDefItem classDefItem : dexFile.ClassDefsSection.getItems()) {
            String string32;
            String string4 = classDefItem.getClassType().getTypeDescriptor();
            if (string4.charAt(0) != 'L' || string4.charAt(string4.length() - 1) != ';') {
                System.err.println("Unrecognized class descriptor - " + string4 + " - skipping class");
                continue;
            }
            string4 = string4.substring(1, string4.length() - 1);
            String[] stringArray2 = string4.split("/");
            StringBuilder stringBuilder = new StringBuilder(string);
            for (String string32 : stringArray2) {
                stringBuilder.append(File.separatorChar);
                stringBuilder.append(string32);
            }
            stringBuilder.append(".smali");
            File file2 = new File(stringBuilder.toString());
            ClassDefinition classDefinition = new ClassDefinition(stringTemplateGroup, classDefItem);
            StringTemplate stringTemplate = classDefinition.createTemplate();
            string32 = stringTemplate.toString();
            OutputStreamWriter outputStreamWriter = null;
            try {
                File file3 = file2.getParentFile();
                if (!file3.exists() && !file3.mkdirs()) {
                    System.err.println("Unable to create directory " + file3.toString() + " - skipping class");
                    continue;
                }
                if (!file2.exists() && !file2.createNewFile()) {
                    System.err.println("Unable to create file " + file2.toString() + " - skipping class");
                    continue;
                }
                outputStreamWriter = new FileWriter(file2);
                outputStreamWriter.write(string32);
            }
            catch (Exception exception) {
                System.err.println("\n\nError occured while disassembling class " + string4.replace('/', '.') + " - skipping class");
                exception.printStackTrace();
            }
            finally {
                if (outputStreamWriter == null) continue;
                try {
                    outputStreamWriter.close();
                }
                catch (Throwable throwable) {
                    System.err.println("\n\nError occured while closing file " + file2.toString());
                    throwable.printStackTrace();
                }
                continue;
            }
            if (!classDefinition.hadValidationErrors()) continue;
            System.exit(1);
        }
    }
}

