/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jf.baksmali.baksmali;
import org.jf.baksmali.dump;
import org.jf.dexlib.DexFile;
import org.jf.util.ConsoleUtil;
import org.jf.util.smaliHelpFormatter;

public class main {
    public static final String VERSION;
    private static final Options basicOptions;
    private static final Options debugOptions;
    private static final Options options;
    public static final int ALL = 1;
    public static final int ALLPRE = 2;
    public static final int ALLPOST = 4;
    public static final int ARGS = 8;
    public static final int DEST = 16;
    public static final int MERGE = 32;
    public static final int FULLMERGE = 64;

    private main() {
    }

    public static void main(String[] stringArray) {
        String[] stringArray2;
        Object object;
        CommandLine commandLine;
        PosixParser posixParser = new PosixParser();
        try {
            commandLine = posixParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            main.usage();
            return;
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = true;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        int n = 0;
        String string = "out";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = "core.jar:ext.jar:framework.jar:android.policy.jar:services.jar";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(".");
        String[] stringArray3 = commandLine.getArgs();
        Option[] optionArray = commandLine.getOptions();
        block27: for (int i = 0; i < optionArray.length; ++i) {
            object = optionArray[i];
            stringArray2 = ((Option)object).getOpt();
            switch (stringArray2.charAt(0)) {
                case 'v': {
                    main.version();
                    return;
                }
                case '?': {
                    while (++i < optionArray.length) {
                        if (optionArray[i].getOpt().charAt(0) != '?') continue;
                        main.usage(true);
                        return;
                    }
                    main.usage(false);
                    return;
                }
                case 'o': {
                    string = commandLine.getOptionValue("o");
                    continue block27;
                }
                case 'p': {
                    bl6 = true;
                    continue block27;
                }
                case 'l': {
                    bl7 = true;
                    continue block27;
                }
                case 's': {
                    bl8 = true;
                    continue block27;
                }
                case 'b': {
                    bl9 = false;
                    continue block27;
                }
                case 'd': {
                    arrayList.add(((Option)object).getValue());
                    continue block27;
                }
                case 'f': {
                    bl10 = true;
                    continue block27;
                }
                case 'r': {
                    String[] stringArray4 = commandLine.getOptionValues('r');
                    if (stringArray4 == null || stringArray4.length == 0) {
                        n = 24;
                        continue block27;
                    }
                    for (String string6 : stringArray4) {
                        if (string6.equalsIgnoreCase("ALL")) {
                            n |= 1;
                            continue;
                        }
                        if (string6.equalsIgnoreCase("ALLPRE")) {
                            n |= 2;
                            continue;
                        }
                        if (string6.equalsIgnoreCase("ALLPOST")) {
                            n |= 4;
                            continue;
                        }
                        if (string6.equalsIgnoreCase("ARGS")) {
                            n |= 8;
                            continue;
                        }
                        if (string6.equalsIgnoreCase("DEST")) {
                            n |= 0x10;
                            continue;
                        }
                        if (string6.equalsIgnoreCase("MERGE")) {
                            n |= 0x20;
                            continue;
                        }
                        if (string6.equalsIgnoreCase("FULLMERGE")) {
                            n |= 0x40;
                            continue;
                        }
                        main.usage();
                        return;
                    }
                    if ((n & 0x40) == 0) continue block27;
                    n &= 0xFFFFFFDF;
                    continue block27;
                }
                case 'c': {
                    String[] stringArray5 = commandLine.getOptionValue("c");
                    if (stringArray5 != null && stringArray5.charAt(0) == ':') {
                        string5 = string5 + (String)stringArray5;
                        continue block27;
                    }
                    string5 = stringArray5;
                    continue block27;
                }
                case 'x': {
                    bl11 = true;
                    continue block27;
                }
                case 'N': {
                    bl = false;
                    continue block27;
                }
                case 'D': {
                    bl2 = true;
                    string2 = commandLine.getOptionValue("D", string4 + ".dump");
                    continue block27;
                }
                case 'W': {
                    bl3 = true;
                    string3 = commandLine.getOptionValue("W");
                    continue block27;
                }
                case 'S': {
                    bl4 = true;
                    continue block27;
                }
                case 'F': {
                    bl5 = true;
                    continue block27;
                }
                case 'V': {
                    bl12 = true;
                    continue block27;
                }
                default: {
                    assert (false);
                    continue block27;
                }
            }
        }
        if (stringArray3.length != 1) {
            main.usage();
            return;
        }
        string4 = stringArray3[0];
        try {
            File file = new File(string4);
            if (!file.exists()) {
                System.err.println("Can't find the file " + string4);
                System.exit(1);
            }
            if (((DexFile)(object = new DexFile(file, !bl5, false))).isOdex()) {
                if (bl2) {
                    System.err.println("-D cannot be used with on odex file. Ignoring -D");
                }
                if (bl3) {
                    System.err.println("-W cannot be used with an odex file. Ignoring -W");
                }
                if (!bl11) {
                    System.err.println("Warning: You are disassembling an odex file without deodexing it. You");
                    System.err.println("won't be able to re-assemble the results unless you deodex it with the -x");
                    System.err.println("option");
                }
            } else {
                bl11 = false;
            }
            if (bl) {
                stringArray2 = new String[arrayList.size()];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = (String)arrayList.get(i);
                }
                baksmali.disassembleDexFile((DexFile)object, bl11, string, stringArray2, string5, bl6, bl7, bl8, bl9, bl10, n, bl12);
            }
            if ((bl2 || bl3) && !((DexFile)object).isOdex()) {
                try {
                    dump.dump((DexFile)object, string2, string3, bl4);
                }
                catch (IOException iOException) {
                    System.err.println("Error occured while writing dump file");
                    iOException.printStackTrace();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println("\n\nUNEXPECTED TOP-LEVEL EXCEPTION:");
            runtimeException.printStackTrace();
            System.exit(1);
        }
        catch (Throwable throwable) {
            System.err.println("\n\nUNEXPECTED TOP-LEVEL ERROR:");
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    private static void usage(boolean bl) {
        smaliHelpFormatter smaliHelpFormatter2 = new smaliHelpFormatter();
        smaliHelpFormatter2.setWidth(ConsoleUtil.getConsoleWidth());
        smaliHelpFormatter2.printHelp("java -jar baksmali.jar [options] <dex-file>", "disassembles and/or dumps a dex file", basicOptions, "");
        if (bl) {
            System.out.println();
            System.out.println("Debug Options:");
            StringBuffer stringBuffer = new StringBuffer();
            smaliHelpFormatter2.renderOptions(stringBuffer, debugOptions);
            System.out.println(stringBuffer.toString());
        }
    }

    private static void usage() {
        main.usage(false);
    }

    protected static void version() {
        System.out.println("baksmali " + VERSION + " (http://smali.googlecode.com)");
        System.out.println("Copyright (C) 2010 Ben Gruver (JesusFreke@JesusFreke.com)");
        System.out.println("BSD license (http://www.opensource.org/licenses/bsd-license.php)");
        System.exit(0);
    }

    private static void buildOptions() {
        OptionBuilder.withLongOpt("version");
        OptionBuilder.withDescription("prints the version then exits");
        Option option = OptionBuilder.create("v");
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("prints the help message then exits. Specify twice for debug options");
        Option option2 = OptionBuilder.create("?");
        OptionBuilder.withLongOpt("no-disassembly");
        OptionBuilder.withDescription("suppresses the output of the disassembly");
        Option option3 = OptionBuilder.create("N");
        OptionBuilder.withLongOpt("dump-to");
        OptionBuilder.withDescription("dumps the given dex file into a single annotated dump file named FILE (<dexfile>.dump by default), along with the normal disassembly.");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName("FILE");
        Option option4 = OptionBuilder.create("D");
        OptionBuilder.withLongOpt("write-dex");
        OptionBuilder.withDescription("additionally rewrites the input dex file to FILE");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("FILE");
        Option option5 = OptionBuilder.create("W");
        OptionBuilder.withLongOpt("output");
        OptionBuilder.withDescription("the directory where the disassembled files will be placed. The default is out");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("DIR");
        Option option6 = OptionBuilder.create("o");
        OptionBuilder.withLongOpt("sort");
        OptionBuilder.withDescription("sort the items in the dex file into a canonical order before dumping/writing");
        Option option7 = OptionBuilder.create("S");
        OptionBuilder.withLongOpt("fix-signed-registers");
        OptionBuilder.withDescription("when dumping or rewriting, fix any registers in the debug info that are encoded as a signed value");
        Option option8 = OptionBuilder.create("F");
        OptionBuilder.withLongOpt("no-parameter-registers");
        OptionBuilder.withDescription("use the v<n> syntax instead of the p<n> syntax for registers mapped to method parameters");
        Option option9 = OptionBuilder.create("p");
        OptionBuilder.withLongOpt("deodex");
        OptionBuilder.withDescription("deodex the given odex file. This option is ignored if the input file is not an odex file.");
        Option option10 = OptionBuilder.create("x");
        OptionBuilder.withLongOpt("use-locals");
        OptionBuilder.withDescription("output the .locals directive with the number of non-parameter registers, rather than the .register directive with the total number of register");
        Option option11 = OptionBuilder.create("l");
        OptionBuilder.withLongOpt("sequential-labels");
        OptionBuilder.withDescription("create label names using a sequential numbering scheme per label type, rather than using the bytecode address");
        Option option12 = OptionBuilder.create("s");
        OptionBuilder.withLongOpt("no-debug-info");
        OptionBuilder.withDescription("don't write out debug info (.local, .param, .line, etc.)");
        Option option13 = OptionBuilder.create("b");
        OptionBuilder.withLongOpt("register-info");
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withArgName("REGISTER_INFO_TYPES");
        OptionBuilder.withValueSeparator(',');
        OptionBuilder.withDescription("print the specificed type(s) of register information for each instruction. \"ARGS,DEST\" is the default if no types are specified.\nValid values are:\nALL: all pre- and post-instruction registers.\nALLPRE: all pre-instruction registers\nALLPOST: all post-instruction registers\nARGS: any pre-instruction registers used as arguments to the instruction\nDEST: the post-instruction destination register, if any\nMERGE: Any pre-instruction register has been merged from more than 1 different post-instruction register from its predecessors\nFULLMERGE: For each register that would be printed by MERGE, also show the incoming register types that were merged");
        Option option14 = OptionBuilder.create("r");
        OptionBuilder.withLongOpt("bootclasspath");
        OptionBuilder.withDescription("the bootclasspath jars to use, for analysis. Defaults to core.jar:ext.jar:framework.jar:android.policy.jar:services.jar. If the value begins with a :, it will be appended to the default bootclasspath instead of replacing it");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName("BOOTCLASSPATH");
        Option option15 = OptionBuilder.create("c");
        OptionBuilder.withLongOpt("bootclasspath-dir");
        OptionBuilder.withDescription("the base folder to look for the bootclasspath files in. Defaults to the current directory");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("DIR");
        Option option16 = OptionBuilder.create("d");
        OptionBuilder.withLongOpt("code-offsets");
        OptionBuilder.withDescription("add comments to the disassembly containing the code offset for each address");
        Option option17 = OptionBuilder.create("f");
        OptionBuilder.withLongOpt("verify");
        OptionBuilder.withDescription("perform bytecode verification");
        Option option18 = OptionBuilder.create("V");
        basicOptions.addOption(option);
        basicOptions.addOption(option2);
        basicOptions.addOption(option6);
        basicOptions.addOption(option9);
        basicOptions.addOption(option10);
        basicOptions.addOption(option11);
        basicOptions.addOption(option12);
        basicOptions.addOption(option13);
        basicOptions.addOption(option14);
        basicOptions.addOption(option15);
        basicOptions.addOption(option16);
        basicOptions.addOption(option17);
        debugOptions.addOption(option4);
        debugOptions.addOption(option3);
        debugOptions.addOption(option5);
        debugOptions.addOption(option7);
        debugOptions.addOption(option8);
        debugOptions.addOption(option18);
        for (Object e : basicOptions.getOptions()) {
            options.addOption((Option)e);
        }
        for (Object e : debugOptions.getOptions()) {
            options.addOption((Option)e);
        }
    }

    static {
        options = new Options();
        basicOptions = new Options();
        debugOptions = new Options();
        main.buildOptions();
        InputStream inputStream = baksmali.class.getClassLoader().getResourceAsStream("baksmali.properties");
        Properties properties = new Properties();
        String string = "(unknown)";
        try {
            properties.load(inputStream);
            string = properties.getProperty("application.version");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        VERSION = string;
    }
}

