/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Analysis;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jf.dexlib.Code.Analysis.ClassPath;
import org.jf.dexlib.Code.Analysis.ValidationException;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.ProtoIdItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;

public class DeodexUtil {
    public static final int Virtual = 0;
    public static final int Direct = 1;
    public static final int Static = 2;
    private InlineMethod[] inlineMethods = new InlineMethod[]{new InlineMethod(2, "Lorg/apache/harmony/dalvik/NativeTestTarget;", "emptyInlineMethod", "", "V"), new InlineMethod(0, "Ljava/lang/String;", "charAt", "I", "C"), new InlineMethod(0, "Ljava/lang/String;", "compareTo", "Ljava/lang/String;", "I"), new InlineMethod(0, "Ljava/lang/String;", "equals", "Ljava/lang/Object;", "Z"), new InlineMethod(0, "Ljava/lang/String;", "length", "", "I"), new InlineMethod(2, "Ljava/lang/Math;", "abs", "I", "I"), new InlineMethod(2, "Ljava/lang/Math;", "abs", "J", "J"), new InlineMethod(2, "Ljava/lang/Math;", "abs", "F", "F"), new InlineMethod(2, "Ljava/lang/Math;", "abs", "D", "D"), new InlineMethod(2, "Ljava/lang/Math;", "min", "II", "I"), new InlineMethod(2, "Ljava/lang/Math;", "max", "II", "I"), new InlineMethod(2, "Ljava/lang/Math;", "sqrt", "D", "D"), new InlineMethod(2, "Ljava/lang/Math;", "cos", "D", "D"), new InlineMethod(2, "Ljava/lang/Math;", "sin", "D", "D")};
    public final DexFile dexFile;
    private static final Pattern shortMethodPattern = Pattern.compile("([^(]+)\\(([^)]*)\\)(.+)");

    public DeodexUtil(DexFile dexFile) {
        this.dexFile = dexFile;
    }

    public InlineMethod lookupInlineMethod(int n) {
        if (n >= this.inlineMethods.length) {
            throw new RuntimeException("Invalid inline method index " + n + ".");
        }
        return this.inlineMethods[n];
    }

    public FieldIdItem lookupField(ClassPath.ClassDef classDef, int n) {
        String string = classDef.getInstanceField(n);
        if (string == null) {
            return null;
        }
        return this.parseAndResolveField(classDef, string);
    }

    public MethodIdItem lookupVirtualMethod(ClassPath.ClassDef classDef, int n) {
        String string = classDef.getVirtualMethod(n);
        Matcher matcher = shortMethodPattern.matcher(string);
        if (!matcher.matches()) {
            assert (false);
            throw new RuntimeException("Invalid method descriptor: " + string);
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        String string4 = matcher.group(3);
        if (classDef.isInterface()) {
            classDef = classDef.getSuperclass();
            assert (classDef != null);
        }
        return this.parseAndResolveMethod(classDef, string2, string3, string4);
    }

    private MethodIdItem parseAndResolveMethod(ClassPath.ClassDef classDef, String string, String string2, String string3) {
        TypeIdItem typeIdItem;
        StringIdItem stringIdItem = StringIdItem.lookupStringIdItem(this.dexFile, string);
        if (stringIdItem == null) {
            return null;
        }
        LinkedList<TypeIdItem> linkedList = new LinkedList<TypeIdItem>();
        for (int i = 0; i < string2.length(); ++i) {
            switch (string2.charAt(i)) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    typeIdItem = TypeIdItem.lookupTypeIdItem(this.dexFile, string2.substring(i, i + 1));
                    break;
                }
                case 'L': {
                    int n2 = string2.indexOf(59, i);
                    if (n2 == -1) {
                        throw new RuntimeException("invalid parameter in the method");
                    }
                    typeIdItem = TypeIdItem.lookupTypeIdItem(this.dexFile, string2.substring(i, n2 + 1));
                    i = n2;
                    break;
                }
                case '[': {
                    int n;
                    int n2;
                    for (n = i + 1; n < string2.length() && string2.charAt(n) == '['; ++n) {
                    }
                    switch (string2.charAt(n)) {
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'F': 
                        case 'I': 
                        case 'J': 
                        case 'S': 
                        case 'Z': {
                            n2 = n;
                            break;
                        }
                        case 'L': {
                            n2 = string2.indexOf(59, n);
                            if (n2 != -1) break;
                            throw new RuntimeException("invalid parameter in the method");
                        }
                        default: {
                            throw new RuntimeException("invalid parameter in the method");
                        }
                    }
                    typeIdItem = TypeIdItem.lookupTypeIdItem(this.dexFile, string2.substring(i, n2 + 1));
                    i = n2;
                    break;
                }
                default: {
                    throw new RuntimeException("invalid parameter in the method");
                }
            }
            if (typeIdItem == null) {
                return null;
            }
            linkedList.add(typeIdItem);
        }
        TypeListItem typeListItem = null;
        if (linkedList.size() > 0 && (typeListItem = TypeListItem.lookupTypeListItem(this.dexFile, linkedList)) == null) {
            return null;
        }
        typeIdItem = TypeIdItem.lookupTypeIdItem(this.dexFile, string3);
        if (typeIdItem == null) {
            return null;
        }
        ProtoIdItem protoIdItem = ProtoIdItem.lookupProtoIdItem(this.dexFile, typeIdItem, typeListItem);
        if (protoIdItem == null) {
            return null;
        }
        ClassPath.ClassDef classDef2 = classDef;
        do {
            MethodIdItem methodIdItem;
            TypeIdItem typeIdItem2;
            if ((typeIdItem2 = TypeIdItem.lookupTypeIdItem(this.dexFile, classDef2.getClassType())) == null || (methodIdItem = MethodIdItem.lookupMethodIdItem(this.dexFile, typeIdItem2, protoIdItem, stringIdItem)) == null) continue;
            return methodIdItem;
        } while ((classDef2 = classDef2.getSuperclass()) != null);
        return null;
    }

    private FieldIdItem parseAndResolveField(ClassPath.ClassDef classDef, String string) {
        String[] stringArray = string.split(":");
        if (stringArray.length != 2) {
            throw new RuntimeException("Invalid field descriptor " + string);
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        StringIdItem stringIdItem = StringIdItem.lookupStringIdItem(this.dexFile, string2);
        if (stringIdItem == null) {
            return null;
        }
        TypeIdItem typeIdItem = TypeIdItem.lookupTypeIdItem(this.dexFile, string3);
        if (typeIdItem == null) {
            return null;
        }
        ClassPath.ClassDef classDef2 = classDef;
        do {
            TypeIdItem typeIdItem2;
            if ((typeIdItem2 = TypeIdItem.lookupTypeIdItem(this.dexFile, classDef2.getClassType())) == null) continue;
            FieldIdItem fieldIdItem = FieldIdItem.lookupFieldIdItem(this.dexFile, typeIdItem2, typeIdItem, stringIdItem);
            if (fieldIdItem != null) {
                return fieldIdItem;
            }
            classDef2 = classDef2.getSuperclass();
        } while (classDef2 != null);
        return null;
    }

    protected void checkInlineMethods(String[] stringArray) {
        if (stringArray.length > this.inlineMethods.length) {
            throw new ValidationException("Inline method count mismatch");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string = stringArray[i];
            if (string.startsWith("static")) {
                n = 2;
                string = string.substring(7);
            } else if (string.startsWith("direct")) {
                n = 1;
                string = string.substring(7);
            } else if (string.startsWith("virtual")) {
                n = 0;
                string = string.substring(8);
            } else {
                throw new ValidationException("Could not parse inline method");
            }
            if (!string.equals(this.inlineMethods[i].getMethodString())) {
                throw new ValidationException(String.format("Inline method mismatch. %s vs. %s", string, this.inlineMethods[i].getMethodString()));
            }
            if (n == this.inlineMethods[i].methodType) continue;
            throw new ValidationException(String.format("Inline method type mismatch. %d vs. %d", n, this.inlineMethods[i].methodType));
        }
    }

    public class InlineMethod {
        public final int methodType;
        public final String classType;
        public final String methodName;
        public final String parameters;
        public final String returnType;
        private MethodIdItem methodIdItem = null;

        protected InlineMethod(int n, String string, String string2, String string3, String string4) {
            this.methodType = n;
            this.classType = string;
            this.methodName = string2;
            this.parameters = string3;
            this.returnType = string4;
        }

        public MethodIdItem getMethodIdItem() {
            if (this.methodIdItem == null) {
                this.loadMethod();
            }
            return this.methodIdItem;
        }

        private void loadMethod() {
            ClassPath.ClassDef classDef = ClassPath.getClassDef(this.classType);
            this.methodIdItem = DeodexUtil.this.parseAndResolveMethod(classDef, this.methodName, this.parameters, this.returnType);
        }

        public String getMethodString() {
            return String.format("%s->%s(%s)%s", this.classType, this.methodName, this.parameters, this.returnType);
        }
    }
}

