/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.LiteralInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction22s
extends Instruction
implements TwoRegisterInstruction,
LiteralInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;
    private byte regB;
    private short litC;

    public Instruction22s(Opcode opcode, byte by, byte by2, short s) {
        super(opcode);
        if (by >= 16 || by2 >= 16) {
            throw new RuntimeException("The register number must be less than v16");
        }
        this.regA = by;
        this.regB = by2;
        this.litC = s;
    }

    private Instruction22s(Opcode opcode, byte[] byArray, int n) {
        super(opcode);
        this.regA = NumberUtils.decodeLowUnsignedNibble(byArray[n + 1]);
        this.regB = NumberUtils.decodeHighUnsignedNibble(byArray[n + 1]);
        this.litC = NumberUtils.decodeShort(byArray, n + 2);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.writeByte(this.opcode.value);
        annotatedOutput.writeByte(this.regB << 4 | this.regA);
        annotatedOutput.writeShort(this.litC);
    }

    @Override
    public Format getFormat() {
        return Format.Format22s;
    }

    @Override
    public int getRegisterA() {
        return this.regA;
    }

    @Override
    public int getRegisterB() {
        return this.regB;
    }

    @Override
    public long getLiteral() {
        return this.litC;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
            return new Instruction22s(opcode, byArray, n);
        }
    }
}

