/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import java.util.Iterator;
import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.MultiOffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class PackedSwitchDataPseudoInstruction
extends Instruction
implements MultiOffsetInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private int firstKey;
    private int[] targets;

    @Override
    public int getSize(int n) {
        return this.getTargetCount() * 2 + 4 + n % 2;
    }

    public PackedSwitchDataPseudoInstruction(int n, int[] nArray) {
        super(Opcode.NOP);
        if (nArray.length > 65535) {
            throw new RuntimeException("The packed-switch data contains too many elements. The maximum number of switch elements is 65535");
        }
        this.firstKey = n;
        this.targets = nArray;
    }

    public PackedSwitchDataPseudoInstruction(byte[] byArray, int n) {
        super(Opcode.NOP);
        byte by = byArray[n];
        if (by != 0) {
            throw new RuntimeException("Invalid opcode byte for a PackedSwitchData pseudo-instruction");
        }
        byte by2 = byArray[n + 1];
        if (by2 != 1) {
            throw new RuntimeException("Invalid sub-opcode byte for a PackedSwitchData pseudo-instruction");
        }
        int n2 = NumberUtils.decodeUnsignedShort(byArray, n + 2);
        this.firstKey = NumberUtils.decodeInt(byArray, n + 4);
        this.targets = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.targets[i] = NumberUtils.decodeInt(byArray, n + 8 + 4 * i);
        }
    }

    @Override
    protected void writeInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.alignTo(4);
        annotatedOutput.writeByte(0);
        annotatedOutput.writeByte(1);
        annotatedOutput.writeShort(this.targets.length);
        annotatedOutput.writeInt(this.firstKey);
        for (int n2 : this.targets) {
            annotatedOutput.writeInt(n2);
        }
    }

    @Override
    protected void annotateInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.annotate(this.getSize(n) * 2, "[0x" + Integer.toHexString(n) + "] " + "packed-switch-data instruction");
    }

    @Override
    public void updateTarget(int n, int n2) {
        this.targets[n] = n2;
    }

    @Override
    public Format getFormat() {
        return Format.PackedSwitchData;
    }

    public int getTargetCount() {
        return this.targets.length;
    }

    public int getFirstKey() {
        return this.firstKey;
    }

    @Override
    public int[] getTargets() {
        return this.targets;
    }

    public Iterator<PackedSwitchTarget> iterateKeysAndTargets() {
        return new Iterator<PackedSwitchTarget>(){
            final int targetCount;
            int i;
            int value;
            PackedSwitchTarget packedSwitchTarget;
            {
                this.targetCount = PackedSwitchDataPseudoInstruction.this.getTargetCount();
                this.i = 0;
                this.value = PackedSwitchDataPseudoInstruction.this.getFirstKey();
                this.packedSwitchTarget = new PackedSwitchTarget();
            }

            @Override
            public boolean hasNext() {
                return this.i < this.targetCount;
            }

            @Override
            public PackedSwitchTarget next() {
                this.packedSwitchTarget.value = this.value++;
                this.packedSwitchTarget.targetAddressOffset = PackedSwitchDataPseudoInstruction.this.targets[this.i];
                ++this.i;
                return this.packedSwitchTarget;
            }

            @Override
            public void remove() {
            }
        };
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
            if (opcode != Opcode.NOP) {
                throw new RuntimeException("The opcode for a PackedSwitchDataPseudoInstruction must be NOP");
            }
            return new PackedSwitchDataPseudoInstruction(byArray, n);
        }
    }

    public static class PackedSwitchTarget {
        public int value;
        public int targetAddressOffset;
    }
}

