/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.EncodedValueUtils;
import org.jf.dexlib.Util.Input;

public class ByteEncodedValue
extends EncodedValue {
    public final byte value;

    protected ByteEncodedValue(Input input) {
        this.value = (byte)EncodedValueUtils.decodeSignedIntegralValue(input.readBytes(1));
    }

    public ByteEncodedValue(byte by) {
        this.value = by;
    }

    @Override
    public void writeValue(AnnotatedOutput annotatedOutput) {
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(1, "value_type=" + ValueType.VALUE_BYTE.name() + ",value_arg=0");
            annotatedOutput.annotate(1, "value: 0x" + Integer.toHexString(this.value) + " (" + this.value + ")");
        }
        annotatedOutput.writeByte(ValueType.VALUE_BYTE.value);
        annotatedOutput.writeByte(this.value);
    }

    @Override
    public int placeValue(int n) {
        return n + 2;
    }

    @Override
    protected int compareValue(EncodedValue encodedValue) {
        ByteEncodedValue byteEncodedValue = (ByteEncodedValue)encodedValue;
        return this.value < byteEncodedValue.value ? -1 : (this.value > byteEncodedValue.value ? 1 : 0);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.VALUE_BYTE;
    }

    public int hashCode() {
        return this.value;
    }
}

