/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.EncodedValueUtils;
import org.jf.dexlib.Util.Input;

public class ShortEncodedValue
extends EncodedValue {
    public final short value;

    protected ShortEncodedValue(Input input, byte by) {
        this.value = (short)EncodedValueUtils.decodeSignedIntegralValue(input.readBytes(by + 1));
    }

    public ShortEncodedValue(short s) {
        this.value = s;
    }

    @Override
    public void writeValue(AnnotatedOutput annotatedOutput) {
        byte[] byArray = EncodedValueUtils.encodeSignedIntegralValue(this.value);
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(1, "value_type=" + ValueType.VALUE_SHORT.name() + ",value_arg=" + (byArray.length - 1));
            annotatedOutput.annotate(byArray.length, "value: 0x" + Integer.toHexString(this.value) + " (" + this.value + ")");
        }
        annotatedOutput.writeByte(ValueType.VALUE_SHORT.value | byArray.length - 1 << 5);
        annotatedOutput.write(byArray);
    }

    @Override
    public int placeValue(int n) {
        return n + EncodedValueUtils.getRequiredBytesForSignedIntegralValue(this.value) + 1;
    }

    @Override
    protected int compareValue(EncodedValue encodedValue) {
        ShortEncodedValue shortEncodedValue = (ShortEncodedValue)encodedValue;
        return this.value < shortEncodedValue.value ? -1 : (this.value > shortEncodedValue.value ? 1 : 0);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.VALUE_SHORT;
    }

    public int hashCode() {
        return this.value;
    }
}

