/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemFactory;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Section;
import org.jf.dexlib.Util.Hex;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.SparseArray;

public class OffsettedSection<T extends Item>
extends Section<T> {
    public OffsettedSection(DexFile dexFile, ItemType itemType) {
        super(dexFile, itemType);
    }

    @Override
    public void readItems(Input input, ReadContext readContext) {
        SparseArray sparseArray = readContext.getItemsByType(this.ItemType);
        assert (sparseArray.size() <= this.items.size()) : "Trying to read " + this.items.size() + " items, but this section " + "already contains " + sparseArray.size() + " items.";
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        if (sparseArray.size() > 0) {
            n2 = sparseArray.keyAt(0);
        }
        for (int i = 0; i < this.items.size(); ++i) {
            assert (this.items.get(i) == null);
            Item item = null;
            input.alignTo(this.ItemType.ItemAlignment);
            int n3 = input.getCursor();
            if (n3 == n2) {
                item = (Item)sparseArray.valueAt(n++);
                n2 = n < sparseArray.size() ? sparseArray.keyAt(n) : Integer.MAX_VALUE;
            } else {
                if (n3 > n2) {
                    throw new RuntimeException("The pre-created item at offset 0x" + Hex.u4(n2) + " was not read");
                }
                item = ItemFactory.makeItem(this.ItemType, this.DexFile);
            }
            this.items.set(i, item);
            item.readFrom(input, i, readContext);
        }
        readContext.setItemsForSection(this.ItemType, this.items);
    }
}

