/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

import org.jf.dexlib.Util.AlignmentUtils;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.Input;

public class ByteArrayInput
implements Input {
    private byte[] data;
    private int cursor;

    public ByteArrayInput(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("data == null");
        }
        this.data = byArray;
        this.cursor = 0;
    }

    public byte[] getArray() {
        return this.data;
    }

    @Override
    public int getCursor() {
        return this.cursor;
    }

    @Override
    public void setCursor(int n) {
        if (n < 0 || n >= this.data.length) {
            throw new IndexOutOfBoundsException("The provided cursor value is not within the bounds of this instance's data array");
        }
        this.cursor = n;
    }

    @Override
    public void assertCursor(int n) {
        if (this.cursor != n) {
            throw new ExceptionWithContext("expected cursor " + n + "; actual value: " + this.cursor);
        }
    }

    @Override
    public byte readByte() {
        int n = this.cursor;
        int n2 = n + 1;
        if (n2 > this.data.length) {
            ByteArrayInput.throwBounds();
        }
        this.cursor = n2;
        return this.data[n];
    }

    @Override
    public int readShort() {
        int n = this.cursor;
        int n2 = n + 2;
        if (n2 > this.data.length) {
            ByteArrayInput.throwBounds();
        }
        this.cursor = n2;
        return (this.data[n] & 0xFF) + ((this.data[n + 1] & 0xFF) << 8);
    }

    @Override
    public int readInt() {
        int n = this.cursor;
        int n2 = n + 4;
        if (n2 > this.data.length) {
            ByteArrayInput.throwBounds();
        }
        this.cursor = n2;
        return (this.data[n] & 0xFF) + ((this.data[n + 1] & 0xFF) << 8) + ((this.data[n + 2] & 0xFF) << 16) + ((this.data[n + 3] & 0xFF) << 24);
    }

    @Override
    public long readLong() {
        int n = this.cursor;
        int n2 = n + 8;
        if (n2 > this.data.length) {
            ByteArrayInput.throwBounds();
        }
        this.cursor = n2;
        return (long)this.data[n] & 0xFFL | ((long)this.data[n + 1] & 0xFFL) << 8 | ((long)this.data[n + 2] & 0xFFL) << 16 | ((long)this.data[n + 3] & 0xFFL) << 24 | ((long)this.data[n + 4] & 0xFFL) << 32 | ((long)this.data[n + 5] & 0xFFL) << 40 | ((long)this.data[n + 6] & 0xFFL) << 48 | ((long)this.data[n + 7] & 0xFFL) << 58;
    }

    @Override
    public int readUnsignedOrSignedLeb128() {
        int n;
        int n2 = this.cursor;
        if ((n = this.data[n2++] & 0xFF) > 127) {
            int n3 = this.data[n2++] & 0xFF;
            n = n & 0x7F | (n3 & 0x7F) << 7;
            if (n3 > 127) {
                n3 = this.data[n2++] & 0xFF;
                n |= (n3 & 0x7F) << 14;
                if (n3 > 127) {
                    n3 = this.data[n2++] & 0xFF;
                    n |= (n3 & 0x7F) << 21;
                    if (n3 > 127) {
                        if ((n3 = this.data[n2++] & 0xFF) > 15) {
                            ByteArrayInput.throwInvalidLeb();
                        }
                        n |= n3 << 28;
                    }
                }
            }
        } else {
            this.cursor = n2;
            return n;
        }
        this.cursor = n2;
        if (this.data[n2 - 1] == 0) {
            return ~n;
        }
        return n;
    }

    @Override
    public int readUnsignedLeb128() {
        int n;
        int n2 = this.cursor;
        if ((n = this.data[n2++] & 0xFF) > 127) {
            int n3 = this.data[n2++] & 0xFF;
            n = n & 0x7F | (n3 & 0x7F) << 7;
            if (n3 > 127) {
                n3 = this.data[n2++] & 0xFF;
                n |= (n3 & 0x7F) << 14;
                if (n3 > 127) {
                    n3 = this.data[n2++] & 0xFF;
                    n |= (n3 & 0x7F) << 21;
                    if (n3 > 127) {
                        if ((n3 = this.data[n2++] & 0xFF) > 15) {
                            ByteArrayInput.throwInvalidLeb();
                        }
                        n |= n3 << 28;
                    }
                }
            }
        }
        this.cursor = n2;
        return n;
    }

    @Override
    public int readSignedLeb128() {
        int n;
        int n2 = this.cursor;
        if ((n = this.data[n2++] & 0xFF) <= 127) {
            n = n << 25 >> 25;
        } else {
            int n3 = this.data[n2++] & 0xFF;
            n = n & 0x7F | (n3 & 0x7F) << 7;
            if (n3 <= 127) {
                n = n << 18 >> 18;
            } else {
                n3 = this.data[n2++] & 0xFF;
                n |= (n3 & 0x7F) << 14;
                if (n3 <= 127) {
                    n = n << 11 >> 11;
                } else {
                    n3 = this.data[n2++] & 0xFF;
                    n |= (n3 & 0x7F) << 21;
                    if (n3 <= 127) {
                        n = n << 4 >> 4;
                    } else {
                        if ((n3 = this.data[n2++] & 0xFF) > 15) {
                            ByteArrayInput.throwInvalidLeb();
                        }
                        n |= n3 << 28;
                    }
                }
            }
        }
        this.cursor = n2;
        return n;
    }

    @Override
    public void read(byte[] byArray, int n, int n2) {
        int n3 = this.cursor + n2;
        if (n3 > this.data.length) {
            ByteArrayInput.throwBounds();
        }
        System.arraycopy(this.data, this.cursor, byArray, n, n2);
        this.cursor = n3;
    }

    @Override
    public void read(byte[] byArray) {
        int n = byArray.length;
        int n2 = this.cursor + n;
        if (n2 > this.data.length) {
            ByteArrayInput.throwBounds();
        }
        System.arraycopy(this.data, this.cursor, byArray, 0, n);
        this.cursor = n2;
    }

    @Override
    public byte[] readBytes(int n) {
        int n2 = this.cursor + n;
        if (n2 > this.data.length) {
            ByteArrayInput.throwBounds();
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.data, this.cursor, byArray, 0, n);
        this.cursor = n2;
        return byArray;
    }

    @Override
    public byte[] readNullTerminatedBytes() {
        int n = this.cursor;
        while (this.data[this.cursor] != 0) {
            ++this.cursor;
            if (this.cursor < this.data.length) continue;
            ByteArrayInput.throwBounds();
        }
        int n2 = this.cursor - n;
        ++this.cursor;
        byte[] byArray = new byte[n2];
        System.arraycopy(this.data, n, byArray, 0, n2);
        return byArray;
    }

    @Override
    public void skipBytes(int n) {
        int n2 = this.cursor + n;
        if (n2 > this.data.length) {
            ByteArrayInput.throwBounds();
        }
        this.cursor = n2;
    }

    @Override
    public void alignTo(int n) {
        int n2 = AlignmentUtils.alignOffset(this.cursor, n);
        if (n2 > this.data.length) {
            ByteArrayInput.throwBounds();
        }
        this.cursor = n2;
    }

    private static void throwBounds() {
        throw new IndexOutOfBoundsException("attempt to read past the end");
    }

    private static void throwInvalidLeb() {
        throw new RuntimeException("invalid LEB128 integer encountered");
    }
}

