/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

public class EncodedValueUtils {
    public static byte getRequiredBytesForSignedIntegralValue(long l) {
        int n = 65 - Long.numberOfLeadingZeros(l ^ l >> 63);
        return (byte)(n + 7 >> 3);
    }

    public static long decodeSignedIntegralValue(byte[] byArray) {
        int n;
        long l = 0L;
        for (n = 0; n < byArray.length; ++n) {
            l |= (long)(byArray[n] & 0xFF) << n * 8;
        }
        n = (8 - byArray.length) * 8;
        return l << n >> n;
    }

    public static byte[] encodeSignedIntegralValue(long l) {
        int n = EncodedValueUtils.getRequiredBytesForSignedIntegralValue(l);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)l;
            l >>= 8;
        }
        return byArray;
    }

    public static byte getRequiredBytesForUnsignedIntegralValue(long l) {
        int n = 64 - Long.numberOfLeadingZeros(l);
        if (n == 0) {
            n = 1;
        }
        return (byte)(n + 7 >> 3);
    }

    public static long decodeUnsignedIntegralValue(byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < byArray.length; ++i) {
            l |= (long)(byArray[i] & 0xFF) << i * 8;
        }
        return l;
    }

    public static byte[] encodeUnsignedIntegralValue(long l) {
        int n = EncodedValueUtils.getRequiredBytesForUnsignedIntegralValue(l);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)l;
            l >>= 8;
        }
        return byArray;
    }

    public static int getRequiredBytesForRightZeroExtendedValue(long l) {
        int n = 64 - Long.numberOfTrailingZeros(l);
        if (n == 0) {
            n = 1;
        }
        return n + 7 >> 3;
    }

    public static long decodeRightZeroExtendedValue(byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < byArray.length; ++i) {
            l |= (long)(byArray[i] & 0xFF) << i * 8;
        }
        return l << (8 - byArray.length) * 8;
    }

    public static byte[] encodeRightZeroExtendedValue(long l) {
        int n = EncodedValueUtils.getRequiredBytesForRightZeroExtendedValue(l);
        l >>= 64 - n * 8;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)l;
            l >>= 8;
        }
        return byArray;
    }
}

