/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

import org.jf.dexlib.Util.Hex;

public final class Utf8Utils {
    private static char[] tempBuffer = null;

    public static byte[] stringToUtf8Bytes(String string) {
        int n = string.length();
        byte[] byArray = new byte[n * 3];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '\u0000' && c < '\u0080') {
                byArray[n2] = (byte)c;
                ++n2;
                continue;
            }
            if (c < '\u0800') {
                byArray[n2] = (byte)(c >> 6 & 0x1F | 0xC0);
                byArray[n2 + 1] = (byte)(c & 0x3F | 0x80);
                n2 += 2;
                continue;
            }
            byArray[n2] = (byte)(c >> 12 & 0xF | 0xE0);
            byArray[n2 + 1] = (byte)(c >> 6 & 0x3F | 0x80);
            byArray[n2 + 2] = (byte)(c & 0x3F | 0x80);
            n2 += 3;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public static String utf8BytesToString(byte[] byArray) {
        int n = byArray.length;
        if (tempBuffer == null || tempBuffer.length < n) {
            tempBuffer = new char[n];
        }
        char[] cArray = tempBuffer;
        int n2 = 0;
        int n3 = 0;
        while (n > 0) {
            char c;
            int n4 = byArray[n3] & 0xFF;
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    --n;
                    if (n4 == 0) {
                        return Utf8Utils.throwBadUtf8(n4, n3);
                    }
                    c = (char)n4;
                    ++n3;
                    break;
                }
                case 12: 
                case 13: {
                    if ((n -= 2) < 0) {
                        return Utf8Utils.throwBadUtf8(n4, n3);
                    }
                    int n5 = byArray[n3 + 1] & 0xFF;
                    if ((n5 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(n5, n3 + 1);
                    }
                    int n6 = (n4 & 0x1F) << 6 | n5 & 0x3F;
                    if (n6 != 0 && n6 < 128) {
                        return Utf8Utils.throwBadUtf8(n5, n3 + 1);
                    }
                    c = (char)n6;
                    n3 += 2;
                    break;
                }
                case 14: {
                    if ((n -= 3) < 0) {
                        return Utf8Utils.throwBadUtf8(n4, n3);
                    }
                    int n5 = byArray[n3 + 1] & 0xFF;
                    if ((n5 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(n5, n3 + 1);
                    }
                    int n6 = byArray[n3 + 2] & 0xFF;
                    if ((n5 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(n6, n3 + 2);
                    }
                    int n7 = (n4 & 0xF) << 12 | (n5 & 0x3F) << 6 | n6 & 0x3F;
                    if (n7 < 2048) {
                        return Utf8Utils.throwBadUtf8(n6, n3 + 2);
                    }
                    c = (char)n7;
                    n3 += 3;
                    break;
                }
                default: {
                    return Utf8Utils.throwBadUtf8(n4, n3);
                }
            }
            cArray[n2] = c;
            ++n2;
        }
        return new String(cArray, 0, n2);
    }

    private static String throwBadUtf8(int n, int n2) {
        throw new IllegalArgumentException("bad utf-8 byte " + Hex.u1(n) + " at offset " + Hex.u4(n2));
    }

    /*
     * Unable to fully structure code
     */
    public static String escapeString(String var0) {
        var1_1 = var0.length();
        var2_2 = new StringBuilder(var1_1 * 3 / 2);
        block5: for (var3_3 = 0; var3_3 < var1_1; ++var3_3) {
            var4_4 = var0.charAt(var3_3);
            if (var4_4 >= ' ' && var4_4 < '\u007f') {
                if (var4_4 == '\'' || var4_4 == '\"' || var4_4 == '\\') {
                    var2_2.append('\\');
                }
                var2_2.append(var4_4);
                continue;
            }
            if (var4_4 > '\u007f') ** GOTO lbl-1000
            switch (var4_4) {
                case '\n': {
                    var2_2.append("\\n");
                    continue block5;
                }
                case '\r': {
                    var2_2.append("\\r");
                    continue block5;
                }
                case '\t': {
                    var2_2.append("\\t");
                    continue block5;
                }
                default: lbl-1000:
                // 2 sources

                {
                    var2_2.append("\\u");
                    var2_2.append(Character.forDigit(var4_4 >> 12, 16));
                    var2_2.append(Character.forDigit(var4_4 >> 8 & 15, 16));
                    var2_2.append(Character.forDigit(var4_4 >> 4 & 15, 16));
                    var2_2.append(Character.forDigit(var4_4 & 15, 16));
                }
            }
        }
        return var2_2.toString();
    }
}

