/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1;

import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XmlPullParserFactory {
    static final Class referenceContextClass;
    public static final String PROPERTY_NAME = "org.xmlpull.v1.XmlPullParserFactory";
    private static final String RESOURCE_NAME = "/META-INF/services/org.xmlpull.v1.XmlPullParserFactory";
    protected ArrayList parserClasses;
    protected String classNamesLocation;
    protected ArrayList serializerClasses;
    protected HashMap features = new HashMap();

    protected XmlPullParserFactory() {
    }

    public void setFeature(String string, boolean bl) throws XmlPullParserException {
        this.features.put(string, new Boolean(bl));
    }

    public boolean getFeature(String string) {
        Boolean bl = (Boolean)this.features.get(string);
        return bl != null ? bl : false;
    }

    public void setNamespaceAware(boolean bl) {
        this.features.put("http://xmlpull.org/v1/doc/features.html#process-namespaces", new Boolean(bl));
    }

    public boolean isNamespaceAware() {
        return this.getFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces");
    }

    public void setValidating(boolean bl) {
        this.features.put("http://xmlpull.org/v1/doc/features.html#validation", new Boolean(bl));
    }

    public boolean isValidating() {
        return this.getFeature("http://xmlpull.org/v1/doc/features.html#validation");
    }

    public XmlPullParser newPullParser() throws XmlPullParserException {
        if (this.parserClasses == null) {
            throw new XmlPullParserException("Factory initialization was incomplete - has not tried " + this.classNamesLocation);
        }
        if (this.parserClasses.size() == 0) {
            throw new XmlPullParserException("No valid parser classes found in " + this.classNamesLocation);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.parserClasses.size(); ++i) {
            Class clazz = (Class)this.parserClasses.get(i);
            try {
                XmlPullParser xmlPullParser = (XmlPullParser)clazz.newInstance();
                for (String string : this.features.keySet()) {
                    Boolean bl = (Boolean)this.features.get(string);
                    if (bl == null || !bl.booleanValue()) continue;
                    xmlPullParser.setFeature(string, true);
                }
                return xmlPullParser;
            }
            catch (Exception exception) {
                stringBuffer.append(clazz.getName() + ": " + exception.toString() + "; ");
                continue;
            }
        }
        throw new XmlPullParserException("could not create parser: " + stringBuffer);
    }

    public XmlSerializer newSerializer() throws XmlPullParserException {
        if (this.serializerClasses == null) {
            throw new XmlPullParserException("Factory initialization incomplete - has not tried " + this.classNamesLocation);
        }
        if (this.serializerClasses.size() == 0) {
            throw new XmlPullParserException("No valid serializer classes found in " + this.classNamesLocation);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.serializerClasses.size(); ++i) {
            Class clazz = (Class)this.serializerClasses.get(i);
            try {
                XmlSerializer xmlSerializer = (XmlSerializer)clazz.newInstance();
                return xmlSerializer;
            }
            catch (Exception exception) {
                stringBuffer.append(clazz.getName() + ": " + exception.toString() + "; ");
                continue;
            }
        }
        throw new XmlPullParserException("could not create serializer: " + stringBuffer);
    }

    public static XmlPullParserFactory newInstance() throws XmlPullParserException {
        return XmlPullParserFactory.newInstance(null, null);
    }

    public static XmlPullParserFactory newInstance(String string, Class clazz) throws XmlPullParserException {
        if (clazz == null) {
            clazz = referenceContextClass;
        }
        string = "org.kxml2.io.KXmlParser,org.kxml2.io.KXmlSerializer";
        XmlPullParserFactory xmlPullParserFactory = null;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf(44, n);
            if (n2 == -1) {
                n2 = string.length();
            }
            String string2 = string.substring(n, n2);
            Class<?> clazz2 = null;
            Object var9_9 = null;
            try {
                clazz2 = Class.forName(string2);
                var9_9 = clazz2.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (clazz2 != null) {
                boolean bl = false;
                if (var9_9 instanceof XmlPullParser) {
                    arrayList.add(clazz2);
                    bl = true;
                }
                if (var9_9 instanceof XmlSerializer) {
                    arrayList2.add(clazz2);
                    bl = true;
                }
                if (var9_9 instanceof XmlPullParserFactory) {
                    if (xmlPullParserFactory == null) {
                        xmlPullParserFactory = var9_9;
                    }
                    bl = true;
                }
                if (!bl) {
                    throw new XmlPullParserException("incompatible class: " + string2);
                }
            }
            n = n2 + 1;
        }
        if (xmlPullParserFactory == null) {
            xmlPullParserFactory = new XmlPullParserFactory();
        }
        xmlPullParserFactory.parserClasses = arrayList;
        xmlPullParserFactory.serializerClasses = arrayList2;
        xmlPullParserFactory.classNamesLocation = "org.kxml2.io.kXmlParser,org.kxml2.io.KXmlSerializer";
        return xmlPullParserFactory;
    }

    static {
        XmlPullParserFactory xmlPullParserFactory = new XmlPullParserFactory();
        referenceContextClass = xmlPullParserFactory.getClass();
    }
}

