/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import java.util.logging.Logger;

public class ResConfigFlags {
    public final short mcc;
    public final short mnc;
    public final char[] language;
    public final char[] country;
    public final byte orientation;
    public final byte touchscreen;
    public final short density;
    public final byte keyboard;
    public final byte navigation;
    public final byte inputFlags;
    public final short screenWidth;
    public final short screenHeight;
    public final short sdkVersion;
    public final byte screenLayout;
    public final byte uiMode;
    public final boolean isInvalid;
    private final String mQualifiers;
    private static int sErrCounter = 0;
    private static final Logger LOGGER = Logger.getLogger(ResConfigFlags.class.getName());

    public ResConfigFlags() {
        this.mcc = 0;
        this.mnc = 0;
        this.language = new char[]{'\u0000', '\u0000'};
        this.country = new char[]{'\u0000', '\u0000'};
        this.orientation = 0;
        this.touchscreen = 0;
        this.density = 0;
        this.keyboard = 0;
        this.navigation = 0;
        this.inputFlags = 0;
        this.screenWidth = 0;
        this.screenHeight = 0;
        this.sdkVersion = 0;
        this.screenLayout = 0;
        this.uiMode = 0;
        this.isInvalid = false;
        this.mQualifiers = "";
    }

    public ResConfigFlags(short mcc, short mnc, char[] language, char[] country, byte orientation, byte touchscreen, short density, byte keyboard, byte navigation, byte inputFlags, short screenWidth, short screenHeight, short sdkVersion, byte screenLayout, byte uiMode, boolean isInvalid) {
        if (orientation < 0 || orientation > 3) {
            LOGGER.warning("Invalid orientation value: " + orientation);
            orientation = 0;
            isInvalid = true;
        }
        if (touchscreen < 0 || touchscreen > 3) {
            LOGGER.warning("Invalid touchscreen value: " + touchscreen);
            touchscreen = 0;
            isInvalid = true;
        }
        if (density < -1) {
            LOGGER.warning("Invalid density value: " + density);
            density = 0;
            isInvalid = true;
        }
        if (keyboard < 0 || keyboard > 3) {
            LOGGER.warning("Invalid keyboard value: " + keyboard);
            keyboard = 0;
            isInvalid = true;
        }
        if (navigation < 0 || navigation > 4) {
            LOGGER.warning("Invalid navigation value: " + navigation);
            navigation = 0;
            isInvalid = true;
        }
        this.mcc = mcc;
        this.mnc = mnc;
        this.language = language;
        this.country = country;
        this.orientation = orientation;
        this.touchscreen = touchscreen;
        this.density = density;
        this.keyboard = keyboard;
        this.navigation = navigation;
        this.inputFlags = inputFlags;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.sdkVersion = sdkVersion;
        this.screenLayout = screenLayout;
        this.uiMode = uiMode;
        this.isInvalid = isInvalid;
        this.mQualifiers = this.generateQualifiers();
    }

    public String getQualifiers() {
        return this.mQualifiers;
    }

    private String generateQualifiers() {
        StringBuilder ret = new StringBuilder();
        if (this.mcc != 0) {
            ret.append("-mcc").append(String.format("%03d", this.mcc));
            if (this.mnc != 0) {
                ret.append("-mnc").append(this.mnc);
            }
        }
        if (this.language[0] != '\u0000') {
            ret.append('-').append(this.language);
            if (this.country[0] != '\u0000') {
                ret.append("-r").append(this.country);
            }
        }
        switch (this.screenLayout & 0xF) {
            case 1: {
                ret.append("-small");
                break;
            }
            case 2: {
                ret.append("-normal");
                break;
            }
            case 3: {
                ret.append("-large");
                break;
            }
            case 4: {
                ret.append("-xlarge");
            }
        }
        switch (this.screenLayout & 0x30) {
            case 32: {
                ret.append("-long");
                break;
            }
            case 16: {
                ret.append("-notlong");
            }
        }
        switch (this.orientation) {
            case 1: {
                ret.append("-port");
                break;
            }
            case 2: {
                ret.append("-land");
                break;
            }
            case 3: {
                ret.append("-square");
            }
        }
        switch (this.uiMode & 0xF) {
            case 3: {
                ret.append("-car");
                break;
            }
            case 2: {
                ret.append("-desk");
            }
        }
        switch (this.uiMode & 0x30) {
            case 32: {
                ret.append("-night");
                break;
            }
            case 16: {
                ret.append("-notnight");
            }
        }
        switch (this.density) {
            case 0: {
                break;
            }
            case 120: {
                ret.append("-ldpi");
                break;
            }
            case 160: {
                ret.append("-mdpi");
                break;
            }
            case 240: {
                ret.append("-hdpi");
                break;
            }
            case 320: {
                ret.append("-xhdpi");
                break;
            }
            case -1: {
                ret.append("-nodpi");
                break;
            }
            default: {
                ret.append('-').append(this.density).append("dpi");
            }
        }
        switch (this.touchscreen) {
            case 1: {
                ret.append("-notouch");
                break;
            }
            case 2: {
                ret.append("-stylus");
                break;
            }
            case 3: {
                ret.append("-finger");
            }
        }
        switch (this.inputFlags & 3) {
            case 1: {
                ret.append("-keysexposed");
                break;
            }
            case 2: {
                ret.append("-keyshidden");
                break;
            }
            case 3: {
                ret.append("-keyssoft");
            }
        }
        switch (this.keyboard) {
            case 1: {
                ret.append("-nokeys");
                break;
            }
            case 2: {
                ret.append("-qwerty");
                break;
            }
            case 3: {
                ret.append("-12key");
            }
        }
        switch (this.inputFlags & 0xC) {
            case 4: {
                ret.append("-navexposed");
                break;
            }
            case 8: {
                ret.append("-navhidden");
            }
        }
        switch (this.navigation) {
            case 1: {
                ret.append("-nonav");
                break;
            }
            case 2: {
                ret.append("-dpad");
                break;
            }
            case 3: {
                ret.append("-trackball");
                break;
            }
            case 4: {
                ret.append("-wheel");
            }
        }
        if (this.screenWidth != 0 && this.screenHeight != 0) {
            if (this.screenWidth > this.screenHeight) {
                ret.append(String.format("-%dx%d", this.screenWidth, this.screenHeight));
            } else {
                ret.append(String.format("-%dx%d", this.screenHeight, this.screenWidth));
            }
        }
        if (this.sdkVersion > this.getNaturalSdkVersionRequirement()) {
            ret.append("-v").append(this.sdkVersion);
        }
        if (this.isInvalid) {
            ret.append("-ERR" + sErrCounter++);
        }
        return ret.toString();
    }

    private short getNaturalSdkVersionRequirement() {
        if ((this.uiMode & 0x3F) != 0) {
            return 8;
        }
        if ((this.screenLayout & 0x3F) != 0 || this.density != 0) {
            return 4;
        }
        return 0;
    }

    public String toString() {
        return !this.getQualifiers().equals("") ? this.getQualifiers() : "[DEFAULT]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResConfigFlags other = (ResConfigFlags)obj;
        return this.mQualifiers.equals(other.mQualifiers);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + this.mQualifiers.hashCode();
        return hash;
    }
}

