/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResConfig;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.value.ResValue;

public class ResResource {
    private final ResConfig mConfig;
    private final ResResSpec mResSpec;
    private final ResValue mValue;

    public ResResource(ResConfig config, ResResSpec spec, ResValue value) {
        this.mConfig = config;
        this.mResSpec = spec;
        this.mValue = value;
    }

    public String getFilePath() {
        return this.mResSpec.getType().getName() + this.mConfig.getFlags().getQualifiers() + "/" + this.mResSpec.getName();
    }

    public ResConfig getConfig() {
        return this.mConfig;
    }

    public ResResSpec getResSpec() {
        return this.mResSpec;
    }

    public ResValue getValue() {
        return this.mValue;
    }

    public void replace(ResValue value) throws AndrolibException {
        ResResource res = new ResResource(this.mConfig, this.mResSpec, value);
        this.mConfig.addResource(res, true);
        this.mResSpec.addResource(res, true);
    }

    public String toString() {
        return this.getFilePath();
    }
}

