/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import org.jf.baksmali.Adaptors.EndTryLabelMethodItem;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.ReferenceFormatter;
import org.jf.dexlib.TypeIdItem;
import org.jf.util.IndentingWriter;

public class CatchMethodItem
extends MethodItem {
    private final TypeIdItem exceptionType;
    private final LabelMethodItem tryStartLabel;
    private final LabelMethodItem tryEndLabel;
    private final LabelMethodItem handlerLabel;

    public CatchMethodItem(MethodDefinition.LabelCache labelCache, int codeAddress, TypeIdItem exceptionType, int startAddress, int endAddress, int handlerAddress) {
        super(codeAddress);
        this.exceptionType = exceptionType;
        this.tryStartLabel = labelCache.internLabel(new LabelMethodItem(startAddress, "try_start_"));
        this.tryEndLabel = labelCache.internLabel(new EndTryLabelMethodItem(codeAddress, endAddress));
        this.handlerLabel = exceptionType == null ? labelCache.internLabel(new LabelMethodItem(handlerAddress, "catchall_")) : labelCache.internLabel(new LabelMethodItem(handlerAddress, "catch_"));
    }

    public double getSortOrder() {
        return 102.0;
    }

    public boolean writeTo(IndentingWriter writer) throws IOException {
        if (this.exceptionType == null) {
            writer.write(".catchall");
        } else {
            writer.write(".catch ");
            ReferenceFormatter.writeTypeReference(writer, this.exceptionType);
        }
        writer.write(" {");
        this.tryStartLabel.writeTo(writer);
        writer.write(" .. ");
        this.tryEndLabel.writeTo(writer);
        writer.write("} ");
        this.handlerLabel.writeTo(writer);
        return true;
    }
}

