/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Analysis;

import org.jf.dexlib.Code.Analysis.ValidationException;
import org.jf.dexlib.Code.Opcode;

public class OdexedFieldInstructionMapper {
    private static Opcode[][][][] opcodeMap = new Opcode[][][][]{{{{Opcode.IGET_QUICK, Opcode.IGET_QUICK, Opcode.IGET_QUICK, Opcode.IGET_QUICK, Opcode.IGET_QUICK, Opcode.IGET_WIDE_QUICK, Opcode.IGET_OBJECT_QUICK}, {Opcode.IGET_BOOLEAN, Opcode.IGET_BYTE, Opcode.IGET_SHORT, Opcode.IGET_CHAR, Opcode.IGET, Opcode.IGET_WIDE, Opcode.IGET_OBJECT}}, {{Opcode.IGET_VOLATILE, Opcode.IGET_VOLATILE, Opcode.IGET_VOLATILE, Opcode.IGET_VOLATILE, Opcode.IGET_VOLATILE, Opcode.IGET_WIDE_VOLATILE, Opcode.IGET_OBJECT_VOLATILE}, {Opcode.IGET_BOOLEAN, Opcode.IGET_BYTE, Opcode.IGET_SHORT, Opcode.IGET_CHAR, Opcode.IGET, Opcode.IGET_WIDE, Opcode.IGET_OBJECT}}, {{Opcode.SGET_VOLATILE, Opcode.SGET_VOLATILE, Opcode.SGET_VOLATILE, Opcode.SGET_VOLATILE, Opcode.SGET_VOLATILE, Opcode.SGET_WIDE_VOLATILE, Opcode.SGET_OBJECT_VOLATILE}, {Opcode.SGET_BOOLEAN, Opcode.SGET_BYTE, Opcode.SGET_SHORT, Opcode.SGET_CHAR, Opcode.SGET, Opcode.SGET_WIDE, Opcode.SGET_OBJECT}}}, {{{Opcode.IPUT_QUICK, Opcode.IPUT_QUICK, Opcode.IPUT_QUICK, Opcode.IPUT_QUICK, Opcode.IPUT_QUICK, Opcode.IPUT_WIDE_QUICK, Opcode.IPUT_OBJECT_QUICK}, {Opcode.IPUT_BOOLEAN, Opcode.IPUT_BYTE, Opcode.IPUT_SHORT, Opcode.IPUT_CHAR, Opcode.IPUT, Opcode.IPUT_WIDE, Opcode.IPUT_OBJECT}}, {{Opcode.IPUT_VOLATILE, Opcode.IPUT_VOLATILE, Opcode.IPUT_VOLATILE, Opcode.IPUT_VOLATILE, Opcode.IPUT_VOLATILE, Opcode.IPUT_WIDE_VOLATILE, Opcode.IPUT_OBJECT_VOLATILE}, {Opcode.IPUT_BOOLEAN, Opcode.IPUT_BYTE, Opcode.IPUT_SHORT, Opcode.IPUT_CHAR, Opcode.IPUT, Opcode.IPUT_WIDE, Opcode.IPUT_OBJECT}}, {{Opcode.SPUT_VOLATILE, Opcode.SPUT_VOLATILE, Opcode.SPUT_VOLATILE, Opcode.SPUT_VOLATILE, Opcode.SPUT_VOLATILE, Opcode.SPUT_WIDE_VOLATILE, Opcode.SPUT_OBJECT_VOLATILE}, {Opcode.SPUT_BOOLEAN, Opcode.SPUT_BYTE, Opcode.SPUT_SHORT, Opcode.SPUT_CHAR, Opcode.SPUT, Opcode.SPUT_WIDE, Opcode.SPUT_OBJECT}}}};

    private static int getTypeIndex(char type) {
        switch (type) {
            case 'Z': {
                return 0;
            }
            case 'B': {
                return 1;
            }
            case 'S': {
                return 2;
            }
            case 'C': {
                return 3;
            }
            case 'F': 
            case 'I': {
                return 4;
            }
            case 'D': 
            case 'J': {
                return 5;
            }
            case 'L': 
            case '[': {
                return 6;
            }
        }
        throw new RuntimeException(String.format("Unknown type %s: ", Character.valueOf(type)));
    }

    private static int getOpcodeSubtype(Opcode opcode) {
        if (opcode.isOdexedInstanceQuick()) {
            return 0;
        }
        if (opcode.isOdexedInstanceVolatile()) {
            return 1;
        }
        if (opcode.isOdexedStaticVolatile()) {
            return 2;
        }
        throw new RuntimeException(String.format("Not an odexed field access opcode: %s", opcode.name));
    }

    static Opcode getAndCheckDeodexedOpcodeForOdexedOpcode(String fieldType, Opcode odexedOpcode) {
        int opcodeType = odexedOpcode.setsRegister() ? 0 : 1;
        int opcodeSubType = OdexedFieldInstructionMapper.getOpcodeSubtype(odexedOpcode);
        int typeIndex = OdexedFieldInstructionMapper.getTypeIndex(fieldType.charAt(0));
        Opcode correctOdexedOpcode = opcodeMap[opcodeType][opcodeSubType][0][typeIndex];
        Opcode deodexedOpcode = opcodeMap[opcodeType][opcodeSubType][1][typeIndex];
        if (correctOdexedOpcode != odexedOpcode) {
            throw new ValidationException(String.format("Incorrect field type \"%s\" for %s", fieldType, odexedOpcode.name));
        }
        return deodexedOpcode;
    }
}

