/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

import org.jf.dexlib.Util.AlignmentUtils;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.Utf8Utils;

public class ByteArrayInput
implements Input {
    private byte[] data;
    private int cursor;

    public ByteArrayInput(byte[] data) {
        if (data == null) {
            throw new NullPointerException("data == null");
        }
        this.data = data;
        this.cursor = 0;
    }

    public int getCursor() {
        return this.cursor;
    }

    public void setCursor(int cursor) {
        if (cursor < 0 || cursor >= this.data.length) {
            throw new IndexOutOfBoundsException("The provided cursor value is not within the bounds of this instance's data array");
        }
        this.cursor = cursor;
    }

    public byte readByte() {
        return this.data[this.cursor++];
    }

    public int readShort() {
        int readAt = this.cursor;
        int result = (this.data[readAt++] & 0xFF) + ((this.data[readAt++] & 0xFF) << 8);
        this.cursor = readAt;
        return result;
    }

    public int readInt() {
        int readAt = this.cursor;
        int result = (this.data[readAt++] & 0xFF) + ((this.data[readAt++] & 0xFF) << 8) + ((this.data[readAt++] & 0xFF) << 16) + ((this.data[readAt++] & 0xFF) << 24);
        this.cursor = readAt;
        return result;
    }

    public int readUnsignedOrSignedLeb128() {
        int result;
        int end = this.cursor;
        if ((result = this.data[end++] & 0xFF) > 127) {
            int currentByteValue = this.data[end++] & 0xFF;
            result = result & 0x7F | (currentByteValue & 0x7F) << 7;
            if (currentByteValue > 127) {
                currentByteValue = this.data[end++] & 0xFF;
                result |= (currentByteValue & 0x7F) << 14;
                if (currentByteValue > 127) {
                    currentByteValue = this.data[end++] & 0xFF;
                    result |= (currentByteValue & 0x7F) << 21;
                    if (currentByteValue > 127) {
                        if ((currentByteValue = this.data[end++] & 0xFF) > 15) {
                            ByteArrayInput.throwInvalidLeb();
                        }
                        result |= currentByteValue << 28;
                    }
                }
            }
        } else {
            this.cursor = end;
            return result;
        }
        this.cursor = end;
        if (this.data[end - 1] == 0) {
            return ~result;
        }
        return result;
    }

    public int readUnsignedLeb128() {
        int result;
        int end = this.cursor;
        if ((result = this.data[end++] & 0xFF) > 127) {
            int currentByteValue = this.data[end++] & 0xFF;
            result = result & 0x7F | (currentByteValue & 0x7F) << 7;
            if (currentByteValue > 127) {
                currentByteValue = this.data[end++] & 0xFF;
                result |= (currentByteValue & 0x7F) << 14;
                if (currentByteValue > 127) {
                    currentByteValue = this.data[end++] & 0xFF;
                    result |= (currentByteValue & 0x7F) << 21;
                    if (currentByteValue > 127) {
                        if ((currentByteValue = this.data[end++] & 0xFF) > 15) {
                            ByteArrayInput.throwInvalidLeb();
                        }
                        result |= currentByteValue << 28;
                    }
                }
            }
        }
        this.cursor = end;
        return result;
    }

    public int readSignedLeb128() {
        int result;
        int end = this.cursor;
        if ((result = this.data[end++] & 0xFF) <= 127) {
            result = result << 25 >> 25;
        } else {
            int currentByteValue = this.data[end++] & 0xFF;
            result = result & 0x7F | (currentByteValue & 0x7F) << 7;
            if (currentByteValue <= 127) {
                result = result << 18 >> 18;
            } else {
                currentByteValue = this.data[end++] & 0xFF;
                result |= (currentByteValue & 0x7F) << 14;
                if (currentByteValue <= 127) {
                    result = result << 11 >> 11;
                } else {
                    currentByteValue = this.data[end++] & 0xFF;
                    result |= (currentByteValue & 0x7F) << 21;
                    if (currentByteValue <= 127) {
                        result = result << 4 >> 4;
                    } else {
                        if ((currentByteValue = this.data[end++] & 0xFF) > 15) {
                            ByteArrayInput.throwInvalidLeb();
                        }
                        result |= currentByteValue << 28;
                    }
                }
            }
        }
        this.cursor = end;
        return result;
    }

    public byte[] readBytes(int length) {
        int end = this.cursor + length;
        if (end > this.data.length) {
            ByteArrayInput.throwBounds();
        }
        byte[] result = new byte[length];
        System.arraycopy(this.data, this.cursor, result, 0, length);
        this.cursor = end;
        return result;
    }

    public String realNullTerminatedUtf8String() {
        int startPosition = this.cursor;
        while (this.data[this.cursor] != 0) {
            ++this.cursor;
        }
        int byteCount = this.cursor - startPosition;
        ++this.cursor;
        return Utf8Utils.utf8BytesToString(this.data, startPosition, byteCount);
    }

    public void alignTo(int alignment) {
        this.cursor = AlignmentUtils.alignOffset(this.cursor, alignment);
    }

    private static void throwBounds() {
        throw new IndexOutOfBoundsException("attempt to read past the end");
    }

    private static void throwInvalidLeb() {
        throw new RuntimeException("invalid LEB128 integer encountered");
    }
}

