/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;
import org.yaml.snakeyaml.serializer.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Yaml {
    protected final Resolver resolver;
    private String name;
    protected BaseConstructor constructor;
    protected Representer representer;
    protected DumperOptions options;

    public Yaml() {
        this(new Constructor(), new Representer(), new DumperOptions(), new Resolver());
    }

    public Yaml(DumperOptions options) {
        this(new Constructor(), new Representer(), options);
    }

    public Yaml(BaseConstructor constructor, Representer representer, DumperOptions options) {
        this(constructor, representer, options, new Resolver());
    }

    public Yaml(BaseConstructor constructor, Representer representer, DumperOptions options, Resolver resolver) {
        if (!constructor.isExplicitPropertyUtils()) {
            constructor.setPropertyUtils(representer.getPropertyUtils());
        } else if (!representer.isExplicitPropertyUtils()) {
            representer.setPropertyUtils(constructor.getPropertyUtils());
        }
        this.constructor = constructor;
        representer.setDefaultFlowStyle(options.getDefaultFlowStyle());
        representer.setDefaultScalarStyle(options.getDefaultScalarStyle());
        representer.getPropertyUtils().setAllowReadOnlyProperties(options.isAllowReadOnlyProperties());
        this.representer = representer;
        this.options = options;
        this.resolver = resolver;
        this.name = "Yaml:" + System.identityHashCode(this);
    }

    public void dump(Object data, Writer output) {
        ArrayList<Object> list = new ArrayList<Object>(1);
        list.add(data);
        this.dumpAll(list.iterator(), output);
    }

    public void dumpAll(Iterator<? extends Object> data, Writer output) {
        Serializer s = new Serializer(new Emitter(output, this.options), this.resolver, this.options);
        try {
            s.open();
            while (data.hasNext()) {
                this.representer.represent(s, data.next());
            }
            s.close();
        }
        catch (IOException e) {
            throw new YAMLException(e);
        }
    }

    public Object load(InputStream io) {
        return this.load(new UnicodeReader(io));
    }

    public Object load(Reader io) {
        Composer composer = new Composer(new ParserImpl(new StreamReader(io)), this.resolver);
        this.constructor.setComposer(composer);
        return this.constructor.getSingleData();
    }

    public String toString() {
        return this.name;
    }
}

