/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.track;

import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.track.Track;
import java.util.Locale;

public class AudioTrack
extends Track {
    public static final int UNKNOWN = 0;
    public static final int FRONT_LEFT = 1;
    public static final int FRONT_RIGHT = 2;
    public static final int FRONT_CENTER = 4;
    public static final int REAR_LEFT = 8;
    public static final int REAR_RIGHT = 16;
    public static final int REAR_CENTER = 32;
    private Locale language;
    private int numChannels;
    private int channelMask;
    private float encodedSampleRate;

    public AudioTrack(Locator locator, String string, Track.Encoding encoding, Locale locale, int n, int n2, float f) {
        super(locator, string, encoding);
        if (locale == null) {
            throw new IllegalArgumentException("language == null!");
        }
        if (n < 1) {
            throw new IllegalArgumentException("numChannels < 1!");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("encodedSampleRate <= 0.0");
        }
        this.language = locale;
        this.numChannels = n;
        this.channelMask = n2;
        this.encodedSampleRate = f;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public int getChannelMask() {
        return this.channelMask;
    }

    public float getEncodedSampleRate() {
        return this.encodedSampleRate;
    }

    public Locale getLocale() {
        return this.language;
    }

    public String toString() {
        return "AudioTrack {\n    locator: " + this.getLocator() + "\n" + "    name: " + this.getName() + "\n" + "    encoding: " + (Object)((Object)this.getEncodingType()) + "\n" + "    language: " + this.language + "\n" + "    numChannels: " + this.numChannels + "\n" + "    channelMask: " + this.channelMask + "\n" + "    encodedSampleRate: " + this.encodedSampleRate + "\n" + "}";
    }
}

