<?php
function iis_get_net_version()
{
	//$versions = array("v1.0.3705","v1.1.4322","v2.0.50727","v4.0.30319");
	$versions = array("v2.0.50727","v4.0.30319");
	$net_dir = getenv("windir");
	$net_version = array();
	foreach ($versions as $version) {
		if (file_exists($net_dir."\\Microsoft.NET\\Framework\\".$version)) {
			$net_version[] = $version;
		}
	}
	return $net_version;
}
function iis_update($params)
{
	apicall('nodes','whmCall',array('iis.whm','update_site',array('vh'=>$params['name'])));
}
/**
 * iis模块
* @param array $params
*/
function iis_precreate($params)
{
	$maps = array(array('1,*',3,'0,server:_iis,*',false));
	apicall('vhost','addInfos',array($params['name'],$maps));
	if (!$params['resync']) {
		if ($params['default_index']) {
			$default_indexs = explode(",",$params['default_index']);
			$indexs = array();
			$i = 100;
			foreach($default_indexs as $index){
				$indexs[] = array($index,2,$i++,false);
			}
		} else {
			$indexs = array(
					array('index.htm',2,'100',false),
					array('index.html',2,'101',false),
					array('index.asp',2,'102',false),
					array('default.asp',2,'103',false),
			);
		}
		apicall('vhost','addInfos',array($params['name'],$indexs));
	}
}
function iis_postcreate($params)
{
	return iis_update($params);
}
function iis_destroy($params)
{
	apicall('nodes','whmCall',array('iis.whm','delete_site',array('vh'=>$params['name'])));
}
function iis_link($params)
{
	//$str = "[<a href='?c=index&a=module&op=test'>测试测试</a>]";
	//return $str;
	$net_version = iis_get_net_version();
	if (count($net_version)>1) {
		$value = daocall('vhostinfo','getInfo',array(getRole('vhost'),100,"NET_VERSION"));
		if ($value) {
			$value = $value[0]["value"];
		}
		$str = "<form action='?c=index&a=module&op=net_version' method='POST'>切换.NET版本:<select name=v>";
		foreach ($net_version as $v) {
			$str .= "<option value='".$v."' ";
			if ($value==$v) {
				$str.= "selected";
			}
			$str.=">".$v."</option>";
		}
		$str .= "</select><input value='确定' type='submit'></form>";
	}
	return $str;
}

function iis_cron($params)
{

}
/**
 * 内部调用
 * @param unknown_type $params
 * @return string
 */
function iis_call($params)
{
	if ($_REQUEST["op"]=="net_version") {
		apicall('vhost','addInfo',array(getRole('vhost'),"NET_VERSION",100,$_REQUEST['v'],false));
	}
}
