/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.baidu.mapapi.common.SysOSUtil;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapapi.map.BitmapDescriptorFactory;
import com.baidu.mapapi.map.HeatMap;
import com.baidu.mapapi.map.InfoWindow;
import com.baidu.mapapi.map.MapBaseIndoorMapInfo;
import com.baidu.mapapi.map.MapPoi;
import com.baidu.mapapi.map.MapStatus;
import com.baidu.mapapi.map.MapStatusUpdate;
import com.baidu.mapapi.map.MapStatusUpdateFactory;
import com.baidu.mapapi.map.MapView;
import com.baidu.mapapi.map.MapViewLayoutParams;
import com.baidu.mapapi.map.Marker;
import com.baidu.mapapi.map.MarkerOptions;
import com.baidu.mapapi.map.MyLocationConfiguration;
import com.baidu.mapapi.map.MyLocationData;
import com.baidu.mapapi.map.Overlay;
import com.baidu.mapapi.map.OverlayOptions;
import com.baidu.mapapi.map.Polyline;
import com.baidu.mapapi.map.Projection;
import com.baidu.mapapi.map.TextureMapView;
import com.baidu.mapapi.map.TileOverlay;
import com.baidu.mapapi.map.TileOverlayOptions;
import com.baidu.mapapi.map.UiSettings;
import com.baidu.mapapi.map.WearMapView;
import com.baidu.mapapi.map.a;
import com.baidu.mapapi.map.b;
import com.baidu.mapapi.map.c;
import com.baidu.mapapi.map.d;
import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.model.LatLngBounds;
import com.baidu.mapapi.model.ParcelItem;
import com.baidu.mapapi.model.inner.GeoPoint;
import com.baidu.platform.comapi.map.C;
import com.baidu.platform.comapi.map.D;
import com.baidu.platform.comapi.map.E;
import com.baidu.platform.comapi.map.e;
import com.baidu.platform.comapi.map.h;
import com.baidu.platform.comapi.map.i;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.opengles.GL10;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BaiduMap {
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    public static final int MAP_TYPE_NONE = 3;
    private static final String e = BaiduMap.class.getSimpleName();
    private Projection f;
    private UiSettings g;
    private i h;
    private e i;
    private E j;
    private List<Overlay> k;
    private List<Marker> l;
    private List<Marker> m;
    private Overlay.a n;
    private OnMapStatusChangeListener o;
    private OnMapTouchListener p;
    private OnMapClickListener q;
    private OnMapLoadedCallback r;
    private OnMapDoubleClickListener s;
    private OnMapLongClickListener t;
    private CopyOnWriteArrayList<OnMarkerClickListener> u = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<OnPolylineClickListener> v = new CopyOnWriteArrayList();
    private OnMarkerDragListener w;
    private OnMyLocationClickListener x;
    private SnapshotReadyCallback y;
    private OnMapDrawFrameCallback z;
    private OnBaseIndoorMapListener A;
    private TileOverlay B;
    private HeatMap C;
    private Lock D = new ReentrantLock();
    private Lock E = new ReentrantLock();
    private InfoWindow F;
    private Marker G;
    private View H;
    private Marker I;
    private MyLocationData J;
    private MyLocationConfiguration K;
    MapView a;
    TextureMapView b;
    WearMapView c;
    C d;
    private boolean L;
    private boolean M;
    private boolean N;
    private boolean O;
    private Point P;

    private void c() {
        this.k = new CopyOnWriteArrayList<Overlay>();
        this.l = new CopyOnWriteArrayList<Marker>();
        this.m = new CopyOnWriteArrayList<Marker>();
        int n2 = (int)(40.0f * SysOSUtil.getDensity());
        int n3 = (int)(40.0f * SysOSUtil.getDensity());
        this.P = new Point(n2, n3);
        this.g = new UiSettings(this.i);
        this.n = new a(this);
        b b2 = new b(this);
        this.i.a(b2);
        c c2 = new c(this);
        this.i.a(c2);
        d d2 = new d(this);
        this.i.a(d2);
        this.L = this.i.B();
        this.M = this.i.C();
    }

    BaiduMap(E e2) {
        this.j = e2;
        this.i = this.j.b();
        this.d = com.baidu.platform.comapi.map.C.b;
        this.c();
    }

    BaiduMap(i i2) {
        this.h = i2;
        this.i = this.h.a();
        this.d = com.baidu.platform.comapi.map.C.a;
        this.c();
    }

    public final Overlay addOverlay(OverlayOptions overlayOptions) {
        Marker marker;
        if (overlayOptions == null) {
            return null;
        }
        Overlay overlay = overlayOptions.a();
        overlay.listener = this.n;
        if (overlay instanceof Marker) {
            marker = (Marker)overlay;
            if (marker.n != null && marker.n.size() != 0) {
                this.l.add(marker);
                if (this.i != null) {
                    this.i.b(true);
                }
            }
            this.m.add(marker);
        }
        marker = new Bundle();
        overlay.a((Bundle)marker);
        if (this.i != null) {
            this.i.b((Bundle)marker);
        }
        this.k.add(overlay);
        return overlay;
    }

    public final List<Overlay> addOverlays(List<OverlayOptions> list) {
        Object object;
        if (list == null) {
            return null;
        }
        ArrayList<Overlay> arrayList = new ArrayList<Overlay>();
        Bundle[] bundleArray = new Bundle[list.size()];
        int n2 = 0;
        for (OverlayOptions overlayOptions : list) {
            if (overlayOptions == null) continue;
            object = new Bundle();
            Overlay overlay = overlayOptions.a();
            overlay.listener = this.n;
            if (overlay instanceof Marker) {
                Marker marker = (Marker)overlay;
                if (marker.n != null && marker.n.size() != 0) {
                    this.l.add(marker);
                    if (this.i != null) {
                        this.i.b(true);
                    }
                }
                this.m.add(marker);
            }
            this.k.add(overlay);
            arrayList.add(overlay);
            overlay.a((Bundle)object);
            bundleArray[n2] = object;
            ++n2;
        }
        int n3 = bundleArray.length / 400;
        for (int i2 = 0; i2 < n3 + 1; ++i2) {
            object = new ArrayList();
            for (int i3 = 0; i3 < 400 && i2 * 400 + i3 < bundleArray.length; ++i3) {
                if (bundleArray[i2 * 400 + i3] == null) continue;
                object.add(bundleArray[i2 * 400 + i3]);
            }
            if (this.i == null) continue;
            this.i.a((List<Bundle>)object);
        }
        return arrayList;
    }

    public List<Marker> getMarkersInBounds(LatLngBounds latLngBounds) {
        MapStatus mapStatus = this.getMapStatus();
        if (mapStatus == null) {
            return null;
        }
        ArrayList<Marker> arrayList = new ArrayList<Marker>();
        if (this.m.size() == 0) {
            return null;
        }
        for (Marker marker : this.m) {
            if (!latLngBounds.contains(marker.getPosition())) continue;
            arrayList.add(marker);
        }
        return arrayList;
    }

    public final void clear() {
        this.k.clear();
        this.l.clear();
        this.m.clear();
        if (this.i != null) {
            this.i.b(false);
            this.i.m();
        }
        this.hideInfoWindow();
    }

    public final void setMapStatus(MapStatusUpdate mapStatusUpdate) {
        if (mapStatusUpdate == null) {
            return;
        }
        D d2 = this.a(mapStatusUpdate);
        if (this.i == null) {
            return;
        }
        this.i.a(d2);
        if (this.o != null) {
            this.o.onMapStatusChange(this.getMapStatus());
        }
    }

    public final MapStatus getMapStatus() {
        if (this.i == null) {
            return null;
        }
        D d2 = this.i.D();
        return MapStatus.a(d2);
    }

    public final LatLngBounds getMapStatusLimit() {
        if (this.i == null) {
            return null;
        }
        return this.i.E();
    }

    public final void setMapStatusLimits(LatLngBounds latLngBounds) {
        if (this.i == null) {
            return;
        }
        this.i.a(latLngBounds);
        MapStatusUpdate mapStatusUpdate = MapStatusUpdateFactory.newLatLngBounds(latLngBounds);
        this.setMapStatus(mapStatusUpdate);
    }

    public final void animateMapStatus(MapStatusUpdate mapStatusUpdate, int n2) {
        if (mapStatusUpdate == null || n2 <= 0) {
            return;
        }
        D d2 = this.a(mapStatusUpdate);
        if (this.i == null) {
            return;
        }
        if (!this.O) {
            this.i.a(d2);
        } else {
            this.i.a(d2, n2);
        }
    }

    public final void animateMapStatus(MapStatusUpdate mapStatusUpdate) {
        this.animateMapStatus(mapStatusUpdate, 300);
    }

    private D a(MapStatusUpdate mapStatusUpdate) {
        if (this.i == null) {
            return null;
        }
        D d2 = this.i.D();
        MapStatus mapStatus = mapStatusUpdate.a(this.i, this.getMapStatus());
        D d3 = mapStatus.b(d2);
        return d3;
    }

    public final void setMapType(int n2) {
        if (this.i == null) {
            return;
        }
        switch (n2) {
            case 3: {
                if (this.i.B()) {
                    this.i.q(false);
                }
                if (this.i.C()) {
                    this.i.r(false);
                }
                this.i.d(false);
                this.i.i(false);
                break;
            }
            case 1: {
                this.i.a(false);
                this.i.q(this.L);
                this.i.r(this.M);
                this.i.d(true);
                this.i.i(this.N);
                break;
            }
            case 2: {
                this.i.a(true);
                this.i.q(this.L);
                this.i.r(this.M);
                this.i.d(true);
                break;
            }
        }
        if (this.h != null) {
            this.h.a(n2);
        }
    }

    public final int getMapType() {
        if (this.i == null) {
            return 1;
        }
        if (!this.i.k()) {
            return 3;
        }
        return this.i.j() ? 2 : 1;
    }

    public final float getMaxZoomLevel() {
        if (this.i == null) {
            return 0.0f;
        }
        return this.i.a;
    }

    public final void setMaxAndMinZoomLevel(float f2, float f3) {
        if (f2 > 21.0f) {
            return;
        }
        if (f3 < 3.0f) {
            return;
        }
        if (f2 < f3) {
            return;
        }
        if (this.i != null) {
            this.i.a(f2, f3);
        }
    }

    public final float getMinZoomLevel() {
        if (this.i == null) {
            return 0.0f;
        }
        return this.i.b;
    }

    public final Projection getProjection() {
        return this.f;
    }

    public final UiSettings getUiSettings() {
        return this.g;
    }

    public final void setBuildingsEnabled(boolean bl) {
        if (this.i != null) {
            this.i.g(bl);
        }
    }

    public final boolean isBuildingsEnabled() {
        if (this.i == null) {
            return false;
        }
        return this.i.l();
    }

    public final void setMyLocationEnabled(boolean bl) {
        if (this.i != null) {
            this.i.k(bl);
        }
    }

    public final boolean isMyLocationEnabled() {
        if (this.i == null) {
            return false;
        }
        return this.i.r();
    }

    public final void setMyLocationData(MyLocationData myLocationData) {
        this.J = myLocationData;
        if (this.K == null) {
            this.K = new MyLocationConfiguration(MyLocationConfiguration.LocationMode.NORMAL, false, null);
        }
        this.a(myLocationData, this.K);
    }

    public final MyLocationData getLocationData() {
        return this.J;
    }

    public final void setMyLocationConfigeration(MyLocationConfiguration myLocationConfiguration) {
        this.K = myLocationConfiguration;
        this.a(this.J, this.K);
    }

    public final MyLocationConfiguration getLocationConfigeration() {
        return this.K;
    }

    private final void a(MyLocationData myLocationData, MyLocationConfiguration myLocationConfiguration) {
        Object object;
        Bundle bundle;
        if (myLocationData == null || myLocationConfiguration == null || !this.isMyLocationEnabled()) {
            return;
        }
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        JSONObject jSONObject3 = new JSONObject();
        LatLng latLng = new LatLng(myLocationData.latitude, myLocationData.longitude);
        GeoPoint geoPoint = CoordUtil.ll2mc((LatLng)latLng);
        try {
            jSONObject.put("type", 0);
            jSONObject2.put("ptx", geoPoint.getLongitudeE6());
            jSONObject2.put("pty", geoPoint.getLatitudeE6());
            float f2 = CoordUtil.getMCDistanceByOneLatLngAndRadius((LatLng)latLng, (int)((int)myLocationData.accuracy));
            jSONObject2.put("radius", (double)f2);
            float f3 = myLocationData.direction;
            if (myLocationConfiguration.enableDirection) {
                f3 = myLocationData.direction % 360.0f;
                if (f3 > 180.0f) {
                    f3 -= 360.0f;
                } else if (f3 < -180.0f) {
                    f3 += 360.0f;
                }
            } else {
                f3 = -1.0f;
            }
            jSONObject2.put("direction", (double)f3);
            jSONObject2.put("iconarrownor", (Object)"NormalLocArrow");
            jSONObject2.put("iconarrownorid", 28);
            jSONObject2.put("iconarrowfoc", (Object)"FocusLocArrow");
            jSONObject2.put("iconarrowfocid", 29);
            jSONObject2.put("lineid", myLocationConfiguration.accuracyCircleStrokeColor);
            jSONObject2.put("areaid", myLocationConfiguration.accuracyCircleFillColor);
            jSONArray.put((Object)jSONObject2);
            jSONObject.put("data", (Object)jSONArray);
            if (myLocationConfiguration.locationMode == MyLocationConfiguration.LocationMode.COMPASS) {
                jSONObject3.put("ptx", geoPoint.getLongitudeE6());
                jSONObject3.put("pty", geoPoint.getLatitudeE6());
                jSONObject3.put("radius", 0);
                jSONObject3.put("direction", 0);
                jSONObject3.put("iconarrownor", (Object)"direction_wheel");
                jSONObject3.put("iconarrownorid", 54);
                jSONObject3.put("iconarrowfoc", (Object)"direction_wheel");
                jSONObject3.put("iconarrowfocid", 54);
                jSONArray.put((Object)jSONObject3);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (myLocationConfiguration.customMarker == null) {
            bundle = null;
        } else {
            ArrayList<BitmapDescriptor> arrayList = new ArrayList<BitmapDescriptor>();
            arrayList.add(myLocationConfiguration.customMarker);
            bundle = new Bundle();
            object = new ArrayList();
            for (BitmapDescriptor bitmapDescriptor : arrayList) {
                ParcelItem parcelItem = new ParcelItem();
                Bundle bundle2 = new Bundle();
                Bitmap bitmap = bitmapDescriptor.a;
                ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getWidth() * bitmap.getHeight() * 4);
                bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
                byte[] byArray = byteBuffer.array();
                bundle2.putByteArray("imgdata", byArray);
                bundle2.putInt("imgindex", bitmapDescriptor.hashCode());
                bundle2.putInt("imgH", bitmap.getHeight());
                bundle2.putInt("imgW", bitmap.getWidth());
                parcelItem.setBundle(bundle2);
                ((ArrayList)object).add(parcelItem);
            }
            if (((ArrayList)object).size() > 0) {
                ParcelItem[] parcelItemArray = new ParcelItem[((ArrayList)object).size()];
                for (int i2 = 0; i2 < ((ArrayList)object).size(); ++i2) {
                    parcelItemArray[i2] = (ParcelItem)((ArrayList)object).get(i2);
                }
                bundle.putParcelableArray("icondata", (Parcelable[])parcelItemArray);
            }
        }
        if (this.i != null) {
            this.i.a(jSONObject.toString(), bundle);
        }
        switch (myLocationConfiguration.locationMode) {
            case COMPASS: {
                MapStatus mapStatus = new MapStatus.Builder().rotate(myLocationData.direction).overlook(-45.0f).target(new LatLng(myLocationData.latitude, myLocationData.longitude)).targetScreen(this.getMapStatus().targetScreen).zoom(this.getMapStatus().zoom).build();
                object = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.animateMapStatus((MapStatusUpdate)object);
                break;
            }
            case FOLLOWING: {
                MapStatus mapStatus = new MapStatus.Builder().target(new LatLng(myLocationData.latitude, myLocationData.longitude)).zoom(this.getMapStatus().zoom).rotate(this.getMapStatus().rotate).overlook(this.getMapStatus().overlook).targetScreen(this.getMapStatus().targetScreen).build();
                object = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.animateMapStatus((MapStatusUpdate)object);
                break;
            }
            case NORMAL: {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeatMap(HeatMap heatMap) {
        if (heatMap == null) {
            return;
        }
        this.D.lock();
        try {
            if (heatMap == this.C) {
                return;
            }
            if (this.C != null) {
                this.C.b();
                this.C.c();
                this.C.a = null;
                this.i.n();
            }
            this.C = heatMap;
            this.C.a = this;
            this.i.l(true);
        }
        finally {
            this.D.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(HeatMap heatMap) {
        this.D.lock();
        try {
            if (this.C != null && this.i != null && heatMap == this.C) {
                this.C.b();
                this.C.c();
                this.C.a = null;
                this.i.n();
                this.C = null;
                this.i.l(false);
            }
        }
        finally {
            this.D.unlock();
        }
    }

    void a() {
        if (this.i == null) {
            return;
        }
        this.i.s();
    }

    public final void setBaiduHeatMapEnabled(boolean bl) {
        if (this.i != null) {
            this.i.e(bl);
        }
    }

    public final void setIndoorEnable(boolean bl) {
        if (this.i != null) {
            this.N = bl;
            this.i.i(bl);
        }
        if (this.A != null && !bl) {
            this.A.onBaseIndoorMapMode(false, null);
        }
    }

    public void setCompassPosition(Point point) {
        if (this.i.a(point)) {
            this.P = point;
        }
    }

    public void setCompassIcon(Bitmap bitmap) {
        if (bitmap == null) {
            throw new IllegalArgumentException("compass's icon can not be null");
        }
        this.i.a(bitmap);
    }

    public final Point getCompassPosition() {
        if (this.i != null) {
            String string = this.i.g();
            return this.a(string);
        }
        return null;
    }

    private Point a(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        for (String string2 : string.replaceAll("^\\{", "").replaceAll("\\}$", "").split(",")) {
            String[] stringArray = string2.replaceAll("\"", "").split(":");
            if ("x".equals(stringArray[0])) {
                n2 = Integer.valueOf(stringArray[1]);
            }
            if (!"y".equals(stringArray[0])) continue;
            n3 = Integer.valueOf(stringArray[1]);
        }
        return new Point(n2, n3);
    }

    public final boolean isBaiduHeatMapEnabled() {
        if (this.i == null) {
            return false;
        }
        return this.i.h();
    }

    public final boolean isSupportBaiduHeatMap() {
        if (this.i == null) {
            return false;
        }
        return this.i.i();
    }

    public final void setTrafficEnabled(boolean bl) {
        if (this.i != null) {
            this.i.f(bl);
        }
    }

    public final boolean isTrafficEnabled() {
        if (this.i == null) {
            return false;
        }
        return this.i.f();
    }

    public final void showMapPoi(boolean bl) {
        if (this.i != null) {
            this.i.q(bl);
            this.L = bl;
        }
    }

    public final void showMapIndoorPoi(boolean bl) {
        if (this.i != null) {
            this.i.r(bl);
            this.M = bl;
        }
    }

    @Deprecated
    public final void setPadding(int n2, int n3, int n4, int n5) {
        if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0) {
            return;
        }
        if (this.i == null) {
            return;
        }
        D d2 = this.i.D();
        switch (this.d) {
            case b: {
                if (this.b == null) {
                    return;
                }
                float f2 = (float)(this.b.getWidth() - n2 - n4) / (float)this.b.getWidth();
                float f3 = (float)(this.b.getHeight() - n3 - n5) / (float)this.b.getHeight();
                int n6 = this.b.getWidth() + n2 - n4;
                int n7 = this.b.getHeight() + n3 - n5;
                MapStatus mapStatus = new MapStatus.Builder().targetScreen(new Point(n6 / 2, n7 / 2)).build();
                MapStatusUpdate mapStatusUpdate = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.i.a(new Point((int)((float)n2 + (float)this.P.x * f2), (int)((float)n3 + (float)this.P.y * f3)));
                this.setMapStatus(mapStatusUpdate);
                this.b.setPadding(n2, n3, n4, n5);
                this.b.invalidate();
                break;
            }
            case a: {
                if (this.a == null) {
                    return;
                }
                float f4 = (float)(this.a.getWidth() - n2 - n4) / (float)this.a.getWidth();
                float f5 = (float)(this.a.getHeight() - n3 - n5) / (float)this.a.getHeight();
                int n8 = this.a.getWidth() + n2 - n4;
                int n9 = this.a.getHeight() + n3 - n5;
                MapStatus mapStatus = new MapStatus.Builder().targetScreen(new Point(n8 / 2, n9 / 2)).build();
                MapStatusUpdate mapStatusUpdate = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.i.a(new Point((int)((float)n2 + (float)this.P.x * f4), (int)((float)n3 + (float)this.P.y * f5)));
                this.setMapStatus(mapStatusUpdate);
                this.a.setPadding(n2, n3, n4, n5);
                this.a.invalidate();
                break;
            }
        }
    }

    public final void setViewPadding(int n2, int n3, int n4, int n5) {
        if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0) {
            return;
        }
        if (this.i == null) {
            return;
        }
        switch (this.d) {
            case b: {
                if (this.b == null) {
                    return;
                }
                float f2 = (float)(this.b.getWidth() - n2 - n4) / (float)this.b.getWidth();
                float f3 = (float)(this.b.getHeight() - n3 - n5) / (float)this.b.getHeight();
                this.i.a(new Point((int)((float)n2 + (float)this.P.x * f2), (int)((float)n3 + (float)this.P.y * f3)));
                this.b.setPadding(n2, n3, n4, n5);
                this.b.invalidate();
                break;
            }
            case a: {
                if (this.a == null) {
                    return;
                }
                float f4 = (float)(this.a.getWidth() - n2 - n4) / (float)this.a.getWidth();
                float f5 = (float)(this.a.getHeight() - n3 - n5) / (float)this.a.getHeight();
                this.i.a(new Point((int)((float)n2 + (float)this.P.x * f4), (int)((float)n3 + (float)this.P.y * f5)));
                this.a.setPadding(n2, n3, n4, n5);
                this.a.invalidate();
                break;
            }
        }
    }

    public final void snapshot(SnapshotReadyCallback snapshotReadyCallback) {
        this.y = snapshotReadyCallback;
        switch (this.d) {
            case b: {
                if (this.j == null) break;
                this.j.a("anything", null);
                break;
            }
            case a: {
                if (this.h == null) break;
                this.h.a("anything", null);
                break;
            }
        }
    }

    public final void snapshotScope(Rect rect, SnapshotReadyCallback snapshotReadyCallback) {
        this.y = snapshotReadyCallback;
        switch (this.d) {
            case b: {
                if (this.j == null) break;
                this.j.a("anything", rect);
                break;
            }
            case a: {
                if (this.h == null) break;
                this.h.a("anything", rect);
                break;
            }
        }
    }

    public void showInfoWindow(InfoWindow infoWindow) {
        if (infoWindow != null) {
            Object object;
            Object object2;
            this.hideInfoWindow();
            if (infoWindow.b != null) {
                this.H = infoWindow.b;
                this.H.destroyDrawingCache();
                object2 = new MapViewLayoutParams.Builder();
                object = ((MapViewLayoutParams.Builder)object2).layoutMode(MapViewLayoutParams.ELayoutMode.mapMode).position(infoWindow.c).yOffset(infoWindow.e).build();
                switch (this.d) {
                    case b: {
                        if (this.b == null) break;
                        this.b.addView(this.H, (ViewGroup.LayoutParams)object);
                        break;
                    }
                    case a: {
                        if (this.h == null) break;
                        this.a.addView(this.H, (ViewGroup.LayoutParams)object);
                        break;
                    }
                }
            }
            this.F = infoWindow;
            object2 = infoWindow.b != null ? BitmapDescriptorFactory.fromView(infoWindow.b) : infoWindow.a;
            object = new MarkerOptions().perspective(false).icon((BitmapDescriptor)object2).position(infoWindow.c).zIndex(Integer.MAX_VALUE).a(infoWindow.e);
            Overlay overlay = ((MarkerOptions)object).a();
            overlay.listener = this.n;
            overlay.q = com.baidu.platform.comapi.map.h.b;
            Bundle bundle = new Bundle();
            overlay.a(bundle);
            if (this.i != null) {
                this.i.b(bundle);
            }
            this.k.add(overlay);
            this.G = (Marker)overlay;
        }
    }

    public void hideInfoWindow() {
        if (this.F != null) {
            if (this.F.b != null) {
                switch (this.d) {
                    case b: {
                        if (this.b == null) break;
                        this.b.removeView(this.H);
                        break;
                    }
                    case a: {
                        if (this.h == null) break;
                        this.a.removeView(this.H);
                        break;
                    }
                }
                this.H = null;
            }
            this.F = null;
            this.G.remove();
            this.G = null;
        }
    }

    public final void setOnMapStatusChangeListener(OnMapStatusChangeListener onMapStatusChangeListener) {
        this.o = onMapStatusChangeListener;
    }

    public final void setOnMapTouchListener(OnMapTouchListener onMapTouchListener) {
        this.p = onMapTouchListener;
    }

    public final void setOnMapClickListener(OnMapClickListener onMapClickListener) {
        this.q = onMapClickListener;
    }

    public void setOnMapLoadedCallback(OnMapLoadedCallback onMapLoadedCallback) {
        this.r = onMapLoadedCallback;
    }

    public final void setOnMapDoubleClickListener(OnMapDoubleClickListener onMapDoubleClickListener) {
        this.s = onMapDoubleClickListener;
    }

    public final void setOnMapLongClickListener(OnMapLongClickListener onMapLongClickListener) {
        this.t = onMapLongClickListener;
    }

    public final void setOnPolylineClickListener(OnPolylineClickListener onPolylineClickListener) {
        if (onPolylineClickListener != null) {
            this.v.add(onPolylineClickListener);
        }
    }

    public final void setOnMarkerClickListener(OnMarkerClickListener onMarkerClickListener) {
        if (onMarkerClickListener != null && !this.u.contains(onMarkerClickListener)) {
            this.u.add(onMarkerClickListener);
        }
    }

    public final void setOnMarkerDragListener(OnMarkerDragListener onMarkerDragListener) {
        this.w = onMarkerDragListener;
    }

    public final void setOnMyLocationClickListener(OnMyLocationClickListener onMyLocationClickListener) {
        this.x = onMyLocationClickListener;
    }

    public final void setOnMapDrawFrameCallback(OnMapDrawFrameCallback onMapDrawFrameCallback) {
        this.z = onMapDrawFrameCallback;
    }

    public final void setOnBaseIndoorMapListener(OnBaseIndoorMapListener onBaseIndoorMapListener) {
        this.A = onBaseIndoorMapListener;
    }

    public MapBaseIndoorMapInfo getFocusedBaseIndoorMapInfo() {
        return this.i.o();
    }

    public MapBaseIndoorMapInfo.SwitchFloorError switchBaseIndoorMapFloor(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            return MapBaseIndoorMapInfo.SwitchFloorError.FLOOR_INFO_ERROR;
        }
        MapBaseIndoorMapInfo mapBaseIndoorMapInfo = this.getFocusedBaseIndoorMapInfo();
        if (!string2.equals(mapBaseIndoorMapInfo.a)) {
            return MapBaseIndoorMapInfo.SwitchFloorError.FOCUSED_ID_ERROR;
        }
        ArrayList<String> arrayList = mapBaseIndoorMapInfo.getFloors();
        if (arrayList == null || !arrayList.contains(string)) {
            return MapBaseIndoorMapInfo.SwitchFloorError.FLOOR_OVERLFLOW;
        }
        if (this.i.a(string, string2)) {
            return MapBaseIndoorMapInfo.SwitchFloorError.SWITCH_OK;
        }
        return MapBaseIndoorMapInfo.SwitchFloorError.SWITCH_ERROR;
    }

    public boolean isBaseIndoorMapMode() {
        return this.i.p();
    }

    public final void removeMarkerClickListener(OnMarkerClickListener onMarkerClickListener) {
        if (this.u.contains(onMarkerClickListener)) {
            this.u.remove(onMarkerClickListener);
        }
    }

    public TileOverlay addTileLayer(TileOverlayOptions tileOverlayOptions) {
        if (tileOverlayOptions == null) {
            return null;
        }
        if (this.B != null) {
            this.B.b();
            this.B.a = null;
        }
        if (this.i != null && this.i.a(tileOverlayOptions.a())) {
            TileOverlay tileOverlay;
            this.B = tileOverlay = tileOverlayOptions.a(this);
            return tileOverlay;
        }
        return null;
    }

    boolean b() {
        if (this.i == null) {
            return false;
        }
        return this.i.d();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(TileOverlay tileOverlay) {
        this.E.lock();
        try {
            if (tileOverlay != null && this.B == tileOverlay) {
                tileOverlay.b();
                tileOverlay.a = null;
                tileOverlay = null;
                if (this.i != null) {
                    this.i.c(false);
                }
            }
        }
        finally {
            this.B = null;
            this.E.unlock();
        }
    }

    static /* synthetic */ List a(BaiduMap baiduMap) {
        return baiduMap.k;
    }

    static /* synthetic */ e b(BaiduMap baiduMap) {
        return baiduMap.i;
    }

    static /* synthetic */ List c(BaiduMap baiduMap) {
        return baiduMap.m;
    }

    static /* synthetic */ List d(BaiduMap baiduMap) {
        return baiduMap.l;
    }

    static /* synthetic */ View e(BaiduMap baiduMap) {
        return baiduMap.H;
    }

    static /* synthetic */ OnMapStatusChangeListener f(BaiduMap baiduMap) {
        return baiduMap.o;
    }

    static /* synthetic */ OnMapTouchListener g(BaiduMap baiduMap) {
        return baiduMap.p;
    }

    static /* synthetic */ OnMapClickListener h(BaiduMap baiduMap) {
        return baiduMap.q;
    }

    static /* synthetic */ OnMapDoubleClickListener i(BaiduMap baiduMap) {
        return baiduMap.s;
    }

    static /* synthetic */ OnMapLongClickListener j(BaiduMap baiduMap) {
        return baiduMap.t;
    }

    static /* synthetic */ Projection a(BaiduMap baiduMap, Projection projection) {
        baiduMap.f = projection;
        return baiduMap.f;
    }

    static /* synthetic */ boolean a(BaiduMap baiduMap, boolean bl) {
        baiduMap.O = bl;
        return baiduMap.O;
    }

    static /* synthetic */ OnMapLoadedCallback k(BaiduMap baiduMap) {
        return baiduMap.r;
    }

    static /* synthetic */ SnapshotReadyCallback l(BaiduMap baiduMap) {
        return baiduMap.y;
    }

    static /* synthetic */ OnMyLocationClickListener m(BaiduMap baiduMap) {
        return baiduMap.x;
    }

    static /* synthetic */ InfoWindow n(BaiduMap baiduMap) {
        return baiduMap.F;
    }

    static /* synthetic */ Marker o(BaiduMap baiduMap) {
        return baiduMap.G;
    }

    static /* synthetic */ CopyOnWriteArrayList p(BaiduMap baiduMap) {
        return baiduMap.u;
    }

    static /* synthetic */ CopyOnWriteArrayList q(BaiduMap baiduMap) {
        return baiduMap.v;
    }

    static /* synthetic */ Marker r(BaiduMap baiduMap) {
        return baiduMap.I;
    }

    static /* synthetic */ Projection s(BaiduMap baiduMap) {
        return baiduMap.f;
    }

    static /* synthetic */ OnMarkerDragListener t(BaiduMap baiduMap) {
        return baiduMap.w;
    }

    static /* synthetic */ Marker a(BaiduMap baiduMap, Marker marker) {
        baiduMap.I = marker;
        return baiduMap.I;
    }

    static /* synthetic */ Lock u(BaiduMap baiduMap) {
        return baiduMap.D;
    }

    static /* synthetic */ HeatMap v(BaiduMap baiduMap) {
        return baiduMap.C;
    }

    static /* synthetic */ OnMapDrawFrameCallback w(BaiduMap baiduMap) {
        return baiduMap.z;
    }

    static /* synthetic */ OnBaseIndoorMapListener x(BaiduMap baiduMap) {
        return baiduMap.A;
    }

    static /* synthetic */ Lock y(BaiduMap baiduMap) {
        return baiduMap.E;
    }

    static /* synthetic */ TileOverlay z(BaiduMap baiduMap) {
        return baiduMap.B;
    }

    public static interface OnBaseIndoorMapListener {
        public void onBaseIndoorMapMode(boolean var1, MapBaseIndoorMapInfo var2);
    }

    public static interface OnMapDrawFrameCallback {
        public void onMapDrawFrame(GL10 var1, MapStatus var2);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(Bitmap var1);
    }

    public static interface OnMyLocationClickListener {
        public boolean onMyLocationClick();
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDrag(Marker var1);

        public void onMarkerDragEnd(Marker var1);

        public void onMarkerDragStart(Marker var1);
    }

    public static interface OnPolylineClickListener {
        public boolean onPolylineClick(Polyline var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(LatLng var1);
    }

    public static interface OnMapDoubleClickListener {
        public void onMapDoubleClick(LatLng var1);
    }

    public static interface OnMapLoadedCallback {
        public void onMapLoaded();
    }

    public static interface OnMapClickListener {
        public void onMapClick(LatLng var1);

        public boolean onMapPoiClick(MapPoi var1);
    }

    public static interface OnMapTouchListener {
        public void onTouch(MotionEvent var1);
    }

    public static interface OnMapStatusChangeListener {
        public void onMapStatusChangeStart(MapStatus var1);

        public void onMapStatusChange(MapStatus var1);

        public void onMapStatusChangeFinish(MapStatus var1);
    }
}

