/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.radar;

import android.os.Handler;
import com.baidu.mapapi.BMapManager;
import com.baidu.mapapi.VersionInfo;
import com.baidu.mapapi.common.BaiduMapSDKException;
import com.baidu.mapapi.common.SysOSUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.radar.RadarNearbyInfo;
import com.baidu.mapapi.radar.RadarNearbyResult;
import com.baidu.mapapi.radar.RadarNearbySearchOption;
import com.baidu.mapapi.radar.RadarNearbySearchSortType;
import com.baidu.mapapi.radar.RadarSearchError;
import com.baidu.mapapi.radar.RadarSearchListener;
import com.baidu.mapapi.radar.RadarUploadInfo;
import com.baidu.mapapi.radar.RadarUploadInfoCallback;
import com.baidu.mapapi.radar.a;
import com.baidu.mapapi.radar.b;
import com.baidu.platform.comapi.NativeLoader;
import com.baidu.platform.comapi.radar.c;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RadarSearchManager
implements c {
    private static RadarSearchManager a;
    private static String b;
    private ArrayList<RadarSearchListener> c = new ArrayList();
    private Timer d = new Timer();
    private TimerTask e;
    private boolean f = false;
    private Handler g;
    private RadarUploadInfoCallback h;
    private RadarUploadInfo i;
    private long j;
    private int k = 0;
    private static int l;

    public static RadarSearchManager getInstance() {
        if (a == null) {
            a = new RadarSearchManager();
        }
        return a;
    }

    private RadarSearchManager() {
        BMapManager.init();
        com.baidu.platform.comapi.radar.a.a().a(this);
    }

    public void setUserID(String string) {
        if (a == null) {
            return;
        }
        b = string != null && !string.equals("") ? string : SysOSUtil.getDeviceID();
        this.i = null;
    }

    public void clearUserInfo() {
        if (a == null) {
            return;
        }
        if (b != null && !b.equals("")) {
            com.baidu.platform.comapi.radar.a.a().a(b);
        }
    }

    public boolean nearbyInfoRequest(RadarNearbySearchOption radarNearbySearchOption) {
        int n;
        int n2;
        if (a == null) {
            return false;
        }
        if (radarNearbySearchOption == null) {
            return false;
        }
        if (radarNearbySearchOption.e == RadarNearbySearchSortType.distance_from_far_to_near || radarNearbySearchOption.e == RadarNearbySearchSortType.distance_from_near_to_far) {
            n2 = 0;
            n = radarNearbySearchOption.e == RadarNearbySearchSortType.distance_from_far_to_near ? 1 : 0;
        } else {
            n2 = 1;
            n = radarNearbySearchOption.e == RadarNearbySearchSortType.time_from_past_to_recent ? 1 : 0;
        }
        if (radarNearbySearchOption.c == null && this.i == null || b.equals("")) {
            return false;
        }
        LatLng latLng = null;
        if (radarNearbySearchOption.c == null) {
            if (this.i.pt == null) {
                return false;
            }
            latLng = this.i.pt;
        } else {
            latLng = radarNearbySearchOption.c;
        }
        String string = "";
        if (radarNearbySearchOption.f != null && radarNearbySearchOption.g != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(radarNearbySearchOption.f);
            long l = calendar.getTimeInMillis();
            calendar.setTime(radarNearbySearchOption.g);
            long l2 = calendar.getTimeInMillis();
            if (l >= l2) {
                return false;
            }
            string = String.valueOf(l / 1000L) + "," + String.valueOf(l2 / 1000L);
        }
        l = radarNearbySearchOption.d;
        this.k = radarNearbySearchOption.b;
        return com.baidu.platform.comapi.radar.a.a().a(b, latLng, radarNearbySearchOption.a, radarNearbySearchOption.b, radarNearbySearchOption.d, n2, n, string);
    }

    public void startUploadAuto(RadarUploadInfoCallback radarUploadInfoCallback, int n) {
        if (a == null) {
            return;
        }
        if (n < 5000) {
            return;
        }
        if (radarUploadInfoCallback == null) {
            return;
        }
        if (this.f) {
            return;
        }
        this.f = true;
        this.h = radarUploadInfoCallback;
        this.g = new a(this);
        this.e = new b(this);
        this.d.schedule(this.e, 1000L, (long)n);
    }

    public void stopUploadAuto() {
        if (a == null) {
            return;
        }
        if (!this.f) {
            return;
        }
        this.f = false;
        this.h = null;
        this.e.cancel();
        this.g = null;
    }

    public void addNearbyInfoListener(RadarSearchListener radarSearchListener) {
        if (a == null) {
            return;
        }
        if (radarSearchListener != null) {
            this.c.add(radarSearchListener);
        }
    }

    public void removeNearbyInfoListener(RadarSearchListener radarSearchListener) {
        if (a == null) {
            return;
        }
        if (this.c.contains(radarSearchListener)) {
            this.c.remove(radarSearchListener);
        }
    }

    public boolean uploadInfoRequest(RadarUploadInfo radarUploadInfo) {
        if (a == null) {
            return false;
        }
        return this.a(radarUploadInfo);
    }

    private boolean a(RadarUploadInfo radarUploadInfo) {
        if (radarUploadInfo == null || b == null || b.equals("")) {
            return false;
        }
        if (System.currentTimeMillis() - this.j < 5000L) {
            return false;
        }
        this.i = radarUploadInfo;
        this.j = System.currentTimeMillis();
        return com.baidu.platform.comapi.radar.a.a().a(b, radarUploadInfo.pt, radarUploadInfo.comments);
    }

    public void destroy() {
        if (a != null) {
            if (this.f) {
                this.stopUploadAuto();
                this.d.cancel();
            }
            com.baidu.platform.comapi.radar.a.a().b();
            com.baidu.platform.comapi.radar.a.a().d();
            BMapManager.destroy();
            a = null;
        }
    }

    private RadarNearbyResult a(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        RadarNearbyResult radarNearbyResult = new RadarNearbyResult();
        try {
            JSONArray jSONArray;
            int n;
            int n2;
            JSONObject jSONObject = new JSONObject(string);
            radarNearbyResult.totalNum = n2 = jSONObject.optInt("total");
            int n3 = jSONObject.optInt("count");
            radarNearbyResult.pageNum = n = n2 / l + (n2 % l > 0 ? 1 : 0);
            radarNearbyResult.pageIndex = this.k;
            if (n3 > 0 && (jSONArray = jSONObject.optJSONArray("contents")) != null) {
                ArrayList<RadarNearbyInfo> arrayList = new ArrayList<RadarNearbyInfo>();
                for (int i = 0; i < jSONArray.length(); ++i) {
                    RadarNearbyInfo radarNearbyInfo = new RadarNearbyInfo();
                    JSONObject jSONObject2 = jSONArray.optJSONObject(i);
                    if (jSONObject2 == null) continue;
                    radarNearbyInfo.userID = jSONObject2.optString("uid");
                    radarNearbyInfo.pt = new LatLng(jSONObject2.optDouble("locy"), jSONObject2.optDouble("locx"));
                    radarNearbyInfo.distance = jSONObject2.optInt("distance");
                    radarNearbyInfo.mobileName = jSONObject2.optString("mb");
                    radarNearbyInfo.mobileOS = jSONObject2.optString("os");
                    radarNearbyInfo.comments = jSONObject2.optString("comments");
                    long l = (long)jSONObject2.optDouble("time");
                    radarNearbyInfo.timeStamp = new Date(l * 1000L);
                    arrayList.add(radarNearbyInfo);
                }
                radarNearbyResult.infoList = arrayList;
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return radarNearbyResult;
    }

    private RadarSearchError a(int n) {
        RadarSearchError radarSearchError = RadarSearchError.RADAR_NO_ERROR;
        switch (n) {
            case 0: {
                radarSearchError = RadarSearchError.RADAR_NO_ERROR;
                break;
            }
            case 500: 
            case 504: {
                radarSearchError = RadarSearchError.RADAR_AK_ERROR;
                break;
            }
            case 507: {
                radarSearchError = RadarSearchError.RADAR_USERID_NOT_EXIST;
                break;
            }
            case 503: {
                radarSearchError = RadarSearchError.RADAR_FORBID_BY_ADMIN;
                break;
            }
            case 502: {
                radarSearchError = RadarSearchError.RADAR_FORBID_BY_USER;
                break;
            }
            case 506: {
                radarSearchError = RadarSearchError.RADAR_AK_NOT_BIND;
                break;
            }
            case 2: 
            case 404: {
                radarSearchError = RadarSearchError.RADAR_NETWORK_ERROR;
                break;
            }
            case 8: {
                radarSearchError = RadarSearchError.RADAR_NETWORK_TIMEOUT;
                break;
            }
            case 508: {
                radarSearchError = RadarSearchError.RADAR_PERMISSION_UNFINISHED;
                break;
            }
            default: {
                radarSearchError = RadarSearchError.RADAR_NO_RESULT;
            }
        }
        return radarSearchError;
    }

    @Override
    public void onGetNearByResult(String string, int n) {
        if (this.c == null || this.c.size() == 0) {
            return;
        }
        RadarSearchError radarSearchError = this.a(n);
        if (radarSearchError != RadarSearchError.RADAR_NO_ERROR) {
            for (RadarSearchListener radarSearchListener : this.c) {
                radarSearchListener.onGetNearbyInfoList(null, radarSearchError);
            }
        } else {
            RadarNearbyResult radarNearbyResult = this.a(string);
            if (radarNearbyResult != null && radarNearbyResult.infoList != null && radarNearbyResult.infoList.size() > 0) {
                for (RadarSearchListener radarSearchListener : this.c) {
                    radarSearchListener.onGetNearbyInfoList(radarNearbyResult, radarSearchError);
                }
            } else {
                for (RadarSearchListener radarSearchListener : this.c) {
                    radarSearchListener.onGetNearbyInfoList(radarNearbyResult, RadarSearchError.RADAR_NO_RESULT);
                }
            }
        }
    }

    @Override
    public void onGetUploadResult(int n) {
        RadarSearchError radarSearchError = this.a(n);
        if (this.c != null && this.c.size() > 0) {
            for (RadarSearchListener radarSearchListener : this.c) {
                radarSearchListener.onGetUploadState(radarSearchError);
            }
        }
    }

    @Override
    public void onGetClearInfoResult(int n) {
        RadarSearchError radarSearchError = this.a(n);
        if (this.c != null && this.c.size() > 0) {
            for (RadarSearchListener radarSearchListener : this.c) {
                radarSearchListener.onGetClearInfoState(radarSearchError);
            }
        }
    }

    static /* synthetic */ RadarSearchManager a() {
        return a;
    }

    static /* synthetic */ RadarUploadInfoCallback a(RadarSearchManager radarSearchManager) {
        return radarSearchManager.h;
    }

    static /* synthetic */ RadarUploadInfo a(RadarSearchManager radarSearchManager, RadarUploadInfo radarUploadInfo) {
        radarSearchManager.i = radarUploadInfo;
        return radarSearchManager.i;
    }

    static /* synthetic */ boolean b(RadarSearchManager radarSearchManager, RadarUploadInfo radarUploadInfo) {
        return radarSearchManager.a(radarUploadInfo);
    }

    static /* synthetic */ Handler b(RadarSearchManager radarSearchManager) {
        return radarSearchManager.g;
    }

    static {
        b = "";
        l = 10;
        if (!VersionInfo.getApiVersion().equals(com.baidu.mapapi.radar.VersionInfo.getApiVersion())) {
            throw new BaiduMapSDKException("the version of radar is not match with base");
        }
        NativeLoader.getInstance().loadLibrary(com.baidu.mapapi.radar.VersionInfo.getKitName());
    }
}

