/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.utils;

import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.model.inner.GeoPoint;
import com.baidu.mapapi.utils.DistanceUtil;
import java.util.List;

public class SpatialRelationUtil {
    public static boolean isPolygonContainsPoint(List<LatLng> list, LatLng latLng) {
        int n;
        if (list == null || list.size() == 0 || latLng == null) {
            return false;
        }
        for (n = 0; n < list.size(); ++n) {
            if (latLng.longitude != list.get((int)n).longitude || latLng.latitude != list.get((int)n).latitude) continue;
            return true;
        }
        n = 0;
        int n2 = 0;
        LatLng latLng2 = null;
        LatLng latLng3 = null;
        double d2 = 0.0;
        int n3 = list.size();
        for (n2 = 0; n2 < n3; ++n2) {
            latLng2 = list.get(n2);
            latLng3 = list.get((n2 + 1) % n3);
            if (latLng2.latitude == latLng3.latitude || latLng.latitude < Math.min(latLng2.latitude, latLng3.latitude) || latLng.latitude > Math.max(latLng2.latitude, latLng3.latitude)) continue;
            d2 = (latLng.latitude - latLng2.latitude) * (latLng3.longitude - latLng2.longitude) / (latLng3.latitude - latLng2.latitude) + latLng2.longitude;
            if (d2 == latLng.longitude) {
                return true;
            }
            if (!(d2 < latLng.longitude)) continue;
            ++n;
        }
        return n % 2 == 1;
    }

    public static boolean isCircleContainsPoint(LatLng latLng, int n, LatLng latLng2) {
        if (latLng == null || n == 0 || latLng2 == null) {
            return false;
        }
        double d2 = DistanceUtil.getDistance(latLng, latLng2);
        if (d2 > (double)n) {
            return false;
        }
        if (d2 == (double)n) {
            return true;
        }
        return true;
    }

    public static LatLng getNearestPointFromLine(List<LatLng> list, LatLng latLng) {
        if (list == null || list.size() == 0 || latLng == null) {
            return null;
        }
        LatLng latLng2 = null;
        for (int i = 0; i < list.size() - 1; ++i) {
            LatLng latLng3;
            LatLng latLng4 = SpatialRelationUtil.a(list.get(i), list.get(i + 1), latLng);
            if ((latLng4.latitude - list.get((int)i).latitude) * (latLng4.latitude - list.get((int)(i + 1)).latitude) <= 0.0 && (latLng4.longitude - list.get((int)i).longitude) * (latLng4.longitude - list.get((int)(i + 1)).longitude) <= 0.0) {
                latLng3 = latLng4;
            } else {
                LatLng latLng5 = latLng3 = DistanceUtil.getDistance(latLng, list.get(i)) < DistanceUtil.getDistance(latLng, list.get(i + 1)) ? list.get(i) : list.get(i + 1);
            }
            latLng2 = latLng2 != null ? (DistanceUtil.getDistance(latLng, latLng3) < DistanceUtil.getDistance(latLng, latLng2) ? latLng3 : latLng2) : latLng3;
        }
        return latLng2;
    }

    private static LatLng a(LatLng latLng, LatLng latLng2, LatLng latLng3) {
        GeoPoint geoPoint = CoordUtil.ll2mc((LatLng)latLng);
        GeoPoint geoPoint2 = CoordUtil.ll2mc((LatLng)latLng2);
        GeoPoint geoPoint3 = CoordUtil.ll2mc((LatLng)latLng3);
        double d2 = Math.sqrt((geoPoint.getLongitudeE6() - geoPoint.getLongitudeE6()) * (geoPoint2.getLongitudeE6() - geoPoint.getLongitudeE6()) + (geoPoint2.getLatitudeE6() - geoPoint.getLatitudeE6()) * (geoPoint2.getLatitudeE6() - geoPoint.getLatitudeE6()));
        double d3 = (geoPoint2.getLongitudeE6() - geoPoint.getLongitudeE6()) * (geoPoint3.getLongitudeE6() - geoPoint.getLongitudeE6()) + (geoPoint2.getLatitudeE6() - geoPoint.getLatitudeE6()) * (geoPoint3.getLatitudeE6() - geoPoint.getLatitudeE6());
        d2 = d3 / (d2 * d2);
        double d4 = geoPoint.getLongitudeE6() + (geoPoint2.getLongitudeE6() - geoPoint.getLongitudeE6()) * d2;
        double d5 = geoPoint.getLatitudeE6() + (geoPoint2.getLatitudeE6() - geoPoint.getLatitudeE6()) * d2;
        return CoordUtil.mc2ll((GeoPoint)new GeoPoint(d5, d4));
    }
}

