window.onload = function () {
    skin.initSkin();

    skin.initWebFaceBox([], true);
    skin.g('moreFace').setAttribute('link', config.openUrl.moreFace);
    window.setTimeout(function () {
        skin.getWebFace();
    }, 1000);

    document.domain = 'image.baidu.com';
};
/**
 * @author v_wangyan
 * @date 2012-11-05
 */ 
var skin = window.skin || {};
// 初始化图形索引
var iIndex = 0;
var imgIndex = 0;
var fixIndex = 0;
var wIndex = 0;

var webLoad = {};
var page = {
    num: 7,
    w: 38
};
var feelId = 1;
var currentIndex = 0;
var feelTabCurrent = 0;     // 记录当前心情高亮标签
var checkList = {};         // 记录更新过的表情组
var addCount = 0;           // 记录正在添加的表情组数目
var isAddEmotion = false;   // 记录初始化是否完成
/**
 * 获取元素对象
 * @param  {string} element 元素id
 * @return {object}         返回元素对象
 */
skin.g = function(element) {
    return document.getElementById(element) || element;
},
/**
 * 转换JSON对象
 * @param  {string} jsonString json字符串
 * @return {object}            json对象
 */
skin.jsonDecode =function(jsonString) {
	return (new Function("return " + jsonString))();
},
/**
 * 显示dom
 * @param  {string} id dom的id
 * @return {void}    无
 */

skin.show = function(id) {
	skin.isShow(id, true);
},
/**
 * 隐藏dom
 * @param  {string} id dom的id
 * @return {void}    无
 */
skin.hide = function(id) {
    skin.isShow(id, false);
},
/**
 * 是否显示
 * @return {bool} 返回布尔值
 */
skin.isShow = function(id, flag) {
    skin.g(id).style.display = flag ? 'block' : 'none';
},
/**
 * 添加样式
 * @param {string|object} element   目标元素
 * @param {string} className 样式名称
 */
skin.addClass = function(element, className) { 
	element = skin.g(element)||element;
    var classArray = className.split(/\s+/),
        result = element.className,
        classMatch = " " + result + " ",
        i = 0,
        l = classArray.length;

    for (; i < l; i++) {
         if ( classMatch.indexOf( " " + classArray[i] + " " ) < 0 ) {
             result += (result ? ' ' : '') + classArray[i];
         }
    }

    element.className = result;
},
/**
 * 移除样式
 * @param  {string|object} element   目标元素
 * @param  {string} className 样式名称
 * @return {void}           无
 */
skin.removeClass = function(element, className) { 
	element = skin.g(element)||element; 

    var oldClasses = element.className.split(/\s+/),
        newClasses = className.split(/\s+/),
        lenOld,
        lenDel = newClasses.length,
        j,
        i = 0;  
    for (; i < lenDel; ++i) {
        for(j = 0, lenOld = oldClasses.length; j < lenOld; ++j) {
            if (oldClasses[j] == newClasses[i]) {
            	oldClasses.splice(j, 1);
            	break;
            }
        }
    }
    element.className = oldClasses.join(' ');
},
/**
 * 设置字体
 * @param {int}   
 * @return void
 */
skin.setFontFamily = function (key) {   //设置字体:  0-宋体 ; 1-微软雅黑;
    key = key || '0';
    var obj = document.body;
    var font = ''; 
    if (key) {
        font = '"微软雅黑", "宋体", Arial, Verdana';
    } else {
        font = '"宋体", "微软雅黑", Arial, Verdana';
    }
    obj.style.fontFamily = font;
}
/**
 * 设置页面显示的字体(win7--雅黑字,其他为宋体)
 * @param 无
 * @return string
 */
skin.getSysver = function () {
    var key = 0;
    try {
        key = execOrder('sysver');
        if ('6.1' == key) {
            key = 1;
        }
    } catch (e) {   }   
    
    skin.setFontFamily(key); 
}
/**
 * 处理icon点击
 * @param  {event} e            事件
 * @param  {bool} rightClick    是否为右键(点击)
 * @param  {number} key         iconid
 * @return {void}               无
 */
skin.execMouseDown = function (e, rightClick, key) {
    //取消冒泡事件
    e.stopPropagation(); 
    
    var order = rightClick ? 'mouseRDown' : 'mouseLDown';
    try {
        window.external.SyncRequest(order, key);
    } catch (e) {}  
},
/**
 * 处理右键点击
 * @param  {string} id elementid
 * @return {void}    无
 */
skin.rightButton = function (id) {
    if (event.button == 2) {
       skin.execMouseDown(event, true, id);
    }
},
/**
 * 执行命令
 * @param {string} 命令名称
 * @param {string} 值
 * @return string | void
 */
skin.execOrder = function (order, key) { 
    var info = '';
    try { 
        key = (!key ? '0' : key); 
        info = window.external.SyncRequest(order, key);
    } catch (e) {       
    } 
    return info;
},
/**
 * 执行客户端命令,获取参数
 * @param  {string} order 命令名称
 * @param  {string} param 参数
 * @return {void|object}       无|-
 */
skin.execSync = function (order, param) {
    try {
        if (window.external.SyncRequest) {
            return window.external.SyncRequest(order, param);
        } 
    } catch (e) {
        return '';
    }
    return '';
},
/**
 * 设置本地存储--(使用)获取到对应参数值,进行赋值后重新存储该值
 * @type {Object}
 */
skin.storage = {
    set: function (key, value) {
        this.data(key, value);
    },
    get: function (key) {  
        return this.data(key);
    },
    /**
     * 处理存储数据
     * @param  {string} key   存储(获取的)key
     * @param  {[type]} value 存储的值
     * @return {boolea | object}       操作结果
     */
    data: function (key, value) { 
        var configData = skin.execSync('readConfig') || '{}'; 
        if (typeof configData  == 'string') {
            configData = JSON.parse(configData);
        }         
        if (value) {     
            configData[key] = value;
            skin.execSync('saveConfig', JSON.stringify(configData));            
            return true;
        } else {                                 
            return (key ? (configData[key] || false) : configData);
        }
        return false;
    }
},
//获取RD数据status,null 时返回当前状态
/**
 * 设置icon状态
 * @param  {string} id  icon的id
 * @param  {string} key 命令
 * @return {void}     无
 */
skin.getExecStatus = function (id, key) {  
    if (typeof skin.g(id) == 'string') {
        return;
    }
    var statu = skin.execSync('getButtonState', key) || skin.g(id).getAttribute('statu'); 
    return statu;
},
/**
 * 初始输入法状态  
 * 参数:0 (中英文切换) 返回值: 0 英文 1 中文;
 * 参数:1 (全半角切换) 返回值: 0 半角 1 全角; 
 * 参数:2 (中英文标点) 返回值: 0 英文标点 1 中文标点;
 * 参数:3 (软键盘)
 * 参数:4 (登录)            返回值: 0 未登录 1 已登录
 * 参数:5 (配置)
 */
skin.setIMEStatus = function () { 
    setButtonState('0', skin.getExecStatus('language', '0'));    
    setButtonState('1', skin.getExecStatus('characters', '1'));
    setButtonState('2', skin.getExecStatus('punctuation', '1'));  
},
/**
 * 绑定输入法icon点击/hover等事件
 * @return {void} 无
 */
skin.bindEvent = function () {
    var icons = skin.g('box').getElementsByTagName('p'); 
    for (var i = 0, len = icons.length; i < len; i++) {   
        icons[i].onclick = function () { 
            skin.execMouseDown(event, false, this.getAttribute('key'));
        }
        icons[i].onmouseup = function () { 
            skin.rightButton(this.getAttribute('key'));          
        }
        icons[i].onmouseover = function () { 
            skin.execOrder('mouseOver', this.getAttribute('key'));
        }
        icons[i].onmouseout = function () { 
            skin.execOrder('mouseOver', 'null');            
        }
    }
    document.onclick  =function () {
        skin.execMouseDown(event, false, 'null');    
    }
    
    document.onmouseup =function () {  
        skin.rightButton('null'); 
    }
},
/**
 * 打开链接
 * @newDom  {object} newDom 新元素
 * @dom {object} dom 指定元素
 */
skin.insertAfter = function (newDom, dom) {
    var parent = dom.parentElement;
    if (parent.lastChild == dom) { 
        parent.appendChild(newDom);
    } else { 
        parent.insertBefore(newDom, dom.nextSibling);
    }
},
/**
 * 处理各种映射事件
 */
skin.proccessEvent = function () {
    document.body.onmouseup = function (e) {
        var element = e.target;
        var eventType = '';
        skin.g('navRBtn').style.display = 'none';
        skin.g('faceRBtn').style.display = 'none';
        skin.g('importItems').style.display = 'none';
        
        if (e.button == 0) { 
            eventType = element.getAttribute('event-type');
            var fnName = config.eventMap[eventType];  
            if (typeof window.skin[fnName] == 'function') { 
                window.skin[fnName](element, eventType);
            }
        }
        if (e.button == 2) { 
            eventType = element.getAttribute('right-btn');
            var fnName = config.rightBtn[eventType];  
            if (typeof window.skin[fnName] == 'function') {
                window.skin[fnName]({element: element, eventType: eventType, e: e});
                return false;
            }
        }
        
        if (eventType != 'nav' && eventType != 'navImg') {
            skin.g('navRBtn').style.display = 'none';
        } 
        if (eventType != 'face' || (eventType == 'face' && e.button != 2)) { 
            skin.g('faceRBtn').style.display = 'none';
        } 
        if (eventType != 'importFace') {
            skin.g('importItems').style.display = 'none';
        }
    }
    document.body.onmouseover = function (e) {
        var element = e.target;
        var eventType = '';
        eventType = element.getAttribute('hover');
        var fnName = config.hoverMap[eventType];  
        if (typeof window.skin[fnName] == 'function') {
            window.skin[fnName]({element: element, eventType: eventType, e: e, isHover: true});
            return false;
        }
    }
    document.body.onmouseout = function (e) {
        var element = e.target;
        var eventType = '';
        eventType = element.getAttribute('hover');
        var fnName = config.hoverMap[eventType];  
        if (typeof window.skin[fnName] == 'function') {
            window.skin[fnName]({element: element, eventType: eventType, e: e, isHover: false});
            return false;
        }
    }
},
/**
 * 表情hover
 * @param  {object} opts 参数
 */
skin.proccessFeceHover = function (opts) { 
    var titObj = skin.g('faceTitle');
    if (opts.isHover) {
        opts.element = opts.eventType == 'faceImg' ? opts.element.parentElement.parentElement : opts.element;
        var title = opts.element.parentElement.getElementsByTagName('span')[0].innerHTML;
        titObj.innerHTML = title;
        titObj.style.left = opts.e.x + 'px';
        titObj.style.top = opts.e.y + 'px';
        titObj.style.display = 'block';
    } else {
        titObj.style.display = 'none';
    }    
},
/**
 * 切换表情组
 * @param  {object} element 触发元素
 * @param  {string} eventType 触发类型
 */
skin.proccessChangeTab = function (element, eventType) {  
    element = eventType == 'tab' ? element : element.parentElement.parentElement; 
    var tabParent = skin.g(element.getAttribute('parentId')); 
    var tabs = tabParent.getElementsByTagName('nav');
    // 切换表情组tab
    var index = -1;
    var len = tabs.length;
    var isAddWebTab = false;
    var GID = element.getAttribute('gid');
    for (var i = 0; i < len; i++) {
        if (element == tabs[i]) {
            index =  i;
        }
        if (i == len - 1 && tabs[i].className.indexOf('current') > 0) {
            isAddWebTab = true;
        }
        skin.removeClass(tabs[i], 'current');
    }    
    if (typeof checkList[GID] == 'undefined') {
        checkList[GID] = 1;
        skin.execOrder('getgroup', GID); 
    }
    skin.addClass(element, 'current');  
    currentIndex = index;
    // 点击'心情'分组上报（20131115）
    if (GID == 'Emotion') {
        skin.execOrder('report', 'clickEmotion'); 
    }
    // 点击'添加网络表情'上报
    if (index == len - 1 && !isAddWebTab) { 
        skin.execOrder('clickMore');
    }
    // 切换表情组
    var emotions = skin.g('faceBox').getElementsByTagName('section');
    var k = -1;
    for (var j = 0, eLen = emotions.length; j < eLen; j++) {         
        // k++ ;
        if (index == j) { 
            k = j;
            // emotions[j].style.display = 'block';
        } else {
            // emotions[j].style.display = 'none';
        }               
    }
    skin.g('faceBox').style.marginTop = -1 * k * config.faceBoxH + 'px';
    skin.g('mask').style.display = (k == feelId || k == len - 1) ? 'none' : 'block';
},
/**
 * 切换心情分组
 * @param  {object} element 触发元素
 * @param  {string} eventType 触发类型
 */
skin.changeFeelTabs = function (element, eventType) {
    var items = skin.g('feelBox');
    var nomalTabs = element.parentElement.getElementsByTagName('li');
    var index = -1;
    for (var i = 0, len = nomalTabs.length; i < len; i++) {
        skin.removeClass(nomalTabs[i], 'current');
        if (nomalTabs[i] == element) {
            items.style.marginTop =  -1 * i * config.feelBoxH + 'px';
            skin.addClass(element, 'current'); 
            feelTabCurrent = i; 
            // 点击心情分组心情标签上报
            skin.execOrder('report', 'clickSubTab' + (i+1));
            // 初始增加查看更多 2013-12-05
            if (skin.addFeelMore) {

            }
        }
    }
},
/**
 * 导入表情按钮
 */
skin.proccessImportFace = function (element, eventType) {
    skin.g('importItems').style.display = 'block';
},
/**
 * 导入本地表情
 */
skin.proccessImportLocalGroup = function (element, eventType) {
    skin.execOrder('import', 'local');
    element.parentElement.style.display = 'none';
},
/**
 * 导入网络表情
 */
skin.proccessImportWebGroup = function (element, eventType) {
    skin.execOrder('import', 'network');
    element.parentElement.style.display = 'none';
},
/**
 * 添加网络表情包
 */ 
skin.proccessAddWebFace = function (element, eventType) {
    var packId = element.getAttribute('packid');
    var pack = skin.g(packId);
    var loadId = packId + 'Load';
    var load = document.createElement('div');
    load.id = loadId;
    load.className = 'loading abs';
    load.innerHTML = '<p class="load"></p>';
    element.parentElement.appendChild(load);
    // 表情组数目已达上限
    if (skin.g('groupBox').getElementsByTagName('section').length + addCount >= 24) {
        addpackRet([-1, loadId]);
        return false;
    }
    addCount++;
    try { 
        var isAdded = window.external.SyncRequest('addpack', loadId + ',' + element.getAttribute('downurl'));
        if (isAdded.toString() == '0') { 
            addpackRet([0, loadId]);
        } 
    } catch (e) {}
},
/**
 * 使用表情
 */
skin.proccessSelectedFace = function (element, eventType) { 
    element = eventType == 'select' ? element : element.parentElement.getElementsByTagName('img')[0];
    skin.execOrder('select', skin.formatImgSrc(element.getAttribute('src')));
},
/**
 * 删除表情
 */
skin.proccessDelFace = function (element, eventType) {
    var obj =  skin.g(element.parentElement.getAttribute('emid')); 
	var src = obj.getElementsByTagName('img')[0].src;
    skin.execOrder('delete', skin.formatImgSrc(src));	
    var liObj = obj.parentElement.parentElement.parentElement; 
    liObj.parentElement.removeChild(liObj);
},
/**
 * 编辑表情
 */
skin.proccessEditFace = function (element, eventType) { 
    var obj =  skin.g(element.parentElement.getAttribute('emid'));
    skin.execOrder('rename', skin.formatImgSrc(obj.getElementsByTagName('img')[0].src));
},
/**
 * 收藏表情
 */
skin.proccessFavoriteFace = function (element, eventType) {
    var obj =  skin.g(element.parentElement.getAttribute('emid'));
    skin.execOrder('bookmark', skin.formatImgSrc(obj.getElementsByTagName('img')[0].src));
},
/**
 * 删除表情组
 */
skin.proccessDelGroup = function (element, eventType) {
    var gid = skin.g(element.parentElement.getAttribute('navid')).getAttribute('gid');
    skin.execOrder('deletegroup', gid);
    deleteGroup([gid]);
},
/**
 * 移动表情组(导致高亮索引变化时,需要更新组列表定位)
 */
skin.proccessMoveGroup = function (element, eventType) { 
    var navBox = skin.g('emotionTabs');
    var emotionBox = skin.g('groupBox'); 
    var navs = navBox.getElementsByTagName('nav');
    var emotions = emotionBox.getElementsByTagName('section');
    var nav = skin.g(element.parentElement.getAttribute('navid'));   
    var num = skin.getNavNum(nav);
    var emotion = emotions[num];
    var gid = nav.getAttribute('gid'); 
    var index = eventType == 'moveFirst' ? 4 : (eventType == 'movePrev' ? num -1 : num + 1);
    var gidArr = [];
    var dom = null;
    /*for (var i = 4, len = navs.length; i < len; i ++) {
        if (nav == navs[i]) {
            continue;
        }
        if (i == index) {
            gidArr.push(navs[num].getAttribute('gid'));            
        } 
        gidArr.push(navs[i].getAttribute('gid'));
    } */
    navBox.removeChild(nav);
    emotionBox.removeChild(emotion);
    skin.insertAfter(nav, navs[index - 1]);
    skin.insertAfter(emotion, emotions[index - 1]);
    if (navs[index].className == 'current') { 
        currentIndex = index;
    } else if (num > currentIndex && index <= currentIndex) {
        currentIndex = currentIndex + 1;
    } else if (num < currentIndex && index >= currentIndex) {
        currentIndex = currentIndex - 1;
    } 
    if (index == 4) {
        skin.g('emotionTabs').style.left = '0px';
        skin.g('pagePrev').setAttribute('page', 0);
        skin.g('pageNext').setAttribute('page', 0);
        showPager();
    } else if (eventType == 'movePrev' && index % 7 == 6) {
        skin.proccessPager(skin.g('pagePrev'), 'pagePrev');
    } else if (eventType == 'moveNext' && index % 7 == 0) {
        skin.proccessPager(skin.g('pageNext'), 'pageNext');
    }
    skin.updatePosition(currentIndex);
	
	for (var i = 4, len = navs.length; i < len; i ++) {
        /*if (nav == navs[i]) {
            continue;
        }
        if (i == index) {
            gidArr.push(navs[num].getAttribute('gid'));            
        } */
        gidArr.push(navs[i].getAttribute('gid'));
    }
    skin.execOrder('sorttab', gidArr.join(' '));
    
},
/**
 * 获取组索引
 */
skin.getNavNum = function (nav) {
    var navs = skin.g('navs').getElementsByTagName('nav');
    for (var i = 0, len = navs.length; i < len; i++) {
        if (navs[i] == nav) {
            return i;
        }
    }
    return 0;
},
/**
 * 打开链接
 */
skin.proccessOpenUrl = function (element, eventType) {
    skin.execOrder('openurl', config.openUrl[eventType]);
},
/**
 * 标签组标签右键
 */
skin.proccessNavRightButton = function (opts) { 
    opts.element = opts.eventType == 'nav' ? opts.selement : opts.element.parentElement.parentElement;
    var navs = skin.g('emotionTabs').getElementsByTagName('nav');
    for (var i = 0, len = navs.length; i < len; i++) {
        if (navs[i] == opts.element) {
            showNavRButton(i, opts.e, opts.element.id);
            return false;
        }
    }
    
},
/**
 * 表情右键
 */
skin.proccessFaceRBtn = function (opts) { 
    opts.element = opts.eventType == 'face' ? opts.element : opts.element.parentElement.getElementsByTagName('img')[0];
    var faceRBtn = skin.g('faceRBtn');
    var pid = parseInt(opts.element.getAttribute('pid'), 10);
    var tabid = opts.element.getAttribute('tabid');
    var rBtnHtml = '';
    faceRBtn.innerHTML = '';
    faceRBtn.setAttribute('pid', pid); 
    faceRBtn.setAttribute('emid', opts.element.parentElement.id); 
    if (tabid == 'Recent' || tabid == 'Default') {
        return false;
    } else if (tabid == 'Emotion') {
        if (pid != 2) {
            faceRBtn.innerHTML = '<p event-type="delFace">删除表情</p>';
        } else {
            return false;
        }
    } else if (tabid == 'Favorite') {
        rBtnHtml = ((pid > 2 || pid == 0) ? '<p event-type="delFace">删除表情</p>' : '') + '<p event-type="editFace">编辑表情</p>';      
        faceRBtn.innerHTML = rBtnHtml;
    } else {
        faceRBtn.innerHTML = '<p event-type="favorite">移动到收藏</p><p event-type="delFace">删除表情</p><p event-type="editFace">编辑表情</p>';         
    }
    var eX = opts.e.x;
    var btnLeft = 0; 
    var btnRight = 0;
    if (eX + 94 > config.emotionBoxW) {
        btnLeft = '';
        btnRight = 0;
    } else {
        btnLeft =  opts.e.x + 'px';
        btnRight = '';
    }
    faceRBtn.style.left = btnLeft;
    faceRBtn.style.right = btnRight;
    faceRBtn.style.top = opts.e.y + 'px';
    faceRBtn.style.display = 'block';
    // 隐藏title显示
    skin.g('faceTitle').style.display='none';
    skin.g('groupTitle').style.display='none';
},
/**
 * 显示动图
 */

skin.playerMagic = function (obj, isHover, e) { 
    isHover ? skin.addClass(obj.parentElement, 'current') : skin.removeClass(obj.parentElement, 'current');
    var titObj = skin.g('faceTitle');
    var title = obj.getElementsByTagName('span')[0].innerHTML;
    var faceWeb = obj.getElementsByTagName('h5');
    var imgBox = obj.getElementsByTagName('em')[0];
    var imgObj = imgBox.getElementsByTagName('img')[0];
    var PID = imgObj.getAttribute('pid');
    var tabid = imgObj.getAttribute('tabid');
    var fConf = tabid == 'Default' ? config.nomal : config.local; // 一个表情的宽度
    var titleW = 0;
    var left = 0;
    var top = 0 ;
    var right = 0;
    if (isHover) {
        if (title.length == 0 || title == 'undefinde') {
            return false;
        }       
        // 2013-10-15 更改：基础表情显示完整名称
        titObj.innerHTML = (PID == '2') ? title : skin.setTextRule(title, 12);
        titObj.style.display = 'block';
        titleW = titObj.offsetWidth; 
        // 2013-10-17 更改：hover title在表情右侧显示；超出则贴盒子右边显示
        left = Math.ceil((e.x - 6) / fConf.w) * fConf.w + 6;
                
        if (left + titleW > config.emotionBoxW) {
            left = 'auto'; 
            right = 0;    
            top = Math.ceil((e.y - 6) / fConf.h) * fConf.h + 6;     
        } else {
            top = e.y;
            left = left + 'px';
            right = 'auto';
        }
        // titObj.style.left = Math.ceil((parseInt(e.x, 10) - 5) / 64) * 64 + 5 + 'px';
        titObj.style.left = left;
        titObj.style.right = right;
        titObj.style.top = top + 'px';

        titObj.style.display = 'block';
        imgBox.style.display = 'none';
        if (faceWeb.length > 0) {
            faceWeb[0].style.display = 'none';
        }
    } else {
        titObj.style.display = 'none';
        imgBox.style.display = 'table-cell';
        if (faceWeb.length > 0) {
            faceWeb[0].style.display = 'block';
        }
    }
},
/**
 * 组标签hover
 */
skin.proccessTabHover = function (opts) {
    var title = opts.element.getAttribute('tabtip');
    var titObj = skin.g('groupTitle');
    if (opts.isHover) {
        if (title.length == 0 || title == 'undefinde') {
            return false;
        }
        titObj.innerHTML = skin.setTextRule(title, 12);
        titObj.style.left = opts.e.x + 'px';
        titObj.style.top = (opts.e.y + 10) + 'px';
        titObj.style.display = 'block';
    } else {
        titObj.style.display = 'none';
    }
},
/**
 * 网络表情包hover
 */
 skin.hoverWebFacePack = function (opts) {
    var obj = opts.element.parentElement.parentElement; 
    opts.isHover ? skin.addClass(obj, 'current') : skin.removeClass(obj, 'current');
 },
/**
 * 转换图片地址
 */
skin.formatImgSrc = function (url) {
    url = decodeURI(url); 
    return url.replace(/^file:\/\/\//ig, '');
},
/**
 * 取消冒泡事件
 */
skin.cancelBubble = function (e) {
    if (e.stopPropagation) e.stopPropagation();
    else e.cancelBubble = true;
},
/**
 * 限制文字长度; 超出长度,减1字加...
 */
skin.setTextRule = function (str, rule) {
    var len = 0,
        charStr = '',
        newStr = "",
        k = 0;           
    for(var i = 0; i < str.length; i++) {
        charStr = str.charAt(i);   
        len = len + (/[^\x00-\xff]/g.test(charStr) ? 2 : 1);              
        if(!(len >= rule)) {
            k = i;
            newStr = newStr + charStr;
        } else {
            return newStr + '...';
        }            
    }           
    return newStr;      
},
/**
 * 获取适应宽度
 * @param  {number}  w      实际宽度
 * @param  {number}  h      实际高度
 * @param  {Boolean} isIcon 是否为组标签
 * @return {number}         合理宽度
 */
skin.getNewWidth = function (w, h, resConf) {
    var pic = config.pic[resConf];
    if (pic.w >= w && pic.h >= h) {
        return w;
    } else if (pic.w / w >= pic.h / h) {
        return ( pic.h / h * w);
    } else {
        return pic.w;
    }
},
/**
 * 更新定位(新增/删除/排序)
 */
skin.updatePosition = function (curIndex) { 
    var len = skin.g('emotionTabs').getElementsByTagName('nav').length;
    skin.g('faceBox').style.marginTop = -1 * curIndex * config.faceBoxH + 'px';
    skin.g('mask').style.display = 'block';
},
/**
 * 设置皮肤初始状态
 */
skin.initSkin = function () { 
    // 设置字体显示
    skin.getSysver();   
    // 映射事件
    skin.proccessEvent();

    skin.tanNum = 0;
},
/**
 * 返回dom
 */
skin.dom = {
    nav: function (eType, gid, gName) {
        var tab = document.createElement('nav');
        var iconId = 'icon_' + iIndex;
        var html = [];
        tab.id = 'n_' + gid;
        tab.setAttribute('event-type', 'tab');
        tab.setAttribute('right-btn', eType);
        tab.setAttribute('gid', gid);
        tab.setAttribute('parentId', 'navs');
        html[html.length] = '<em id="' + iconId + '"></em>';
        html[html.length] = '<div class="tipbox rel">';
        html[html.length] = '   <p hover="tabHover" event-type="tabbox" right-btn="' + (eType ? eType + 'Box' : '') + '" tabtip="' + gName + '" class="tabtips"></p>';
        html[html.length] = '</div>';
        tab.innerHTML = html.join('');
        return tab;
    },
    tab: function (icon, eType, obj) {
        var img = new Image();
        img.src = icon;
        img.onload = function () {
            obj.innerHTML = '<img event-type="tabimg" onclick="skin.cancelBubble(event)" right-btn="' + (eType ? eType + 'Img' : '') + '" src="' + this.src + '" width="' + skin.getNewWidth(this.width, this.height, 'icon') + '">';
        }
    },
    face: function (opts) { 
        var face = document.createElement('li'); 
        var html = []; 
        var imgId = 'img_' + imgIndex;
        var fixId = 'fix_' + fixIndex;
        var tabId = opts['tabId'];
        html[html.length] = '<div class="emotion rel" onmouseover="skin.playerMagic(this, true, event)" onmouseout="skin.playerMagic(this, false, event)">';
        html[html.length] = '   <em id="' + imgId + '" class="nomalshow"></em>';
        html[html.length] = '   <p class="magic" hover="face">';
        html[html.length] = '       <em id="' + fixId + '"  event-type="selectFix" right-btn="faceFix" hover="faceImg"></em>';
        html[html.length] = '   </p>';        
        // if (opts['pid'] == 1) {
        //     html[html.length] = '<span class="title">网络表情</span>';
        //     html[html.length] = '<h5 class="face-web" event-type="selectWeb"></h5>';
        // } else {
            html[html.length] = '<span class="title" >' + opts['N'] + '</span>';
        // }
        html[html.length] = '</div>';
        face.innerHTML = html.join('');
        var img = new Image();
        img.src = opts['direct'] + opts['img_1'];
        img.onload = function () {
            skin.g(imgId).innerHTML = '<img tabid="' + opts['GID'] +'" pid="' + opts.pid + '" src="' + this.src + '" width="' + skin.getNewWidth(this.width, this.height, opts.resConf) + '" alt="">';
        }
        var fixImg = new Image();
        fixImg.src = opts['direct'] + opts['img_2'];
        fixImg.onload = function () {
            skin.g(fixId).innerHTML = '<img tabid="' + opts['GID'] + '" pid="' + opts.pid + '" onclick="skin.cancelBubble(event)" event-type="select" right-btn="face" src="' + this.src + '" width="' + skin.getNewWidth(this.width, this.height, opts.resConf) + '" alt="">';
        }
        imgIndex++;
        fixIndex++;
        return face;
    },
    pack: function (item) {
        var li = document.createElement('li');
        var html = [];
        var wId = 'w_' + wIndex;
        html[html.length] = '<div class="recom-item rel">';
        html[html.length] = '   <div id="' + wId + '" class="pack-img"></div>';
        html[html.length] = '   <p class="title">' + skin.setTextRule(item.SetTitle, 8) + '</p>';
        html[html.length] = '   <em event-type="addWebPack" hover="packHover" packid="' + wId + '" downurl="' + encodeHTML(item.SetDownloadUrl) + '"></em>';
        html[html.length] = '</div>';

        li.innerHTML = html.join('');

        var wImg = new Image(); 
        wImg.src = item.objURL;
        var imgSrc = item.objURL;
        wImg.onload = function () { 
           skin.g(wId).innerHTML = '<img src="' + this.src + '" width="' + skin.getNewWidth(this.width, this.height, 'face') + '" alt="' + item.SetTitle + '">';
        }
        wIndex++;
        webLoad[wId + 'Load'] = 0;
        return li;
    }
};
/**
 * 分页
 */
skin.proccessPager = function (element, eventType) {
    var pIndex = parseInt(element.getAttribute('page'), 10);
        pIndex = eventType == 'pagePrev' ? pIndex - 1 : pIndex + 1;
    var pTotal = Math.ceil(skin.g('groupBox').getElementsByTagName('section').length / page.num);
    if (pIndex < 0 || pIndex >= pTotal) {
        return false;
    }
    
    var prev = skin.g('pagePrev');
    var next = skin.g('pageNext');
    if (eventType == 'pagePrev' && pIndex != pTotal) {
        skin.removeClass(next, 'unable');
    }
    if (eventType == 'pageNext' && pIndex > 0) {
        skin.removeClass(prev, 'unable');
    }
    if (eventType == 'pagePrev' && pIndex == 0) {
        skin.addClass(prev, 'unable');
    }
    if (eventType == 'pageNext' && pIndex == pTotal - 1) { 
        skin.addClass(next, 'unable');
    }
    prev.setAttribute('page', pIndex);
    next.setAttribute('page', pIndex);
    skin.g('emotionTabs').style.left = (-1 * pIndex * page.w * page.num) + 'px';
},
/**
 * 查看更多表情
 * 注：关于openURL打开页面接口：由于‘查看更多网络表情’中用过该命令，
 *     且该命令被客户端RD作为‘查看更多网络表情’点击统计上报用；
 *     本应用其他所有打开页面的命令均需用openURL2，用法相同
 */
skin.proccessFeelMore = function (element, eventType) { 
    var linkid = parseInt(element.getAttribute('linkid'), 10); 
    skin.execOrder('report', 'clickFeelMore' + linkid); 
    skin.execOrder('openurl2', config.feelMoreUrl[linkid].url);    
},
/**
 * 设置皮肤动画
 */
skin.setAnimate = function () {

},
skin.initWebFaceBox = function (data, isInit) {
    var ul = skin.g('recomFace');
    var item = null;
    var iLen = data.length;
    if (iLen == 0 && !isInit) {
        window.setTimeout(function () {
            skin.getWebFace();
        }, config.sleepTime);
        return false;
    }
    var len = iLen > config.web.len ? (iLen % config.web.lineNum == 0 ? iLen : Math.ceil(iLen / config.web.lineNum) * config.web.lineNum) : config.web.len; 
    skin.g('recomFace').innerHTML = '';
    for (var i = 0; i < len; i++) {
        if (i >= iLen) {
            li = document.createElement('li');
        } else {
            item = data[i];
            li = skin.dom.pack(item);
        }
        if (i >= len - config.web.lineNum) {
            skin.addClass(li, 'border-b');
        }
        if ((i + 1) % 3 == 0) {
            skin.addClass(li, 'border-r');
        }
        
        ul.appendChild(li); 
    }        
},
/**
 * 拉取网络表情
 */
skin.getWebFace = function () {
    try {
        baidu.ajax.request(config.requestUrl + '&t=' + (+ new Date()), {
            headers: {"Referer": "http://image.baidu.com/"},
            timeout: 3000,
            onsuccess:function (xhr, result) {  
                if (typeof result == 'string') {
                    result = JSON.parse(result);
                }
                skin.initWebFaceBox(result.data);      
            },
            onfailure: function (xhr) { 
                window.setTimeout(function () {
                    skin.getWebFace();
                }, config.sleepTime);
            },
            ontimeout: function (xhr) {
                window.setTimeout(function () {
                    skin.getWebFace();
                }, config.sleepTime);
            }
        }); 
    } catch (e) { }
},
/**
 * 重置滚动条
 */
skin.resetScroll = function () {
    skin.g('recomFaceBox').scrollTop = 0;
    var navs = skin.g('groupBox').getElementsByTagName('section');
    var feels = skin.g('feelBox').getElementsByTagName('div');
    for (var i = 0, iLen = navs.length; i < iLen; i++) {
        navs[i].children[0].scrollTop = 0;
    }   
    for (var j = 0, jLen = feels.length; j < jLen; j++) {
        if (feels[j].className.indexOf('emotionBox') > -1) {
            feels[j].scrollTop = 0;
        }
    }
}
function encodeHTML(str) {
    return str.replace(/&/g,'&amp;')
            .replace(/</g,'&lt;')
            .replace(/>/g,'&gt;')
            .replace(/"/g, "&quot;")
            .replace(/'/g, "&#39;");
}
// 供客户端调用
function setButtonState(key, statu) { 
    var status = config.buttonstatus;
    var id = '';
    key = key || '0';
    id = status[key].id;
    if (typeof skin.g(id) == 'string') {
        return;
    }
    statu =  statu || (skin.g(id).getAttribute('statu') == '0' ? '1' : '0');     
    skin.g(id).style.backgroundImage = 'url(images/icons/' + status[key][statu] + ')';
    skin.g(id).setAttribute ('statu', statu);        
}
/**
 * 在一支笔中打印日志
 * @param {string} str 打印的内容
 */
function Log(str) {   
    try {
        if(window.external.SyncRequest) { 
            window.external.SyncRequest('log', str);
        } else {   //在浏览器控制台中输出        
            console.log(str);
        }
    } catch (e) {}
}
/*
 * 标签组标签右键
 */
function showNavRButton (num, e, navId) {
    var navs = skin.g('navs').getElementsByTagName('nav');
    var rBtn = skin.g('navRBtn');
    var rBtnItem = rBtn.getElementsByTagName('p');
    var len = navs.length - 6;
    for (var i = 0, rLen = rBtnItem.length; i < rLen; i++) {
        skin.removeClass(rBtnItem[i], 'unable');
        rBtnItem[i].setAttribute('event-type', config.navRBtn[i]);
    }

    if (num - 4 == len) { // 向后移动不可用
        skin.addClass(rBtnItem[3], 'unable');
        rBtnItem[3].setAttribute('event-type', '');
    }
    if (num - 4 == 0){ // 移到首位 和 向前移动不可用
        skin.addClass(rBtnItem[1], 'unable');
        skin.addClass(rBtnItem[2], 'unable');
        rBtnItem[1].setAttribute('event-type', '');
        rBtnItem[2].setAttribute('event-type', '');
    } 
    rBtn.style.top = (e.y - 293) + 'px';
    rBtn.style.left = e.x + 'px';
    rBtn.setAttribute('num', num);
    rBtn.setAttribute('navid', navId);
    rBtn.style.display = 'block'; 
    // 隐藏title显示
    skin.g('faceTitle').style.display='none';
    skin.g('groupTitle').style.display='none';
}
function addEmotionList(data, pathArr, opts, callback) {   
    var li = null; 
    var path = ''; 
    var box = document.createElement('div');
    var item = document.createElement('div');
    var ul = document.createElement('ul');
    var clear = document.createElement('div');
        clear.className = 'clear';
    var jLen = data['FA'].length;
    var sizeConf = opts.groupID == 'Default' ? config.nomal : config.local; 
    if (jLen > 0) {
        checkList[opts.groupID] = 1;
        
    }
    var len = jLen > sizeConf.len ? (jLen % sizeConf.lineNum == 0 ? jLen : Math.ceil(jLen / sizeConf.lineNum) * sizeConf.lineNum) : sizeConf.len;
    var resizeConf = opts.groupID == 'Default' ? 'nomal' : 'face';
    // 增加更多
    var feelMore = opts.scrollCls == 'feel' ? true : false;
    len = (opts.scrollCls == 'feel' && len % sizeConf.lineNum == 0) ? (len + sizeConf.lineNum) : len;
    for (var j = 0; j < len; j++) { 
        if (j >= jLen) {
            li = document.createElement('li');
            if (feelMore) {
                li.innerHTML = '<p event-type="feelMore" class="feel-more" linkid="' + opts.feelIndex + '">更多</p>';
                feelMore = false;
            }
        } else {
            path =(opts.groupID == 'Recent' || opts.groupID == 'Emotion') ? data['FA'][j]['P'] : data['GP'];
            li = skin.dom.face({
                tabId: opts.gIndex,
                direct: pathArr[path] + '\/',
                pid: path,
                resConf: resizeConf,
                GID: opts.groupID,
                N: data['FA'][j]['N'],
                img_1: data['FA'][j]['ID'] + data['FA'][j]['FF'],
                img_2: data['FA'][j]['ID'] + data['FA'][j]['OF']
            }); 
        } 
        if (j >= len - sizeConf.lineNum) {
            skin.addClass(li, 'border-b');
        }
        if ((j + 1) % sizeConf.lineNum == 0) {
            skin.addClass(li, 'border-r');
        }
        li.setAttribute('cid', j);
        ul.appendChild(li); 
    }
    item.appendChild(ul);
    item.appendChild(clear);
    callback && callback(item, box);
}
// 返回心情子标签d
function appendFeeTabs(tabName) { 
    li = document.createElement('li');
    li.setAttribute('event-type', 'feelTab');
    li.innerHTML = tabName;
    return li;
}
function isSYS(GID) {
    return typeof config.groupId[GID] == 'undefined';
}
function getGID() {

}
/*
 * 更新(创建)一个或多个表情组 (RD调用)
 * @param {object} data 更新数据
 */
function addEmotion(data) { 
    data = !data ? testData1 : data;  
    var tabs =  skin.g('emotionTabs');  // 表情分组标签盒子
    var box = skin.g('groupBox');        // 表情分组列表盒子
    var tab = null;                     // 表情标签
    var boxItem = null;                 // 表情分组
    var faceArr = data['FA'];           // 表情数据
    var path = data['PA'];              // 路径数据
    skin.tabs = [];                     // 标签标签组存储
    var len = faceArr.length; 
    var GID = '';
    var tabTit = null;
    for (var i = 0; i < len; i++) { 
        GID = faceArr[i]['GID'];
        // 分组icon
        if (typeof skin.g('n_' + GID) == 'string') { 
            tab = skin.dom.nav((isSYS(GID) ? 'nav' : ''), GID, faceArr[i]['GN']);
            tabs.appendChild(tab);
            iIndex++;
        } else {
            tab = skin.g('n_' + GID);
        }
        skin.dom.tab(faceArr[i]['GI'], (isSYS(GID) ? 'nav' : ''), tab.getElementsByTagName('em')[0]);

        if (typeof skin.g('g_' + GID) == 'string') {
            boxItem = document.createElement('section');
            boxItem.id = 'g_' + GID;
            boxItem.className = (GID == 'Emotion' ? 'feel-box rel' : '');
            box.appendChild(boxItem);
        } else {
            boxItem = skin.g('g_' + GID);
            boxItem.innerHTML = '';
        }
        // 分组表情列表
        if (GID == 'Emotion') { // 心情分组            
            var feelFaceBox = document.createElement('div');
                feelFaceBox.id = 'feelFaceBox';
                feelFaceBox.className = 'feel feelFaceBox';            
            var feelItems = document.createElement('div');
                feelItems.id = 'feelBox';
            var feelTab = document.createElement('div');
                feelTab.id = 'feelTabs';
                feelTab.className = 'feel-tab abs';
            var ul = document.createElement('ul');

            feelTab.appendChild(ul);
            feelFaceBox.appendChild(feelItems);
            boxItem.appendChild(feelFaceBox); 
            boxItem.appendChild(feelTab);
            box.appendChild(boxItem);
            var feelArr = faceArr[i]['FA'];
            for (var j = 0, gLen = feelArr.length; j < gLen; j++) {
                ul.appendChild(appendFeeTabs(feelArr[j]['GN']));

                addEmotionList(feelArr[j], path, {gIndex: i, scrollCls: 'feel', feelIndex: j, fType:'Emotion', groupID: GID}, function (item, scrollBox) {
                    item.className = 'feel emotion-items emotionBox';
                    scrollBox.className = '';
                    scrollBox.appendChild(item);
                    feelItems.appendChild(item);
                });
            }
        } else { // 其他分组
            addEmotionList(faceArr[i], path, {gIndex: i, scrollCls: '', fType: 'nomal', groupID: GID}, function (item, scrollBox) {
                item.className = 'emotion-items' + (GID == 'Default' ? ' emotion-nomal' : '');
                scrollBox.className = 'emotionBox';
                scrollBox.appendChild(item);
                boxItem.appendChild(scrollBox);                
            });
        }
        
    }
    showPager();
    isAddEmotion = true;
    var firstNav = skin.g('emotionTabs').getElementsByTagName('nav')[0];
    skin.execOrder('getgroup', firstNav.getAttribute('gid')); 
    skin.proccessChangeTab(firstNav, 'tab');
    skin.changeFeelTabs(skin.g('feelTabs').getElementsByTagName('li')[0], 'feelTab');    
}
/*
 * 刷新分组
 */
 function refreshGroup(data) { 
    if (!isAddEmotion) {
        return false;
    }
    data = !data ? testData : data;    
    var tabs =  skin.g('emotionTabs');  // 表情分组标签盒子
    var box = skin.g('groupBox');        // 表情分组列表盒子
    var tab = null;                     // 表情标签
    var boxItem = null;                 // 表情分组
    var faceArr = data['FA'];           // 表情数据
    var path = data['PA'];              // 路径数据
    skin.tabs = [];                     // 标签组存储
    var len = faceArr.length;
    var GID = '';
    var newGroup = false;
    
    for (var i = 0; i < len; i++) { 
        GID = faceArr[i]['GID']; 
        // 分组icon
        if (typeof skin.g('n_' + GID) == 'string') { 
            tab = skin.dom.nav((isSYS(GID) ? 'nav' : ''), GID, faceArr[i]['GN']);
            tabs.appendChild(tab);
            newGroup = true;
            iIndex++;
        } else {
            tab = skin.g('n_' + GID);
            newGroup = false;
        }
        skin.dom.tab(faceArr[i]['GI'], (isSYS(GID) ? 'nav' : ''), tab.getElementsByTagName('em')[0]);
        if (typeof skin.g('g_' + GID) == 'string') {
            boxItem = document.createElement('section');
            boxItem.id = 'g_' + GID;
            boxItem.className = (GID == 'Emotion' ? 'feel-box rel' : '');
            box.appendChild(boxItem);
        } else {
            boxItem = skin.g('g_' + GID); 
            boxItem.innerHTML = ''; 
        }
        // 分组表情列表
        if (GID == 'Emotion') { // 心情分组
            var feelFaceBox = document.createElement('div');
                feelFaceBox.id = 'feelFaceBox';
                feelFaceBox.className = 'feel feelFaceBox';            
            var feelItems = document.createElement('div');
                feelItems.id = 'feelBox';
            var feelTab = document.createElement('div');
                feelTab.id = 'feelTabs';
                feelTab.className = 'feel-tab abs';
            var ul = document.createElement('ul');

            feelTab.appendChild(ul);
            feelFaceBox.appendChild(feelItems);
            boxItem.appendChild(feelFaceBox); 
            boxItem.appendChild(feelTab);
            var feelArr = faceArr[i]['FA'];
            for (var j = 0, gLen = feelArr.length; j < gLen; j++) {
                ul.appendChild(appendFeeTabs(feelArr[j]['GN']));

                addEmotionList(feelArr[j], path, {gIndex: i, scrollCls: 'feel', feelIndex: j, fType: 'Emotion', groupID: GID}, function (item, scrollBox) {
                    item.className = 'feel emotion-items emotionBox';
                    scrollBox.className = '';
                    scrollBox.appendChild(item);
                    feelItems.appendChild(item);
                });
            }
        } else { // 其他分组
            addEmotionList(faceArr[i], path, {gIndex: i, scrollCls: '', fType: 'nomal', groupID: GID}, function (item, scrollBox) {
                item.className = 'emotion-items' + (GID == 'Default' ? ' emotion-nomal' : '');
                scrollBox.className = 'emotionBox';
                scrollBox.appendChild(item);
                boxItem.appendChild(scrollBox);                
            });
        }
        
        if (newGroup && skin.g('addFace').className.indexOf('current') > -1) {
            // skin.g('faceBox').style.marginTop = (parseInt(skin.g('faceBox').style.marginTop, 10) - config.faceBoxH) + 'px';
            currentIndex++;
            skin.updatePosition(currentIndex);
        }
    }
    showPager();
    skin.changeFeelTabs(skin.g('feelTabs').getElementsByTagName('li')[feelTabCurrent], 'feelTab');
 }
/*
 * 控制分页显示
 */
 function showPager() {
    var tabs = skin.g('emotionTabs');
    var len = tabs.getElementsByTagName('nav').length;
    var dis = (len > page.num) ? 'block' : 'none';    
    skin.g('pagePrev').style.display = dis;
    skin.g('pageNext').style.display = dis;

    var tabs = skin.g('emotionTabs');
    var pageCount = Math.ceil(len / page.num);
    var left = parseInt(skin.g('emotionTabs').style.left, 10);
    var limitLeft = (1 - pageCount) * page.w * page.num;  
    if (limitLeft > left) {
        skin.g('emotionTabs').style.left = limitLeft + 'px';
        skin.addClass(skin.g('pageNext'), 'unable');
        skin.g('pagePrev').setAttribute('page', 0);
        skin.g('pageNext').setAttribute('page', 0);
    } else if (limitLeft <= left && skin.g('pageNext').className.indexOf('unable') > -1) {
        skin.removeClass(skin.g('pageNext'), 'unable');
    }
    if (left == 0 && pageCount > 1) {
        skin.addClass(skin.g('pagePrev'), 'unable');
    } 
 }
/*
 * 移除表情组
 * @param {Object} gid 移除的id列表
 */
function deleteGroup (gid) { 
    var faceBox = skin.g('groupBox');
    var navBox = skin.g('emotionTabs');
    var curGID = null;
    var len = gid.length;
    for (var i = 0; i < len; i++) {
        if (typeof skin.g('n_' + gid[i]) == 'object') {
            faceBox.removeChild(skin.g('g_' + gid[i])); 

            if (skin.g('n_' + gid[i]).className == 'current') {
                curGID = skin.g('n_' + gid).previousSibling;
            }             
            navBox.removeChild(skin.g('n_' + gid[i]));  
        }
    }
    if (curGID) {
        skin.proccessChangeTab(curGID, 'tab');
    } 
    
    if (skin.g('addFace').className.indexOf('current') > -1) {
        currentIndex = currentIndex - len;
    }
   
    skin.updatePosition(currentIndex);
    showPager();
}
/*
 * 恢复默认显示
 */
function gotoTab () { 
    skin.proccessChangeTab(skin.g('n_Recent'), 'tab');
    skin.changeFeelTabs(skin.g('feelTabs').getElementsByTagName('li')[0], 'feelTab');
    skin.g('pagePrev').setAttribute('page', 0);
    skin.g('pageNext').setAttribute('page', 0);
    skin.g('emotionTabs').style.left = '0px';
    showPager();
    skin.resetScroll();
}
/*
 * 隐藏菜单
 */
function hideMenu() {
    skin.g('faceRBtn').style.display = 'none';
    skin.g('navRBtn').style.display = 'none';
    skin.g('importItems').style.display = 'none';
}
/*
 * 添加完成
 */
function addpackRet(opts) { 
    var parentDom = skin.g(opts[1]).parentElement;
    var key = opts[0];
    var wranText = '';
    skin.g(opts[1]).innerHTML = '';
    switch (key) {
        case -1: 
            wranText = '表情组数量已达上限';
            window.setTimeout(function () {
                parentDom.removeChild(skin.g(opts[1]));
            }, config.warnTime);
            break;
        case 0: 
            wranText = '添加失败,请重试';
            window.setTimeout(function () {
                parentDom.removeChild(skin.g(opts[1]));
            }, config.warnTime);
            addCount--;
            break;
        case 1: 
            wranText = '添加成功';
            window.setTimeout(function () {
                parentDom.removeChild(skin.g(opts[1]));
                var span = document.createElement('span');
                span.className = 'addret';
                span.innerHTML = '已添加';
                parentDom.appendChild(span);
            }, config.warnTime);
            addCount--;
            break;
        default: break;
    }
    skin.g(opts[1]).innerHTML = wranText;
}