/**
 * @author v_wangyan
 */
function g(element) {
    return document.getElementById(element) || element;
}
function jsonDecode(jsonString) {
    return (new Function("return " + jsonString))();
}
function show(id) {
    isShow(id, true);
}
function hide(id) {
    isShow(id, false);
}
function isShow(id, flag) {
    g(id).style.display = flag ? 'block' : 'none';
}
function addClass(element, className) {
    element = g(element) || element;
    var classArray = className.split(/\s+/),
        result = element.className,
        classMatch = " " + result + " ",
        i = 0,
        l = classArray.length;

    for (; i < l; i++) {
        if (classMatch.indexOf(" " + classArray[i] + " ") < 0) {
            result += (result ? ' ' : '') + classArray[i];
        }
    }

    element.className = result;
}
function removeClass(element, className) {
    element = g(element) || element;

    var oldClasses = element.className.split(/\s+/),
        newClasses = className.split(/\s+/),
        lenOld,
        lenDel = newClasses.length,
        j,
        i = 0;
    for (; i < lenDel; ++i) {
        for (j = 0, lenOld = oldClasses.length; j < lenOld; ++j) {
            if (oldClasses[j] == newClasses[i]) {
                oldClasses.splice(j, 1);
                break;
            }
        }
    }
    element.className = oldClasses.join(' ');
}
/* 阻止冒泡事件 */
function cancelBubble(e) {
    if (e.stopPropagation) e.stopPropagation();
    else e.cancelBubble = true;
}
function createElement(className) {
    var div = document.createElement('div');
    div.className = className;
    return div;
}
function trim(str) {
    return str.replace(/^(\s|\u00A0)+/, '').replace(/(\s|\u00A0)+$/, '');
}
/**
 * 字符长度
 */
function getLen(str) {
    var len = 0,
        abc = '';
    for (var i = 0; i < str.length; i++) {
        abc = str.charAt(i);
        if (str.charCodeAt(i) > 255) {
            len = len + 2;
        } else {
            len = len + 1;
        }
    }
    return len;
}
/**
 * 长度限制
 * str:目标字符串
 * rule:规则(maxlength)
 */
function setTextRule(str, rule) {
    var len = 0,
        abc = '',
        newStr = "",
        k = 0;
    try {
        if (!str || str == '' || str == 'undefined') {
            return '';
        }
    } catch (e) {
        return '';
    }

    if (rule == getLen(str) || rule > getLen(str)) {
        return str;
    } else {
        rule = rule - 4;
        for (var i = 0; i < str.length; i++) {
            abc = str.charAt(i);
            if (str.charCodeAt(i) > 255)
                len = len + 2;
            else {
                len = len + 1;
            }
            if (!(len > rule)) {
                k = i;
                newStr = newStr + abc;
            }
        }
        return newStr + "...";
    }
}
//设置页面显示的字体
function setFontFamily(key) {   //设置字体:  0-宋体 ; 1-微软雅黑;
    key = key || '0';
    var obj = document.body;
    var font = '';

    if (key) {
        font = '"微软雅黑", "宋体", Arial, Verdana';
    } else {
        font = '"宋体", "微软雅黑", Arial, Verdana';
    }
    obj.style.fontFamily = font;
}

//是否为win7--雅黑字
function getSysver() {
    var key = 0;
    try {
        key = execOrder('sysver');
        if ('6.1' == key) {
            key = 1;
        }
    } catch (e) {
    }

    setFontFamily(key);
}

/*批量管理显示*/
function manageSkins(isManage) {
    if (isManage) {   //进入批量管理，隐藏批量管理按钮，显示批量删除下的按钮
        addClass('userSkins', 'manage'); //标志进入批量管理
        showChkDelete(true);
        noUnLikeSkinsTips();      //设置已下载皮肤的tips
        unCheckAllSkins();        //初始状态：不选择任何皮肤
        hide('deleteSkins');
        show('skin-manage-op');
    } else { //退出批量管理，隐藏批量删除下的按钮，显示批量管理按钮
        removeClass('userSkins', 'manage'); //标志退出批量管理
        showChkDelete(false);
        setManageSkinsBtn();           //设置批量管理按钮
        hide('skin-manage-op');
        show('deleteSkins');
    }
}

//设置批量管理按钮状态
//可能使用被调用的情况：1.单个删除皮肤  2.退出批量管理 3.从推荐皮肤切换到我的皮肤
function setManageSkinsBtn() {
    var noManage = noManagedSkins(); //没有皮肤管理时为true，否则为false
    var obj = g('deleteSkins');
    var obj_btn = g('btn-manage');

    if (noManage) { //没有皮肤可管理时
        addClass(obj, 'del-disable');
        obj_btn.setAttribute('event-type', '');
    } else {
        removeClass(obj, 'del-disable');
        obj_btn.setAttribute('event-type', 'deleteSkins');
    }
}

/* 批量删除-操作 */
function processDeleteSkins(element, eventType) {
    if (eventType == 'deleteSkins') { //进入批量管理
        manageSkins(true);
    } else {
        if (eventType == 'deleteNow') { //批量删除
            if (!noSelectedSkins()) {    //如果有皮肤被选中
                skin_confirm("确认删除选中的皮肤？", function () {
                    processDelete();
                });
            }
        } else { //退出管理
            manageSkins(false);
        }
    }
}

//设置批量管理的状态
function processManageSkins() {
    if (g('userSkins').className.indexOf('manage') < 0) {
        setManageSkinsBtn();
    }
}

//选中/取消选中皮肤时，设置check相关button
function checkSkins(isChecked, chkObj) {
    var chkBox = chkObj.parentElement;
    var objLi = chkBox.parentElement.parentElement;
    if (isChecked) { //点击前已经被选中，则点击表示取消选中，否则相反
        removeClass(objLi, 'skin_check');
        chkObj.checked = false;
    } else {
        addClass(objLi, 'skin_check');
        chkObj.checked = true;
    }
    setDelSkinsBtn();
}

/* 删除复选框-操作 */
function processChkBoxChanged(element, eventType) {
    var chkObj = null;

    if (element.getAttribute('name') == 'mask') {
        chkObj = element.parentElement.getElementsByTagName('input')[0];
    } else {
        chkObj = element;
    }

    checkSkins(chkObj.checked, chkObj);
}

//设置批量管理状态下，各个按钮的状态
//被调用的情况：1.check皮肤 2.批量删除皮肤
function setDelSkinsBtn() {
    if (noSelectedSkins()) { //根据皮肤是否被选中，来设置"删除"按钮的状态
        addClass('btn-delete', 'disable');
    } else {
        removeClass('btn-delete', 'disable');
    }

    if (noManagedSkins()) { //根据皮肤是否可被管理，来设置“全选”按钮的状态
        addClass('btn-select-all', 'disable');
    } else {
        removeClass('btn-select-all', 'disable');
        if (allSelectedSkins()) { //根据皮肤是否已被全选，来设置“全选”按钮的状态
            addClass('btn-select-all-bg', 'check');
        } else {
            removeClass('btn-select-all-bg', 'check');
        }
    }
}

function skin_confirm(text, ok_callback, cancel_callback) {
    g("confirm_text").innerHTML = text;
    g("btn-delete-ok").onclick = function () {
        hide("delete_confirm");
        hide("delete_confirm_mask");
        if (ok_callback && typeof ok_callback == "function") {
            ok_callback();
        }
    };
    g("btn-delete-cancel").onclick = function () {
        hide("delete_confirm");
        hide("delete_confirm_mask");
        if (cancel_callback && typeof cancel_callback == "function") {
            cancel_callback();
        }
    };
    show("delete_confirm");
    show("delete_confirm_mask");
}
/* 删除一款皮肤-操作 */
function processDeleteThisSkin(element, eventType) {
    skin_confirm("确认删除选中的皮肤？", function () {
        var objLi = element.parentElement.parentElement.parentElement;
        execOrder('deleteSkin', objLi.getAttribute('skinid'));
        removeSkin(objLi);
    });
}

/* 保存一款皮肤-操作 */
function processSaveThisSkin(element, eventType) {
    var objLi = element.parentElement.parentElement.parentElement;
    var skinId = objLi.getAttribute('skinid');
    execOrder('saveSkin', skinId);
}
/* 设置喜欢|不喜欢皮肤-操作 */
function processSetLikeSkin(element, eventType) {
    var skinType = (eventType == 'setLike' ? 'like' : 'unlike');
    var objLi = element.parentElement.parentElement.parentElement.parentElement;
    element.className = box.skinsLike[skinType].clsName;
    element.setAttribute('event-type', box.skinsLike[skinType].eventType);
    element.innerHTML = '<span>'+(eventType == 'setLike' ? '取消' : '')+'收藏</span>';
    execOrder((skinType == 'like' ? 'likeIt' : 'dislikeIt'), objLi.getAttribute('skinid'));
    removeSkin(objLi);

    window.setTimeout(function () {
        addSkin(objLi, g(skinType + 'SkinsList'));
        showAddToLikePoint(eventType);
        noUnLikeSkinsTips();
        setManageSkinsBtn();
    }, 400);
}
/* 成功添加到喜欢的皮肤-提示 */
function showAddToLikePoint(eventType) {
    if (eventType == 'setLike' && g('userSkins').scrollTop > 124) {
        show('succeedAddToLike');
        addClass('succeedAddToLike', 'addtolike-slidedown');

        window.setTimeout(function () {
            hide('succeedAddToLike');
        }, 2600);
    }
}
/* 随便换换-操作 */
function processRandomSkin(element, eventType) {
    addClass(element, 'random-install');
    element.setAttribute('event-type', 'changingRandom');
    execOrder('randomSkin', '');
}
/* 执行搜索-操作 */
function processSearchSkins(element, eventType) {
    var keyword = trim(g('searchInput').value);
    searchSkins(keyword);
}
/* 清空搜索框--操作 */
function processClearSearchInput(element, eventType) {
    removeClass('searchButton', 'btn-search-close');
    g('searchInput').value = '';
    element.setAttribute('event-type', 'search');
    showSearchList(false, 0);
    execOrder('doSearch', '145EAD09-514B-49c2-AFDB-7A451098AF2F');
}
/* 执行命令 */
function processOrder(element, eventType) {
    execOrder(eventType, '0');
}

/* 返回-操作 */
function processCloseSearchBox(element, eventType) {
    showSearchList(false, 0);
    g('searchInput').value = '';
    setSearchBoxButton(true);
}

/* 打开链接 */
function processOpenPage(element, eventType) {
    execOrder('openUrl', element.getAttribute('link'));
}
/* 到官网查看更多结果 */
function processMoreSearchList(element, eventType) {
    var keyword = element.getAttribute('keyword');
    if (keyword) {
        var url = box.searchSkinsUrl + encodeURIComponent(keyword);
    } else {
        var url = box.skinsUrl;
    }
    execOrder('openUrl', url);

}
/* 填充关键词 */
function processHotKeyClick(element, eventType) {
    g('searchInput').value = element.innerHTML;
    hide('hotKeywords');
    //选中即搜索
    var keyword = trim(element.innerHTML);
    searchSkins(keyword);
}
/* 各种点击 */
function addTargetEvent() {
    document.body.onmouseup = function (e) {
        var element = e.target;
        var obj = null;
        if (e.button == 0) { //左击
            var eventType = element.getAttribute('event-type');
            if (!element.getAttribute('event-type')) {
                return;
            }
			if (element.getAttribute('id')=='minBox'){
				addClass(element,"nohover");
			}
            var fnName = box.eventTypeMap[eventType];
            if (typeof window[fnName] == 'function') {
                window[fnName](element, eventType);
            } else {
                return;
            }
        }
    }
}
/* 搜索框操作 */
function searchBoxFocus() {
    g('searchInput').onfocus = function () {
        if (trim(this.value).length == 0) {
            getHotKeywords();
        }
    }
    g('searchInput').onblur = function () {
        if (g('hotKeywords').getAttribute('hover') == '0') {
            hide('hotKeywords');
        }
    }
    g('searchInput').onkeydown = function (e) {
        var keyword = trim(this.value);
        if (e.keyCode == 13) { //执行搜索
        } else if (e.keyCode == 38) { //上一个
            g('hotKeywords').setAttribute('hover', '1');
            selectHotKeywords(-1);

        } else if (e.keyCode == 40) { //下一个
            g('hotKeywords').setAttribute('hover', '1');
            selectHotKeywords(1);
        } else {
            if (keyword.length > 0) {
                hide('hotKeywords');
                g('hotKeywords').setAttribute('hover', '0');
            } else {
                getHotKeywords();
            }
        }
    }
    g('searchInput').onkeyup = function (e) {
        var keyword = trim(this.value);
        if (keyword.length > 0) {
            hide('hotKeywords');
            g('hotKeywords').setAttribute('hover', '0');
        } else {
            if (g('hotKeywords').getElementsByTagName('li').length > 0) {
                show('hotKeywords');
            }
        }
        if (e.keyCode == 13) { //执行搜索
            if (keyword.length > 0) {
                searchSkins(keyword);
            } else {
                if (g('hotKeywords').getAttribute('hover') == 1) {
                    var currentObj = getCrrentElement('hotKeywords', 'li', 'hover');
                    g('searchInput').value = currentObj.innerHTML;
                    searchSkins(currentObj.innerHTML);
                    hide('hotKeywords');
                }
            }
        } else {
            setSearchBoxButton(true);
        }
    }
    g('searchInput').onchange = function () {
        setSearchBoxButton(true);
    }
    g('hotKeywords').onmouseover = function () {
        this.setAttribute('hover', '1');
    }
    g('hotKeywords').onmouseout = function () {
        this.setAttribute('hover', '0');
    }

}
/* 热词-上下键 */
function selectHotKeywords(num) {
    var list = g('hotKeywords').getElementsByTagName('li');
    var len = list.length;
    var currentObj = getCrrentElement('hotKeywords', 'li', 'hover');
    var hoverIndex = -1, newIndex = 0;
    if (currentObj) {
        for (var i = 0; i < len; i++) {
            if (list[i] == currentObj) {
                hoverIndex = i;
                break;
            }
        }
    }
    newIndex = hoverIndex + num;
    if (newIndex < 0) {
        newIndex = len - 1;
    } else if (newIndex >= len) {
        newIndex = 0;
    }
    hoverIndex = (hoverIndex == -1 ? 0 : hoverIndex);
    removeClass(list[hoverIndex], 'hover');
    addClass(list[newIndex], 'hover');
}
/* 设置搜索框按钮状态 */
function setSearchBoxButton(btnSearch) {
    var element = g('searchButton');
    if (btnSearch) {
        removeClass('searchButton', 'btn-search-close');
        element.setAttribute('event-type', 'search');
    } else {
        addClass('searchButton', 'btn-search-close');
        element.setAttribute('event-type', 'searched');
    }
}
/* 热门关键词 */
function getHotKeywords() {
    var keywordsList = [];
    try {
        keywordsList = execOrder('getPresetKeywords', '0');
    } catch (e) {
    }

    createHotKeywords(g('searchInput'), keywordsList, 'hotKeywords');
}
/* 填充皮肤热门关键词 */
function createHotKeywords(inputObj, keywordsList, hotKeywordsId) {
    if (keywordsList.length == 0) {
        return;
    }
    var objLi = null;
    var hotKeywords = g('hotKeywords');
    hotKeywords.innerHTML = '';
    for (var i = 0, len = keywordsList.length; i < len; i++) {
        objLi = document.createElement('li');
        objLi.setAttribute('event-type', 'hotKey');
        objLi.innerHTML = keywordsList[i].keyword;
        hotKeywords.appendChild(objLi);
    }
    show('hotKeywords');
    // inputObj.setAttribute('loadword', '1');
}


/* 拉取皮肤热门关键词 */
function getHotKeywords1() {
    var keywordsList = [];
    try {
        keywordsList = execOrder('getPresetKeywords', '0');
    } catch (e) {
    }

    createHotKeywords(g('searchInput'), keywordsList, 'hotKeywords');
}
/* 填充皮肤热门关键词 */
function createHotKeywords1(inputObj, keywordsList, hotKeywordsId) {
    if (keywordsList.length == 0) {
        return;
    }
    var objLi = null;
    var hotKeywords = g('hotKeywords');
    hotKeywords.innerHTML = '';
    for (var i = 0, len = keywordsList.length; i < len; i++) {
        objLi = document.createElement('li');
        objLi.setAttribute('event-type', 'hotKey');
        objLi.innerHTML = keywordsList[i].keyword;
        hotKeywords.appendChild(objLi);
    }
    inputObj.setAttribute('loadword', '1');
}
/* 设置搜索tab */
function showSearchList(showSearch, count) {
    var tabObj = searchChindNodes(g('tabItem'), 'li', 'class', 'active');
    if (showSearch) {
        if (count > box.maxSearchSkins) {
            show('hasMoreSearch');
        } else {
            hide('hasMoreSearch');
        }
        hide(tabObj.getAttribute('moudle') + 'Box');
        show('searchBox');
    } else {
        hide('hasMoreSearch');
        hide('searchBox');
        g('searchSkinsList').innerHTML = '';
        show(tabObj.getAttribute('moudle') + 'Box');
    }
}
/* 执行搜索 */
function searchSkins(keyword) {
    if (keyword.length > 0) {
        g('moreSearchList').setAttribute('keyword', keyword);
        setSearchBoxButton(false);
        execOrder('doSearch', keyword);
    }
}
/* 更改loading状态 */
function setLoadingState(canvasType, skinId, installResult) {
    var canvasBoxId = canvasType + '_' + skinId;
    if (typeof g(canvasBoxId) != 'undefined') {
        createLoading(canvasBoxId, true, installResult);
    }

}
/*
 *供客户端调用: 处理搜索到的数据
 *skinsList : 搜索数据
 */
function showSearchResult(skinsList) {
    if (typeof skinsList == 'string' && skinsList.length > 0) {
        skinsList = JSON.parse(skinsList);
    }

    if ((typeof skinsList == 'string' && skinsList.length == 0) ||
        typeof skinsList == 'object' && skinsList.length == 0) { //没有相关搜索结果
        g('searchSkinsList').innerHTML = '';
        g('moreSearchList').setAttribute('keyword', g('searchInput').value);
        g('missedKw').innerHTML = g('searchInput').value;
        g('skins-total').innerHTML = "共找到0款皮肤";
        show('gwMoreSearch');
        hide('hasMoreSearch');
        var tabObj = searchChindNodes(g('tabItem'), 'li', 'class', 'active');
        hide(tabObj.getAttribute('moudle') + 'Box');
        show('searchBox');
    } else {  //有搜索结果
        g('searchSkinsList').innerHTML = '';
        g('moreSearchList').setAttribute('keyword', skinsList.keyword);
        hide('gwMoreSearch');
        createDomList('search', skinsList.list,skinsList.total);
        g('skins-total').innerHTML = "共找到" + skinsList.total + "款皮肤";
        /*var temp = "";
        for(var i in skinsList){//用javascript的for/in循环遍历对象的属性
            temp += i+":"+skinsList[i]+"\n";
        }
        testData(temp);//结果：cid:C0 \n ctext:区县*/
    }
}
/*
 *供客户端调用: 被客户端用来通知外部安装，删除，换肤了某款皮肤等。
 *
 *通知项列表:
 Installed       本地安装了某款皮肤，参数=SkinInfo
 deleted     本地删除了某款皮肤
 changedto       本地更换了某款皮肤

 上面三个只有本地列表有涉及，下面三个只有推荐列表和随机推荐会涉及：

 installResult    (推荐皮肤的 使用-安装)异步安装成功还是失败，参数=0/1（成功/失败）
 randomInstallResult 随机安装结果(skininfo)
 */
function localChanged(notifyName, skinId, result) {
    if (!notifyName) {
        return;
    }
    notifyName = notifyName.toLowerCase();
    switch (notifyName) {
        case 'installed':
            if (!result) {
                return;
            }
            if (typeof result == 'string') {
                result = JSON.parse(result);
            }
            var parentObj = g('unlikeSkinsList');
            var objLi = createSkin(result, 'unlike', parentObj);
            addSkin(objLi, parentObj);
            //更新推荐皮肤中对应皮肤的 状态-已安装
            syncSkinsInstalled('recom', skinId, true);
            break;
        case 'deleted': //删除指定皮肤
            var objLi = searchChindNodes(g('userSkins'), 'li', 'skinid', skinId);
            removeSkin(objLi);
            //更新推荐皮肤中对应皮肤的 状态-未安装
            syncSkinsInstalled('recom', skinId, false);
            break;
        case 'changedto':  //无效果,在下次打开时排到最前面
            break;
        case 'update': //更新本地皮肤图片
        case 'updatesearch': //更新搜索结果中的图片
            if (!result) {
                return;
            }
            if (typeof result == 'string') {
                result = JSON.parse(result);
            }
            var skinListId = (notifyName == 'update' ? 'userSkins' : 'searchSkins');
            var objLi = searchChindNodes(g(skinListId), 'li', 'skinid', skinId);
            updateSkinInfo(objLi, result);
            break;
        default:
            break;
    }
}
/* 更新皮肤信息--图片 */
function updateSkinInfo(objLi, skinInfo) {
    var imgs = objLi.getElementsByTagName('img');
    imgs[0].src = skinInfo.thumbnail1 || imgs[0].src;
}
/* 同步皮肤状态 */
function syncSkinsInstalled(skinBox, skinId, isInstalled) {
    var objElement = searchChindNodes(g(skinBox + 'Skins'), 'li', 'skinid', skinId);
    if (objElement) {
        var installedState = (isInstalled ? '1' : '0');
        objElement.setAttribute('installed', installedState);
    }
}
/* 重置loading状态 */
function updateInstallResult(skinBox, skinId, result) {
    result = (result == '0' ? false : true);
    //检查是否为loading中的皮肤
    setLoadingState(skinBox, skinId, result);
    if (result) {
        //更新推荐皮肤中对应皮肤的 状态
        syncSkinsInstalled('recom', skinId, true);
    }
}
/*
 *(通知项， 皮肤ID， 参数)
 */
function submitAnswer(notifyName, skinId, result) {
    if (!notifyName) {
        return;
    }
    switch (notifyName) {
        case 'rcmdInstallResult':
            updateInstallResult('recom', skinId, result);
            break;
        case 'localInstallResult':
            updateInstallResult('user', skinId, result);
            break;
        case 'randomInstallResult':     //处理随便换换操作结果
            var element = g('changeRandom');
            removeClass(element, 'random-install');
            element.setAttribute('event-type', 'changeRandom');
            if (!result) {
                return;
            }
            addRandomInstalledSkin(result);
            //更新推荐皮肤中对应皮肤的 状态
            syncSkinsInstalled('recom', skinId, true);
            break;
        case 'searchInstallResult':
            updateInstallResult('search', skinId, result);
            break;
        case 'regetRcmndList': //重新获取一次推荐列表
            setBoxLoading(false, 'loadBox', 'recomMoudle');
            initRcmdSkinsList();
            break;
        default:
            break;
    }
}
/* 处理随便换换返回结果 */
function addRandomInstalledSkin(result) {
    if (typeof result == 'string') {
        result = JSON.parse(result)
    }
    var parentObj = g('unlikeSkinsList');
    var skinObj = createSkin(result, 'unlike', parentObj);
    addSkin(skinObj, g('unlikeSkinsList'));
}

/* 判断皮肤是否为当前皮肤 */
function isCurrentSkin(objSkinId) {
    var currentSkin = execOrder('getCurrentSkinID', '0');
    return (objSkinId == currentSkin);
}
/* 查找对应元素 */
function searchChindNodes(parentDom, childTagName, attrName, tagVal) {
    var list = parentDom.getElementsByTagName(childTagName);
    for (var i = 0, l = list.length; i < l; i++) {
        if (list[i].getAttribute(attrName) && list[i].getAttribute(attrName) == tagVal) {
            return list[i];
        }
    }
    return '';
}

/* 移除皮肤 */
function removeSkin(skinObj) {
    var objParent = skinObj.parentElement;
    // removeClass(skinObj, 'scale-recover');
    // addClass(skinObj, 'scale-smaller');
    var skinElm = skinObj.getElementsByTagName('div')[0];
    removeClass(skinObj, 'skin-larger');
    removeClass(skinElm, 'scale-recover');
    addClass(skinObj, 'skin-smaller');
    addClass(skinElm, 'scale-smaller');
    skinObj.setAttribute('skinStatu', '0');
    removeClass(skinObj, 'hover');
    window.setTimeout(function () {
        //setSkinAnimate(skinObj, -10);
        objParent.removeChild(skinObj);
        if (objParent.getAttribute('id') == 'likeSkinsList') {
            noLikedSkinPoint();
        }
        if (objParent.getAttribute('id') == 'unlikeSkinsList') {
            noUnLikeSkinsTips();
        }

        if (g('userSkins').className.indexOf('manage') < 0) { //删除当前皮肤后，更新批量管理按钮状态
            setManageSkinsBtn();
        }
    }, 400);
}
/* 追加皮肤(首位置) */
function addSkin(skinObj, skinsListObj) {
    skinsListObj.insertBefore(skinObj, skinsListObj.getElementsByTagName('li')[0]);
    if (skinsListObj.getAttribute('id') == 'likeSkinsList') {
        noLikedSkinPoint();
    }
    if (skinsListObj.getAttribute('id') == 'unlikeSkinsList') {
        noUnLikeSkinsTips();
    }
    // removeClass(skinObj, 'scale-smaller');
    // addClass(skinObj, 'scale-recover');
    var skinElm = skinObj.getElementsByTagName('div')[0];
    removeClass(skinObj, 'skin-smaller');
    removeClass(skinElm, 'scale-smaller');
    addClass(skinObj, 'skin-larger');
    addClass(skinElm, 'scale-recover');
    skinObj.setAttribute('skinStatu', '0');
    removeClass(skinObj, 'hover');
    //setSkinAnimate(skinObj, 5);
    window.setTimeout(function () {

        //removeClass(skinObj, 'scale-recover');
        removeClass(skinObj, 'skin-larger');
        removeClass(skinElm, 'scale-recover');
        skinObj.setAttribute('skinStatu', '1');
    }, 400);
}
/* 添加-删除皮肤的辅助特效 */
function setSkinAnimate(skinObj, step) {
    var skinParentObj = skinObj.parentElement;
    var listObj = skinParentObj.getElementsByTagName('li');
    var num = getObjIndex(skinObj, skinParentObj);
    if (num % 2 != 2 && num < listObj.length - 1) { //非行尾
        var left = (step == 1 ? -176 : 176);
        listObj[num + 1].style.marginLeft = left + 'px';
        moveSkin(listObj[num + 1], 176, 0, step, left);
    }

}
function moveSkin(skinObj, width, count, step, left) {
    count = count + step;
    left = left + step;
    if (Math.abs(count) >= width) {
        skinObj.style.marginLeft = 0;
        return;
    }
    skinObj.style.marginLeft = left + 'px';

    window.setTimeout(function () {
        moveSkin(skinObj, width, count, step, left);
    }, 2);
}
/* 返回索引 */
function getObjIndex(obj, parentObj) {
    var listObj = parentObj.getElementsByTagName('li');
    var elementIndex = -1;
    for (var i = 0, len = listObj.length; i < len; i++) {
        if (listObj[i] == obj) {
            elementIndex = i;
            break;
        }
    }
    return elementIndex;
}

/* 显示-隐藏删除选择框 */
function showChkDelete(showChkDel) {
    var objList = g('userSkins').getElementsByTagName('div');
    for (var i = 0, len = objList.length; i < len; i++) {
        if ('default' == objList[i].getAttribute('skin-type')) {
            var objLi = objList[i].parentElement;
            addClass(objLi, 'skin_default');
            if (showChkDel) {
                addClass(objList[i], 'mask-bg');
            } else {
                removeClass(objList[i], 'mask-bg');
            }
        }
        if ('mask' == objList[i].getAttribute('name')) {
            if (showChkDel) {
                objList[i].className = 'mask pointer';
                objList[i].parentElement.parentElement.setAttribute("execClick", '2');
                show(objList[i]);
            } else {
                objList[i].parentElement.parentElement.setAttribute("execClick", '0');
                hide(objList[i]);
            }
        }
        if ('chkDelete' == objList[i].getAttribute('event-type')) {
            if (showChkDel) {
                show(objList[i]);
            } else {
                hide(objList[i]);
            }
        }
    }
}

//设置所有chexbox为非选中状态
function unCheckAllSkins() {
    var chkObj = null,
        chkBox = null,
        chkList = g('userSkins').getElementsByTagName('input');
    var len = chkList.length;

    for (var i = 0; i < len; i++) {
        chkObj = chkList[i];
        chkBox = chkObj.parentElement;
        if (chkBox.getAttribute('event-type') != 'chkDelete')
            continue;
        checkSkins(true, chkObj);
    }
}
/* 执行命令 */
function execOrder(order, key) {
    var info = '';
    try {
        key = (key.length == 0 ? '0' : key);
        info = JSON.parse(window.external.SyncRequest(order, key));
        if (typeof info.result != 'undefined' && info.result.length > 0) {
            info = info.result;
        }
    } catch (e) {

    }
    return info;
}
/* 确定删除-接口 （批量删除）*/
function processDelete() {
    var idList = [],
        chkObj = null,
        liObj = null,
        chkList = g('userSkins').getElementsByTagName('input');
    var i = 0;
    var len = chkList.length;

    //获取删除列表
    for (i = 0; i < len; i++) {
        chkObj = chkList[i];
        if (chkObj.checked) {
            liObj = chkObj.parentElement.parentElement.parentElement;
            idList[idList.length] = liObj.getAttribute('skinid') || '';
        }
    }

    //执行删除命令
    execOrder('deleteSkin', idList);

    //删除皮肤节点
    for (i = len - 1; i >= 0; i--) {
        chkObj = chkList[i];
        if (chkObj.checked) {
            liObj = chkObj.parentElement.parentElement.parentElement;
            liObj.parentElement.removeChild(liObj);
        }
    }

    //删除之后的善后工作
    afterProcessDelete();
}

//批量删除之后，更新“我的皮肤”中可能发生的变化
function afterProcessDelete() {
    //无喜欢皮肤时,显示提示
    noLikedSkinPoint();

    //无下载皮肤时,显示提示
    noUnLikeSkinsTips();

    //设置批量管理状态下各按钮状态
    setDelSkinsBtn();
}

/* 切换tab */
function changeTab(clsName) {
    var liList = g('tabItem').getElementsByTagName('li');
    for (var i = 0, len = liList.length; i < len; i++) {
        liList[i].onclick = function () {
            setActiveTab(clsName, this, liList);
        }
    }
}
/* 设置当前tab */
function setActiveTab(clsName, obj, objList) {
    var currentTabIndex = 0;
    for (var i = 0, len = objList.length; i < len; i++) {
        removeClass(objList[i], clsName);
        if (objList[i] == obj) {
            currentTabIndex = i;
        }
    }
    addClass(obj, clsName);
    setActiveSkins(obj.getAttribute('moudle'));
    //统计tab点击
    execOrder('gotoTab', currentTabIndex);
}
/* 设置显示模块 */
function setActiveSkins(moudle) {
    var id = moudle + 'Box';
    var skinsBox = box.skinsBox;
    for (var i = 0, len = skinsBox.length; i < len; i++) {
        var boxObj = skinsBox[i] + 'Box';
        if (id == boxObj) {
            show(boxObj);
            //清空搜索过的关键词
            if (g('searchButton').getAttribute('event-type') == 'searched') {
                setSearchBoxButton(true);
                g('searchInput').value = '';
            }
        } else {
            hide(boxObj);
        }
    }
}
/* 皮肤点击事件 */
function skinsClick(skinObj) {
    var skinId = skinObj.getAttribute('skinid');
    var eventType = '',
        loadingType = '';
    var skinsListId = skinObj.parentElement.getAttribute('id');
    if (skinsListId.indexOf('like') >= 0) {
        eventType = 'changeSkin';
        loadingType = 'user';
    } else if (skinsListId.indexOf('search') >= 0) {
        eventType = 'searchInstall';
        loadingType = 'search';
    } else {
        eventType = 'installSkin';
        loadingType = 'recom';
    }
    skinId = skinObj.getAttribute('skinid') || '';

    execOrder(eventType, skinId);
    createLoading(loadingType + '_' + skinId, false);
}
//创建dom
function createDomList(skinType, skinList,total) {
    if (!skinList || skinList.length == 0) {
        return;
    }
    var liObj = null;
    var objDom = g(skinType + 'SkinsList');
    var i = 0, len = skinList.length;
    if (skinType == 'search') {
        showSearchList(true, total);
    }
    for (i = 0; i < len; i++) {
        if (!skinList[i]) {  //容错处理，客户端传过来的可能为空
            continue;
        }
        if ((skinType == 'hot' && i >= box.maxRecomHotSkins) || (skinType == 'new' && i >= box.maxRecomNewSkins) || skinType == 'search' && i >= box.maxSearchSkins) { //热门皮肤:4个，最新皮肤：12个,搜索结果：32个
            break;
        }
        liObj = createSkin(skinList[i], skinType, objDom);
        objDom.appendChild(liObj);
    }
}

/* 创建一条皮肤数据 */
function createSkin(skinInfo, skinType, parentDom) {
    var liObj = null;
    if (skinType == 'hot' || skinType == 'new') {
        var isRecom = 1;
    } else {
        var isRecom = 0;
    }
    liObj = document.createElement('li');
    liObj.setAttribute('tag', 'skin');
    liObj.setAttribute('skinStatu', '1');
    liObj.setAttribute('skinType', (skinInfo.skintype || ''));
    liObj.setAttribute('isRecom', isRecom);
    liObj.setAttribute('execClick', '0');
    liObj.setAttribute('skinid', (skinInfo.skinid || ''));
    liObj.setAttribute('installed', (skinInfo.installed || '0'));

    function isEnter(parent, child) {
        while (child) {
            if (child.parentNode === parent) {
                return true;
            }
            child = child.parentNode;
        }
        return false;
    }

    liObj.onmouseover = function (e) {
        if (!e) e = window.event;
        var reltg = e.relatedTarget ? e.relatedTarget : e.fromElement;
        while (reltg && reltg != this) reltg = reltg.parentNode;
        if (reltg != this) {
            // 这里可以编写 onmouseenter 事件的处理代码
            if (this.getAttribute('skinStatu') != '1') {
                return;
            }
            skinsMouseover(this, true, parentDom.parentElement.parentElement);
        }
    };
    liObj.onmouseout = function (e) {
        if (!e) e = window.event;
        var reltg = e.relatedTarget ? e.relatedTarget : e.toElement;
        while (reltg && reltg != this) reltg = reltg.parentNode;
        if (reltg != this) {
            // 这里可以编写 onmouseleave 事件的处理代码
            skinsMouseover(this, false, parentDom.parentElement.parentElement);
        }
    };

    liObj.onclick = function () {
        if (this.getAttribute('execClick') == '0') {
            skinsClick(this);
            this.setAttribute('execClick', '1');
        }
    }
    liObj.ondblclick = function () {
        if (this.getAttribute('execClick') == '0') {
            skinsClick(this);
            this.setAttribute('execClick', '1');
        }
    }
    liObj.innerHTML = buildSkinHtml(skinInfo, skinType);
    return liObj;
}

//hover到收藏、保存、删除等按钮上时，取消大图预览，并显示title
function hoverTitle(e){
    var obj = e;
    if (obj.getAttribute('event-type').indexOf('Like') >=0 ){
        obj = obj.parentElement;
    }
    var objLi = obj.parentElement.parentElement.parentElement;
    skinId = objLi.getAttribute('skinid');
    execOrder('hidePreview', skinId);
}

//从收藏、保存、删除等按钮离开后，恢复大图预览
function hoverPreview(e){
    var obj = e;
    if (obj.getAttribute('event-type').indexOf('Like') >=0 ){
        obj = obj.parentElement;
    }
    var objLi = obj.parentElement.parentElement.parentElement;
    skinId = objLi.getAttribute('skinid');

    if (objLi.className.indexOf('hover') >= 0){ //如果还处于hover态，恢复默认的大图预览
        execOrder('showPreview', skinId);
    }
}

/* 创建数据 skinBox: tab类型; skinType: 皮肤类型 */
function buildSkinHtml(skinInfo, skinType) {
    var html = [];
    var skinTypeVal = '';
    var isDefaultSkin = false;
    //是否为默认皮肤: 默认皮肤不可删除
    if (skinInfo.skintype == '2' || skinInfo.skintype == '3') {
        isDefaultSkin = true;
    }
    html[html.length] = '<div class="skin" skin-type="' + (isDefaultSkin ? 'default' : 'not_default') + '">';
    html[html.length] = '   <img src="' + (skinInfo.thumbnail1 || '') + '"  class="default_skin" >';
    html[html.length] = '       <div class="mask" name="mask"  event-type="' + (isDefaultSkin ? '' : 'maskDelete') + '"></div>';
    html[html.length] = '       <div class="large">';
    html[html.length] = '           <img src="' + (skinInfo.thumbnail2 || '') + '" load-state="0" />';
    html[html.length] = '       </div>';
    if (skinType == 'like' || skinType == 'unlike') {
        html[html.length] = '   <div class="chk-del" name="chkDelete" event-type="' + (isDefaultSkin ? '' : 'chkDelete') + '" ><input type="checkbox" style="display: none;" /></div>';
        html[html.length] = '   <div id="' + (( 'user_' + skinInfo.skinid ) || '') + '" class="mask" name="canvasBox"></div>';
        html[html.length] = '   <div class="info">';
        html[html.length] = '       <div class="indent">';
        if (skinType == 'like'){
            html[html.length] = '       <div class="like title_info" event-type="setUnLike" onmouseover="hoverTitle(this);"  onmouseout="hoverPreview(this);" onclick="cancelBubble(event)"><span>取消收藏</span></div>';
        }else{
            html[html.length] = '       <div class="unlike title_info" event-type="setLike" onmouseover="hoverTitle(this);" onmouseout="hoverPreview(this);" onclick="cancelBubble(event)"><span>收藏</span></div>';
        }
        html[html.length] = '       </div>';
        if (!isDefaultSkin) {
            html[html.length] = '       <div class="btn-save-this title_info" event-type="saveThis" onmouseover="hoverTitle(this);" onmouseout="hoverPreview(this);" onclick="cancelBubble(event)"><span>保存</span></div>';
            html[html.length] = '       <div class="btn-del-this title_info" event-type="delThis" onmouseover="hoverTitle(this);" onmouseout="hoverPreview(this);" onclick="cancelBubble(event)"><span>删除</span></div>';
        }
    } else {
        if (skinType == 'hot' || skinType == 'new') {
            html[html.length] = '   <div class="tip ' + skinType + '"></div>';
            skinTypeVal = 'recom_';
        } else {
            skinTypeVal = skinType + '_';
        }
        html[html.length] = '       <div id="' + ((skinTypeVal + skinInfo.skinid ) || '') + '" class="mask" name="canvasBox"></div>';
        html[html.length] = '   <div class="info">';
        html[html.length] = '       <div class="title">';
        html[html.length] = '           <a tag="title" class="btn-fill" href="#" text="' + (skinInfo.skinname || '') + '">使用皮肤</a>';
        html[html.length] = '       </div>';
    }
    html[html.length] = '       </div>';
    html[html.length] = '</div>';
    html[html.length] = '<div class="skin-name">' + skinInfo.skinname + '</div>';

    return html.join('');
}

function html_encode(str) {
    var s = "";
    if (str.length == 0) return "";
    s = str.replace(/&/g, "&gt;");
    s = s.replace(/</g, "&lt;");
    s = s.replace(/>/g, "&gt;");
    s = s.replace(/ /g, "&nbsp;");
    s = s.replace(/\'/g, "&#39;");
    s = s.replace(/\"/g, "&quot;");
    s = s.replace(/\n/g, "<br>");
    return s;
}

function html_decode(str) {
    var s = "";
    if (str.length == 0) return "";
    s = str.replace(/&gt;/g, "&");
    s = s.replace(/&lt;/g, "<");
    s = s.replace(/&gt;/g, ">");
    s = s.replace(/&nbsp;/g, " ");
    s = s.replace(/&#39;/g, "\'");
    s = s.replace(/&quot;/g, "\"");
    s = s.replace(/<br>/g, "\n");
    return s;
}

/* 控制hover */
function skinsMouseover(objLi, hover, skinsListObj) {
    var editState = false;
    var skinId = objLi.getAttribute('skinid');
    if ((objLi.parentElement.id).indexOf('like') >= 0 && g('userSkins').className.indexOf('manage') >= 0) {
        editState = true;
    }

    if (hover) {
        if (!editState) {
            addClass(objLi, 'hover');
            execOrder('showPreview', skinId);
        } else {
            var chkBox = objLi.getElementsByTagName('div')[0];
            if (chkBox.getAttribute('skin-type') == 'not_default') {
                addClass(objLi, 'skin_check');
            }
        }
    } else {
        if (!editState) {
            removeClass(objLi, 'hover');
            execOrder('hidePreview', skinId);
        } else {
            var chkObj = objLi.getElementsByTagName('input')[0];
            if (!chkObj.checked) {
                removeClass(objLi, 'skin_check');
            }
        }
    }
}
/* 获取当前哪个元素被选中 */
function getCrrentElement(parentId, tagName, currentName) {
    var list = g(parentId).getElementsByTagName(tagName);
    for (var i = 0, len = list.length; i < len; i++) {
        if (list[i].className.indexOf(currentName) >= 0) {
            return list[i];
        }
    }
    return null;
}
/* 获取当前是哪个tab */
function getCrrentTab() {
    var list = g('tabItem').getElementsByTagName('li');
    for (var i = 0, len = list.length; i < len; i++) {
        if (list[i].className.indexOf('active') >= 0) {
            return list[i];
        }
    }
    return null;
}
/* 无喜欢皮肤时,显示提示 */
function noLikedSkinPoint() {
    var obj = g('likeSkinsList');
    if (obj.getElementsByTagName('li').length == 0) {
        addClass('likeSkinsList', 'no-liked');
    } else {
        removeClass('likeSkinsList', 'no-liked');
    }
}

//无下载皮肤时，显示提示
function noUnLikeSkinsTips() {
    var obj = g('unlikeSkinsList');
    var len = obj.getElementsByTagName('li').length;
    if (len == 0) {
        show('UnLikeSkinsTips');
    } else {
        hide('UnLikeSkinsTips');
    }
}

/* 皮肤区域是否显示loading */
function setBoxLoading(loading, loadingBoxId, skinsMoudleId) {
    if (loading) {
        addClass(loadingBoxId, 'loading');
        hide(skinsMoudleId);
    } else {
        removeClass(loadingBoxId, 'loading');
        show(skinsMoudleId);
    }
}
/* 初始化我的皮肤 */
function initLocalSkinsList() {
    var userSkinsList = execOrder('getLocalSkinList', '0');
    /*if (!userSkinsList) { //just for test
        userSkinsList = {
            'like': box.testData.skinsList,
            'unlike': box.testData.skinsList
        }
    }*/
    var likeSkinsList = userSkinsList['like'] || [];
    var unlikeSkinsList = userSkinsList['unlike'] || [];
    createDomList('like', likeSkinsList, likeSkinsList.length );
    createDomList('unlike', unlikeSkinsList, unlikeSkinsList.length);
    noLikedSkinPoint();
    noUnLikeSkinsTips();
}
/* 初始化推荐皮肤 */
function initRcmdSkinsList() {
    var recomSkinsList = execOrder('getRcmdSkinList', '0');
    var hotList = recomSkinsList['hot'] || [];
    var newList = recomSkinsList['new'] || [];
    /*if (!recomSkinsList) { //just for test
        hotList = box.testData.skinsList;
    }*/
    createDomList('hot', hotList, hotList.length);
    createDomList('new', newList, newList.length);
}

function createLoading(canvasBoxId, isLoading, installResult) {
    var canvasId = canvasBoxId + 'Canvas';
    var canvasParams = null;
    if (isLoading) { //结束loading; 快速转完余下部分
        canvasParams = {angleBase: 1.5, endCircle: 2, speed: 20, step: 0.1};
        drawCircle(canvasBoxId, canvasParams);
        window.setTimeout(function () {
            g(canvasBoxId).innerHTML = "";
            g(canvasBoxId).parentElement.parentElement.setAttribute('execclick', '0');
            if (installResult) {
                // hide(canvasBoxId);
            } else {
                removeClass(canvasBoxId, 'mask');
                failedInstalled(canvasBoxId, true);
                window.setTimeout(function () {
                    failedInstalled(canvasBoxId, false);
                }, 800);
            }
        }, (canvasParams.speed * (0.5 / 0.1) + 800));
    } else { //开始loading
        canvasParams = {angleBase: 0.01, endCircle: 1.5, speed: 50, step: 0.05};
        createCanvas(canvasBoxId);
        if (canvasBoxId.indexOf('recom') == 0 || canvasBoxId.indexOf('search') == 0) { //下载皮肤进入loading态时，隐藏"使用皮肤button"
            var objLi = g(canvasBoxId).parentElement.parentElement;
            addClass(objLi, 'click');
        }
        show(canvasBoxId);
        drawCircle(canvasBoxId, canvasParams);
    }
}
/* 安装失败 */
function failedInstalled(canvasBoxId, isWarn) {
    if (isWarn) {
        var p = document.createElement('p');
        p.className = 'failed';
        g(canvasBoxId).appendChild(p);
    } else {
        g(canvasBoxId).innerHTML = '';
    }
}
/* 安装成功 */
function addedInstalled(canvasBoxId, isWarn) {
    if (isWarn) {
        var p = document.createElement('p');
        p.className = 'added';
        g(canvasBoxId).appendChild(p);
    } else {
        g(canvasBoxId).innerHTML = '';
    }
}
//设置canvas样式
function createCanvas(canvasBoxId) {
    var canvasId = canvasBoxId + 'Canvas';
    var canvas = document.createElement('canvas');
    canvas.id = canvasId;
    canvas.width = 134;
    canvas.height = 90;
    canvas.style.border = '1px solid #999';
    canvas.style.background = 'rgba(0, 0, 0, 0.5)';
    canvas.style.position = 'absolute';
    canvas.style.top = 0;
    canvas.style.left = 0;

    g(canvasBoxId).appendChild(canvas);
}
//loading动画
function drawCircle(canvasBoxId, canvasParams) {
    var canvasId = canvasBoxId + 'Canvas';
    var canvas = g(canvasId);
    var ctx = canvas.getContext('2d');
    var radius = 12,
        lineWidth = 4;
    var center = {
        x: canvas.width / 2,
        y: canvas.height / 2
    };
    var rotatorAngle = Math.PI * 1.5,
        angleBase = canvasParams.angleBase;
    if (canvas.loadingInterval) {
        window.clearInterval(canvas.loadingInterval);
    }
    canvas.loadingInterval = window.setInterval(function () {
        // backend
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        ctx.beginPath();
        ctx.lineWidth = lineWidth;
        ctx.strokeStyle = 'rgba(0, 0, 0, 0.6)';
        ctx.arc(center.x, center.y, radius, 0, Math.PI * 2);
        ctx.closePath();
        ctx.stroke();

        // frontend
        ctx.beginPath();
        ctx.strokeStyle = 'rgba(255, 255, 255, 0.8)';
        ctx.arc(center.x, center.y, radius, rotatorAngle, rotatorAngle + Math.PI * angleBase);
        ctx.stroke();
        if (angleBase >= canvasParams.endCircle) {
            window.clearInterval(canvas.loadingInterval);
            hide(canvasBoxId);
            window.setTimeout(function () {
                if (canvasBoxId.indexOf('recom') == 0 || canvasBoxId.indexOf('search') == 0) { //推荐皮肤:下载皮肤进入loading态时，隐藏"使用皮肤button"
                    var objLi = g(canvasBoxId).parentElement.parentElement;
                    removeClass(objLi, 'click');
                }
            }, 30);
        }
        angleBase += canvasParams.step;

    }, canvasParams.speed);
}
//loading结束后操作
function removeCanvas(canvasId) {
    g(canvasId).parentElement.removeChild(g(canvasId));
}

//没有皮肤被选中返回true,否则返回false
function noSelectedSkins() {
    var chkObj = null;
    var chkBox;
    var chkList = g('userSkins').getElementsByTagName('input');
    var len = chkList.length;

    for (var i = 0; i < len; i++) {
        chkObj = chkList[i];
        chkBox = chkObj.parentElement;
        if (chkObj.checked) { //如果当前有一个皮肤被选中，则删除按钮可用
            return false;
        }
    }
    return true;
}

//没有皮肤可管理时返回true，否则返回false
function noManagedSkins() {
    var chkObj = null;
    var chkBox = null;
    var chkList = g('userSkins').getElementsByTagName('input');
    var len = chkList.length;

    for (var i = 0; i < len; i++) {
        chkObj = chkList[i];
        chkBox = chkObj.parentElement;
        if (chkBox.getAttribute('event-type') == 'chkDelete') { //event-type:chkDelete 表示皮肤可管理
            return false;
        }
    }
    return true;
}

//所有皮肤被选中,则返回true,否则，返回false
function allSelectedSkins() {
    var chkObj = null;
    var chkBox = null;
    var chkList = g('userSkins').getElementsByTagName('input');
    var len = chkList.length;

    for (var i = 0; i < len; i++) {
        chkObj = chkList[i];
        chkBox = chkObj.parentElement;
        if (chkBox.getAttribute('event-type') == 'chkDelete' && !chkObj.checked) { //如果当前有一个皮肤没有选中，则返回false
            return false;
        }
    }
    return true;
}

//全选要删除的皮肤
function checkAllSkins(element, eventType) {
    var chkObj = null,
        chkBox = null,
        chkList = g('userSkins').getElementsByTagName('input');
    var len = chkList.length;

    isChecked = allSelectedSkins();
    for (var i = 0; i < len; i++) {
        chkObj = chkList[i];
        chkBox = chkObj.parentElement;
        if (chkBox.getAttribute('event-type') != 'chkDelete')
            continue;
        checkSkins(isChecked, chkObj);
    }
}

/**
 * 在一支笔中打印日志
 * @param {string} str 打印的内容
 */
function Log(str) {
    try {
        if (window.external.SyncRequest) {
            window.external.SyncRequest('log', str);
        } else {   //在浏览器控制台中输出        
            console.log(str);
        }
    } catch (e) {
    }
}

/*测试数据*/
function testData(str) {
    g('testData').innerHTML = g('testData').innerHTML + '<br />' + str;
}


/**
 * create by xuxincheng01@baidu.com
 * 2016-08-09
 *
 * 获取页面参数  供个人中心定位到我的皮肤tab=userSkins
 *
 * */




