﻿// CCDecode: A library for decoding digital public safety standards.
// 
//  Author: Gabriel Graves
// Website: http://www.ccdecode.com/
// 
// This software has been released with no license and is public domain.
// You are free to do anything with the code for any purpose with out
// permission.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CCDecodeP25
{
    /// <summary>
    /// Type of Duplex
    /// </summary>
    public enum P25ServiceOptionsDuplex
    {
        /// <summary>
        /// Channel doesn't allow radios to receive when transmitting.
        /// </summary>
        Half,
        /// <summary>
        /// Channel allows radios to receive and transmit at the same time.
        /// </summary>
        Full
    }

    /// <summary>
    /// Mode being used.
    /// </summary>
    public enum P25ServiceOptionsMode
    {
        /// <summary>
        /// Circuit Mode.
        /// </summary>
        Circuit,
        /// <summary>
        /// Packet Mode.
        /// </summary>
        Packet
    }

    /// <summary>
    /// Priority Level of transmissions.
    /// </summary>
    public enum P25ServiceOptionsPriorityLevel
    {
        /// <summary>
        /// Highest Level (at top)
        /// </summary>
        Highest,
        /// <summary>
        /// System Definable (bits 110)
        /// </summary>
        SysDefinable110,
        /// <summary>
        /// System Definable (bits 101)
        /// </summary>
        SysDefinable101,
        /// <summary>
        /// Default Level.
        /// </summary>
        Default,
        /// <summary>
        /// System Definable (bits 011)
        /// </summary>
        SysDefinable011,
        /// <summary>
        /// System Definable (bits 010)
        /// </summary>
        SysDefinable010,
        /// <summary>
        /// Lowest Level (at bottom)
        /// </summary>
        Lowest,
        /// <summary>
        /// Reserved Level.
        /// </summary>
        Reserved000
    }

    /// <summary>
    /// Type of Affiliation
    /// </summary>
    public enum P25GroupAffiliationType
    {
        /// <summary>
        /// Local Affiliation.
        /// </summary>
        Local,
        /// <summary>
        /// Global Affiliation.
        /// </summary>
        Global
    }

    /// <summary>
    /// Affiliation Status
    /// </summary>
    public enum P25GroupAffiliationValue
    {
        /// <summary>
        /// Affiliation was accepted.
        /// </summary>
        Accept,
        /// <summary>
        /// Affiliation failed.
        /// </summary>
        Fail,
        /// <summary>
        /// Affiliation was denied.
        /// </summary>
        Deny,
        /// <summary>
        /// Affiliation was refused.
        /// </summary>
        Refused
    }

    /// <summary>
    /// Registration Status
    /// </summary>
    public enum P25UnitRegistrationValue
    {
        /// <summary>
        /// Registration was accepted.
        /// </summary>
        Accept,
        /// <summary>
        /// Registration failed.
        /// </summary>
        Fail,
        /// <summary>
        /// Registration was denied.
        /// </summary>
        Deny,
        /// <summary>
        /// Registration was refused.
        /// </summary>
        Refused
    }
}